/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.ConstantDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.XTagsVectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsUtil;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.ImageVectorDataSetRenderer;
import edu.uiowa.physics.pw.das.graph.Psym;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

public class GraphUtil {
    public static DasPlot newDasPlot(DasCanvas dasCanvas, DatumRange datumRange, DatumRange datumRange2) {
        DasAxis dasAxis = new DasAxis(datumRange.min(), datumRange.max(), 2);
        DasAxis dasAxis2 = new DasAxis(datumRange2.min(), datumRange2.max(), 3);
        DasRow dasRow = DasRow.create(dasCanvas);
        DasColumn dasColumn = DasColumn.create(dasCanvas);
        DasPlot dasPlot = new DasPlot(dasAxis, dasAxis2);
        dasCanvas.add(dasPlot, dasRow, dasColumn);
        return dasPlot;
    }

    public static void serializeCanvas(DasCanvas dasCanvas, OutputStream outputStream) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            document.appendChild(dasCanvas.getDOMElement(document));
            StringWriter stringWriter = new StringWriter();
            OutputFormat outputFormat = new OutputFormat("xml", "UTF-8", true);
            XMLSerializer xMLSerializer = new XMLSerializer(new OutputStreamWriter(outputStream), outputFormat);
            xMLSerializer.serialize(document);
            outputStream.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static JTabbedPane loadCanvas(InputStream inputStream) throws Exception {
        FormBase formBase = new FormBase(inputStream, null, true);
        return formBase;
    }

    public static GeneralPath getPath(DasAxis dasAxis, DasAxis dasAxis2, VectorDataSet vectorDataSet, boolean bl) {
        return GraphUtil.getPath(dasAxis, dasAxis2, new XTagsVectorDataSet(vectorDataSet), vectorDataSet, bl);
    }

    public static GeneralPath getPath(DasAxis dasAxis, DasAxis dasAxis2, VectorDataSet vectorDataSet, VectorDataSet vectorDataSet2, boolean bl) {
        double d;
        Object object;
        GeneralPath generalPath = new GeneralPath();
        Units units = dasAxis.getUnits();
        Units units2 = dasAxis2.getUnits();
        double d2 = dasAxis.getDataMaximum().doubleValue(units);
        double d3 = dasAxis.getDataMinimum().doubleValue(units);
        double d4 = dasAxis2.getDataMaximum().doubleValue(units2);
        double d5 = dasAxis2.getDataMinimum().doubleValue(units2);
        if (vectorDataSet.getProperty("xTagWidth") != null) {
            object = (Datum)vectorDataSet.getProperty("xTagWidth");
            d = ((Datum)object).doubleValue(units.getOffsetUnits());
        } else if (vectorDataSet.getProperty("xSampleWidth") != null) {
            object = (Datum)vectorDataSet.getProperty("xSampleWidth");
            d = ((Datum)object).doubleValue(units.getOffsetUnits());
        } else {
            object = (String)vectorDataSet.getProperty("x_sample_width");
            if (object != null) {
                double d6 = Double.parseDouble((String)object);
                d = Units.seconds.convertDoubleTo(units.getOffsetUnits(), d6);
            } else {
                d = 1.0E31;
            }
        }
        double d7 = -1.7976931348623157E308;
        double d8 = -1.7976931348623157E308;
        double d9 = -1.7976931348623157E308;
        double d10 = -1.7976931348623157E308;
        double d11 = -1.7976931348623157E308;
        boolean bl2 = true;
        int n = vectorDataSet.getXLength();
        for (int i = 0; i < n; ++i) {
            double d12 = vectorDataSet.getXTagDouble(i, units);
            double d13 = vectorDataSet.getDouble(i, units2);
            double d14 = vectorDataSet2.getDouble(i, units2);
            double d15 = dasAxis.transform(d13, units);
            double d16 = dasAxis2.transform(d14, units2);
            if (units2.isFill(d14) || Double.isNaN(d14)) {
                bl2 = true;
            } else if (bl2 || d12 - d7 > d) {
                generalPath.moveTo((float)d15, (float)d16);
                bl2 = false;
            } else {
                if (bl) {
                    double d17 = (d10 + d15) / 2.0;
                    generalPath.lineTo((float)d17, (float)d11);
                    generalPath.lineTo((float)d17, (float)d16);
                    generalPath.lineTo((float)d15, (float)d16);
                } else {
                    generalPath.lineTo((float)d15, (float)d16);
                }
                bl2 = false;
            }
            d7 = d12;
            d8 = d13;
            d9 = d14;
            d10 = d15;
            d11 = d16;
        }
        return generalPath;
    }

    public static AffineTransform calculateAT(DasAxis dasAxis, DasAxis dasAxis2, DasAxis dasAxis3, DasAxis dasAxis4) {
        AffineTransform affineTransform = new AffineTransform();
        double d = dasAxis3.transform(dasAxis.getDataMinimum());
        double d2 = dasAxis3.transform(dasAxis.getDataMaximum());
        double d3 = dasAxis3.transform(dasAxis3.getDataMinimum());
        double d4 = dasAxis3.transform(dasAxis3.getDataMaximum());
        double d5 = (d - d2) / (d3 - d4);
        double d6 = -1.0 * d3 * d5 + d;
        affineTransform.translate(d6, 0.0);
        affineTransform.scale(d5, 1.0);
        if (affineTransform.getDeterminant() == 0.0) {
            return null;
        }
        d = dasAxis4.transform(dasAxis2.getDataMinimum());
        d2 = dasAxis4.transform(dasAxis2.getDataMaximum());
        d3 = dasAxis4.transform(dasAxis4.getDataMinimum());
        d4 = dasAxis4.transform(dasAxis4.getDataMaximum());
        double d7 = (d - d2) / (d3 - d4);
        double d8 = -1.0 * d3 * d7 + d;
        affineTransform.translate(0.0, d8);
        affineTransform.scale(1.0, d7);
        return affineTransform;
    }

    public static DasAxis guessYAxis(DataSet dataSet) {
        DasAxis dasAxis;
        boolean bl = false;
        if (dataSet.getProperty("yScaleType") != null && dataSet.getProperty("yScaleType").equals("log")) {
            bl = true;
        }
        if (dataSet instanceof TableDataSet) {
            TableDataSet tableDataSet = (TableDataSet)dataSet;
            Units units = tableDataSet.getYUnits();
            DatumRange datumRange = DataSetUtil.yRange(dataSet);
            Datum datum = TableUtil.guessYTagWidth(tableDataSet);
            if (UnitsUtil.isRatiometric(datum.getUnits())) {
                bl = true;
            }
            dasAxis = new DasAxis(datumRange.min(), datumRange.max(), 3, bl);
        } else if (dataSet instanceof VectorDataSet) {
            VectorDataSet vectorDataSet = (VectorDataSet)dataSet;
            Units units = vectorDataSet.getYUnits();
            DatumRange datumRange = DataSetUtil.yRange(dataSet);
            if (datumRange.width().doubleValue(units.getOffsetUnits()) == 0.0 && (datumRange = datumRange.include(units.createDatum(0))).width().doubleValue(units.getOffsetUnits()) == 0.0) {
                datumRange = new DatumRange(0.0, 10.0, units);
            }
            dasAxis = new DasAxis(datumRange.min(), datumRange.max(), 3, bl);
        } else {
            throw new IllegalArgumentException("not supported: " + dataSet);
        }
        if (dataSet.getProperty("yLabel") != null) {
            dasAxis.setLabel((String)dataSet.getProperty("yLabel"));
        }
        return dasAxis;
    }

    public static DasAxis guessXAxis(DataSet dataSet) {
        Datum datum = dataSet.getXTagDatum(0);
        Datum datum2 = dataSet.getXTagDatum(dataSet.getXLength() - 1);
        return new DasAxis(datum, datum2, 2);
    }

    public static DasAxis guessZAxis(DataSet dataSet) {
        if (!(dataSet instanceof TableDataSet)) {
            throw new IllegalArgumentException("only TableDataSet supported");
        }
        TableDataSet tableDataSet = (TableDataSet)dataSet;
        Units units = tableDataSet.getZUnits();
        DatumRange datumRange = DataSetUtil.zRange(tableDataSet);
        boolean bl = false;
        if (dataSet.getProperty("zScaleType") != null && dataSet.getProperty("zScaleType").equals("log")) {
            bl = true;
            if (datumRange.min().doubleValue(datumRange.getUnits()) <= 0.0) {
                double d = datumRange.max().doubleValue(datumRange.getUnits());
                datumRange = new DatumRange(d / 1000.0, d, datumRange.getUnits());
            }
        }
        DasAxis dasAxis = new DasAxis(datumRange.min(), datumRange.max(), 3, bl);
        if (dataSet.getProperty("zLabel") != null) {
            dasAxis.setLabel((String)dataSet.getProperty("zLabel"));
        }
        return dasAxis;
    }

    public static Renderer guessRenderer(DataSet dataSet) {
        Renderer renderer = null;
        if (dataSet instanceof VectorDataSet) {
            if (dataSet.getXLength() > 10000) {
                renderer = new ImageVectorDataSetRenderer(new ConstantDataSetDescriptor(dataSet));
            } else {
                renderer = new SymbolLineRenderer(dataSet);
                ((SymbolLineRenderer)renderer).setPsym(Psym.DOTS);
                ((SymbolLineRenderer)renderer).setSymSize(2.0);
            }
        } else if (dataSet instanceof TableDataSet) {
            Units units = ((TableDataSet)dataSet).getZUnits();
            DasAxis dasAxis = GraphUtil.guessZAxis(dataSet);
            DasColorBar dasColorBar = new DasColorBar(dasAxis.getDataMinimum(), dasAxis.getDataMaximum(), dasAxis.isLog());
            dasColorBar.setLabel(dasAxis.getLabel());
            renderer = new SpectrogramRenderer(new ConstantDataSetDescriptor(dataSet), dasColorBar);
        }
        return renderer;
    }

    public static DasPlot guessPlot(DataSet dataSet) {
        DasAxis dasAxis = GraphUtil.guessXAxis(dataSet);
        DasAxis dasAxis2 = GraphUtil.guessYAxis(dataSet);
        DasPlot dasPlot = new DasPlot(dasAxis, dasAxis2);
        dasPlot.addRenderer(GraphUtil.guessRenderer(dataSet));
        return dasPlot;
    }

    public static DasPlot visualize(DataSet dataSet) {
        JFrame jFrame = new JFrame("DataSetUtil.visualize");
        DasCanvas dasCanvas = new DasCanvas(400, 400);
        jFrame.getContentPane().add(dasCanvas);
        DasPlot dasPlot = GraphUtil.guessPlot(dataSet);
        dasCanvas.add(dasPlot, DasRow.create(dasCanvas), DasColumn.create(dasCanvas));
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(3);
        return dasPlot;
    }

    public static DasPlot visualize(DataSet dataSet, boolean bl) {
        DatumRange datumRange = DataSetUtil.xRange(dataSet);
        DatumRange datumRange2 = DataSetUtil.yRange(dataSet);
        JFrame jFrame = new JFrame("DataSetUtil.visualize");
        DasCanvas dasCanvas = new DasCanvas(400, 400);
        jFrame.getContentPane().add(dasCanvas);
        DasPlot dasPlot = GraphUtil.guessPlot(dataSet);
        dasCanvas.add(dasPlot, DasRow.create(dasCanvas), DasColumn.create(dasCanvas));
        Units units = dasPlot.getXAxis().getUnits();
        dasPlot.getXAxis().setDatumRange(datumRange.zoomOut(1.1));
        Units units2 = dasPlot.getYAxis().getUnits();
        if (bl) {
            dasPlot.getYAxis().setDatumRange(datumRange2);
            dasPlot.getYAxis().setLog(true);
        } else {
            dasPlot.getYAxis().setDatumRange(datumRange2.zoomOut(1.1));
        }
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(3);
        return dasPlot;
    }
}

