/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.graph.TickLabeller;
import edu.uiowa.physics.pw.das.graph.TickVDescriptor;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class GrannyTickLabeller
implements TickLabeller {
    private TickVDescriptor ticks;
    private Component parent;
    private DatumFormatter df;

    public GrannyTickLabeller(Component component) {
        this.parent = component;
    }

    public void init(TickVDescriptor tickVDescriptor) {
        this.ticks = tickVDescriptor;
        this.df = tickVDescriptor.getFormatter();
    }

    public void setFormatter(DatumFormatter datumFormatter) {
        this.df = datumFormatter;
    }

    private double length(Line2D line2D) {
        double d = line2D.getX2() - line2D.getX1();
        double d2 = line2D.getY2() - line2D.getY1();
        double d3 = Math.sqrt(d * d + d2 * d2);
        return d3;
    }

    private Line2D normalize(Line2D line2D, double d) {
        Point2D point2D = line2D.getP1();
        double d2 = line2D.getX2() - line2D.getX1();
        double d3 = line2D.getY2() - line2D.getY1();
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        Line2D line2D2 = (Line2D)line2D.clone();
        line2D2.setLine(point2D.getX(), point2D.getY(), point2D.getX() + d2 / d4 * d, point2D.getY() + d3 / d4 * d);
        return line2D2;
    }

    public Rectangle labelMajorTick(Graphics graphics, int n, Line2D line2D) {
        double d;
        double d2;
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        String string = this.getLabel(n, this.ticks.tickV.get(n));
        grannyTextRenderer.setString(this.parent, string);
        Rectangle rectangle = grannyTextRenderer.getBounds();
        double d3 = (line2D.getY2() - line2D.getY1()) / (line2D.getX2() - line2D.getX1());
        double d4 = rectangle.getWidth();
        double d5 = rectangle.getHeight();
        double d6 = d5 / d4;
        int n2 = 3;
        int n3 = 3;
        int n4 = 2;
        line2D = this.normalize(line2D, this.length(line2D) + (double)n4);
        if (d6 > Math.abs(d3)) {
            if (line2D.getX2() > line2D.getX1()) {
                double d7 = d3 * d4 / 2.0;
                d2 = line2D.getX2();
                d = line2D.getY2() - d5 / 2.0 + grannyTextRenderer.getAscent() + d7;
            } else {
                double d8 = -d3 * d4 / 2.0;
                d2 = line2D.getX2() - d4;
                d = line2D.getY2() - d5 / 2.0 + grannyTextRenderer.getAscent() + d8;
            }
        } else if (line2D.getY2() < line2D.getY1()) {
            double d9 = -d5 / d3 / 2.0;
            d2 = line2D.getX2() + d9 - d4 / 2.0;
            d = line2D.getY2() - grannyTextRenderer.getDescent() + (double)n3;
        } else {
            double d10 = d5 / d3 / 2.0;
            d2 = line2D.getX2() + d10 - d4 / 2.0;
            d = line2D.getY2() + grannyTextRenderer.getAscent() - (double)n2;
        }
        grannyTextRenderer.draw(graphics, (float)d2, (float)d);
        rectangle.translate((int)d2, (int)d);
        return rectangle;
    }

    protected String getLabel(int n, Datum datum) {
        return this.df.grannyFormat(datum);
    }

    public void finished() {
    }
}

