/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumUtil;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.event.LabelDragRenderer;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.system.DasLogger;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EventsRenderer
extends Renderer {
    int[] eventMap;
    private Color color = new Color(100, 100, 100, 180);
    private String widthPlaneId = "xTagWidth";

    public EventsRenderer(DataSetDescriptor dataSetDescriptor) {
        super(dataSetDescriptor);
    }

    public EventsRenderer() {
    }

    protected Element getDOMElement(Document document) {
        return null;
    }

    protected void installRenderer() {
        MouseModule mouseModule = this.getMouseModule();
        this.parent.getMouseAdapter().addMouseModule(mouseModule);
        this.parent.getMouseAdapter().setPrimaryModule(mouseModule);
    }

    private MouseModule getMouseModule() {
        return new MouseModule(this.parent, new DragRenderer(this.parent), "event lookup");
    }

    public void render(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2) {
        VectorDataSet vectorDataSet = (VectorDataSet)this.getDataSet();
        if (vectorDataSet == null || vectorDataSet.getXLength() == 0) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("null data set");
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(this.color);
        if (vectorDataSet == null && this.lastException != null) {
            this.renderException(graphics2D, dasAxis, dasAxis2, this.lastException);
        } else {
            VectorDataSet vectorDataSet2 = (VectorDataSet)vectorDataSet.getPlanarView(this.widthPlaneId);
            if (vectorDataSet2 == null) {
                throw new IllegalArgumentException("no width plane named \"" + this.widthPlaneId + "\" found");
            }
            DasColumn dasColumn = dasAxis.getColumn();
            DasRow dasRow = this.parent.getRow();
            this.eventMap = new int[dasColumn.getWidth()];
            for (int i = 0; i < this.eventMap.length; ++i) {
                this.eventMap[i] = -1;
            }
            if (vectorDataSet.getXLength() > 0) {
                int n;
                int n2;
                int n3;
                UnitsConverter unitsConverter = UnitsConverter.getConverter(vectorDataSet2.getYUnits(), dasAxis.getUnits().getOffsetUnits());
                int n4 = 0;
                int n5 = vectorDataSet.getXLength();
                for (n3 = n4; n3 < n5; ++n3) {
                    Datum datum = vectorDataSet.getXTagDatum(n3);
                    n2 = (int)dasAxis.transform(datum);
                    if (unitsConverter != null) {
                        Datum datum2 = vectorDataSet2.getDatum(n3);
                        n = (int)dasAxis.transform(datum.add(datum2)) - n2;
                    } else {
                        n = 1;
                    }
                    if (dasColumn.getDMinimum() >= n2 + n && dasColumn.getDMaximum() <= n2) continue;
                    if (n == 0) {
                        n = 1;
                    }
                    graphics2D.fill(new Rectangle(n2, dasRow.getDMinimum(), n, dasRow.getHeight()));
                    int n6 = n2 - dasColumn.getDMinimum();
                    int n7 = n6 - 1;
                    int n8 = n6 + n + 1;
                    for (int i = n7; i < n8; ++i) {
                        if (i < 0 || i >= this.eventMap.length) continue;
                        this.eventMap[i] = n3;
                    }
                }
                for (n3 = 1; n3 <= 2; ++n3) {
                    for (int i = -1; i <= 1; i += 2) {
                        n2 = i == 1 ? 0 : this.eventMap.length - 1;
                        n = i == 1 ? this.eventMap.length - n3 : n3;
                        for (int j = n2; j != n; j += i) {
                            if (this.eventMap[j] != -1) continue;
                            this.eventMap[j] = this.eventMap[j + i];
                        }
                    }
                }
            }
        }
        graphics2D.dispose();
    }

    protected void uninstallRenderer() {
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 180);
        super.invalidateParentCacheImage();
    }

    public void setWidthPlaneId(String string) {
        this.widthPlaneId = string;
    }

    public String getWidthPlaneId() {
        return this.widthPlaneId;
    }

    private class DragRenderer
    extends LabelDragRenderer {
        DasAxis xaxis;
        DasAxis yaxis;
        DasPlot parent;

        DragRenderer(DasPlot dasPlot) {
            super(dasPlot);
            this.xaxis = dasPlot.getXAxis();
            this.yaxis = dasPlot.getYAxis();
            this.parent = dasPlot;
            this.setTooltip(true);
        }

        public Rectangle[] renderDrag(Graphics graphics, Point point, Point point2) {
            VectorDataSet vectorDataSet = (VectorDataSet)EventsRenderer.this.getDataSet();
            if (vectorDataSet == null) {
                return new Rectangle[0];
            }
            if (vectorDataSet.getXLength() == 0) {
                return new Rectangle[0];
            }
            if (point2.getX() < 0.0 || point2.getX() >= (double)EventsRenderer.this.eventMap.length) {
                this.setLabel(null);
            } else {
                int n = EventsRenderer.this.eventMap[(int)point2.getX()];
                if (n >= 0) {
                    Datum datum = vectorDataSet.getXTagDatum(n);
                    Datum datum2 = vectorDataSet.getDatum(n);
                    VectorDataSet vectorDataSet2 = (VectorDataSet)vectorDataSet.getPlanarView(EventsRenderer.this.widthPlaneId);
                    Datum datum3 = DatumUtil.asOrderOneUnits(vectorDataSet2.getDatum(n));
                    DatumRange datumRange = new DatumRange(datum, datum.add(datum3));
                    this.setLabel("" + datumRange + " (" + datum3 + ")!c" + datum2);
                } else {
                    this.setLabel(null);
                }
            }
            return super.renderDrag(graphics, point, point2);
        }
    }
}

