/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateEvent;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class DataRange
implements Cloneable {
    private DasAxis parent;
    private Units units;
    private double minimum;
    private double maximum;
    private Datum pendingMin = null;
    private Datum pendingMax = null;
    private DatumRange range;
    private boolean log;
    private EventListenerList listenerList = new EventListenerList();
    private Stack history;
    private Stack forwardHistory;
    private List favorites;
    private PropertyChangeSupport propertyChangeDelegate;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Assertion failure");
        }
    }

    public DataRange(DasAxis dasAxis, Datum datum, Datum datum2, boolean bl) {
        if (datum.gt(datum2)) {
            throw new IllegalArgumentException("data min on axis is greater than data max");
        }
        if (!datum.isValid()) {
            throw new IllegalArgumentException("data_minimum on axis is NaN");
        }
        if (!datum2.isValid()) {
            throw new IllegalArgumentException("data_maximum on axis is NaN");
        }
        if (datum.getUnits() != datum2.getUnits()) {
            throw new IllegalArgumentException("units don't match on range");
        }
        this.parent = dasAxis;
        this.units = datum.getUnits();
        if (bl) {
            this.minimum = DasMath.log10(datum.doubleValue(this.units));
            this.maximum = DasMath.log10(datum2.doubleValue(this.units));
        } else {
            this.minimum = datum.doubleValue(this.units);
            this.maximum = datum2.doubleValue(this.units);
        }
        this.range = new DatumRange(datum, datum2);
        this.log = bl;
        this.history = new Stack();
        this.forwardHistory = new Stack();
        this.propertyChangeDelegate = new PropertyChangeSupport(this);
    }

    public boolean isLog() {
        return this.log;
    }

    public void resetRange(DatumRange datumRange) {
        this.units = datumRange.getUnits();
        this.range = datumRange;
        this.minimum = datumRange.min().doubleValue(this.units);
        this.maximum = datumRange.max().doubleValue(this.units);
        if (this.isLog()) {
            this.minimum = DasMath.log10(this.minimum);
            this.maximum = DasMath.log10(this.maximum);
        }
        this.fireUpdate();
    }

    public void setLog(boolean bl) {
        if (this.log == bl) {
            return;
        }
        boolean bl2 = this.log;
        if (bl) {
            if (this.minimum <= 0.0 || this.maximum <= 0.0) {
                if (this.maximum <= 0.0) {
                    this.maximum = 100.0;
                }
                if (this.minimum <= 0.0) {
                    this.minimum = this.maximum / 1000.0;
                }
                this.range = new DatumRange(this.minimum, this.maximum, this.range.getUnits());
            }
            this.minimum = DasMath.log10(this.minimum);
            this.maximum = DasMath.log10(this.maximum);
        } else {
            this.minimum = DasMath.exp10(this.minimum);
            this.maximum = DasMath.exp10(this.maximum);
        }
        this.clearHistory();
        this.log = bl;
        this.firePropertyChange("log", bl2, bl);
        this.fireUpdate();
    }

    public DasAxis getCreator() {
        return this.parent;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public final double findex(double d) {
        if (this.log) {
            d = DasMath.log10(d);
        }
        return (d - this.minimum) / (this.maximum - this.minimum);
    }

    public Units getUnits() {
        return this.units;
    }

    public DatumRange getDatumRange() {
        return this.range;
    }

    public void setUnits(Units units) {
        if (this.units.equals(units)) {
            return;
        }
        this.minimum = this.units.convertDoubleTo(units, this.minimum);
        this.maximum = this.units.convertDoubleTo(units, this.maximum);
        this.units = units;
        this.clearHistory();
    }

    public void setMinimum(Datum datum) {
        Datum datum2;
        Datum datum3 = datum2 = this.pendingMax != null ? this.pendingMax : this.range.max();
        if (datum.le(datum2)) {
            this.setRange(new DatumRange(datum, datum2));
        } else {
            this.pendingMin = datum;
        }
    }

    public void setMaximum(Datum datum) {
        Datum datum2;
        Datum datum3 = datum2 = this.pendingMin != null ? this.pendingMin : this.range.min();
        if (datum2.le(datum)) {
            this.setRange(new DatumRange(datum2, datum));
        } else {
            this.pendingMax = datum;
        }
    }

    private void reportHistory() {
        Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);
        logger.finest("history: " + this.history.size());
        for (int i = 0; i < this.history.size(); ++i) {
            logger.finest("   " + this.history.get(i));
        }
        logger.finest("forwardHistory: " + this.forwardHistory.size());
        logger.finest("-------------");
    }

    protected void clearHistory() {
        ArrayList arrayList = new ArrayList(this.history);
        this.history.removeAllElements();
        this.forwardHistory.removeAllElements();
        this.firePropertyChange("history", arrayList, this.history);
    }

    public void addToFavorites(DatumRange datumRange) {
        if (this.favorites == null) {
            this.favorites = new ArrayList();
        }
        ArrayList arrayList = new ArrayList(this.favorites);
        this.favorites.add(datumRange);
        this.firePropertyChange("favorites", arrayList, this.favorites);
    }

    public List getFavorites() {
        if (this.favorites == null) {
            return new ArrayList();
        }
        return new ArrayList(this.favorites);
    }

    public List getHistory() {
        if (this.history == null) {
            return new ArrayList();
        }
        ArrayList arrayList = new ArrayList(this.history);
        Collections.reverse(arrayList);
        return arrayList.subList(0, Math.min(arrayList.size(), 10));
    }

    public void setRange(DatumRange datumRange) {
        this.pendingMin = null;
        this.pendingMax = null;
        this.setRange(datumRange, true);
    }

    public void setRange(double d, double d2) {
        DatumRange datumRange = this.log ? new DatumRange(DasMath.exp10(d), DasMath.exp10(d2), this.units) : new DatumRange(d, d2, this.units);
        this.setRange(datumRange, true);
    }

    private void setRange(DatumRange datumRange, boolean bl) {
        if (!datumRange.getUnits().isConvertableTo(this.units)) {
            throw new IllegalArgumentException("units may not be changed");
        }
        if (bl) {
            ArrayList arrayList = new ArrayList(this.history);
            this.history.push(this.range);
            DasApplication.getDefaultApplication().getLogger(DasApplication.GUI_LOG).fine("push history: " + datumRange);
            this.forwardHistory.removeAllElements();
            this.firePropertyChange("history", new ArrayList(), new ArrayList(this.history));
        }
        this.range = datumRange;
        double d = this.minimum;
        double d2 = this.maximum;
        this.minimum = datumRange.min().doubleValue(this.units);
        this.maximum = datumRange.max().doubleValue(this.units);
        if (this.log) {
            this.minimum = DasMath.log10(this.minimum);
            this.maximum = DasMath.log10(this.maximum);
        }
        this.fireUpdate();
        if (this.minimum != d) {
            this.firePropertyChange("minimum", d, this.minimum);
        }
        if (this.maximum != d2) {
            this.firePropertyChange("maximum", d2, this.maximum);
        }
    }

    public void setRangePrev() {
        this.reportHistory();
        if (!this.history.isEmpty()) {
            this.forwardHistory.push(this.range);
            DatumRange datumRange = (DatumRange)this.history.pop();
            this.setRange(datumRange, false);
            this.firePropertyChange("history", null, new ArrayList(this.history));
        }
    }

    public void setRangeForward() {
        this.reportHistory();
        if (!this.forwardHistory.isEmpty()) {
            ArrayList arrayList = new ArrayList(this.history);
            this.history.push(this.range);
            DatumRange datumRange = (DatumRange)this.forwardHistory.pop();
            this.setRange(datumRange, false);
            this.firePropertyChange("history", arrayList, this.history);
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeDelegate.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeDelegate.addPropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(String string, double d, double d2) {
        this.firePropertyChange(string, new Double(d), new Double(d2));
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.firePropertyChange(string, bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeDelegate.firePropertyChange(string, object, object2);
    }

    public void addUpdateListener(DasUpdateListener dasUpdateListener) {
        this.listenerList.add(DasUpdateListener.class, dasUpdateListener);
    }

    public void removeUpdateListener(DasUpdateListener dasUpdateListener) {
        this.listenerList.remove(DasUpdateListener.class, dasUpdateListener);
    }

    protected void fireUpdate() {
        Object[] objectArray = this.listenerList.getListenerList();
        DasUpdateEvent dasUpdateEvent = new DasUpdateEvent(this);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DasUpdateListener.class) continue;
            ((DasUpdateListener)objectArray[i + 1]).update(dasUpdateEvent);
        }
    }

    protected void popHistory(int n) {
        for (int i = 0; i < n; ++i) {
            this.history.pop();
        }
    }

    public static DataRange getAnimationDataRange(DatumRange datumRange, boolean bl) {
        return new Animation(datumRange, bl);
    }

    public static class Animation
    extends DataRange {
        private double minimum;
        private double maximum;

        public Animation(DatumRange datumRange, boolean bl) {
            super(null, datumRange.min(), datumRange.max(), bl);
        }

        protected void fireUpdate() {
        }

        public void setRange(double d, double d2) {
            this.minimum = d;
            this.maximum = d2;
        }

        public double getMinimum() {
            return this.minimum;
        }

        public double getMaximum() {
            return this.maximum;
        }
    }
}

