/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;

public abstract class DataLoader {
    Renderer renderer;
    private boolean fullResolution = false;
    private boolean reloadDataSet;
    private boolean active = true;

    protected DasProgressMonitor getMonitor(String string) {
        return DasApplication.getDefaultApplication().getMonitorFactory().getMonitor(this.renderer.getParent(), "Loading data set", string);
    }

    protected DataLoader(Renderer renderer) {
        this.renderer = renderer;
    }

    public abstract void update();

    public boolean isFullResolution() {
        return this.fullResolution;
    }

    public void setFullResolution(boolean bl) {
        if (this.fullResolution == bl) {
            return;
        }
        this.fullResolution = bl;
    }

    public void setReloadDataSet(boolean bl) {
        if (bl) {
            this.renderer.setDataSet(null);
            this.renderer.getParent().markDirty();
            this.renderer.getParent().update();
        }
        bl = false;
    }

    public boolean isReloadDataSet() {
        return this.reloadDataSet;
    }

    protected Renderer getRenderer() {
        return this.renderer;
    }

    protected RebinDescriptor getRebinDescriptor(DasAxis dasAxis) {
        int n = dasAxis.getOrientation() == 3 ? dasAxis.getRow().getHeight() : dasAxis.getColumn().getWidth();
        RebinDescriptor rebinDescriptor = new RebinDescriptor(dasAxis.getDataMinimum(), dasAxis.getDataMaximum(), n, dasAxis.isLog());
        rebinDescriptor.setOutOfBoundsAction(-3);
        return rebinDescriptor;
    }

    public boolean isActive() {
        return this.active && this.renderer.isActive();
    }

    public void setActive(boolean bl) {
        this.active = bl;
        this.update();
    }

    public class Request {
        public DasProgressMonitor monitor;
        public DasAxis.Memento xmem;
        public DasAxis.Memento ymem;

        public Request(DasProgressMonitor dasProgressMonitor, DasAxis.Memento memento, DasAxis.Memento memento2) {
            this.monitor = dasProgressMonitor;
            this.xmem = memento;
            this.ymem = memento2;
        }

        public String toString() {
            return this.xmem.toString();
        }
    }
}

