/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasDevicePosition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasRow
extends DasDevicePosition {
    public static final DasRow NULL = new DasRow(null, null, 0.0, 0.0, 0.0, 0.0, 0, 0);

    public DasRow(DasCanvas dasCanvas, double d, double d2) {
        super(dasCanvas, d, d2, false);
    }

    public DasRow(DasCanvas dasCanvas, DasRow dasRow, double d, double d2, double d3, double d4, int n, int n2) {
        super(dasCanvas, false, dasRow, d, d2, d3, d4, n, n2);
    }

    public DasRow createSubRow(double d, double d2) {
        double d3 = this.getMinimum();
        double d4 = this.getMaximum();
        double d5 = d3 - d4;
        return new DasRow(this.getCanvas(), d4 + d * d5, d4 + d2 * d5);
    }

    public int getHeight() {
        return this.getDMaximum() - this.getDMinimum();
    }

    public static DasRow create(DasCanvas dasCanvas) {
        return new DasRow(dasCanvas, 0.1, 0.9);
    }

    public static DasRow create(DasCanvas dasCanvas, int n, int n2) {
        double d = 0.1 + (double)n * 0.8 / (double)n2;
        double d2 = 0.099 + (double)(n + 1) * 0.8 / (double)n2;
        return new DasRow(dasCanvas, d, d2);
    }

    public DasRow createAttachedRow(double d, double d2) {
        return new DasRow(null, this, d, d2, 0.0, 0.0, 0, 0);
    }

    static DasRow processRowElement(Element element, DasCanvas dasCanvas, FormBase formBase) throws DasException {
        String string = element.getAttribute("name");
        double d = Double.parseDouble(element.getAttribute("minimum"));
        double d2 = Double.parseDouble(element.getAttribute("maximum"));
        DasRow dasRow = new DasRow(dasCanvas, d, d2);
        dasRow.setDasName(string);
        DasApplication dasApplication = formBase.getDasApplication();
        NameContext nameContext = dasApplication.getNameContext();
        nameContext.put(string, dasRow);
        return dasRow;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("row");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("minimum", Double.toString(this.getMinimum()));
        element.setAttribute("maximum", Double.toString(this.getMaximum()));
        return element;
    }
}

