/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.event.BoxZoomMouseModule;
import edu.uiowa.physics.pw.das.event.CrossHairMouseModule;
import edu.uiowa.physics.pw.das.event.HorizontalRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.event.LengthDragRenderer;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.VerticalRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRendererUpdateEvent;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import edu.uiowa.physics.pw.das.graph.TickVDescriptor;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableRenderer;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DasPlot
extends DasCanvasComponent
implements DataSetConsumer {
    protected DataSetDescriptor dataSetDescriptor;
    protected DataSet Data;
    private DasAxis xAxis;
    private DasAxis yAxis;
    DasAxis.Memento xmemento;
    DasAxis.Memento ymemento;
    protected String offsetTime = "";
    protected String plotTitle = "";
    protected double[] psym_x;
    protected double[] psym_y;
    protected RebinListener rebinListener = new RebinListener();
    DnDSupport dndSupport;
    static Logger logger = DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG);
    boolean cacheImageValid = false;
    Image cacheImage;
    boolean preview = false;
    private int repaintCount = 0;
    private int paintComponentCount = 0;
    private Action DUMP_TO_FILE_ACTION = new AbstractAction("Dump Data Set to File"){

        public void actionPerformed(ActionEvent actionEvent) {
            if (DasPlot.this.renderers.isEmpty()) {
                return;
            }
            Renderer renderer = (Renderer)DasPlot.this.renderers.get(0);
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showSaveDialog(DasPlot.this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                try {
                    FileChannel fileChannel = new FileOutputStream(file).getChannel();
                    DataSet dataSet = renderer.getDataSet();
                    if (dataSet instanceof TableDataSet) {
                        TableUtil.dumpToAsciiStream((TableDataSet)dataSet, fileChannel);
                    } else if (dataSet instanceof VectorDataSet) {
                        VectorUtil.dumpToAsciiStream((VectorDataSet)dataSet, fileChannel);
                    }
                }
                catch (IOException iOException) {
                    DasExceptionHandler.handle(iOException);
                }
            }
        }
    };
    private List renderers = null;
    private boolean drawGrid = false;

    public DasPlot(DasAxis dasAxis, DasAxis dasAxis2) {
        this.setOpaque(false);
        this.renderers = new ArrayList();
        this.xAxis = dasAxis;
        if (dasAxis != null) {
            if (!dasAxis.isHorizontal()) {
                throw new IllegalArgumentException("xAxis is not horizontal");
            }
            dasAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            dasAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            dasAxis.addPropertyChangeListener("log", this.rebinListener);
        }
        this.yAxis = dasAxis2;
        if (dasAxis2 != null) {
            if (dasAxis2.isHorizontal()) {
                throw new IllegalArgumentException("yAxis is not vertical");
            }
            dasAxis2.addPropertyChangeListener("dataMinimum", this.rebinListener);
            dasAxis2.addPropertyChangeListener("dataMaximum", this.rebinListener);
            dasAxis2.addPropertyChangeListener("log", this.rebinListener);
        }
        if (!"true".equals(System.getProperty("java.awt.headless"))) {
            this.addDefaultMouseModules();
        }
    }

    private void addDefaultMouseModules() {
        HorizontalRangeSelectorMouseModule horizontalRangeSelectorMouseModule = new HorizontalRangeSelectorMouseModule(this, this.xAxis);
        this.mouseAdapter.addMouseModule(horizontalRangeSelectorMouseModule);
        horizontalRangeSelectorMouseModule.addDataRangeSelectionListener(this.xAxis);
        VerticalRangeSelectorMouseModule verticalRangeSelectorMouseModule = new VerticalRangeSelectorMouseModule(this, this.yAxis);
        this.mouseAdapter.addMouseModule(verticalRangeSelectorMouseModule);
        verticalRangeSelectorMouseModule.addDataRangeSelectionListener(this.yAxis);
        MouseModule mouseModule = CrossHairMouseModule.create(this);
        this.mouseAdapter.addMouseModule(mouseModule);
        this.mouseAdapter.setSecondaryModule(mouseModule);
        this.mouseAdapter.setPrimaryModule(mouseModule);
        this.mouseAdapter.addMouseModule(new BoxZoomMouseModule(this, this, this.getXAxis(), this.getYAxis()));
        mouseModule = new MouseModule(this, new LengthDragRenderer(this, null, null), "Length");
        this.mouseAdapter.addMouseModule(mouseModule);
        JMenuItem jMenuItem = new JMenuItem(this.DUMP_TO_FILE_ACTION);
        this.mouseAdapter.addMenuItem(jMenuItem);
    }

    public DataSet getDataSet() {
        return this.Data;
    }

    public DataSet getData() {
        return this.Data;
    }

    public void setXAxis(DasAxis dasAxis) {
        DasAxis dasAxis2 = this.xAxis;
        Container container = this.getParent();
        if (this.xAxis != null) {
            DasProperties.getLogger().fine("setXAxis upsets the dmia");
            if (container != null) {
                container.remove(this.xAxis);
            }
            dasAxis.removePropertyChangeListener("dataMinimum", this.rebinListener);
            dasAxis.removePropertyChangeListener("dataMaximum", this.rebinListener);
            dasAxis.removePropertyChangeListener("log", this.rebinListener);
        }
        this.xAxis = dasAxis;
        if (dasAxis != null) {
            if (!dasAxis.isHorizontal()) {
                throw new IllegalArgumentException("xAxis is not horizontal");
            }
            if (container != null) {
                container.add(this.xAxis);
                container.validate();
            }
            dasAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            dasAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            dasAxis.addPropertyChangeListener("log", this.rebinListener);
        }
        if (dasAxis != dasAxis2) {
            this.firePropertyChange("xAxis", dasAxis2, dasAxis);
        }
    }

    public void setYAxis(DasAxis dasAxis) {
        DasAxis dasAxis2 = this.yAxis;
        logger.info("setYAxis(" + dasAxis.getName() + "), removes " + this.yAxis);
        Container container = this.getParent();
        if (this.yAxis != null) {
            DasProperties.getLogger().fine("setYAxis upsets the dmia");
            if (container != null) {
                container.remove(this.yAxis);
            }
            this.yAxis.removePropertyChangeListener("dataMinimum", this.rebinListener);
            this.yAxis.removePropertyChangeListener("dataMaximum", this.rebinListener);
            this.yAxis.removePropertyChangeListener("log", this.rebinListener);
        }
        this.yAxis = dasAxis;
        if (dasAxis != null) {
            if (dasAxis.isHorizontal()) {
                throw new IllegalArgumentException("yAxis is not vertical");
            }
            dasAxis.setRow(this.getRow());
            dasAxis.setColumn(this.getColumn());
            if (container != null) {
                container.add(this.yAxis);
                container.validate();
            }
            dasAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            dasAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            dasAxis.addPropertyChangeListener("log", this.rebinListener);
        }
        if (dasAxis != dasAxis2) {
            this.firePropertyChange("yAxis", dasAxis2, dasAxis);
        }
    }

    protected void updateImmediately() {
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        logger.finer("DasPlot.updateImmediately");
        for (int i = 0; i < this.renderers.size(); ++i) {
            Renderer renderer = (Renderer)this.renderers.get(i);
            renderer.update();
        }
    }

    private String getATScaleTranslateString(AffineTransform affineTransform) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        if (affineTransform == null) {
            return "null";
        }
        if (!affineTransform.isIdentity()) {
            String string = "scaleX:" + decimalFormat.format(affineTransform.getScaleX()) + " translateX:" + decimalFormat.format(affineTransform.getTranslateX());
            string = string + "!cscaleY:" + decimalFormat.format(affineTransform.getScaleY()) + " translateY:" + decimalFormat.format(affineTransform.getTranslateY());
            return string;
        }
        return "identity";
    }

    protected AffineTransform getAffineTransform(DasAxis dasAxis, DasAxis dasAxis2) {
        if (this.xmemento == null) {
            logger.fine("unable to calculate AT, because old transform is not defined.");
            return null;
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform = dasAxis.getAffineTransform(this.xmemento, affineTransform);
        affineTransform = dasAxis2.getAffineTransform(this.ymemento, affineTransform);
        return affineTransform;
    }

    private boolean isIdentity(AffineTransform affineTransform) {
        return affineTransform.isIdentity() || Math.abs(affineTransform.getScaleX() - 1.0) < 0.001 && Math.abs(affineTransform.getScaleY() - 1.0) < 0.001 && Math.abs(affineTransform.getTranslateX()) < 0.001 && Math.abs(affineTransform.getTranslateY()) < 0.001;
    }

    private void paintInvalidScreen(Graphics graphics, AffineTransform affineTransform) {
        Color color = new Color(255, 255, 255, 128);
        graphics.setColor(color);
        int n = this.getColumn().getDMinimum();
        int n2 = this.getRow().getDMinimum();
        graphics.fillRect(n - 1, n2 - 1, this.getWidth(), this.getHeight());
        logger.finest(" using cacheImage with ricepaper to invalidate");
    }

    protected void paintComponent(Graphics graphics) {
        Object object;
        Object object2;
        if (!EventQueue.isDispatchThread()) {
            throw new RuntimeException("not event thread: " + Thread.currentThread().getName());
        }
        logger.finer("entering DasPlot.paintComponent");
        int n = this.getColumn().getDMinimum();
        int n2 = this.getRow().getDMinimum();
        int n3 = this.getColumn().getDMaximum() - n;
        int n4 = this.getRow().getDMaximum() - n2;
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.y + this.getY() >= n2 + n4) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(-this.getX(), -this.getY());
        if (this.cacheImageValid && !this.getCanvas().isPrintingThread()) {
            object2 = (Graphics2D)graphics2D.create();
            AffineTransform affineTransform = this.getAffineTransform(this.xAxis, this.yAxis);
            if (affineTransform == null || !this.preview && !this.isIdentity(affineTransform)) {
                ((Graphics)object2).drawImage(this.cacheImage, n - 1, n2 - 1, this.getWidth(), this.getHeight(), this);
                this.paintInvalidScreen((Graphics)object2, affineTransform);
            } else {
                object = new DecimalFormat("0.00");
                String string = this.getATScaleTranslateString(affineTransform);
                if (!affineTransform.isIdentity()) {
                    logger.finest(" using cacheImage w/AT " + string);
                    ((Graphics2D)object2).transform(affineTransform);
                } else {
                    logger.finest(" using cacheImage");
                }
                ((Graphics)object2).drawImage(this.cacheImage, n - 1, n2 - 1, this.getWidth(), this.getHeight(), this);
            }
            ((Graphics)object2).dispose();
        } else {
            if (this.getCanvas().isPrintingThread()) {
                object2 = (Graphics2D)graphics2D.create(n - 1, n2 - 1, n3 + 2, n4 + 2);
                logger.finest(" printing thread, drawing");
            } else {
                this.cacheImage = new BufferedImage(this.getWidth(), this.getHeight(), 6);
                object2 = (Graphics2D)this.cacheImage.getGraphics();
                ((Graphics2D)object2).setRenderingHints(DasProperties.getRenderingHints());
                logger.finest(" rebuilding cacheImage");
            }
            ((Graphics2D)object2).translate(-n + 1, -n2 + 1);
            if (this.drawGrid) {
                this.drawGrid((Graphics2D)object2);
            }
            this.drawContent((Graphics2D)object2);
            boolean bl = true;
            for (int i = 0; i < this.renderers.size(); ++i) {
                object = (Renderer)this.renderers.get(i);
                if (!((Renderer)object).isActive()) continue;
                ((Renderer)object).render((Graphics)object2, this.xAxis, this.yAxis);
                bl = false;
            }
            if (this.renderers.size() == 0) {
                graphics2D.setColor(Color.gray);
                String string = "(no renderers)";
                logger.info("dasPlot has no renderers");
                graphics2D.drawString(string, this.getColumn().getDMiddle() - graphics2D.getFontMetrics().stringWidth(string) / 2, this.getRow().getDMiddle());
            } else if (bl) {
                graphics2D.setColor(Color.gray);
                String string = "(no active renderers)";
                graphics2D.drawString(string, this.getColumn().getDMiddle() - graphics2D.getFontMetrics().stringWidth(string) / 2, this.getRow().getDMiddle());
            }
            if (!this.getCanvas().isPrintingThread()) {
                this.cacheImageValid = true;
                graphics2D.drawImage(this.cacheImage, n - 1, n2 - 1, this.getWidth(), this.getHeight(), this);
                this.xmemento = this.xAxis.getMemento();
                this.ymemento = this.yAxis.getMemento();
                DatumRange datumRange = new DatumRange(this.xAxis.getDataRange().getMinimum(), this.xAxis.getDataRange().getMaximum(), this.xAxis.getDataRange().getUnits());
                logger.finest("recalc cacheImage, xmemento=" + this.xmemento + " dr=" + datumRange);
            }
        }
        graphics2D.setColor(this.getForeground());
        graphics2D.drawRect(n - 1, n2 - 1, n3 + 1, n4 + 1);
        if (this.plotTitle != null && this.plotTitle.length() != 0) {
            object2 = new GrannyTextRenderer();
            ((GrannyTextRenderer)object2).setAlignment(1);
            ((GrannyTextRenderer)object2).setString(this, this.plotTitle);
            int n5 = (int)((GrannyTextRenderer)object2).getWidth();
            int n6 = n + (n3 - n5) / 2;
            int n7 = n2 - (int)((GrannyTextRenderer)object2).getDescent() - (int)((GrannyTextRenderer)object2).getAscent() / 2;
            ((GrannyTextRenderer)object2).draw(graphics2D, n6, n7);
        }
        graphics2D.translate(this.getX(), this.getY());
        this.getMouseAdapter().paint(graphics2D);
    }

    private void drawGrid(Graphics2D graphics2D) {
        int n;
        int n2;
        DatumVector datumVector;
        TickVDescriptor tickVDescriptor;
        graphics2D.setColor(Color.lightGray);
        if (this.yAxis.isVisible()) {
            tickVDescriptor = this.yAxis.getTickV();
            datumVector = tickVDescriptor.getMajorTicks();
            for (n2 = 0; n2 < datumVector.getLength(); ++n2) {
                n = (int)this.yAxis.transform(datumVector.get(n2));
                graphics2D.drawLine(this.getX(), n, this.getX() + this.getWidth(), n);
            }
        }
        if (this.xAxis.isVisible()) {
            tickVDescriptor = this.xAxis.getTickV();
            datumVector = tickVDescriptor.getMajorTicks();
            for (n2 = 0; n2 < datumVector.getLength(); ++n2) {
                n = (int)this.xAxis.transform(datumVector.get(n2));
                graphics2D.drawLine(n, this.getY(), n, this.getY() + this.getHeight());
            }
        }
    }

    protected void drawContent(Graphics2D graphics2D) {
    }

    public void resize() {
        logger.fine("resize");
        if (this.isDisplayable()) {
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, this.getTitle());
            int n = (int)grannyTextRenderer.getHeight() + (int)grannyTextRenderer.getAscent() / 2;
            Rectangle rectangle = new Rectangle();
            rectangle.x = this.getColumn().getDMinimum() - 1;
            rectangle.y = this.getRow().getDMinimum() - 1;
            rectangle.width = this.getColumn().getDMaximum() - rectangle.x + 1;
            rectangle.height = this.getRow().getDMaximum() - rectangle.y + 1;
            if (!this.getTitle().equals("")) {
                rectangle.y -= n;
                rectangle.height += n;
            }
            this.setBounds(rectangle);
        }
    }

    public void setTitle(String string) {
        String string2 = this.plotTitle;
        this.plotTitle = string;
        if (this.getCanvas() != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getCanvas().getFont());
            int n = fontMetrics.getHeight() + fontMetrics.getHeight() / 2;
            this.resize();
            this.repaint(0, 0, this.getWidth(), n);
        }
        if (string != string2) {
            this.firePropertyChange("title", string2, string);
        }
    }

    public String getTitle() {
        return this.plotTitle;
    }

    public DasAxis getXAxis() {
        return this.xAxis;
    }

    public DasAxis getYAxis() {
        return this.yAxis;
    }

    public DataSetDescriptor getDataSetDescriptor() {
        return this.dataSetDescriptor;
    }

    public void setDataSetDescriptor(DataSetDescriptor dataSetDescriptor) {
        this.dataSetDescriptor = dataSetDescriptor;
        this.markDirty();
    }

    public void setData(DataSet dataSet) {
        this.Data = dataSet;
        this.markDirty();
    }

    protected void installComponent() {
        super.installComponent();
        if (this.xAxis != null) {
            this.getCanvas().add(this.xAxis, this.getRow(), this.getColumn());
        }
        if (this.yAxis != null) {
            this.getCanvas().add(this.yAxis, this.getRow(), this.getColumn());
        }
        Renderer[] rendererArray = this.getRenderers();
        for (int i = 0; i < rendererArray.length; ++i) {
            rendererArray[i].installRenderer();
        }
        if (!"true".equals(System.getProperty("java.awt.headless"))) {
            this.dndSupport = new PlotDnDSupport(this.getCanvas().dndSupport);
        }
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
        if (this.xAxis != null && this.xAxis.getCanvas() != null) {
            this.xAxis.getCanvas().remove(this.xAxis);
        }
        if (this.yAxis != null && this.yAxis.getCanvas() != null) {
            this.yAxis.getCanvas().remove(this.yAxis);
        }
        Renderer[] rendererArray = this.getRenderers();
        for (int i = 0; i < rendererArray.length; ++i) {
            rendererArray[i].uninstallRenderer();
        }
    }

    public void addRenderer(Renderer renderer) {
        logger.info("addRenderer(" + renderer + ")");
        if (renderer.parent != null) {
            renderer.parent.removeRenderer(renderer);
        }
        this.renderers.add(renderer);
        renderer.parent = this;
        if (this.getCanvas() != null) {
            renderer.installRenderer();
        }
        renderer.update();
        this.invalidateCacheImage();
        this.repaint();
    }

    public void removeRenderer(Renderer renderer) {
        if (this.getCanvas() != null) {
            renderer.uninstallRenderer();
        }
        this.renderers.remove(renderer);
        renderer.parent = null;
    }

    public static DasPlot createDummyPlot() {
        DasAxis dasAxis = new DasAxis(Datum.create(-10), Datum.create(10), 2);
        DasAxis dasAxis2 = new DasAxis(Datum.create(-10), Datum.create(10), 3);
        DasPlot dasPlot = new DasPlot(dasAxis, dasAxis2);
        return dasPlot;
    }

    public static DasPlot createPlot(DatumRange datumRange, DatumRange datumRange2) {
        DasAxis dasAxis = new DasAxis(datumRange, 2);
        DasAxis dasAxis2 = new DasAxis(datumRange2, 3);
        DasPlot dasPlot = new DasPlot(dasAxis, dasAxis2);
        return dasPlot;
    }

    public Renderer getRenderer(int n) {
        return (Renderer)this.renderers.get(n);
    }

    public Renderer[] getRenderers() {
        return this.renderers.toArray(new Renderer[0]);
    }

    public static DasPlot processPlotElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        Object object;
        String string = element.getAttribute("name");
        DasRow dasRow = (DasRow)formBase.checkValue(element.getAttribute("row"), DasRow.class, "<row>");
        DasColumn dasColumn = (DasColumn)formBase.checkValue(element.getAttribute("column"), DasColumn.class, "<column>");
        DasAxis dasAxis = null;
        DasAxis dasAxis2 = null;
        DasColorBar dasColorBar = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = nodeList.item(i);
            if (!(object instanceof Element)) continue;
            if (object.getNodeName().equals("xAxis")) {
                dasAxis = DasPlot.processXAxisElement((Element)object, dasRow, dasColumn, formBase);
                continue;
            }
            if (object.getNodeName().equals("yAxis")) {
                dasAxis2 = DasPlot.processYAxisElement((Element)object, dasRow, dasColumn, formBase);
                continue;
            }
            if (!object.getNodeName().equals("zAxis")) continue;
            dasColorBar = DasPlot.processZAxisElement((Element)object, dasRow, dasColumn, formBase);
        }
        if (dasAxis == null) {
            dasAxis = (DasAxis)formBase.checkValue(element.getAttribute("xAxis"), DasAxis.class, "<axis> or <timeaxis>");
        }
        if (dasAxis2 == null) {
            dasAxis2 = (DasAxis)formBase.checkValue(element.getAttribute("yAxis"), DasAxis.class, "<axis> or <timeaxis>");
        }
        DasPlot dasPlot = new DasPlot(dasAxis, dasAxis2);
        if (element.getNodeName().equals("spectrogram")) {
            object = new SpectrogramRenderer(null, dasColorBar);
            dasPlot.addRenderer((Renderer)object);
        }
        dasPlot.setTitle(element.getAttribute("title"));
        dasPlot.setDasName(string);
        dasPlot.setRow(dasRow);
        dasPlot.setColumn(dasColumn);
        object = formBase.getDasApplication();
        NameContext nameContext = ((DasApplication)object).getNameContext();
        nameContext.put(string, dasPlot);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("renderers")) continue;
            DasPlot.processRenderersElement((Element)node, dasPlot, formBase);
        }
        return dasPlot;
    }

    private static DasAxis processXAxisElement(Element element, DasRow dasRow, DasColumn dasColumn, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            if (node.getNodeName().equals("axis")) {
                DasAxis dasAxis = DasAxis.processAxisElement(element2, formBase);
                if (!dasAxis.isHorizontal()) {
                    dasAxis.setOrientation(2);
                }
                return dasAxis;
            }
            if (node.getNodeName().equals("timeaxis")) {
                DasAxis dasAxis = DasAxis.processTimeaxisElement(element2, formBase);
                if (!dasAxis.isHorizontal()) {
                    dasAxis.setOrientation(2);
                }
                return dasAxis;
            }
            if (!node.getNodeName().equals("attachedaxis")) continue;
            DasAxis dasAxis = DasAxis.processAttachedaxisElement(element2, formBase);
            if (!dasAxis.isHorizontal()) {
                dasAxis.setOrientation(2);
            }
            return dasAxis;
        }
        return null;
    }

    private static DasAxis processYAxisElement(Element element, DasRow dasRow, DasColumn dasColumn, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            if (node.getNodeName().equals("axis")) {
                DasAxis dasAxis = DasAxis.processAxisElement(element2, formBase);
                if (dasAxis.isHorizontal()) {
                    dasAxis.setOrientation(3);
                }
                return dasAxis;
            }
            if (node.getNodeName().equals("timeaxis")) {
                DasAxis dasAxis = DasAxis.processTimeaxisElement(element2, formBase);
                if (dasAxis.isHorizontal()) {
                    dasAxis.setOrientation(3);
                }
                return dasAxis;
            }
            if (!node.getNodeName().equals("attachedaxis")) continue;
            DasAxis dasAxis = DasAxis.processAttachedaxisElement(element2, formBase);
            if (dasAxis.isHorizontal()) {
                dasAxis.setOrientation(3);
            }
            return dasAxis;
        }
        return null;
    }

    private static DasColorBar processZAxisElement(Element element, DasRow dasRow, DasColumn dasColumn, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("colorbar")) continue;
            return DasColorBar.processColorbarElement((Element)node, formBase);
        }
        return null;
    }

    private static void processRenderersElement(Element element, DasPlot dasPlot, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            if (node.getNodeName().equals("spectrogram")) {
                dasPlot.addRenderer(SpectrogramRenderer.processSpectrogramElement((Element)node, dasPlot, formBase));
                continue;
            }
            if (!node.getNodeName().equals("lineplot")) continue;
            dasPlot.addRenderer(SymbolLineRenderer.processLinePlotElement((Element)node, dasPlot, formBase));
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("plot");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("title", this.getTitle());
        Element element2 = document.createElement("xAxis");
        Element element3 = this.getXAxis().getDOMElement(document);
        element3.removeAttribute("orientation");
        if (element3.getAttribute("row").equals(this.getRow().getDasName())) {
            element3.removeAttribute("row");
        }
        if (element3.getAttribute("column").equals(this.getColumn().getDasName())) {
            element3.removeAttribute("column");
        }
        element2.appendChild(element3);
        element.appendChild(element2);
        Element element4 = document.createElement("yAxis");
        Element element5 = this.getYAxis().getDOMElement(document);
        element5.removeAttribute("orientation");
        if (element5.getAttribute("row").equals(this.getRow().getDasName())) {
            element5.removeAttribute("row");
        }
        if (element5.getAttribute("column").equals(this.getColumn().getDasName())) {
            element5.removeAttribute("column");
        }
        element4.appendChild(element5);
        element.appendChild(element4);
        Renderer[] rendererArray = this.getRenderers();
        if (rendererArray.length > 0) {
            Element element6 = document.createElement("renderers");
            for (int i = 0; i < rendererArray.length; ++i) {
                element6.appendChild(rendererArray[i].getDOMElement(document));
            }
            element.appendChild(element6);
        }
        return element;
    }

    public static DasPlot createNamedPlot(String string) {
        DasAxis dasAxis = DasAxis.createNamedAxis(null);
        dasAxis.setOrientation(2);
        DasAxis dasAxis2 = DasAxis.createNamedAxis(null);
        dasAxis2.setOrientation(3);
        DasPlot dasPlot = new DasPlot(dasAxis, dasAxis2);
        if (string == null) {
            string = "plot_" + Integer.toHexString(System.identityHashCode(dasPlot));
        }
        try {
            dasPlot.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        return dasPlot;
    }

    public Shape getActiveRegion() {
        return this.getBounds();
    }

    protected AWTEvent coalesceEvents(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        if (aWTEvent instanceof DasRendererUpdateEvent && aWTEvent2 instanceof DasRendererUpdateEvent) {
            DasRendererUpdateEvent dasRendererUpdateEvent = (DasRendererUpdateEvent)aWTEvent;
            DasRendererUpdateEvent dasRendererUpdateEvent2 = (DasRendererUpdateEvent)aWTEvent2;
            if (dasRendererUpdateEvent.getRenderer() == dasRendererUpdateEvent2.getRenderer()) {
                return aWTEvent;
            }
            return null;
        }
        return super.coalesceEvents(aWTEvent, aWTEvent2);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof DasRendererUpdateEvent) {
            DasRendererUpdateEvent dasRendererUpdateEvent = (DasRendererUpdateEvent)aWTEvent;
            dasRendererUpdateEvent.getRenderer().updateImmediately();
            this.cacheImageValid = false;
            this.repaint();
        } else {
            super.processEvent(aWTEvent);
        }
    }

    public void repaint() {
        super.repaint();
        ++this.repaintCount;
    }

    protected void invalidateCacheImage() {
        this.cacheImageValid = false;
        this.repaint();
    }

    void markDirty() {
        logger.finer("DasPlot.markDirty");
        super.markDirty();
        this.repaint();
    }

    public boolean isDrawGrid() {
        return this.drawGrid;
    }

    public void setDrawGrid(boolean bl) {
        this.drawGrid = bl;
        this.update();
    }

    public void setPreviewEnabled(boolean bl) {
        this.preview = bl;
    }

    public boolean isPreviewEnabled() {
        return this.preview;
    }

    private class PlotDnDSupport
    extends DnDSupport {
        PlotDnDSupport(DnDSupport dnDSupport) {
            super(DasPlot.this, 3, dnDSupport);
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
        }

        protected int canAccept(DataFlavor[] dataFlavorArray, int n, int n2, int n3) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(TransferableRenderer.RENDERER_FLAVOR)) continue;
                return n3;
            }
            return -1;
        }

        protected void done() {
        }

        protected boolean importData(Transferable transferable, int n, int n2, int n3) {
            boolean bl = false;
            try {
                Renderer renderer = (Renderer)transferable.getTransferData(TransferableRenderer.RENDERER_FLAVOR);
                DasPlot.this.addRenderer(renderer);
                DasPlot.this.revalidate();
                bl = true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bl;
        }

        protected Transferable getTransferable(int n, int n2, int n3) {
            return null;
        }

        protected void exportDone(Transferable transferable, int n) {
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DasPlot.this.markDirty();
            DasPlot.this.update();
        }
    }
}

