/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumUtil;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.DataRange;
import edu.uiowa.physics.pw.das.graph.TickVDescriptor;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateEvent;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;

public class DasLabelAxis
extends DasAxis
implements DasUpdateListener {
    DecimalFormat nfy = null;
    DatumVector labels = null;
    double[] labelValues = null;
    Units labelUnits = null;
    int[] labelPositions = null;
    DatumFormatter df = null;
    int indexMinimum;
    int indexMaximum;
    private int outsidePadding = 5;
    private boolean floppyItemSpacing = false;

    private void setLabels(DatumVector datumVector) {
        if (datumVector.getLength() == 0) {
            throw new IllegalArgumentException("labels can not be a zero-length array!");
        }
        this.labels = datumVector;
        this.labelPositions = new int[datumVector.getLength()];
        this.indexMinimum = 0;
        this.indexMaximum = datumVector.getLength() - 1;
        this.labelUnits = datumVector.getUnits();
        this.labelValues = datumVector.toDoubleArray(this.labelUnits);
        this.df = DatumUtil.bestFormatter(datumVector);
    }

    public void setLabelFormatter(DatumFormatter datumFormatter) {
        this.df = datumFormatter;
    }

    protected DasLabelAxis(DatumVector datumVector, DataRange dataRange, int n) {
        super(dataRange, n);
        this.setLabels(datumVector);
        this.getDataRange().addUpdateListener(this);
    }

    public DasLabelAxis(DatumVector datumVector, int n) {
        super(datumVector.get(0), datumVector.get(datumVector.getLength() - 1), n, false);
        this.setLabels(datumVector);
        this.getDataRange().addUpdateListener(this);
    }

    public int[] getLabelPositions() {
        return this.labelPositions;
    }

    private void updateTickPositions() {
        if (this.isDisplayable()) {
            int n;
            double d;
            int n2;
            int n3 = this.indexMaximum - this.indexMinimum + 1;
            if (this.getOrientation() == 2) {
                n2 = this.getColumn().getWidth() - this.outsidePadding * 2;
                d = (float)n2 / (float)n3;
                if (!this.floppyItemSpacing) {
                    d = (int)d;
                }
                n = this.getColumn().getDMinimum() + this.outsidePadding + (int)(d / 2.0);
            } else {
                n2 = this.getRow().getHeight() - this.outsidePadding * 2;
                d = -1.0f * (float)n2 / (float)n3;
                if (!this.floppyItemSpacing) {
                    d = (int)d;
                }
                n = this.getRow().getDMaximum() - this.outsidePadding + (int)(d / 2.0);
            }
            for (int i = 0; i < this.labelPositions.length; ++i) {
                this.labelPositions[i] = n + (int)(d * (double)(i - this.indexMinimum + 0));
            }
            this.firePropertyChange("labelPositions", null, this.labelPositions);
        }
    }

    public Datum findTick(Datum datum, double d, boolean bl) {
        return datum;
    }

    public void updateTickV() {
        this.updateTickPositions();
    }

    public TickVDescriptor getTickV() {
        TickVDescriptor tickVDescriptor = new TickVDescriptor();
        tickVDescriptor.units = this.getUnits();
        tickVDescriptor.tickV = this.labels.getSubVector(this.indexMinimum, this.indexMaximum + 1);
        tickVDescriptor.minorTickV = DatumVector.newDatumVector(new double[0], tickVDescriptor.units);
        return tickVDescriptor;
    }

    public double transform(double d, Units units) {
        if (units != this.labelUnits) {
            throw new IllegalArgumentException("units don't match");
        }
        int n = this.findClosestIndex(this.labelValues, d);
        return this.labelPositions[n];
    }

    private int findClosestIndex(int[] nArray, int n) {
        int n2 = 0;
        double d = Math.abs(nArray[n2] - n);
        for (int i = 0; i < this.labelPositions.length; ++i) {
            double d2 = Math.abs(nArray[i] - n);
            if (!(d2 < d)) continue;
            n2 = i;
            d = d2;
        }
        return n2;
    }

    private int findClosestIndex(double[] dArray, double d) {
        int n = 0;
        double d2 = Math.abs(dArray[n] - d);
        for (int i = 0; i < this.labelPositions.length; ++i) {
            double d3 = Math.abs(dArray[i] - d);
            if (!(d3 < d2)) continue;
            n = i;
            d2 = d3;
        }
        return n;
    }

    public Datum invTransform(double d) {
        int n = this.findClosestIndex(this.labelPositions, (int)d);
        return this.labels.get(n);
    }

    protected boolean rangeIsAcceptable(DatumRange datumRange) {
        return true;
    }

    protected String tickFormatter(double d) {
        return this.df.format(Datum.create(d, this.labels.getUnits()));
    }

    public int getInterItemSpace() {
        return (int)Math.abs(this.transform(this.labels.get(1)) - this.transform(this.labels.get(0)));
    }

    public int getItemMin(Datum datum) {
        Units units = datum.getUnits();
        double d = datum.doubleValue(units);
        int n = this.findClosestIndex(this.labelValues, units.convertDoubleTo(this.getUnits(), d));
        int n2 = this.labelPositions[n];
        int n3 = this.getInterItemSpace();
        return n2 - n3 / 2;
    }

    public int getItemMax(Datum datum) {
        int n = this.getInterItemSpace();
        return this.getItemMin(datum) + n;
    }

    public DasAxis createAttachedAxis(DasRow dasRow, DasColumn dasColumn) {
        DasLabelAxis dasLabelAxis = new DasLabelAxis(this.labels, this.getDataRange(), this.getOrientation());
        return dasLabelAxis;
    }

    public DasAxis createAttachedAxis(int n) {
        return new DasLabelAxis(this.labels, this.getDataRange(), n);
    }

    public void update(DasUpdateEvent dasUpdateEvent) {
        double d = this.getDataRange().getMinimum();
        double d2 = this.getDataRange().getMaximum();
        if (this.getDataRange().getUnits() != this.labelUnits) {
            throw new IllegalArgumentException("units don't match");
        }
        this.indexMinimum = this.findClosestIndex(this.labelValues, d);
        this.indexMaximum = this.findClosestIndex(this.labelValues, d2);
        if (this.indexMinimum > this.indexMaximum) {
            int n = this.indexMinimum;
            this.indexMaximum = this.indexMinimum;
            this.indexMinimum = n;
        }
    }

    protected void paintHorizontalAxis(Graphics2D graphics2D) {
        int n;
        int n2;
        boolean bl = this.getOrientation() == 2 || this.isOppositeAxisVisible();
        boolean bl2 = this.getOrientation() == 2 && this.areTickLabelsVisible();
        boolean bl3 = this.getOrientation() == 2 && !this.axisLabel.equals("");
        boolean bl4 = this.getOrientation() == 1 || this.isOppositeAxisVisible();
        boolean bl5 = this.getOrientation() == 1 && this.areTickLabelsVisible();
        boolean bl6 = this.getOrientation() == 1 && !this.axisLabel.equals("");
        int n3 = this.getRow().getDMinimum() - 1;
        int n4 = this.getRow().getDMaximum();
        int n5 = this.getColumn().getDMaximum();
        int n6 = this.getColumn().getDMinimum();
        Font font = this.getTickLabelFont();
        double d = this.dataRange.getMaximum();
        double d2 = this.dataRange.getMinimum();
        TickVDescriptor tickVDescriptor = this.getTickV();
        if (bl) {
            graphics2D.drawLine(n6, n4, n5, n4);
        }
        if (bl4) {
            graphics2D.drawLine(n6, n3, n5, n3);
        }
        int n7 = font.getSize() * 2 / 3;
        int n8 = n7 / 2;
        for (int i = 0; i < tickVDescriptor.tickV.getLength(); ++i) {
            double d3 = tickVDescriptor.tickV.doubleValue(i, this.getUnits());
            Datum datum = tickVDescriptor.units.createDatum(d3);
            n2 = this.getInterItemSpace();
            n = (int)Math.floor(this.transform(d3, tickVDescriptor.units) + 0.5) - n2 / 2;
            int n9 = n7;
            if (bl) {
                graphics2D.drawLine(this.getItemMin(datum), n4, this.getItemMin(datum), n4 + n9);
                if (i == tickVDescriptor.tickV.getLength() - 1) {
                    graphics2D.drawLine(this.getItemMax(datum), n4, this.getItemMax(datum), n4 + n9);
                }
                if (bl2) {
                    this.drawLabel(graphics2D, d3, i, n + n2 / 2, n4 + n9);
                }
            }
            if (!bl4) continue;
            graphics2D.drawLine(this.getItemMin(datum), n3, this.getItemMin(datum), n3 - n9);
            if (i == tickVDescriptor.tickV.getLength() - 1) {
                graphics2D.drawLine(this.getItemMax(datum), n3, this.getItemMax(datum), n3 - n9);
            }
            if (!bl5) continue;
            this.drawLabel(graphics2D, d3, i, n + n2 / 2, n3 - n9);
        }
        if (!this.axisLabel.equals("")) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            int n10 = this.getTitlePositionOffset();
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, this.axisLabel);
            int n11 = (int)grannyTextRenderer.getWidth();
            graphics2D2.setFont(this.getLabelFont());
            if (bl3) {
                n = n6 + (n5 - n6 - n11) / 2;
                n2 = n4 + n10;
                grannyTextRenderer.draw(graphics2D2, n, n2);
            }
            if (bl6) {
                n = n6 + (n5 - n6 - n11) / 2;
                n2 = n3 - n10;
                grannyTextRenderer.draw(graphics2D2, n, n2);
            }
            graphics2D2.dispose();
        }
    }

    protected void paintVerticalAxis(Graphics2D graphics2D) {
        int n;
        int n2;
        boolean bl = this.getOrientation() == 3 || this.isOppositeAxisVisible();
        boolean bl2 = this.getOrientation() == 3 && this.areTickLabelsVisible();
        boolean bl3 = this.getOrientation() == 3 && !this.axisLabel.equals("");
        boolean bl4 = this.getOrientation() == 4 || this.isOppositeAxisVisible();
        boolean bl5 = this.getOrientation() == 4 && this.areTickLabelsVisible();
        boolean bl6 = this.getOrientation() == 4 && !this.axisLabel.equals("");
        int n3 = this.getColumn().getDMinimum() - 1;
        int n4 = this.getColumn().getDMaximum();
        int n5 = this.getRow().getDMaximum();
        int n6 = this.getRow().getDMinimum();
        Font font = this.getTickLabelFont();
        double d = this.dataRange.getMaximum();
        double d2 = this.dataRange.getMinimum();
        TickVDescriptor tickVDescriptor = this.getTickV();
        if (bl) {
            graphics2D.drawLine(n3, n6, n3, n5);
        }
        if (bl4) {
            graphics2D.drawLine(n4, n6, n4, n5);
        }
        int n7 = font.getSize() * 2 / 3;
        int n8 = n7 / 2;
        for (int i = 0; i < tickVDescriptor.tickV.getLength(); ++i) {
            double d3 = tickVDescriptor.tickV.doubleValue(i, this.getUnits());
            Datum datum = tickVDescriptor.units.createDatum(d3);
            if (!(d3 >= d2 * 0.999) || !(d3 <= d * 1.001)) continue;
            n2 = this.getInterItemSpace();
            n = (this.getItemMax(datum) + this.getItemMin(datum)) / 2 - graphics2D.getFontMetrics().getAscent() / 5;
            int n9 = n7;
            if (bl) {
                if (i == tickVDescriptor.tickV.getLength() - 1) {
                    graphics2D.drawLine(n3, this.getItemMin(datum), n3 - n9, this.getItemMin(datum));
                }
                graphics2D.drawLine(n3, this.getItemMax(datum), n3 - n9, this.getItemMax(datum));
                if (bl2) {
                    this.drawLabel(graphics2D, d3, i, n3 - n9, n);
                }
            }
            if (!bl4) continue;
            if (i == tickVDescriptor.tickV.getLength() - 1) {
                graphics2D.drawLine(n4, this.getItemMin(datum), n4 + n9, this.getItemMin(datum));
            }
            graphics2D.drawLine(n4, this.getItemMax(datum), n4 + n9, this.getItemMax(datum));
            if (!bl5) continue;
            this.drawLabel(graphics2D, d3, i, n4 + n9, n);
        }
        if (!this.axisLabel.equals("")) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            int n10 = this.getTitlePositionOffset();
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, this.axisLabel);
            int n11 = (int)grannyTextRenderer.getWidth();
            graphics2D2.setFont(this.getLabelFont());
            if (bl3) {
                graphics2D2.rotate(-1.5707963267948966);
                n = -n5 + (n5 - n6 - n11) / 2;
                n2 = n3 - n10;
                grannyTextRenderer.draw(graphics2D2, n, n2);
            }
            if (bl6) {
                graphics2D2.rotate(1.5707963267948966);
                n = n6 + (n5 - n6 - n11) / 2;
                n2 = -n4 - n10;
                grannyTextRenderer.draw(graphics2D2, n, n2);
            }
            graphics2D2.dispose();
        }
    }

    public int getOutsidePadding() {
        return this.outsidePadding;
    }

    public void setOutsidePadding(int n) {
        int n2 = n;
        this.outsidePadding = n;
        this.firePropertyChange("setOutsidePadding", n2, n);
        this.updateTickPositions();
        this.update();
    }

    public boolean isFloppyItemSpacing() {
        return this.floppyItemSpacing;
    }

    public void setFloppyItemSpacing(boolean bl) {
        boolean bl2 = this.floppyItemSpacing;
        this.floppyItemSpacing = bl;
        this.firePropertyChange("floppyItemSpacing", bl2, bl);
        this.updateTickPositions();
        this.update();
    }

    public AffineTransform getAffineTransform(DasAxis.Memento memento, AffineTransform affineTransform) {
        return affineTransform;
    }
}

