/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateEvent;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.event.EventListenerList;

public abstract class DasDevicePosition
implements Editable,
Serializable {
    protected transient DasCanvas canvas;
    protected transient DasDevicePosition parent;
    private double minimum;
    private double maximum;
    private boolean isWidth;
    private String dasName;
    private transient PropertyChangeSupport propertyChangeDelegate;
    protected EventListenerList listenerList = new EventListenerList();
    private PropertyChangeListener canvasListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (DasDevicePosition.this.emMinimum != 0.0 || DasDevicePosition.this.emMaximum != 0.0) {
                DasDevicePosition.this.revalidate();
            }
        }
    };
    private int dMinimum;
    private int dMaximum;
    private double emMinimum;
    private double emMaximum;
    private int ptMinimum;
    private int ptMaximum = 0;

    protected DasDevicePosition(DasCanvas dasCanvas, boolean bl, DasDevicePosition dasDevicePosition, double d, double d2, double d3, double d4, int n, int n2) {
        boolean bl2;
        if (d > d2) {
            throw new IllegalArgumentException("minimum>maximum");
        }
        boolean bl3 = bl2 = dasCanvas == null && dasDevicePosition == null;
        if (dasDevicePosition != null) {
            dasCanvas = dasDevicePosition.getCanvas();
            bl = dasDevicePosition.isWidth;
        }
        if (dasCanvas == null & !bl2) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        this.canvas = dasCanvas;
        this.parent = dasDevicePosition;
        this.minimum = d;
        this.maximum = d2;
        this.emMinimum = d3;
        this.emMaximum = d4;
        this.ptMinimum = n;
        this.ptMaximum = n2;
        this.isWidth = bl;
        this.dasName = DasApplication.getDefaultApplication().suggestNameFor(this);
        this.propertyChangeDelegate = new PropertyChangeSupport(this);
        if (dasDevicePosition != null) {
            dasDevicePosition.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DasDevicePosition.this.revalidate();
                }
            });
        } else if (dasCanvas != null) {
            dasCanvas.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    DasDevicePosition.this.revalidate();
                }
            });
            dasCanvas.addPropertyChangeListener("font", this.canvasListener);
            dasCanvas.addDevicePosition(this);
        }
        if (!bl2) {
            this.revalidate();
        }
    }

    public DasDevicePosition(DasCanvas dasCanvas, double d, double d2, boolean bl) {
        this(dasCanvas, bl, null, d, d2, 0.0, 0.0, 0, 0);
    }

    protected DasCanvas getCanvas() {
        return this.canvas;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        DasApplication dasApplication = this.canvas.getDasApplication();
        if (dasApplication != null) {
            dasApplication.getNameContext().put(string, this);
            if (string2 != null) {
                dasApplication.getNameContext().remove(string2);
            }
        }
        this.firePropertyChange("name", string2, string);
    }

    public String getDasName() {
        return this.dasName;
    }

    private int getEmSize() {
        return this.canvas.getFont().getSize();
    }

    private int getParentMin() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getDMinimum();
    }

    private int getParentMax() {
        if (this.parent == null) {
            return this.isWidth ? this.canvas.getWidth() : this.canvas.getHeight();
        }
        return this.parent.getDMaximum();
    }

    protected void revalidate() {
        int n = this.dMinimum;
        int n2 = this.dMaximum;
        this.dMinimum = (int)((double)this.getParentMin() + this.minimum * (double)this.getDeviceSize() + (double)this.getEmSize() * this.emMinimum + (double)this.ptMinimum);
        this.dMaximum = (int)((double)this.getParentMin() + this.maximum * (double)this.getDeviceSize() + (double)this.getEmSize() * this.emMaximum + (double)this.ptMaximum);
        if (this.dMaximum <= this.dMinimum) {
            this.dMaximum = this.dMinimum + 1;
        }
        if (this.dMinimum != n) {
            this.firePropertyChange("dMinimum", n, this.dMinimum);
        }
        if (this.dMaximum != n2) {
            this.firePropertyChange("dMaximum", n2, this.dMaximum);
        }
        if (this.dMinimum != n || this.dMaximum != n2) {
            this.fireUpdate();
        }
    }

    public int getDMinimum() {
        if (this.canvas == null && this.parent == null) {
            String string = this.isWidth ? "column" : "row";
            throw new RuntimeException("null " + string + ", " + string + " was not set before layout");
        }
        return this.dMinimum;
    }

    public int getDMaximum() {
        if (this.canvas == null && this.parent == null) {
            String string = this.isWidth ? "column" : "row";
            throw new RuntimeException("null " + string + ", " + string + " was not set before layout");
        }
        return this.dMaximum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setPosition(double d, double d2) {
        double d3 = this.minimum;
        double d4 = this.maximum;
        double d5 = this.minimum;
        double d6 = this.maximum;
        this.minimum = Math.min(d, d2);
        this.maximum = Math.max(d2, d2);
        this.revalidate();
        if (d3 != this.minimum) {
            this.firePropertyChange("minimum", d3, this.minimum);
        }
        if (d4 != this.maximum) {
            this.firePropertyChange("maximum", d4, this.maximum);
        }
    }

    public void setDPosition(int n, int n2) {
        int n3 = this.getParentMin();
        int n4 = this.getParentMax();
        int n5 = this.getEmSize();
        int n6 = n4 - n3;
        double d = ((double)n - this.emMinimum * (double)n5 - (double)this.ptMinimum) / (double)n6;
        double d2 = ((double)n2 - this.emMaximum * (double)n5 - (double)this.ptMaximum) / (double)n6;
        this.setPosition(d, d2);
    }

    public void setMaximum(double d) {
        if (d == this.maximum) {
            return;
        }
        if (d < this.minimum) {
            this.setPosition(d, this.minimum);
        } else {
            double d2 = this.maximum;
            this.maximum = d;
            this.firePropertyChange("maximum", d2, d);
            this.revalidate();
        }
    }

    public void setDMaximum(int n) {
        int n2 = this.getParentMin();
        int n3 = this.getParentMax();
        int n4 = this.getEmSize();
        int n5 = n3 - n2;
        double d = ((double)n - this.emMaximum * (double)n4 - (double)this.ptMaximum) / (double)n5;
        this.setMaximum(d);
    }

    public void setMinimum(double d) {
        if (d == this.minimum) {
            return;
        }
        if (d > this.maximum) {
            this.setPosition(this.maximum, d);
        } else {
            double d2 = this.minimum;
            this.minimum = d;
            this.firePropertyChange("minimum", d2, d);
            this.revalidate();
        }
    }

    public void setDMinimum(int n) {
        int n2 = this.getParentMin();
        int n3 = this.getParentMax();
        int n4 = this.getEmSize();
        int n5 = n3 - n2;
        double d = ((double)n - this.emMinimum * (double)n4 - (double)this.ptMinimum) / (double)n5;
        this.setMinimum(d);
    }

    public DasCanvas getParent() {
        return this.canvas;
    }

    public void setParent(DasCanvas dasCanvas) {
        this.canvas = dasCanvas;
        this.fireUpdate();
    }

    public void addpwUpdateListener(DasUpdateListener dasUpdateListener) {
        this.listenerList.add(DasUpdateListener.class, dasUpdateListener);
    }

    public void removepwUpdateListener(DasUpdateListener dasUpdateListener) {
        this.listenerList.remove(DasUpdateListener.class, dasUpdateListener);
    }

    protected void fireUpdate() {
        DasUpdateEvent dasUpdateEvent = new DasUpdateEvent(this);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DasUpdateListener.class) continue;
            ((DasUpdateListener)objectArray[i + 1]).update(dasUpdateEvent);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeDelegate.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeDelegate.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeDelegate.addPropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.firePropertyChange(string, bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void firePropertyChange(String string, int n, int n2) {
        this.firePropertyChange(string, new Integer(n), new Integer(n2));
    }

    protected void firePropertyChange(String string, long l, long l2) {
        this.firePropertyChange(string, new Long(l), new Long(l2));
    }

    protected void firePropertyChange(String string, float f, float f2) {
        this.firePropertyChange(string, new Float(f), new Float(f2));
    }

    protected void firePropertyChange(String string, double d, double d2) {
        this.firePropertyChange(string, new Double(d), new Double(d2));
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeDelegate.firePropertyChange(string, object, object2);
    }

    protected int getDeviceSize() {
        return this.getParentMax() - this.getParentMin();
    }

    public static Rectangle toRectangle(DasRow dasRow, DasColumn dasColumn) {
        int n = dasColumn.getDMinimum();
        int n2 = dasRow.getDMinimum();
        return new Rectangle(n, n2, dasColumn.getDMaximum() - n, dasRow.getDMaximum() - n2);
    }

    public String toString() {
        return this.getClass().getName() + "[minimum=" + this.getDMinimum() + " maximum=" + this.getDMaximum() + "]";
    }

    public boolean contains(int n) {
        return this.getDMinimum() <= n && n <= this.getDMaximum();
    }

    public int getDMiddle() {
        return (this.getDMinimum() + this.getDMaximum()) / 2;
    }

    public double getEmMinimum() {
        return this.emMinimum;
    }

    public void setEmMinimum(double d) {
        double d2 = this.emMinimum;
        this.emMinimum = d;
        this.firePropertyChange("emMinimum", d2, d);
        this.revalidate();
    }

    public double getEmMaximum() {
        return this.emMaximum;
    }

    public void setEmMaximum(double d) {
        double d2 = this.emMaximum;
        this.emMaximum = d;
        this.firePropertyChange("emMaximum", d2, d);
        this.revalidate();
    }

    public int getPtMinimum() {
        return this.ptMinimum;
    }

    public void setPtMinimum(int n) {
        int n2 = this.ptMinimum;
        this.ptMinimum = n;
        this.firePropertyChange("ptMinimum", n2, n);
        this.revalidate();
    }

    public int getPtMaximum() {
        return this.ptMaximum;
    }

    public void setPtMaximum(int n) {
        int n2 = this.ptMaximum;
        this.ptMaximum = n;
        this.firePropertyChange("ptMaximum", n2, n);
        this.revalidate();
    }

    public DasDevicePosition getParentDevicePosition() {
        return this.parent;
    }
}

