/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasDevicePosition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasColumn
extends DasDevicePosition {
    public static final DasColumn NULL = new DasColumn(null, null, 0.0, 0.0, 0.0, 0.0, 0, 0);

    public DasColumn(DasCanvas dasCanvas, double d, double d2) {
        super(dasCanvas, d, d2, true);
    }

    public DasColumn(DasCanvas dasCanvas, DasColumn dasColumn, double d, double d2, double d3, double d4, int n, int n2) {
        super(dasCanvas, true, dasColumn, d, d2, d3, d4, n, n2);
    }

    public DasColumn createSubColumn(double d, double d2) {
        double d3 = this.getMinimum();
        double d4 = this.getMaximum();
        double d5 = d4 - d3;
        return new DasColumn(this.getCanvas(), d3 + d * d5, d3 + d2 * d5);
    }

    public int getWidth() {
        return this.getDMaximum() - this.getDMinimum();
    }

    public static DasColumn create(DasCanvas dasCanvas) {
        return new DasColumn(dasCanvas, 0.1, 0.8);
    }

    public static DasColumn create(DasCanvas dasCanvas, int n, int n2) {
        double d = 0.1 + (double)n * 0.7 / (double)n2;
        double d2 = 0.099 + (double)(n + 1) * 0.7 / (double)n2;
        return new DasColumn(dasCanvas, d, d2);
    }

    public DasColumn createAttachedColumn(double d, double d2) {
        return new DasColumn(null, this, d, d2, 0.0, 0.0, 0, 0);
    }

    static DasColumn processColumnElement(Element element, DasCanvas dasCanvas, FormBase formBase) throws DasException {
        String string = element.getAttribute("name");
        double d = Double.parseDouble(element.getAttribute("minimum"));
        double d2 = Double.parseDouble(element.getAttribute("maximum"));
        DasColumn dasColumn = new DasColumn(dasCanvas, d, d2);
        dasColumn.setDasName(string);
        DasApplication dasApplication = formBase.getDasApplication();
        NameContext nameContext = dasApplication.getNameContext();
        nameContext.put(string, dasColumn);
        return dasColumn;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("column");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("minimum", Double.toString(this.getMinimum()));
        element.setAttribute("maximum", Double.toString(this.getMaximum()));
        return element;
    }
}

