/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.components.propertyeditor.Displayable;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.event.HorizontalSliceSelectionRenderer;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MousePointSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.text.ParseException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasColorBar
extends DasAxis {
    private BufferedImage image;
    private Type type;
    private int fillColor;
    private int fillColorIndex;
    private int ncolor;
    private static final int COLORTABLE_SIZE = 240;

    public DasColorBar(Datum datum, Datum datum2, boolean bl) {
        this(datum, datum2, 4, bl);
    }

    public DasColorBar(Datum datum, Datum datum2, int n, boolean bl) {
        super(datum, datum2, n, bl);
        this.setLayout(new ColorBarLayoutManager());
        this.setType(Type.COLOR_WEDGE);
    }

    public int rgbTransform(double d, Units units) {
        int n = (int)this.transform(d, units, 0, this.ncolor);
        if (units.isFill(d)) {
            return this.fillColor;
        }
        n = n < 0 ? 0 : n;
        n = n >= this.ncolor ? this.ncolor - 1 : n;
        return this.type.getRGB(n);
    }

    public int indexColorTransform(double d, Units units) {
        int n = (int)this.transform(d, units, 0, this.ncolor);
        if (units.isFill(d)) {
            return this.fillColorIndex;
        }
        n = n < 0 ? 0 : n;
        n = n >= this.ncolor ? this.ncolor - 1 : n;
        return n;
    }

    public IndexColorModel getIndexColorModel() {
        return new IndexColorModel(8, this.type.getColorCount() + 1, this.type.colorTable, 0, false, -1, 0);
    }

    public int getFillColorIndex() {
        return this.fillColorIndex;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (this.type == type) {
            return;
        }
        Type type2 = this.type;
        this.type = type;
        this.ncolor = type.getColorCount();
        this.image = null;
        this.fillColorIndex = this.getType().getColorCount();
        this.fillColor = this.getType().getRGB(this.fillColorIndex);
        this.markDirty();
        this.update();
        this.firePropertyChange("type", type2, type);
    }

    protected void paintComponent(Graphics graphics) {
        int n = Math.round(this.getColumn().getDMinimum());
        int n2 = Math.round(this.getRow().getDMinimum());
        int n3 = Math.round(this.getColumn().getDMaximum()) - n;
        int n4 = Math.round(this.getRow().getDMaximum()) - n2;
        this.image = this.isHorizontal() ? this.type.getHorizontalScaledImage(n3, n4) : this.type.getVerticalScaledImage(n3, n4);
        graphics.translate(-this.getX(), -this.getY());
        if (!this.isHorizontal()) {
            ++n2;
        }
        graphics.drawImage(this.image, n, n2, this);
        graphics.translate(this.getX(), this.getY());
        super.paintComponent(graphics);
    }

    protected Rectangle getAxisBounds() {
        int n = Math.round(this.getColumn().getDMinimum());
        int n2 = Math.round(this.getRow().getDMinimum());
        int n3 = Math.round(this.getColumn().getDMaximum()) - n;
        int n4 = Math.round(this.getRow().getDMaximum()) - n2;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = super.getAxisBounds();
        rectangle2.add(rectangle);
        return rectangle2;
    }

    public static DasColumn getColorBarColumn(DasColumn dasColumn) {
        return dasColumn.createAttachedColumn(1.05, 1.1);
    }

    static DasColorBar processColorbarElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        Object object;
        Object object2;
        String string;
        Datum datum;
        Datum datum2;
        Object object3;
        Object object4;
        String string2 = element.getAttribute("name");
        boolean bl = element.getAttribute("log").equals("true");
        String string3 = element.getAttribute("units");
        if (string3 == null) {
            string3 = "";
        }
        if (string3.equals("TIME")) {
            object4 = element.getAttribute("dataMinimum");
            object3 = element.getAttribute("dataMaximum");
            datum2 = object4 == null || ((String)object4).equals("") ? TimeUtil.create("1979-02-26") : TimeUtil.create((String)object4);
            datum = object3 == null || ((String)object3).equals("") ? TimeUtil.create("1979-02-27") : TimeUtil.create((String)object3);
        } else {
            object4 = Units.getByName(string3);
            object3 = element.getAttribute("dataMinimum");
            string = element.getAttribute("dataMaximum");
            datum2 = object3 == null || ((String)object3).equals("") ? Datum.create(1.0, (Units)object4) : Datum.create(Double.parseDouble((String)object3), (Units)object4);
            datum = string == null || string.equals("") ? Datum.create(10.0, (Units)object4) : Datum.create(Double.parseDouble(string), (Units)object4);
        }
        int n = DasColorBar.parseOrientationString(element.getAttribute("orientation"));
        object3 = new DasColorBar(datum2, datum, n, bl);
        string = element.getAttribute("row");
        if (!string.equals("")) {
            object2 = (DasRow)formBase.checkValue(string, DasRow.class, "<row>");
            ((DasCanvasComponent)object3).setRow((DasRow)object2);
        }
        if (!((String)(object2 = element.getAttribute("column"))).equals("")) {
            object = (DasColumn)formBase.checkValue((String)object2, DasColumn.class, "<column>");
            ((DasCanvasComponent)object3).setColumn((DasColumn)object);
        }
        ((DasAxis)object3).setLabel(element.getAttribute("label"));
        ((DasAxis)object3).setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        ((DasAxis)object3).setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        ((DasColorBar)object3).setType(Type.parse(element.getAttribute("type")));
        ((DasCanvasComponent)object3).setDasName(string2);
        object = formBase.getDasApplication();
        NameContext nameContext = ((DasApplication)object).getNameContext();
        nameContext.put(string2, object3);
        return object3;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("colorbar");
        String string = this.getDataMinimum().toString();
        element.setAttribute("dataMinimum", string);
        String string2 = this.getDataMaximum().toString();
        element.setAttribute("dataMaximum", string2);
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("label", this.getLabel());
        element.setAttribute("log", Boolean.toString(this.isLog()));
        element.setAttribute("tickLabelsVisible", Boolean.toString(this.areTickLabelsVisible()));
        element.setAttribute("oppositeAxisVisible", Boolean.toString(this.isOppositeAxisVisible()));
        element.setAttribute("animated", Boolean.toString(this.isAnimated()));
        element.setAttribute("orientation", DasColorBar.orientationToString(this.getOrientation()));
        element.setAttribute("type", this.getType().toString());
        return element;
    }

    public static DasColorBar createNamedColorBar(String string) {
        DasColorBar dasColorBar = new DasColorBar(Datum.create(1.0, Units.dimensionless), Datum.create(10.0, Units.dimensionless), false);
        if (string == null) {
            string = "colorbar_" + Integer.toHexString(System.identityHashCode(dasColorBar));
        }
        try {
            dasColorBar.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        return dasColorBar;
    }

    public Shape getActiveRegion() {
        int n = Math.round(this.getColumn().getDMinimum());
        int n2 = Math.round(this.getRow().getDMinimum());
        int n3 = Math.round(this.getColumn().getDMaximum()) - n;
        int n4 = Math.round(this.getRow().getDMaximum()) - n2;
        Rectangle rectangle = this.primaryInputPanel.getBounds();
        rectangle.translate(this.getX(), this.getY());
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        rectangle.add(rectangle2);
        if (this.isOppositeAxisVisible()) {
            Rectangle rectangle3 = this.secondaryInputPanel.getBounds();
            rectangle3.translate(this.getX(), this.getY());
            rectangle.add(rectangle3);
        }
        return rectangle;
    }

    public MouseModule getRepaletteMouseModule(Renderer renderer) {
        return new ColorBarRepaletteMouseModule(renderer, this);
    }

    public class ColorBarRepaletteMouseModule
    extends MouseModule {
        DasColorBar colorBar;
        Renderer parent;
        DatumRange range0;
        int lastTopColor;
        boolean animated0;
        int state;
        int STATE_IGNORE = 300;
        int STATE_TOP = 200;
        int STATE_BOTTOM = 100;
        private EventListenerList listenerList = null;

        public String getLabel() {
            return "Repalette";
        }

        public ColorBarRepaletteMouseModule(Renderer renderer, DasColorBar dasColorBar2) {
            if (dasColorBar2.isHorizontal()) {
                throw new IllegalArgumentException("Axis orientation is not vertical");
            }
            this.parent = renderer;
            this.dragRenderer = new HorizontalSliceSelectionRenderer(renderer.getParent());
            this.colorBar = dasColorBar2;
        }

        private void setColorBar(int n) {
            if (this.state != this.STATE_IGNORE) {
                DasRow dasRow = this.colorBar.getRow();
                double d = (double)(dasRow.getDMaximum() - n) / (1.0 * (double)dasRow.getHeight());
                this.lastTopColor = Math.max(13, (int)(240.0 * d));
                this.colorBar.type.initializeColorTable(240, this.lastTopColor);
                this.colorBar.image = null;
                this.colorBar.type.image = null;
                this.colorBar.repaint();
                this.parent.refreshImage();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.state != this.STATE_IGNORE) {
                this.colorBar.setAnimated(this.animated0);
                int n = this.lastTopColor;
                this.setColorBar(this.colorBar.getRow().getDMinimum());
                DatumRange datumRange = this.range0.rescale(0.0, (double)n / 240.0);
                this.colorBar.type.initializeColorTable(240, 240);
                this.colorBar.setDatumRange(datumRange);
            }
        }

        public void mousePointSelected(MousePointSelectionEvent mousePointSelectionEvent) {
            this.setColorBar(mousePointSelectionEvent.getY());
        }

        public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(DataRangeSelectionListener.class, dataRangeSelectionListener);
        }

        public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
            this.listenerList.remove(DataRangeSelectionListener.class, dataRangeSelectionListener);
        }

        private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent dataRangeSelectionEvent) {
            if (this.listenerList == null) {
                return;
            }
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DataRangeSelectionListener.class) continue;
                ((DataRangeSelectionListener)objectArray[i + 1]).DataRangeSelected(dataRangeSelectionEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (DasColorBar.this.getColumn().contains(mouseEvent.getX() + DasColorBar.this.getX())) {
                this.state = this.STATE_TOP;
                this.animated0 = this.colorBar.isAnimated();
                this.colorBar.setAnimated(false);
                this.range0 = this.colorBar.getDatumRange();
            } else {
                this.state = this.STATE_IGNORE;
            }
        }
    }

    public static final class Type
    implements Enumeration,
    Displayable {
        public static final Type COLOR_WEDGE = new Type("color_wedge");
        public static final Type GRAYSCALE = new Type("grayscale");
        public static final Type INVERSE_GRAYSCALE = new Type("inverse_grayscale");
        public static final Type WRAPPED_COLOR_WEDGE = new Type("wrapped_color_wedge");
        private BufferedImage image;
        private int[] colorTable;
        private final String desc;
        private Icon icon;

        private Type(String string) {
            this.desc = string;
        }

        public Icon getListIcon() {
            this.maybeInitializeIcon();
            return this.icon;
        }

        public void maybeInitializeIcon() {
            if (this.icon == null) {
                this.icon = new ImageIcon(this.getVerticalScaledImage(24, 24));
            }
        }

        public String toString() {
            return this.desc;
        }

        public String getListLabel() {
            return this.desc;
        }

        public int getColorCount() {
            this.maybeInitializeColorTable();
            return this.colorTable.length - 1;
        }

        public int getRGB(int n) {
            this.maybeInitializeColorTable();
            return this.colorTable[n];
        }

        public BufferedImage getHorizontalScaledImage(int n, int n2) {
            this.maybeInitializeImage();
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale((double)n / (double)this.getColorCount(), n2);
            affineTransform.rotate(-1.5707963267948966);
            affineTransform.translate(-1.0, 0.0);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
            affineTransformOp.filter(this.image, bufferedImage);
            return bufferedImage;
        }

        public BufferedImage getVerticalScaledImage(int n, int n2) {
            this.maybeInitializeImage();
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(n, -((double)n2) / (double)this.getColorCount());
            affineTransform.translate(0.0, -((double)this.getColorCount()));
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
            affineTransformOp.filter(this.image, bufferedImage);
            return bufferedImage;
        }

        private void maybeInitializeImage() {
            if (this.image == null) {
                this.maybeInitializeColorTable();
                this.image = new BufferedImage(1, this.getColorCount(), 1);
                this.image.setRGB(0, 0, 1, this.getColorCount(), this.colorTable, 0, 1);
            }
        }

        private static int[] makeColorTable(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, int n2) {
            int[] nArray5 = new int[n];
            int n3 = 0;
            for (int i = 0; i < n - 1; ++i) {
                double d;
                float f = i * 255 / n2;
                if (f > (float)nArray[n3 + 1]) {
                    ++n3;
                }
                if (n3 >= nArray.length - 1) {
                    d = 1.0;
                    n3 = nArray.length - 2;
                } else {
                    d = (double)(f - (float)nArray[n3]) / (double)(nArray[n3 + 1] - nArray[n3]);
                }
                if (d > 1.0) {
                    d = 1.0;
                }
                if (d < 0.0) {
                    d = 0.0;
                }
                double d2 = ((double)nArray2[n3] * (1.0 - d) + (double)nArray2[n3 + 1] * d) / 255.0;
                double d3 = ((double)nArray3[n3] * (1.0 - d) + (double)nArray3[n3 + 1] * d) / 255.0;
                double d4 = ((double)nArray4[n3] * (1.0 - d) + (double)nArray4[n3 + 1] * d) / 255.0;
                nArray5[i] = new Color((float)d2, (float)d3, (float)d4).getRGB();
            }
            nArray5[n - 1] = Color.LIGHT_GRAY.getRGB();
            return nArray5;
        }

        private void maybeInitializeColorTable() {
            if (this.colorTable == null) {
                this.initializeColorTable(240, 240);
            }
        }

        private void initializeColorTable(int n, int n2) {
            if (this == COLOR_WEDGE) {
                this.initializeColorWedge(n, n2);
            } else if (this == GRAYSCALE) {
                this.initializeGrayScale(n, n2);
            } else if (this == INVERSE_GRAYSCALE) {
                this.initializeInverseGrayScale(n, n2);
            } else if (this == WRAPPED_COLOR_WEDGE) {
                this.initializeWrappedColorWedge(n, n2);
            }
        }

        private void initializeColorWedge(int n, int n2) {
            int[] nArray = new int[]{0, 30, 63, 126, 162, 192, 221, 255};
            int[] nArray2 = new int[]{0, 0, 0, 0, 255, 255, 255, 255};
            int[] nArray3 = new int[]{0, 0, 255, 255, 255, 185, 84, 0};
            int[] nArray4 = new int[]{137, 255, 255, 0, 0, 0, 0, 0};
            this.colorTable = Type.makeColorTable(nArray, nArray2, nArray3, nArray4, n, n2);
            this.colorTable[0] = this.colorTable[0] & 0xFFFFFF00 | 1;
        }

        private void initializeWrappedColorWedge(int n, int n2) {
            int[] nArray = new int[]{0, 32, 64, 96, 128, 160, 192, 224, 255};
            int[] nArray2 = new int[]{225, 0, 0, 0, 255, 255, 255, 255, 255};
            int[] nArray3 = new int[]{0, 0, 255, 255, 255, 185, 84, 0, 0};
            int[] nArray4 = new int[]{225, 255, 255, 0, 0, 0, 0, 0, 255};
            this.colorTable = Type.makeColorTable(nArray, nArray2, nArray3, nArray4, n, n2);
        }

        private void initializeInverseGrayScale(int n, int n2) {
            int[] nArray = new int[]{0, 255};
            int[] nArray2 = new int[]{0, 255};
            int[] nArray3 = new int[]{0, 255};
            int[] nArray4 = new int[]{0, 255};
            this.colorTable = Type.makeColorTable(nArray, nArray2, nArray3, nArray4, n, n2);
        }

        private void initializeGrayScale(int n, int n2) {
            int[] nArray = new int[]{0, 255};
            int[] nArray2 = new int[]{255, 0};
            int[] nArray3 = new int[]{255, 0};
            int[] nArray4 = new int[]{255, 0};
            this.colorTable = Type.makeColorTable(nArray, nArray2, nArray3, nArray4, n, n2);
        }

        public static Type parse(String string) {
            if (string.equals("color_wedge")) {
                return COLOR_WEDGE;
            }
            if (string.equals("grayscale")) {
                return GRAYSCALE;
            }
            if (string.equals("inverse_grayscale")) {
                return INVERSE_GRAYSCALE;
            }
            throw new IllegalArgumentException("invalid DasColorBar.Type string: " + string);
        }
    }

    protected class ColorBarLayoutManager
    extends DasAxis.AxisLayoutManager {
        protected ColorBarLayoutManager() {
        }

        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            int n = Math.round(DasColorBar.this.getColumn().getDMinimum());
            int n2 = Math.round(DasColorBar.this.getRow().getDMinimum());
            int n3 = Math.round(DasColorBar.this.getColumn().getDMaximum()) - n;
            int n4 = Math.round(DasColorBar.this.getRow().getDMaximum()) - n2;
            Rectangle rectangle = new Rectangle(n - DasColorBar.this.getX(), n2 - DasColorBar.this.getY(), n3, n4);
            Rectangle rectangle2 = DasColorBar.this.primaryInputPanel.getBounds();
            rectangle2.add(rectangle);
            DasColorBar.this.primaryInputPanel.setBounds(rectangle2);
        }
    }
}

