/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyEditor;
import edu.uiowa.physics.pw.das.event.DasMouseInputAdapter;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateEvent;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;
import edu.uiowa.physics.pw.das.system.DasLogger;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class DasCanvasComponent
extends JComponent
implements Editable {
    private Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);
    private static final MouseListener currentComponentListener = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            DasCanvas dasCanvas;
            DasCanvasComponent dasCanvasComponent = mouseEvent.getSource() instanceof DasCanvasComponent ? (DasCanvasComponent)mouseEvent.getComponent() : (DasCanvasComponent)SwingUtilities.getAncestorOfClass(DasCanvasComponent.class, mouseEvent.getComponent());
            CanvasComponentAction.currentCanvasComponent = dasCanvasComponent;
            DasCanvas.CanvasAction.currentCanvas = dasCanvas = dasCanvasComponent.getCanvas();
        }
    };
    public static final Action PROPERTIES_ACTION = new CanvasComponentAction("Properties"){

        public void actionPerformed(ActionEvent actionEvent) {
            if (2.getCurrentComponent() != null) {
                2.getCurrentComponent().showProperties();
            }
        }
    };
    private DasRow row;
    private DasColumn column;
    private ResizeListener rl;
    protected DasMouseInputAdapter mouseAdapter;
    private String dasName;
    private edu.uiowa.physics.pw.das.event.DasUpdateEvent devt;
    boolean dirty = true;

    public DasCanvasComponent() {
        this.setOpaque(false);
        this.rl = new ResizeListener();
        this.row = DasRow.NULL;
        this.column = DasColumn.NULL;
        this.mouseAdapter = new DasMouseInputAdapter(this);
        this.addMouseListener(this.mouseAdapter);
        this.addMouseMotionListener(this.mouseAdapter);
        this.addMouseListener(currentComponentListener);
        this.addKeyListener(this.mouseAdapter.getKeyAdapter());
        try {
            String string = DasApplication.getDefaultApplication().suggestNameFor(this);
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            // empty catch block
        }
    }

    public void addMouseModule(MouseModule mouseModule) {
        this.mouseAdapter.addMouseModule(mouseModule);
    }

    public void removeMouseModule(MouseModule mouseModule) {
        this.mouseAdapter.removeMouseModule(mouseModule);
    }

    public DasRow getRow() {
        return this.row;
    }

    public DasColumn getColumn() {
        return this.column;
    }

    public void resize() {
        if (this.column == DasColumn.NULL || this.row == DasRow.NULL) {
            Logger logger = DasApplication.getDefaultApplication().getLogger();
            logger.warning("Null row and/or column in resize: row=" + this.row + " column=" + this.column);
        } else {
            this.setBounds(this.column.getDMinimum(), this.row.getDMinimum(), this.column.getDMaximum() - this.column.getDMinimum(), this.row.getDMaximum() - this.row.getDMinimum());
        }
    }

    public void setRow(DasRow dasRow) {
        if (this.row == dasRow) {
            return;
        }
        DasRow dasRow2 = this.row;
        if (this.row != DasRow.NULL) {
            this.row.removepwUpdateListener(this.rl);
        }
        this.row = dasRow;
        if (this.row != DasRow.NULL) {
            this.row.addpwUpdateListener(this.rl);
        }
        this.firePropertyChange("row", dasRow2, dasRow);
    }

    public void setColumn(DasColumn dasColumn) {
        if (this.column == dasColumn) {
            return;
        }
        DasColumn dasColumn2 = this.column;
        if (this.column != DasColumn.NULL) {
            this.column.removepwUpdateListener(this.rl);
        }
        this.column = dasColumn;
        if (this.column != DasColumn.NULL) {
            this.column.addpwUpdateListener(this.rl);
        }
        this.firePropertyChange("column", dasColumn2, dasColumn);
    }

    public void showProperties() {
        PropertyEditor propertyEditor = new PropertyEditor(this);
        propertyEditor.showDialog(this);
    }

    public String toString() {
        return this.getClass().getName() + "'" + this.getDasName() + "'";
    }

    protected void updateImmediately() {
        this.logger.finer("updateImmediately for " + this.getClass().getName());
    }

    public void update() {
        this.logger.finer("update for " + this.getClass().getName());
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (this.devt == null) {
            this.devt = new edu.uiowa.physics.pw.das.event.DasUpdateEvent(this);
        }
        eventQueue.postEvent(this.devt);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
        if (aWTEvent instanceof edu.uiowa.physics.pw.das.event.DasUpdateEvent) {
            this.processDasUpdateEvent((edu.uiowa.physics.pw.das.event.DasUpdateEvent)aWTEvent);
        }
    }

    protected void processDasUpdateEvent(edu.uiowa.physics.pw.das.event.DasUpdateEvent dasUpdateEvent) {
        if (this.isDisplayable()) {
            if (this.isDirty()) {
                this.markClean();
                this.updateImmediately();
            }
            this.resize();
            this.repaint();
        }
    }

    protected AWTEvent coalesceEvents(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        if (aWTEvent instanceof edu.uiowa.physics.pw.das.event.DasUpdateEvent && aWTEvent2 instanceof edu.uiowa.physics.pw.das.event.DasUpdateEvent) {
            return aWTEvent;
        }
        return super.coalesceEvents(aWTEvent, aWTEvent2);
    }

    protected void installComponent() {
    }

    protected void uninstallComponent() {
    }

    public Font getFont() {
        return this.getParent() == null ? super.getFont() : this.getParent().getFont();
    }

    void markDirty() {
        this.dirty = true;
    }

    boolean isDirty() {
        return this.dirty;
    }

    void markClean() {
        this.dirty = false;
    }

    public DasCanvas getCanvas() {
        return (DasCanvas)this.getParent();
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        DasApplication dasApplication = DasApplication.getDefaultApplication();
        if (dasApplication != null) {
            dasApplication.getNameContext().put(string, this);
            if (string2 != null) {
                dasApplication.getNameContext().remove(string2);
            }
        }
        this.firePropertyChange("name", string2, string);
    }

    public Shape getActiveRegion() {
        int n = this.getColumn().getDMinimum();
        int n2 = this.getRow().getDMinimum();
        int n3 = this.getColumn().getDMaximum() - n;
        int n4 = this.getRow().getDMaximum() - n2;
        return new Rectangle(n, n2, n3, n4);
    }

    public DasMouseInputAdapter getMouseAdapter() {
        return this.mouseAdapter;
    }

    public Action[] getActions() {
        return new Action[]{PROPERTIES_ACTION};
    }

    public DasMouseInputAdapter getDasMouseInputAdapter() {
        return this.mouseAdapter;
    }

    public void setDasMouseInputAdapter(DasMouseInputAdapter dasMouseInputAdapter) {
        this.mouseAdapter = dasMouseInputAdapter;
    }

    private class ResizeListener
    implements DasUpdateListener {
        private ResizeListener() {
        }

        public void update(DasUpdateEvent dasUpdateEvent) {
            DasCanvasComponent.this.markDirty();
            DasCanvasComponent.this.update();
        }
    }

    protected static abstract class CanvasComponentAction
    extends DasCanvas.CanvasAction {
        private static DasCanvasComponent currentCanvasComponent;

        public CanvasComponentAction(String string) {
            super(string);
        }

        public static DasCanvasComponent getCurrentComponent() {
            return currentCanvasComponent;
        }
    }
}

