/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyEditor;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dasml.FormComponent;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasDevicePosition;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Legend;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableCanvasComponent;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.system.RequestProcessor;
import edu.uiowa.physics.pw.das.system.UserMessageCenter;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasPNGEncoder;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import edu.uiowa.physics.pw.das.util.Splash;
import edu.uiowa.physics.pw.das.util.awt.EventQueueBlocker_1;
import edu.uiowa.physics.pw.das.util.awt.GraphicsOutput;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DasCanvas
extends JLayeredPane
implements Printable,
Editable,
FormComponent {
    public static final Integer DEFAULT_LAYER = JLayeredPane.DEFAULT_LAYER;
    public static final Integer PLOT_LAYER = new Integer(300);
    public static final Integer VERTICAL_AXIS_LAYER = new Integer(400);
    public static final Integer HORIZONTAL_AXIS_LAYER = new Integer(500);
    public static final Integer AXIS_LAYER = VERTICAL_AXIS_LAYER;
    public static final Integer ANNOTATION_LAYER = new Integer(1000);
    public static final Integer GLASS_PANE_LAYER = new Integer(30000);
    private static final Paint PAINT_ROW = new Color(255, 178, 178, 146);
    private static final Paint PAINT_COLUMN = new Color(178, 178, 255, 146);
    private static final Paint PAINT_SELECTION = Color.GRAY;
    private static final Stroke STROKE_DASHED;
    public static final Action SAVE_AS_PNG_ACTION;
    public static final Action SAVE_AS_SVG_ACTION;
    public static final Action SAVE_AS_PDF_ACTION;
    public static final Action EDIT_DAS_PROPERTIES_ACTION;
    public static final Action PRINT_ACTION;
    public static final Action REFRESH_ACTION;
    public static final Action ABOUT_ACTION;
    public final Action PROPERTIES_ACTION = new CanvasAction("properties"){

        public void actionPerformed(ActionEvent actionEvent) {
            PropertyEditor propertyEditor = new PropertyEditor(DasCanvas.this);
            propertyEditor.showDialog(DasCanvas.this);
        }
    };
    private final GlassPane glassPane;
    private String dasName;
    private JPopupMenu popup;
    private boolean editable;
    private int printing = 0;
    List devicePositionList = new ArrayList();
    DnDSupport dndSupport;
    private Set printingThreads;
    private int displayLockCount = 0;
    private Object displayLockObject = new String("DISPLAY_LOCK_OBJECT");
    private Font baseFont = null;
    private static final int R_1024_X_768 = 786432;
    private static final int R_800_X_600 = 480000;
    private static final int R_640_X_480 = 307200;
    private static final int R_320_X_240 = 76800;
    private HashSet horizontalLineSet = new HashSet();
    private HashSet verticalLineSet = new HashSet();
    private HashSet cellSet = new HashSet();

    public static Action[] getActions() {
        return new Action[]{ABOUT_ACTION, REFRESH_ACTION, EDIT_DAS_PROPERTIES_ACTION, PRINT_ACTION, SAVE_AS_PNG_ACTION, SAVE_AS_SVG_ACTION, SAVE_AS_PDF_ACTION};
    }

    public DasCanvas() {
        LookAndFeel.installColorsAndFont(this, "Panel.background", "Panel.foreground", "Panel.font");
        String string = DasApplication.getDefaultApplication().suggestNameFor(this);
        this.setName(string);
        this.setOpaque(true);
        this.setLayout(new RowColumnLayout());
        this.addComponentListener(this.createResizeListener());
        this.setBackground(Color.white);
        this.setDoubleBuffered(true);
        this.glassPane = new GlassPane();
        this.add((Component)this.glassPane, GLASS_PANE_LAYER);
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.popup = this.createPopupMenu();
            this.addMouseListener(this.createMouseInputAdapter());
            try {
                this.dndSupport = new CanvasDnDSupport();
            }
            catch (SecurityException securityException) {
                this.dndSupport = new CanvasDnDSupport();
            }
        }
    }

    private MouseInputAdapter createMouseInputAdapter() {
        return new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                CanvasAction.currentCanvas = DasCanvas.this;
                DasCanvas.this.popup.show(DasCanvas.this, mouseEvent.getX(), mouseEvent.getY());
            }
        };
    }

    private JPopupMenu createPopupMenu() {
        JMenuItem jMenuItem;
        JPopupMenu jPopupMenu = new JPopupMenu();
        Action[] actionArray = DasCanvas.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            jMenuItem = new JMenuItem();
            jMenuItem.setAction(actionArray[i]);
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem(this.PROPERTIES_ACTION);
        jPopupMenu.add(jMenuItem2);
        jMenuItem = new JMenuItem("close");
        jMenuItem.setToolTipText("close this popup");
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public Component getGlassPane() {
        return this.glassPane;
    }

    public List getDevicePositionList() {
        return Collections.unmodifiableList(this.devicePositionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void lockDisplay(Object object) {
        Object object2 = this.displayLockObject;
        synchronized (object2) {
            ++this.displayLockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void freeDisplay(Object object) {
        Object object2 = this.displayLockObject;
        synchronized (object2) {
            --this.displayLockCount;
            if (this.displayLockCount == 0) {
                this.displayLockObject.notifyAll();
            }
        }
    }

    public DasCanvas(int n, int n2) {
        this();
        this.setPreferredSize(new Dimension(n, n2));
    }

    public DasApplication getApplication() {
        return DasApplication.getDefaultApplication();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected void paintComponent(Graphics graphics) {
        if (!this.isPrintingThread() || !this.getBackground().equals(Color.WHITE)) {
            graphics.setColor(this.getBackground());
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.fill(graphics2D.getClipBounds());
        }
        graphics.setColor(this.getForeground());
        if (this.isPrintingThread()) {
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("'UIOWA 'yyyyMMdd");
            String string = simpleDateFormat.format(date);
            Font font = graphics.getFont();
            Font font2 = font.deriveFont((float)font.getSize() / 2.0f);
            FontMetrics fontMetrics = graphics.getFontMetrics(font2);
            int n = fontMetrics.stringWidth(string);
            int n2 = fontMetrics.getHeight();
            graphics.setFont(font2);
            graphics.drawString(string, this.getWidth() - n - 2 * n2, this.getHeight() - 2 * n2);
            graphics.setFont(font);
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double d5 = Math.max(d, d2);
        double d6 = Math.min(d, d2);
        double d7 = Math.max(d3, d4);
        double d8 = Math.min(d3, d4);
        double d9 = d7 / d5;
        double d10 = d8 / d6;
        double d11 = Math.min(d9, d10);
        graphics2D.scale(d11, d11);
        if (d == d5 ^ d3 == d7) {
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(0.0, -d2);
        }
        this.print(graphics2D);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isPrintingThread() {
        DasCanvas dasCanvas = this;
        synchronized (dasCanvas) {
            return this.printingThreads == null ? false : this.printingThreads.contains(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        DasCanvas dasCanvas = this;
        synchronized (dasCanvas) {
            if (this.printingThreads == null) {
                this.printingThreads = new HashSet();
            }
            this.printingThreads.add(Thread.currentThread());
        }
        try {
            this.setOpaque(false);
            super.print(graphics);
        }
        finally {
            this.setOpaque(true);
            dasCanvas = this;
            synchronized (dasCanvas) {
                this.printingThreads.remove(Thread.currentThread());
            }
        }
    }

    public Printable getPrintable() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToPng(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        Image image = this.getImage(this.getWidth(), this.getHeight());
        DasPNGEncoder dasPNGEncoder = new DasPNGEncoder();
        dasPNGEncoder.addText("Creation Time", new Date().toString());
        try {
            dasPNGEncoder.write((BufferedImage)image, fileOutputStream);
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).info("write png file " + string);
        }
        catch (IOException iOException) {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException2) {
                throw new RuntimeException(iOException2);
            }
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public void writeToPDF(String string) throws IOException {
        try {
            this.writeToGraphicsOutput(string, "edu.uiowa.physics.pw.das.util.awt.PdfGraphicsOutput");
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).info("write pdf file " + string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            DasExceptionHandler.handle(new RuntimeException("PDF output is not available", noClassDefFoundError));
        }
        catch (ClassNotFoundException classNotFoundException) {
            DasExceptionHandler.handle(new RuntimeException("PDF output is not available", classNotFoundException));
        }
        catch (InstantiationException instantiationException) {
            DasExceptionHandler.handleUncaught(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            DasExceptionHandler.handleUncaught(illegalAccessException);
        }
    }

    public void writeToGraphicsOutput(String string, String string2) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        Class<?> clazz = Class.forName(string2);
        GraphicsOutput graphicsOutput = (GraphicsOutput)clazz.newInstance();
        graphicsOutput.setOutputStream(fileOutputStream);
        graphicsOutput.setSize(this.getWidth(), this.getHeight());
        graphicsOutput.start();
        this.print(graphicsOutput.getGraphics());
        graphicsOutput.finish();
    }

    public void writeToSVG(String string) throws IOException {
        try {
            this.writeToGraphicsOutput(string, "edu.uiowa.physics.pw.das.util.awt.SvgGraphicsOutput");
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).info("write svg file " + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            DasExceptionHandler.handle(new RuntimeException("SVG output is not available", classNotFoundException));
        }
        catch (InstantiationException instantiationException) {
            DasExceptionHandler.handleUncaught(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            DasExceptionHandler.handleUncaught(illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilIdle() throws InterruptedException {
        String string = "dasCanvas.waitUntilIdle";
        Logger logger = DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG);
        logger.fine(string);
        final Object object = new Object();
        EventQueueBlocker_1.clearEventQueue();
        logger.finer("pending events processed");
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object2 = object;
                synchronized (object2) {
                    object.notifyAll();
                }
            }
        };
        try {
            Object object2 = object;
            synchronized (object2) {
                RequestProcessor.invokeAfter(runnable, this);
                object.wait();
                logger.finer("requestProcessor.invokeAfter task complete");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        EventQueueBlocker_1.clearEventQueue();
        logger.finer("post data-load pending events processed");
        logger.fine("canvas is idle");
    }

    public Image getImage(int n, int n2) {
        String string = "dasCanvas.getImage(" + n + "," + n2 + ")";
        Logger logger = DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG);
        logger.fine(string);
        this.setPreferredWidth(n);
        this.setPreferredHeight(n2);
        if ("true".equals(System.getProperty("java.awt.headless"))) {
            this.addNotify();
            this.setSize(this.getPreferredSize());
            this.validate();
        }
        try {
            this.waitUntilIdle();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        final BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        if (SwingUtilities.isEventDispatchThread()) {
            this.writeToImageImmediately(bufferedImage);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    DasCanvas.this.writeToImageImmediately(bufferedImage);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                UserMessageCenter.getDefault().notifyUser((Object)this, invocationTargetException.getCause());
            }
            catch (InterruptedException interruptedException) {
                UserMessageCenter.getDefault().notifyUser((Object)this, interruptedException);
            }
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToImageImmediately(Image image) {
        try {
            Object object = this.displayLockObject;
            synchronized (object) {
                if (this.displayLockCount != 0) {
                    this.displayLockObject.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(this), image.getHeight(this));
        this.print(graphics);
    }

    public void add(DasCanvasComponent dasCanvasComponent, DasRow dasRow, DasColumn dasColumn) {
        if (dasCanvasComponent.getRow() == DasRow.NULL || dasCanvasComponent.getRow().getParent() != this) {
            dasCanvasComponent.setRow(dasRow);
        }
        if (dasCanvasComponent.getColumn() == DasColumn.NULL || dasCanvasComponent.getColumn().getParent() != this) {
            dasCanvasComponent.setColumn(dasColumn);
        }
        this.add(dasCanvasComponent);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component == null) {
            DasDie.println("NULL COMPONENT");
            Thread.dumpStack();
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (component instanceof DasPlot) {
            ((DasPlot)component).putClientProperty("layeredContainerLayer", PLOT_LAYER);
        } else if (component instanceof DasAxis) {
            ((DasAxis)component).putClientProperty("layeredContainerLayer", AXIS_LAYER);
        } else if (component instanceof Legend) {
            ((Legend)component).putClientProperty("layeredContainerLayer", AXIS_LAYER);
        } else if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("layeredContainerLayer", DEFAULT_LAYER);
        }
        super.addImpl(component, object, n);
        if (component instanceof DasCanvasComponent) {
            ((DasCanvasComponent)component).installComponent();
        }
    }

    public void setPreferredWidth(int n) {
        Dimension dimension = this.getPreferredSize();
        dimension.width = n;
        this.setPreferredSize(dimension);
    }

    public void setPreferredHeight(int n) {
        Dimension dimension = this.getPreferredSize();
        dimension.height = n;
        this.setPreferredSize(dimension);
    }

    public Font getBaseFont() {
        if (this.baseFont == null) {
            this.baseFont = this.getFont();
        }
        return this.baseFont;
    }

    public void setBaseFont(Font font) {
        Font font2 = this.getFont();
        this.baseFont = font;
        this.setFont(this.getFontForSize(this.getWidth(), this.getHeight()));
        this.firePropertyChange("font", font2, this.getFont());
        this.repaint();
    }

    private Font getFontForSize(int n, int n2) {
        int n3 = n * n2;
        float f = this.getBaseFont().getSize2D();
        Font font = n3 >= 633216 ? this.getBaseFont().deriveFont(f / 12.0f * 18.0f) : (n3 >= 393600 ? this.getBaseFont().deriveFont(f / 12.0f * 14.0f) : (n3 >= 192000 ? this.getBaseFont().deriveFont(f / 12.0f * 12.0f) : (n3 >= 38400 ? this.getBaseFont().deriveFont(f / 12.0f * 8.0f) : this.getBaseFont().deriveFont(f / 12.0f * 6.0f))));
        return font;
    }

    private ComponentListener createResizeListener() {
        return new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DasCanvas.this.setFont(DasCanvas.this.getFontForSize(DasCanvas.this.getWidth(), DasCanvas.this.getHeight()));
            }
        };
    }

    public Element getDOMElement(Document document) {
        Object object3;
        int n;
        Object object2;
        Element element = document.createElement("canvas");
        Dimension dimension = this.getPreferredSize();
        element.setAttribute("name", this.getDasName());
        element.setAttribute("width", Integer.toString(dimension.width));
        element.setAttribute("height", Integer.toString(dimension.height));
        for (int i = 0; i < this.devicePositionList.size(); ++i) {
            DasDevicePosition dasDevicePosition;
            object2 = this.devicePositionList.get(i);
            if (object2 instanceof DasRow) {
                dasDevicePosition = (DasRow)object2;
                element.appendChild(((DasRow)dasDevicePosition).getDOMElement(document));
                continue;
            }
            if (!(object2 instanceof DasColumn)) continue;
            dasDevicePosition = (DasColumn)object2;
            element.appendChild(((DasColumn)dasDevicePosition).getDOMElement(document));
        }
        Component[] componentArray = this.getComponents();
        object2 = new LinkedHashMap();
        for (n = 0; n < componentArray.length; ++n) {
            if (!(componentArray[n] instanceof DasAxis)) continue;
            object3 = (DasAxis)componentArray[n];
            object2.put(((DasCanvasComponent)object3).getDasName(), ((DasAxis)object3).getDOMElement(document));
        }
        for (n = 0; n < componentArray.length; ++n) {
            if (!(componentArray[n] instanceof DasColorBar)) continue;
            object3 = (DasColorBar)componentArray[n];
            object2.put(((DasCanvasComponent)object3).getDasName(), ((DasColorBar)object3).getDOMElement(document));
        }
        for (n = 0; n < componentArray.length; ++n) {
            if (!(componentArray[n] instanceof DasPlot)) continue;
            object3 = (DasPlot)componentArray[n];
            object2.remove(((DasPlot)object3).getXAxis().getDasName());
            object2.remove(((DasPlot)object3).getYAxis().getDasName());
            Renderer[] rendererArray = ((DasPlot)object3).getRenderers();
            for (int i = 0; i < rendererArray.length; ++i) {
                if (!(rendererArray[i] instanceof SpectrogramRenderer)) continue;
                SpectrogramRenderer spectrogramRenderer = (SpectrogramRenderer)rendererArray[i];
                object2.remove(spectrogramRenderer.getColorBar().getDasName());
            }
            object2.put(((DasCanvasComponent)object3).getDasName(), ((DasPlot)object3).getDOMElement(document));
        }
        for (Object object3 : object2.values()) {
            if (object3 == null) continue;
            element.appendChild((Node)object3);
        }
        return element;
    }

    public static DasCanvas processCanvasElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, DasException, ParsedExpressionException, ParseException {
        try {
            Logger logger = DasLogger.getLogger(DasLogger.DASML_LOG);
            String string = element.getAttribute("name");
            int n = Integer.parseInt(element.getAttribute("width"));
            int n2 = Integer.parseInt(element.getAttribute("height"));
            DasApplication dasApplication = formBase.getDasApplication();
            NameContext nameContext = dasApplication.getNameContext();
            DasCanvas dasCanvas = new DasCanvas(n, n2);
            NodeList nodeList = element.getChildNodes();
            int n3 = nodeList.getLength();
            for (int i = 0; i < n3; ++i) {
                Serializable serializable;
                Node node = nodeList.item(i);
                logger.fine("node=" + node.getNodeName());
                if (!(node instanceof Element)) continue;
                String string2 = node.getNodeName();
                if (string2.equals("row")) {
                    serializable = DasRow.processRowElement((Element)node, dasCanvas, formBase);
                    continue;
                }
                if (string2.equals("column")) {
                    serializable = DasColumn.processColumnElement((Element)node, dasCanvas, formBase);
                    continue;
                }
                if (string2.equals("axis")) {
                    serializable = DasAxis.processAxisElement((Element)node, formBase);
                    dasCanvas.add((Component)serializable);
                    continue;
                }
                if (string2.equals("timeaxis")) {
                    serializable = DasAxis.processTimeaxisElement((Element)node, formBase);
                    dasCanvas.add((Component)serializable);
                    continue;
                }
                if (string2.equals("attachedaxis")) {
                    serializable = DasAxis.processAttachedaxisElement((Element)node, formBase);
                    dasCanvas.add((Component)serializable);
                    continue;
                }
                if (string2.equals("colorbar")) {
                    serializable = DasColorBar.processColorbarElement((Element)node, formBase);
                    dasCanvas.add((Component)serializable);
                    continue;
                }
                if (string2.equals("plot")) {
                    serializable = DasPlot.processPlotElement((Element)node, formBase);
                    dasCanvas.add((Component)serializable);
                    continue;
                }
                if (!string2.equals("spectrogram")) continue;
                serializable = DasPlot.processPlotElement((Element)node, formBase);
                dasCanvas.add((Component)serializable);
            }
            dasCanvas.setDasName(string);
            nameContext.put(string, dasCanvas);
            return dasCanvas;
        }
        catch (DasPropertyException dasPropertyException) {
            if (!element.getAttribute("name").equals("")) {
                dasPropertyException.setObjectName(element.getAttribute("name"));
            }
            throw dasPropertyException;
        }
    }

    public static DasCanvas createFormCanvas(String string, int n, int n2) {
        DasCanvas dasCanvas = new DasCanvas(n, n2);
        if (string == null) {
            string = "canvas_" + Integer.toHexString(System.identityHashCode(dasCanvas));
        }
        try {
            dasCanvas.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        return dasCanvas;
    }

    public DasCanvasComponent getCanvasComponentAt(int n, int n2) {
        Component[] componentArray = this.getComponents();
        for (int i = 1; i < componentArray.length; ++i) {
            DasCanvasComponent dasCanvasComponent;
            Component component = componentArray[i];
            if (!(component instanceof DasCanvasComponent) || !(dasCanvasComponent = (DasCanvasComponent)component).getActiveRegion().contains(n, n2)) continue;
            return dasCanvasComponent;
        }
        return null;
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        super.remove(n);
        if (component instanceof DasCanvasComponent) {
            ((DasCanvasComponent)component).uninstallComponent();
        }
    }

    public HotLine getLineAt(int n, int n2) {
        for (HotLine hotLine : this.horizontalLineSet) {
            if (n2 < hotLine.position - 1 || n2 > hotLine.position + 1) continue;
            return hotLine;
        }
        for (HotLine hotLine : this.verticalLineSet) {
            if (n < hotLine.position - 1 || n > hotLine.position + 1) continue;
            return hotLine;
        }
        return null;
    }

    public Cell getCellAt(int n, int n2) {
        Cell cell = null;
        Point point = null;
        Point point2 = null;
        for (Cell cell2 : this.cellSet) {
            Rectangle rectangle = cell2.rc;
            if (!rectangle.contains(n, n2)) continue;
            if (cell == null) {
                cell = cell2;
                continue;
            }
            if (point == null) {
                point = new Point();
                point2 = new Point();
            }
            if (cell.rc.contains(rectangle)) {
                cell = cell2;
                continue;
            }
            point.setLocation(cell.rc.x + cell.rc.width / 2, cell.rc.y + cell.rc.height / 2);
            point2.setLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            int n3 = DasCanvas.distanceSquared(n, n2, point.x, point.y);
            int n4 = DasCanvas.distanceSquared(n, n2, point2.x, point2.y);
            if (n4 < n3) {
                cell = cell2;
                continue;
            }
            if (n4 != n3 || rectangle.width * rectangle.height >= cell.rc.width * cell.rc.height) continue;
            cell = cell2;
        }
        return cell;
    }

    private static int distanceSquared(int n, int n2, int n3, int n4) {
        return (n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2);
    }

    void addDevicePosition(DasDevicePosition dasDevicePosition) {
        this.devicePositionList.add(dasDevicePosition);
        if (dasDevicePosition instanceof DasRow) {
            this.addRow((DasRow)dasDevicePosition);
        } else if (dasDevicePosition instanceof DasColumn) {
            this.addColumn((DasColumn)dasDevicePosition);
        }
    }

    private void addRow(DasRow dasRow) {
        HotLine hotLine = new HotLine(dasRow, -1);
        HotLine hotLine2 = new HotLine(dasRow, 1);
        this.horizontalLineSet.add(hotLine);
        this.horizontalLineSet.add(hotLine2);
        for (DasDevicePosition dasDevicePosition : this.devicePositionList) {
            if (!(dasDevicePosition instanceof DasColumn)) continue;
            DasColumn dasColumn = (DasColumn)dasDevicePosition;
            this.cellSet.add(new Cell(dasRow, dasColumn));
        }
    }

    private void addColumn(DasColumn dasColumn) {
        HotLine hotLine = new HotLine(dasColumn, -1);
        HotLine hotLine2 = new HotLine(dasColumn, 1);
        this.verticalLineSet.add(hotLine);
        this.verticalLineSet.add(hotLine2);
        for (DasDevicePosition dasDevicePosition : this.devicePositionList) {
            if (!(dasDevicePosition instanceof DasRow)) continue;
            DasRow dasRow = (DasRow)dasDevicePosition;
            this.cellSet.add(new Cell(dasRow, dasColumn));
        }
    }

    public void removepwDevicePosition(DasDevicePosition dasDevicePosition) {
        this.devicePositionList.remove(dasDevicePosition);
        if (dasDevicePosition instanceof DasRow) {
            this.removeRow((DasRow)dasDevicePosition);
        } else if (dasDevicePosition instanceof DasColumn) {
            this.removeColumn((DasColumn)dasDevicePosition);
        }
    }

    private void removeRow(DasRow dasRow) {
        PropertyChangeListener propertyChangeListener;
        Iterator iterator = this.horizontalLineSet.iterator();
        while (iterator.hasNext()) {
            propertyChangeListener = (HotLine)iterator.next();
            if (propertyChangeListener.devicePosition != dasRow) continue;
            iterator.remove();
        }
        iterator = this.cellSet.iterator();
        while (iterator.hasNext()) {
            propertyChangeListener = (Cell)iterator.next();
            if (((Cell)propertyChangeListener).row != dasRow) continue;
            iterator.remove();
        }
    }

    private void removeColumn(DasColumn dasColumn) {
        PropertyChangeListener propertyChangeListener;
        Iterator iterator = this.verticalLineSet.iterator();
        while (iterator.hasNext()) {
            propertyChangeListener = (HotLine)iterator.next();
            if (propertyChangeListener.devicePosition != dasColumn) continue;
            iterator.remove();
        }
        iterator = this.cellSet.iterator();
        while (iterator.hasNext()) {
            propertyChangeListener = (Cell)iterator.next();
            if (((Cell)propertyChangeListener).column != dasColumn) continue;
            iterator.remove();
        }
    }

    public FormBase getForm() {
        Container container = this.getParent();
        if (container instanceof FormComponent) {
            return ((FormComponent)((Object)container)).getForm();
        }
        return null;
    }

    public boolean getEditingMode() {
        return this.editable;
    }

    public void setEditingMode(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        this.editable = bl;
        this.revalidate();
    }

    public DnDSupport getDnDSupport() {
        return this.dndSupport;
    }

    public boolean startDrag(int n, int n2, int n3, MouseEvent mouseEvent) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!this.getComponent(i).getBounds().contains(n, n2)) continue;
            this.dndSupport.startDrag(n, n2, n3, mouseEvent);
            return true;
        }
        return false;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            dasApplication.getNameContext().put(string, this);
            if (string2 != null) {
                dasApplication.getNameContext().remove(string2);
            }
        }
        this.firePropertyChange("name", string2, string);
    }

    public void deregisterComponent() {
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            Serializable serializable2;
            NameContext nameContext = dasApplication.getNameContext();
            for (Serializable serializable2 : this.devicePositionList) {
                try {
                    if (nameContext.get(((DasDevicePosition)serializable2).getDasName()) != serializable2) continue;
                    nameContext.remove(((DasDevicePosition)serializable2).getDasName());
                }
                catch (DasPropertyException dasPropertyException) {
                    IllegalStateException illegalStateException = new IllegalStateException(dasPropertyException.toString());
                    illegalStateException.initCause(dasPropertyException);
                    throw illegalStateException;
                }
                catch (InvocationTargetException invocationTargetException) {
                    IllegalStateException illegalStateException = new IllegalStateException(invocationTargetException.toString());
                    illegalStateException.initCause(invocationTargetException);
                    throw illegalStateException;
                }
            }
            for (int i = 0; i < this.getComponentCount(); ++i) {
                serializable2 = this.getComponent(i);
                if (!(serializable2 instanceof DasCanvasComponent)) continue;
                DasCanvasComponent dasCanvasComponent = (DasCanvasComponent)serializable2;
                try {
                    if (nameContext.get(dasCanvasComponent.getDasName()) != dasCanvasComponent) continue;
                    nameContext.remove(dasCanvasComponent.getDasName());
                    continue;
                }
                catch (DasPropertyException dasPropertyException) {
                    IllegalStateException illegalStateException = new IllegalStateException(dasPropertyException.toString());
                    illegalStateException.initCause(dasPropertyException);
                    throw illegalStateException;
                }
                catch (InvocationTargetException invocationTargetException) {
                    IllegalStateException illegalStateException = new IllegalStateException(invocationTargetException.toString());
                    illegalStateException.initCause(invocationTargetException);
                    throw illegalStateException;
                }
            }
            try {
                if (nameContext.get(this.getDasName()) == this) {
                    nameContext.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dasPropertyException) {
                serializable2 = new IllegalStateException(dasPropertyException.toString());
                ((Throwable)serializable2).initCause(dasPropertyException);
                throw serializable2;
            }
            catch (InvocationTargetException invocationTargetException) {
                serializable2 = new IllegalStateException(invocationTargetException.toString());
                ((Throwable)serializable2).initCause(invocationTargetException);
                throw serializable2;
            }
        }
    }

    public DasApplication getDasApplication() {
        Container container = this.getParent();
        if (container instanceof FormComponent) {
            return ((FormComponent)((Object)container)).getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        try {
            DasApplication dasApplication = this.getDasApplication();
            if (dasApplication != null) {
                NameContext nameContext = dasApplication.getNameContext();
                for (Serializable serializable : this.devicePositionList) {
                    nameContext.put(serializable.getDasName(), serializable);
                }
                for (int i = 0; i < this.getComponentCount(); ++i) {
                    Serializable serializable;
                    serializable = this.getComponent(i);
                    if (!(serializable instanceof DasCanvasComponent)) continue;
                    DasCanvasComponent dasCanvasComponent = (DasCanvasComponent)serializable;
                    nameContext.put(dasCanvasComponent.getDasName(), dasCanvasComponent);
                }
                nameContext.put(this.getDasName(), this);
            }
        }
        catch (DasNameException dasNameException) {
            this.deregisterComponent();
            throw dasNameException;
        }
    }

    public DasCanvasComponent getCanvasComponents(int n) {
        return (DasCanvasComponent)this.getComponent(n + 1);
    }

    public DasCanvasComponent[] getCanvasComponents() {
        int n = this.getComponentCount() - 1;
        DasCanvasComponent[] dasCanvasComponentArray = new DasCanvasComponent[n];
        for (int i = 0; i < n; ++i) {
            dasCanvasComponentArray[i] = this.getCanvasComponents(i);
        }
        return dasCanvasComponentArray;
    }

    public String toString() {
        return "[DasCanvas " + this.getWidth() + "x" + this.getHeight() + " " + this.getDasName() + "]";
    }

    static {
        float f = 3.0f;
        int n = 2;
        int n2 = 0;
        float[] fArray = new float[]{f * 4.0f, f * 4.0f};
        STROKE_DASHED = new BasicStroke(f, n, n2, f, fArray, 0.0f);
        SAVE_AS_PNG_ACTION = new CanvasAction("Save as PNG"){
            JFileChooser pngFileChooser;
            JPanel pngFileNamePanel;
            JTextField pngFileTextField;

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (this.pngFileNamePanel == null) {
                    this.pngFileNamePanel = new JPanel();
                    this.pngFileNamePanel.setLayout(new BoxLayout(this.pngFileNamePanel, 0));
                    this.pngFileTextField = new JTextField(32);
                    this.pngFileTextField.setMaximumSize(this.pngFileTextField.getPreferredSize());
                    this.pngFileChooser = new JFileChooser();
                    this.pngFileChooser.setApproveButtonText("Select File");
                    this.pngFileChooser.setDialogTitle("Write to PNG");
                    object = new JButton("Browse");
                    ((AbstractButton)object).setActionCommand("pngBrowse");
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = pngFileChooser.showDialog(CanvasAction.currentCanvas, "Select File");
                            if (n == 0) {
                                pngFileTextField.setText(pngFileChooser.getSelectedFile().getPath());
                            }
                        }
                    });
                    this.pngFileNamePanel.add(this.pngFileTextField);
                    this.pngFileNamePanel.add((Component)object);
                }
                this.pngFileTextField.setText(this.pngFileChooser.getCurrentDirectory().getPath());
                object = new String[]{"Save as PNG", "Cancel"};
                int n = JOptionPane.showOptionDialog(currentCanvas, this.pngFileNamePanel, "Write to PNG", 0, 3, null, (Object[])object, "Ok");
                if (n == 0) {
                    final DasCanvas dasCanvas = currentCanvas;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            try {
                                dasCanvas.writeToPng(pngFileTextField.getText());
                            }
                            catch (IOException iOException) {
                                DasExceptionHandler.handle(iOException);
                            }
                        }
                    };
                    new Thread(runnable, "writeToPng").start();
                }
            }
        };
        SAVE_AS_SVG_ACTION = new CanvasAction("Save as SVG"){
            JFileChooser svgFileChooser;
            JPanel svgFileNamePanel;
            JTextField svgFileTextField;

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (this.svgFileNamePanel == null) {
                    this.svgFileNamePanel = new JPanel();
                    this.svgFileNamePanel.setLayout(new BoxLayout(this.svgFileNamePanel, 0));
                    this.svgFileTextField = new JTextField(32);
                    this.svgFileTextField.setMaximumSize(this.svgFileTextField.getPreferredSize());
                    this.svgFileChooser = new JFileChooser();
                    this.svgFileChooser.setApproveButtonText("Select File");
                    this.svgFileChooser.setDialogTitle("Write to SVG");
                    object = new JButton("Browse");
                    ((AbstractButton)object).setActionCommand("pngBrowse");
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = svgFileChooser.showDialog(CanvasAction.currentCanvas, "Select File");
                            if (n == 0) {
                                svgFileTextField.setText(svgFileChooser.getSelectedFile().getPath());
                            }
                        }
                    });
                    this.svgFileNamePanel.add(this.svgFileTextField);
                    this.svgFileNamePanel.add((Component)object);
                }
                this.svgFileTextField.setText(this.svgFileChooser.getCurrentDirectory().getPath());
                object = new String[]{"Save as SVG", "Cancel"};
                int n = JOptionPane.showOptionDialog(currentCanvas, this.svgFileNamePanel, "Write to SVG", 0, 3, null, (Object[])object, "Ok");
                if (n == 0) {
                    DasCanvas dasCanvas = currentCanvas;
                    try {
                        dasCanvas.writeToSVG(this.svgFileTextField.getText());
                    }
                    catch (IOException iOException) {
                        DasExceptionHandler.handle(iOException);
                    }
                }
            }
        };
        SAVE_AS_PDF_ACTION = new CanvasAction("Save as PDF"){
            JFileChooser pdfFileChooser;
            JPanel pdfFileNamePanel;
            JTextField pdfFileTextField;

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (this.pdfFileNamePanel == null) {
                    this.pdfFileNamePanel = new JPanel();
                    this.pdfFileNamePanel.setLayout(new BoxLayout(this.pdfFileNamePanel, 0));
                    this.pdfFileTextField = new JTextField(32);
                    this.pdfFileTextField.setMaximumSize(this.pdfFileTextField.getPreferredSize());
                    this.pdfFileChooser = new JFileChooser();
                    this.pdfFileChooser.setApproveButtonText("Select File");
                    this.pdfFileChooser.setDialogTitle("Write to PDF");
                    object = new JButton("Browse");
                    ((AbstractButton)object).setActionCommand("pngBrowse");
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = pdfFileChooser.showDialog(CanvasAction.currentCanvas, "Select File");
                            if (n == 0) {
                                pdfFileTextField.setText(pdfFileChooser.getSelectedFile().getPath());
                            }
                        }
                    });
                    this.pdfFileNamePanel.add(this.pdfFileTextField);
                    this.pdfFileNamePanel.add((Component)object);
                }
                this.pdfFileTextField.setText(this.pdfFileChooser.getCurrentDirectory().getPath());
                object = new String[]{"Save as PDF", "Cancel"};
                int n = JOptionPane.showOptionDialog(currentCanvas, this.pdfFileNamePanel, "Write to PDF", 0, 3, null, (Object[])object, "Ok");
                if (n == 0) {
                    DasCanvas dasCanvas = currentCanvas;
                    try {
                        dasCanvas.writeToPDF(this.pdfFileTextField.getText());
                    }
                    catch (IOException iOException) {
                        DasExceptionHandler.handle(iOException);
                    }
                }
            }
        };
        EDIT_DAS_PROPERTIES_ACTION = new AbstractAction("DAS Properties"){

            public void actionPerformed(ActionEvent actionEvent) {
                DasProperties.showEditor();
            }
        };
        PRINT_ACTION = new CanvasAction("Print..."){

            public void actionPerformed(ActionEvent actionEvent) {
                Printable printable = currentCanvas.getPrintable();
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(printable);
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        Object[] objectArray = new Object[]{"Error printing", printerException.getMessage()};
                        JOptionPane.showMessageDialog(null, objectArray, "ERROR", 0);
                    }
                }
            }
        };
        REFRESH_ACTION = new CanvasAction("Refresh"){

            public void actionPerformed(ActionEvent actionEvent) {
                DasCanvasComponent[] dasCanvasComponentArray = currentCanvas.getCanvasComponents();
                for (int i = 0; i < dasCanvasComponentArray.length; ++i) {
                    dasCanvasComponentArray[i].update();
                }
            }
        };
        ABOUT_ACTION = new CanvasAction("About"){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                String string = Splash.getVersion();
                String string2 = System.getProperty("java.version");
                String string3 = "???";
                URL uRL = this.getClass().getResource("/buildTime.txt");
                if (uRL != null) {
                    try {
                        object = new BufferedReader(new InputStreamReader(uRL.openStream()));
                        string3 = ((BufferedReader)object).readLine();
                        ((BufferedReader)object).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                object = System.getProperty("sun.arch.data.model");
                DecimalFormat decimalFormat = new DecimalFormat("0.0");
                String string4 = decimalFormat.format(Runtime.getRuntime().maxMemory() / 0x100000L);
                String string5 = "<html>release version: " + string + "<br>build time: " + string3 + "<br>java version: " + string2 + "<br>max memory (Mb): " + string4 + "<br>arch (bits): " + (String)object + "<br></html>";
                JOptionPane.showConfirmDialog(currentCanvas, string5, "about das2", -1);
                currentCanvas.setSize(currentCanvas.getWidth() + 1, currentCanvas.getHeight() + 1);
                currentCanvas.setSize(currentCanvas.getWidth(), currentCanvas.getHeight());
            }
        };
    }

    public static class Cell
    implements PropertyChangeListener {
        Rectangle rc;
        DasRow row;
        DasColumn column;

        Cell(DasRow dasRow, DasColumn dasColumn) {
            this.row = dasRow;
            this.column = dasColumn;
            this.rc = new Rectangle();
            dasRow.addPropertyChangeListener("dMinimum", this);
            dasRow.addPropertyChangeListener("dMaximum", this);
            dasColumn.addPropertyChangeListener("dMinimum", this);
            dasColumn.addPropertyChangeListener("dMaximum", this);
            this.rc.x = (int)Math.floor((double)dasColumn.getDMinimum() + 0.5);
            this.rc.y = (int)Math.floor((double)dasRow.getDMinimum() + 0.5);
            this.rc.width = (int)Math.floor((double)dasColumn.getDMaximum() + 0.5) - this.rc.x;
            this.rc.height = (int)Math.floor((double)dasRow.getDMaximum() + 0.5) - this.rc.y;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == this.row) {
                this.rc.y = (int)Math.floor((double)this.row.getDMinimum() + 0.5);
                this.rc.height = (int)Math.floor((double)this.row.getDMaximum() + 0.5) - this.rc.y;
            } else {
                this.rc.x = (int)Math.floor((double)this.column.getDMinimum() + 0.5);
                this.rc.width = (int)Math.floor((double)this.column.getDMaximum() + 0.5) - this.rc.x;
            }
        }

        public boolean equals(Object object) {
            if (object instanceof Cell) {
                Cell cell = (Cell)object;
                return cell.row == this.row && cell.column == this.column;
            }
            return false;
        }

        public String toString() {
            return "{" + this.row.getDasName() + " x " + this.column.getDasName() + ": " + this.rc.toString() + "}";
        }

        public Rectangle getCellBounds() {
            return new Rectangle(this.rc);
        }

        public Rectangle getCellBounds(Rectangle rectangle) {
            if (rectangle == null) {
                return this.getCellBounds();
            }
            rectangle.setBounds(this.rc);
            return rectangle;
        }

        public DasRow getRow() {
            return this.row;
        }

        public DasColumn getColumn() {
            return this.column;
        }
    }

    public static class HotLine
    implements PropertyChangeListener {
        public static final int MIN = -1;
        public static final int NONE = 0;
        public static final int MAX = 1;
        int position;
        DasDevicePosition devicePosition;
        int minOrMax;

        HotLine(DasDevicePosition dasDevicePosition, int n) {
            this.devicePosition = dasDevicePosition;
            this.minOrMax = n;
            this.refresh();
            dasDevicePosition.addPropertyChangeListener(n == -1 ? "dMinimum" : "dMaximum", this);
        }

        void refresh() {
            this.position = this.minOrMax == -1 ? (int)Math.floor((double)this.devicePosition.getDMinimum() + 0.5) : (int)Math.floor((double)this.devicePosition.getDMaximum() + 0.5);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.refresh();
        }

        public boolean equals(Object object) {
            if (object instanceof HotLine) {
                HotLine hotLine = (HotLine)object;
                return hotLine.devicePosition == this.devicePosition && hotLine.minOrMax == this.minOrMax;
            }
            return false;
        }

        public int hashCode() {
            return this.minOrMax * this.devicePosition.hashCode();
        }

        public String toString() {
            return "{" + this.devicePosition.getDasName() + (this.minOrMax == -1 ? ", MIN, " : ", MAX, ") + this.position + "}";
        }

        public DasDevicePosition getDevicePosition() {
            return this.devicePosition;
        }

        public int getMinOrMax() {
            return this.minOrMax;
        }
    }

    private static class GlassPane
    extends JPanel
    implements MouseInputListener,
    KeyListener {
        boolean blocking = false;
        boolean accepting = false;
        Rectangle target;

        public GlassPane() {
            this.setOpaque(false);
            this.setLayout(null);
        }

        DasCanvas getCanvas() {
            return (DasCanvas)this.getParent();
        }

        void setBlocking(boolean bl) {
            if (bl != this.blocking) {
                this.blocking = bl;
                if (bl) {
                    this.addMouseListener(this);
                    this.addMouseMotionListener(this);
                } else {
                    this.removeMouseListener(this);
                    this.removeMouseMotionListener(this);
                }
                this.repaint();
            }
        }

        void setAccepting(boolean bl) {
            if (bl != this.accepting) {
                this.accepting = bl;
                this.repaint();
            }
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.blocking) {
                this.paintLoading(graphics2D);
            }
            if (((DasCanvas)this.getParent()).getEditingMode()) {
                this.paintRowColumn(graphics2D);
            }
            if (this.accepting && this.target != null) {
                this.paintDnDTarget(graphics2D);
            }
        }

        private void paintRowColumn(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            DasCanvas dasCanvas = this.getCanvas();
            for (DasDevicePosition dasDevicePosition : dasCanvas.devicePositionList) {
                Paint paint;
                int n;
                int n2;
                int n3;
                int n4;
                double d = dasDevicePosition.getMinimum();
                double d2 = dasDevicePosition.getMaximum();
                int n5 = dasCanvas.getWidth();
                int n6 = dasCanvas.getHeight();
                if (dasDevicePosition instanceof DasRow) {
                    n4 = 0;
                    n3 = n5;
                    n2 = (int)Math.floor(d * (double)n6 + 0.5);
                    n = (int)Math.floor(d2 * (double)n6 + 0.5) - n2;
                    paint = PAINT_ROW;
                } else {
                    n4 = (int)Math.floor(d * (double)n5 + 0.5);
                    n3 = (int)Math.floor(d2 * (double)n5 + 0.5) - n4;
                    n2 = 0;
                    n = n6;
                    paint = PAINT_COLUMN;
                }
                graphics2D.setPaint(paint);
                graphics2D.fillRect(n4, n2, n3, n);
            }
        }

        private void paintDnDTarget(Graphics2D graphics2D) {
            graphics2D.setStroke(STROKE_DASHED);
            graphics2D.setPaint(PAINT_SELECTION);
            graphics2D.drawRect(this.target.x + 1, this.target.y + 1, this.target.width - 2, this.target.height - 2);
        }

        private void paintLoading(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            graphics2D.setColor(new Color(-587202561, true));
            Rectangle rectangle = graphics2D.getClipBounds();
            if (rectangle == null) {
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private class CanvasDnDSupport
    extends DnDSupport {
        private List acceptList;

        CanvasDnDSupport() {
            super(DasCanvas.this, 3, null);
            this.acceptList = Arrays.asList(TransferableCanvasComponent.PLOT_FLAVOR, TransferableCanvasComponent.AXIS_FLAVOR, TransferableCanvasComponent.COLORBAR_FLAVOR);
        }

        private Rectangle getAxisRectangle(Rectangle rectangle, Rectangle rectangle2, int n, int n2) {
            if (rectangle2 == null) {
                rectangle2 = new Rectangle();
            }
            int n3 = this.getAxisOrientation(rectangle, n, n2);
            switch (n3) {
                case 1: {
                    rectangle2.width = rectangle.width;
                    rectangle2.height = 3 * DasCanvas.this.getFont().getSize();
                    rectangle2.x = rectangle.x;
                    rectangle2.y = rectangle.y - rectangle2.height;
                    break;
                }
                case 4: {
                    rectangle2.width = 3 * DasCanvas.this.getFont().getSize();
                    rectangle2.height = rectangle.height;
                    rectangle2.x = rectangle.x + rectangle.width;
                    rectangle2.y = rectangle.y;
                    break;
                }
                case 3: {
                    rectangle2.width = 3 * DasCanvas.this.getFont().getSize();
                    rectangle2.height = rectangle.height;
                    rectangle2.x = rectangle.x - rectangle2.width;
                    rectangle2.y = rectangle.y;
                    break;
                }
                case 2: {
                    rectangle2.width = rectangle.width;
                    rectangle2.height = 3 * DasCanvas.this.getFont().getSize();
                    rectangle2.x = rectangle.x;
                    rectangle2.y = rectangle.y + rectangle.height;
                    break;
                }
                default: {
                    throw new RuntimeException("invalid orientation: " + n3);
                }
            }
            return rectangle2;
        }

        private int getAxisOrientation(Rectangle rectangle, int n, int n2) {
            boolean bl;
            int n3 = (n - rectangle.x) * rectangle.height;
            int n4 = (n2 - rectangle.y) * rectangle.width;
            int n5 = rectangle.width * rectangle.height;
            boolean bl2 = bl = n3 + n4 < n5;
            return n3 > n4 ? (bl ? 1 : 4) : (bl ? 3 : 2);
        }

        protected int canAccept(DataFlavor[] dataFlavorArray, int n, int n2, int n3) {
            DasCanvas.this.glassPane.setAccepting(true);
            List<DataFlavor> list = Arrays.asList(dataFlavorArray);
            Cell cell = DasCanvas.this.getCellAt(n, n2);
            Rectangle rectangle = cell == null ? null : cell.getCellBounds();
            Rectangle rectangle2 = ((DasCanvas)DasCanvas.this).glassPane.target;
            if (list.contains(TransferableCanvasComponent.COLORBAR_FLAVOR)) {
                return n3;
            }
            if (list.contains(TransferableCanvasComponent.AXIS_FLAVOR)) {
                if (!(rectangle2 == rectangle || rectangle2 != null && rectangle2.equals(rectangle))) {
                    if (rectangle2 != null) {
                        DasCanvas.this.glassPane.repaint(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
                    }
                    if (rectangle != null) {
                        rectangle2 = ((DasCanvas)DasCanvas.this).glassPane.target = this.getAxisRectangle(rectangle, rectangle2, n, n2);
                        DasCanvas.this.glassPane.repaint(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
                    } else {
                        ((DasCanvas)DasCanvas.this).glassPane.target = null;
                    }
                }
                return n3;
            }
            if (list.contains(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR)) {
                if (!(rectangle2 == rectangle || rectangle2 != null && rectangle2.equals(rectangle))) {
                    if (rectangle2 != null) {
                        DasCanvas.this.glassPane.repaint(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
                    }
                    rectangle2 = ((DasCanvas)DasCanvas.this).glassPane.target = rectangle;
                    if (rectangle != null) {
                        DasCanvas.this.glassPane.repaint(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
                    }
                }
                return n3;
            }
            return -1;
        }

        protected void done() {
            DasCanvas.this.glassPane.setAccepting(false);
            if (((DasCanvas)DasCanvas.this).glassPane.target != null) {
                Rectangle rectangle = ((DasCanvas)DasCanvas.this).glassPane.target;
                ((DasCanvas)DasCanvas.this).glassPane.target = null;
                DasCanvas.this.glassPane.repaint(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            }
        }

        protected boolean importData(Transferable transferable, int n, int n2, int n3) {
            boolean bl = false;
            try {
                Cell cell;
                if (transferable.isDataFlavorSupported(TransferableCanvasComponent.COLORBAR_FLAVOR)) {
                    Cell cell2 = DasCanvas.this.getCellAt(n, n2);
                    if (cell2 != null) {
                        DasCanvasComponent dasCanvasComponent = (DasCanvasComponent)transferable.getTransferData(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR);
                        dasCanvasComponent.setRow(cell2.getRow());
                        dasCanvasComponent.setColumn(cell2.getColumn());
                        DasCanvas.this.add(dasCanvasComponent);
                        DasCanvas.this.revalidate();
                        bl = true;
                    }
                } else if (transferable.isDataFlavorSupported(TransferableCanvasComponent.AXIS_FLAVOR)) {
                    Cell cell3 = DasCanvas.this.getCellAt(n, n2);
                    if (cell3 != null) {
                        DasAxis dasAxis = (DasAxis)transferable.getTransferData(TransferableCanvasComponent.AXIS_FLAVOR);
                        dasAxis.setRow(cell3.getRow());
                        dasAxis.setColumn(cell3.getColumn());
                        Rectangle rectangle = cell3.getCellBounds();
                        int n4 = this.getAxisOrientation(rectangle, n, n2);
                        dasAxis.setOrientation(n4);
                        DasCanvas.this.add(dasAxis);
                        DasCanvas.this.revalidate();
                        bl = true;
                    }
                } else if (transferable.isDataFlavorSupported(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR) && (cell = DasCanvas.this.getCellAt(n, n2)) != null) {
                    DasCanvasComponent dasCanvasComponent = (DasCanvasComponent)transferable.getTransferData(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR);
                    dasCanvasComponent.setRow(cell.getRow());
                    dasCanvasComponent.setColumn(cell.getColumn());
                    DasCanvas.this.add(dasCanvasComponent);
                    DasCanvas.this.revalidate();
                    bl = true;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bl;
        }

        protected Transferable getTransferable(int n, int n2, int n3) {
            DasCanvasComponent dasCanvasComponent = DasCanvas.this.getCanvasComponentAt(n, n2);
            if (dasCanvasComponent instanceof DasColorBar) {
                return new TransferableCanvasComponent((DasColorBar)dasCanvasComponent);
            }
            if (dasCanvasComponent instanceof DasAxis) {
                return new TransferableCanvasComponent((DasAxis)dasCanvasComponent);
            }
            if (dasCanvasComponent instanceof DasPlot) {
                return new TransferableCanvasComponent((DasPlot)dasCanvasComponent);
            }
            return null;
        }

        protected void exportDone(Transferable transferable, int n) {
        }
    }

    protected static class RowColumnLayout
    implements LayoutManager {
        protected RowColumnLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    if (component instanceof DasCanvasComponent) {
                        ((DasCanvasComponent)component).update();
                        continue;
                    }
                    if (component != ((DasCanvas)container).glassPane) continue;
                    Dimension dimension = container.getSize();
                    component.setBounds(0, 0, dimension.width, dimension.height);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = container.getComponentCount();
                Rectangle rectangle = new Rectangle(0, 0, 0, 0);
                for (int i = 0; i < n; ++i) {
                    rectangle.add(container.getComponent(i).getBounds());
                }
                return new Dimension(rectangle.width, rectangle.height);
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    protected static abstract class CanvasAction
    extends AbstractAction {
        protected static DasCanvas currentCanvas;

        CanvasAction(String string) {
            super(string);
        }
    }
}

