/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.DataRequestThread;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateEvent;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.DefaultDatumFormatterFactory;
import edu.uiowa.physics.pw.das.event.BoxRenderer;
import edu.uiowa.physics.pw.das.event.BoxSelectionEvent;
import edu.uiowa.physics.pw.das.event.BoxSelectionListener;
import edu.uiowa.physics.pw.das.event.BoxSelectorMouseModule;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.event.HorizontalRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener;
import edu.uiowa.physics.pw.das.event.VerticalRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasDevicePosition;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.DataRange;
import edu.uiowa.physics.pw.das.graph.TickVDescriptor;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.system.UserMessageCenter;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasMath;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasAxis
extends DasCanvasComponent
implements DataRangeSelectionListener,
TimeRangeSelectionListener,
Cloneable {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int UP = 995;
    public static final int DOWN = 996;
    private static final String SCAN_PREVIOUS_LABEL = "<< scan";
    private static final String SCAN_NEXT_LABEL = "scan >>";
    protected DataRange dataRange;
    private int orientation;
    private int tickDirection = 1;
    protected String axisLabel = "";
    protected TickVDescriptor tickV;
    protected boolean autoTickV = true;
    private boolean ticksVisible = true;
    private boolean tickLabelsVisible = true;
    private boolean oppositeAxisVisible = false;
    protected DatumFormatter datumFormatter = DefaultDatumFormatterFactory.getInstance().defaultFormatter();
    private MouseModule zoom = null;
    private PropertyChangeListener dataRangePropertyListener;
    protected JPanel primaryInputPanel;
    protected JPanel secondaryInputPanel;
    private ScanButton scanPrevious;
    private ScanButton scanNext;
    private boolean animated = "on".equals(DasProperties.getInstance().get("visualCues"));
    private Rectangle blLineRect;
    private Rectangle trLineRect;
    private Rectangle blTickRect;
    private Rectangle trTickRect;
    private Rectangle blLabelRect;
    private Rectangle trLabelRect;
    private Rectangle blTitleRect;
    private Rectangle trTitleRect;
    private boolean flipped;
    private EventListenerList timeRangeListenerList = null;
    private TimeRangeSelectionEvent lastProcessedEvent = null;
    private DataSetDescriptor dsd;
    private VectorDataSet[] tcaData = new VectorDataSet[0];
    private String dataset = "";
    private boolean drawTca;
    private DataRequestThread drt;
    private static final boolean DEBUG_GRAPHICS = false;
    private static final Color[] DEBUG_COLORS = null;
    private int debugColorIndex = 0;
    private DasPlot dasPlot;
    private JMenu favoritesMenu;
    private JMenu backMenu;
    private static final Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);
    private final DataSetUpdateListener tcaListener = new DataSetUpdateListener(){

        public void dataSetUpdated(DataSetUpdateEvent dataSetUpdateEvent) {
            VectorDataSet vectorDataSet = (VectorDataSet)dataSetUpdateEvent.getDataSet();
            if (vectorDataSet == null) {
                UserMessageCenter.getDefault().notifyUser((Object)DasAxis.this, dataSetUpdateEvent.getException());
                return;
            }
            logger.fine("got TCADataSet");
            List list = (List)vectorDataSet.getProperty("plane-list");
            VectorDataSet[] vectorDataSetArray = new VectorDataSet[list.size()];
            vectorDataSetArray[0] = vectorDataSet;
            for (int i = 1; i < list.size(); ++i) {
                vectorDataSetArray[i] = (VectorDataSet)vectorDataSet.getPlanarView((String)list.get(i));
            }
            DasAxis.access$602(DasAxis.this, vectorDataSetArray);
            DasAxis.this.update();
        }
    };
    private static final Pattern pattern = Pattern.compile("\\([eEfF]\\d+.\\d+\\)");

    public DasAxis(Datum datum, Datum datum2, int n) {
        this(datum, datum2, n, false);
    }

    public DasAxis(Datum datum, Datum datum2, int n, boolean bl) {
        this(n);
        this.dataRange = new DataRange(this, datum, datum2, bl);
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("history", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("favorites", this.dataRangePropertyListener);
        this.copyFavorites();
        this.copyHistory();
    }

    protected DasAxis(DataRange dataRange, int n) {
        this(n);
        this.dataRange = dataRange;
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("history", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("favorites", this.dataRangePropertyListener);
        this.copyFavorites();
        this.copyHistory();
    }

    public DasAxis(DatumRange datumRange, int n) {
        this(datumRange.min(), datumRange.max(), n);
    }

    private DasAxis(int n) {
        this.setOpaque(false);
        this.setOrientationInternal(n);
        this.installMouseModules();
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.backMenu = new JMenu("Back");
            this.mouseAdapter.addMenuItem(this.backMenu);
            this.favoritesMenu = new JMenu("Favorites");
            this.mouseAdapter.addMenuItem(this.favoritesMenu);
        }
        this.dataRangePropertyListener = this.createDataRangePropertyListener();
        this.setLayout(new AxisLayoutManager());
        this.maybeInitializeInputPanels();
        this.maybeInitializeScanButtons();
        this.add(this.primaryInputPanel);
        this.add(this.secondaryInputPanel);
    }

    public void addToFavorites(DatumRange datumRange) {
        this.dataRange.addToFavorites(datumRange);
        this.copyFavorites();
    }

    private void copyFavorites() {
        Object object2;
        if (DasApplication.getDefaultApplication().isHeadless()) {
            return;
        }
        this.favoritesMenu.removeAll();
        List list = this.dataRange.getFavorites();
        for (Object object2 : list) {
            AbstractAction abstractAction = new AbstractAction(((DatumRange)object2).toString(), (DatumRange)object2){
                final /* synthetic */ DatumRange val$r;
                {
                    this.val$r = datumRange;
                    super(string);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    DasAxis.this.setDatumRange(this.val$r);
                }
            };
            JMenuItem jMenuItem = new JMenuItem(abstractAction);
            this.favoritesMenu.add(jMenuItem);
        }
        AbstractAction abstractAction = new AbstractAction("add to favorites"){

            public void actionPerformed(ActionEvent actionEvent) {
                DasAxis.this.addToFavorites(DasAxis.this.getDatumRange());
            }
        };
        object2 = new JMenuItem(abstractAction);
        this.favoritesMenu.add((JMenuItem)object2);
    }

    private void copyHistory() {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            return;
        }
        this.backMenu.removeAll();
        List list = this.dataRange.getHistory();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            final int n2 = n++;
            DatumRange datumRange = (DatumRange)iterator.next();
            AbstractAction abstractAction = new AbstractAction(datumRange.toString()){

                public void actionPerformed(ActionEvent actionEvent) {
                    DasAxis.this.dataRange.popHistory(n2);
                    DasAxis.this.setDataRangePrev();
                }
            };
            JMenuItem jMenuItem = new JMenuItem(abstractAction);
            this.backMenu.add(jMenuItem);
        }
    }

    private void maybeInitializeInputPanels() {
        if (this.primaryInputPanel == null) {
            this.primaryInputPanel = new JPanel();
            this.primaryInputPanel.setOpaque(false);
        }
        if (this.secondaryInputPanel == null) {
            this.secondaryInputPanel = new JPanel();
            this.secondaryInputPanel.setOpaque(false);
        }
    }

    private void maybeInitializeScanButtons() {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.scanPrevious = new ScanButton(SCAN_PREVIOUS_LABEL);
            this.scanNext = new ScanButton(SCAN_NEXT_LABEL);
            ActionListener actionListener = this.createScanActionListener();
            this.scanPrevious.addActionListener(actionListener);
            this.scanNext.addActionListener(actionListener);
            this.add(this.scanPrevious);
            this.add(this.scanNext);
        }
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("back")) {
                    DasAxis.this.setDataRangePrev();
                }
            }
        };
    }

    private ActionListener createScanActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                DasLogger.getLogger(DasLogger.GUI_LOG).info("event " + string);
                if (string.equals(DasAxis.SCAN_PREVIOUS_LABEL)) {
                    DasAxis.this.scanPrevious();
                } else if (string.equals(DasAxis.SCAN_NEXT_LABEL)) {
                    DasAxis.this.scanNext();
                }
            }
        };
    }

    private PropertyChangeListener createDataRangePropertyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getOldValue();
                Object object2 = propertyChangeEvent.getNewValue();
                if (string.equals("log")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("log", object, object2);
                } else if (string.equals("minimum")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("dataMinimum", object, object2);
                } else if (string.equals("maximum")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("dataMaximum", object, object2);
                } else if (string.equals("favorites")) {
                    DasAxis.this.copyFavorites();
                } else if (string.equals("history")) {
                    DasAxis.this.copyHistory();
                }
                DasAxis.this.markDirty();
            }
        };
    }

    private void installMouseModules() {
        if (this.zoom instanceof HorizontalRangeSelectorMouseModule) {
            ((HorizontalRangeSelectorMouseModule)this.zoom).removeDataRangeSelectionListener(this);
            this.mouseAdapter.removeMouseModule(this.zoom);
        } else if (this.zoom instanceof VerticalRangeSelectorMouseModule) {
            ((VerticalRangeSelectorMouseModule)this.zoom).removeDataRangeSelectionListener(this);
            this.mouseAdapter.removeMouseModule(this.zoom);
        }
        if (this.isHorizontal()) {
            this.zoom = new HorizontalRangeSelectorMouseModule(this, this);
            ((HorizontalRangeSelectorMouseModule)this.zoom).addDataRangeSelectionListener(this);
            this.mouseAdapter.addMouseModule(this.zoom);
            this.mouseAdapter.setPrimaryModule(this.zoom);
            BoxSelectorMouseModule boxSelectorMouseModule = new BoxSelectorMouseModule(this, this, null, null, new BoxRenderer(this), "Zoom Out");
            boxSelectorMouseModule.addBoxSelectionListener(new BoxSelectionListener(){

                public void BoxSelected(BoxSelectionEvent boxSelectionEvent) {
                    DatumRange datumRange = DasAxis.this.getDatumRange();
                    DatumRange datumRange2 = boxSelectionEvent.getXRange();
                    datumRange2 = DasAxis.this.getTickV().enclosingRange(datumRange2, true);
                    DatumRange datumRange3 = datumRange.rescale(datumRange2.normalize(datumRange.min()), datumRange2.normalize(datumRange.max()));
                    DasAxis.this.setDatumRange(datumRange3);
                }
            });
            this.mouseAdapter.addMouseModule(boxSelectorMouseModule);
            this.mouseAdapter.setSecondaryModule(boxSelectorMouseModule);
        } else {
            this.zoom = new VerticalRangeSelectorMouseModule(this, this);
            ((VerticalRangeSelectorMouseModule)this.zoom).addDataRangeSelectionListener(this);
            this.mouseAdapter.addMouseModule(this.zoom);
            this.mouseAdapter.setPrimaryModule(this.zoom);
            BoxSelectorMouseModule boxSelectorMouseModule = new BoxSelectorMouseModule(this, null, this, null, new BoxRenderer(this), "Zoom Out");
            boxSelectorMouseModule.addBoxSelectionListener(new BoxSelectionListener(){

                public void BoxSelected(BoxSelectionEvent boxSelectionEvent) {
                    System.out.println(boxSelectionEvent.getYRange());
                    DatumRange datumRange = DasAxis.this.getDatumRange();
                    DatumRange datumRange2 = boxSelectionEvent.getYRange();
                    datumRange2 = DasAxis.this.getTickV().enclosingRange(datumRange2, true);
                    DatumRange datumRange3 = datumRange.rescale(datumRange2.normalize(datumRange.min()), datumRange2.normalize(datumRange.max()));
                    DasAxis.this.setDatumRange(datumRange3);
                }
            });
            this.mouseAdapter.addMouseModule(boxSelectorMouseModule);
            this.mouseAdapter.setSecondaryModule(boxSelectorMouseModule);
        }
    }

    public void setOrientation(int n) {
        boolean bl = this.isHorizontal();
        this.setOrientationInternal(n);
        if (bl != this.isHorizontal()) {
            this.installMouseModules();
        }
    }

    private void setOrientationInternal(int n) {
        this.orientation = n;
        if (n == 1) {
            this.setTickDirection(995);
        } else if (n == 2) {
            this.setTickDirection(996);
        } else if (n == 3) {
            this.setTickDirection(4);
        } else if (n == 4) {
            this.setTickDirection(3);
        } else {
            throw new IllegalArgumentException("Invalid value for orientation");
        }
    }

    public void setDatumRange(DatumRange datumRange) {
        this.setDataRange(datumRange.min(), datumRange.max());
    }

    public DatumRange getDatumRange() {
        return this.dataRange.getDatumRange();
    }

    protected boolean rangeIsAcceptable(DatumRange datumRange) {
        return datumRange.min().lt(datumRange.max());
    }

    public void setDataRange(Datum datum, Datum datum2) {
        double d;
        double d2;
        DatumRange datumRange = new DatumRange(datum, datum2);
        logger.fine("enter dasAxis.setDataRange( " + datumRange + " )");
        if (!this.rangeIsAcceptable(datumRange)) {
            DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).warning("invalid range ignored");
            return;
        }
        Units units = this.dataRange.getUnits();
        if (datum.getUnits() != units) {
            datum.convertTo(units);
            datum2.convertTo(units);
        }
        double d3 = this.dataRange.getMinimum();
        double d4 = this.dataRange.getMaximum();
        if (this.dataRange.isLog()) {
            d2 = DasMath.log10(datum.doubleValue(this.getUnits()));
            d = DasMath.log10(datum2.doubleValue(this.getUnits()));
        } else {
            d2 = datum.doubleValue(this.getUnits());
            d = datum2.doubleValue(this.getUnits());
        }
        this.animateChange(d3, d4, d2, d);
        this.dataRange.setRange(datumRange);
        this.update();
        this.createAndFireRangeSelectionEvent();
    }

    public void clearHistory() {
        this.dataRange.clearHistory();
    }

    private void createAndFireRangeSelectionEvent() {
        if (this.getUnits() instanceof TimeLocationUnits) {
            logger.fine("firing rangeSelectionEvent");
            TimeRangeSelectionEvent timeRangeSelectionEvent = new TimeRangeSelectionEvent(this, new DatumRange(this.getDataMinimum(), this.getDataMaximum()));
            this.fireTimeRangeSelectionListenerTimeRangeSelected(timeRangeSelectionEvent);
        }
    }

    public void setDataRangePrev() {
        logger.fine("enter dasAxis.setDataRangePrev()");
        double d = this.dataRange.getMinimum();
        double d2 = this.dataRange.getMaximum();
        this.dataRange.setRangePrev();
        double d3 = this.dataRange.getMinimum();
        double d4 = this.dataRange.getMaximum();
        this.animateChange(d, d2, d3, d4);
        this.update();
        this.createAndFireRangeSelectionEvent();
    }

    public void setDataRangeForward() {
        logger.fine("enter dasAxis.setDataRangeForward()");
        double d = this.dataRange.getMinimum();
        double d2 = this.dataRange.getMaximum();
        this.dataRange.setRangeForward();
        double d3 = this.dataRange.getMinimum();
        double d4 = this.dataRange.getMaximum();
        this.animateChange(d, d2, d3, d4);
        this.update();
        this.createAndFireRangeSelectionEvent();
    }

    public void setDataRangeZoomOut() {
        logger.fine("enter dasAxis.setDataRangeZoomOut()");
        double d = this.dataRange.getMinimum();
        double d2 = this.dataRange.getMaximum();
        double d3 = d2 - d;
        double d4 = d - d3;
        double d5 = d2 + d3;
        this.animateChange(d, d2, d4, d5);
        this.dataRange.setRange(d4, d5);
        this.update();
        this.createAndFireRangeSelectionEvent();
    }

    public DataRange getDataRange() {
        return this.dataRange;
    }

    protected void deviceRangeChanged() {
    }

    public Datum getDataMinimum() {
        return this.dataRange.getDatumRange().min();
    }

    public Datum getDataMaximum() {
        return this.dataRange.getDatumRange().max();
    }

    public DatumRange getRange() {
        return this.dataRange.getDatumRange();
    }

    public double getDataMaximum(Units units) {
        return this.getDataMaximum().doubleValue(units);
    }

    public double getDataMinimum(Units units) {
        return this.getDataMinimum().doubleValue(units);
    }

    public void setDataMaximum(Datum datum) {
        this.dataRange.setMaximum(datum);
        this.update();
    }

    public void setDataMinimum(Datum datum) {
        this.dataRange.setMinimum(datum);
        this.update();
    }

    public boolean isLog() {
        return this.dataRange.isLog();
    }

    public void setLog(boolean bl) {
        boolean bl2 = this.isLog();
        this.dataRange.setLog(bl);
        this.update();
        if (bl != bl2) {
            this.firePropertyChange("log", bl2, bl);
        }
    }

    public Units getUnits() {
        return this.dataRange.getUnits();
    }

    public void setUnits(Units units) {
        this.dataRange.setUnits(units);
    }

    public void resetRange(DatumRange datumRange) {
        logger.finest("replaceRange(" + datumRange + ")");
        this.dataRange.resetRange(datumRange);
        this.markDirty();
        this.update();
    }

    public void setOppositeAxisVisible(boolean bl) {
        if (bl == this.oppositeAxisVisible) {
            return;
        }
        boolean bl2 = this.oppositeAxisVisible;
        this.oppositeAxisVisible = bl;
        this.revalidate();
        this.repaint();
        this.firePropertyChange("oppositeAxisVisible", bl2, bl);
    }

    public boolean isOppositeAxisVisible() {
        return this.oppositeAxisVisible;
    }

    public void setLabel(String string) {
        if (string == null) {
            throw new NullPointerException("axis label cannot be null");
        }
        String string2 = this.axisLabel;
        this.axisLabel = string;
        this.update();
        this.firePropertyChange("label", string2, string);
    }

    public String getLabel() {
        return this.axisLabel;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean bl) {
        this.animated = bl;
    }

    public boolean getDrawTca() {
        return this.drawTca;
    }

    public void setDrawTca(boolean bl) {
        boolean bl2 = this.drawTca;
        if (bl && this.getOrientation() != 2) {
            throw new IllegalArgumentException("Vertical time axes cannot have annotations");
        }
        if (this.drawTca == bl) {
            return;
        }
        this.drawTca = bl;
        this.markDirty();
        this.update();
        this.firePropertyChange("showTca", bl2, bl);
    }

    public String getDataPath() {
        return this.dataset;
    }

    public void setDataPath(String string) {
        if (string == null) {
            throw new NullPointerException("null dataPath string not allowed");
        }
        String string2 = this.dataset;
        if (string.equals(this.dataset)) {
            return;
        }
        this.dataset = string;
        if (string.equals("")) {
            this.dsd = null;
        } else {
            try {
                this.dsd = DataSetDescriptor.create(string);
            }
            catch (DasException dasException) {
                DasExceptionHandler.handle(dasException);
            }
        }
        this.markDirty();
        this.update();
        this.firePropertyChange("dataPath", string2, string);
    }

    private void updateTCADataSet() {
        Datum datum;
        Datum datum2;
        Datum datum3;
        logger.fine("updateTCADataSet");
        double[] dArray = this.getTickV().tickV.toDoubleArray(this.getUnits());
        if (dArray.length == 1) {
            datum3 = Datum.create(dArray[0], this.getTickV().units);
            datum2 = Datum.create(dArray[0], this.getTickV().units);
            datum = datum2.subtract(datum3);
        } else {
            datum3 = Datum.create(dArray[0], this.getTickV().units);
            datum2 = Datum.create(dArray[dArray.length - 1], this.getTickV().units);
            datum = datum2.subtract(datum3).divide(dArray.length - 1);
        }
        datum2 = datum2.add(datum);
        Datum datum4 = datum;
        this.tcaData = null;
        this.dsd.requestDataSet(datum3, datum2.add(Datum.create(1.0, Units.seconds)), datum4, DasProgressMonitor.NULL, this.getCanvas(), this.tcaListener);
    }

    public final int getDevicePosition() {
        if (this.orientation == 2) {
            return this.getRow().getDMaximum();
        }
        if (this.orientation == 1) {
            return this.getRow().getDMinimum();
        }
        if (this.orientation == 3) {
            return this.getColumn().getDMinimum();
        }
        return this.getColumn().getDMaximum();
    }

    public int getDLength() {
        if (this.isHorizontal()) {
            return this.getColumn().getWidth();
        }
        return this.getRow().getHeight();
    }

    public DasAxis getMasterAxis() {
        return this.dataRange.getCreator();
    }

    public void attachTo(DasAxis dasAxis) {
        DataRange dataRange = this.dataRange;
        this.dataRange = dasAxis.dataRange;
        dataRange.removePropertyChangeListener("log", this.dataRangePropertyListener);
        dataRange.removePropertyChangeListener("minimum", this.dataRangePropertyListener);
        dataRange.removePropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
        if (dataRange.isLog() != this.dataRange.isLog()) {
            this.firePropertyChange("log", dataRange.isLog(), this.dataRange.isLog());
        }
        this.firePropertyChange("minimum", dataRange.getMinimum(), this.dataRange.getMinimum());
        this.firePropertyChange("maximum", dataRange.getMaximum(), this.dataRange.getMaximum());
        this.copyFavorites();
        this.copyHistory();
    }

    public void detach() {
        DataRange dataRange;
        this.dataRange.removePropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange = dataRange = new DataRange(this, Datum.create(this.dataRange.getMinimum(), this.dataRange.getUnits()), Datum.create(this.dataRange.getMaximum(), this.dataRange.getUnits()), this.dataRange.isLog());
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.copyFavorites();
        this.copyHistory();
    }

    public boolean isAttached() {
        return this != this.getMasterAxis();
    }

    public TickVDescriptor getTickV() {
        if (this.tickV == null) {
            this.updateTickV();
        }
        return this.tickV;
    }

    public void setTickV(TickVDescriptor tickVDescriptor) {
        this.checkTickV(tickVDescriptor);
        this.tickV = tickVDescriptor;
        if (tickVDescriptor == null) {
            this.autoTickV = true;
            this.updateTickV();
        } else {
            this.autoTickV = false;
        }
        this.update();
    }

    private void checkTickV(TickVDescriptor tickVDescriptor) throws IllegalArgumentException {
    }

    private void updateTickVLog() {
        double d = this.getDataMinimum().doubleValue(this.getUnits());
        double d2 = this.getDataMaximum().doubleValue(this.getUnits());
        double d3 = DasMath.roundNFractionalDigits(DasMath.log10(d), 4);
        int n = (int)Math.ceil(d3);
        double d4 = DasMath.roundNFractionalDigits(DasMath.log10(d2), 4);
        int n2 = (int)Math.floor(d4);
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, "10!U-10");
        int n3 = this.isHorizontal() ? (int)Math.floor((double)this.getColumn().getWidth() / grannyTextRenderer.getWidth()) : (int)Math.floor((double)this.getRow().getHeight() / (grannyTextRenderer.getHeight() * 2.0));
        n3 = n3 < 7 ? n3 : 7;
        this.tickV = TickVDescriptor.bestTickVLogNew(this.getDataMinimum(), this.getDataMaximum(), 3, n3);
        this.datumFormatter = this.tickV.getFormatter();
    }

    private void updateTickVLinear() {
        int n;
        if (this.isHorizontal()) {
            int n2 = (int)((double)this.getFontMetrics(this.getTickLabelFont()).stringWidth("0.0000") * 1.5);
            int n3 = this.getColumn().getWidth();
            n = n3 / n2;
        } else {
            int n4 = this.getFontMetrics(this.getTickLabelFont()).getHeight() * 2;
            int n5 = this.getRow().getHeight();
            n = n5 / n4;
        }
        n = n < 7 ? n : 7;
        this.tickV = TickVDescriptor.bestTickVLinear(this.getDataMinimum(), this.getDataMaximum(), 3, n);
        this.datumFormatter = this.tickV.getFormatter();
    }

    private void updateTickVTime() {
        if (this.isHorizontal()) {
            String string;
            int n;
            Object object;
            FontMetrics fontMetrics;
            int n2;
            this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 3, 6);
            Datum datum = this.tickV.getMajorTicks().get(0);
            String string2 = this.tickV.getFormatter().grannyFormat(datum);
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, string2);
            int n3 = (int)grannyTextRenderer.getWidth();
            if (this.drawTca && (n2 = (fontMetrics = this.getFontMetrics(this.getTickLabelFont())).stringWidth((String)(object = DasAxis.format(99999.99, "(f8.2)")))) > n3) {
                n3 = n2;
            }
            int n4 = this.getColumn().getWidth();
            int n5 = n4 / n3;
            this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 3, n5);
            this.datumFormatter = this.tickV.getFormatter();
            datum = this.tickV.getMajorTicks().get(0);
            string2 = this.tickV.getFormatter().grannyFormat(datum);
            grannyTextRenderer.setString(this, string2);
            n3 = (int)grannyTextRenderer.getWidth();
            if (this.drawTca && (n = ((FontMetrics)(object = this.getFontMetrics(this.getTickLabelFont()))).stringWidth(string = DasAxis.format(99999.99, "(f8.2)"))) > n3) {
                n3 = n;
            }
            n5 = (n5 = n4 / n3) > 1 ? n5 : 2;
            n5 = n5 < 10 ? n5 : 10;
            boolean bl = true;
            while (bl && n5 > 2) {
                this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 3, n5);
                datum = this.tickV.getMajorTicks().get(0);
                string2 = this.tickV.getFormatter().grannyFormat(datum);
                grannyTextRenderer.setString(this, string2);
                n3 = (int)grannyTextRenderer.getWidth();
                double d = this.transform(this.tickV.getMajorTicks().get(0));
                double d2 = this.transform(this.tickV.getMajorTicks().get(1));
                if (d2 - d > (double)n3) {
                    bl = false;
                    continue;
                }
                --n5;
            }
        } else {
            int n = this.getFontMetrics(this.getTickLabelFont()).getHeight();
            int n6 = this.getRow().getHeight();
            int n7 = n6 / n;
            n7 = n7 > 1 ? n7 : 2;
            n7 = n7 < 10 ? n7 : 10;
            this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 3, n7);
        }
        this.datumFormatter = this.tickV.getFormatter();
        if (this.drawTca && !this.dataset.equals("") && this.dsd != null) {
            this.updateTCADataSet();
        }
    }

    public void updateTickV() {
        if (this.autoTickV) {
            if (this.getUnits() instanceof TimeLocationUnits) {
                this.updateTickVTime();
            } else if (this.dataRange.isLog()) {
                this.updateTickVLog();
            } else {
                this.updateTickVLinear();
            }
        }
    }

    private double pixelSizeData() {
        Units units = this.getUnits();
        return (this.getDataMaximum().doubleValue(units) - this.getDataMinimum().doubleValue(units)) / (double)this.getDLength();
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.translate(-this.getX(), -this.getY());
        graphics2D.setColor(this.getForeground());
        if (this.isHorizontal()) {
            this.paintHorizontalAxis(graphics2D);
        } else {
            this.paintVerticalAxis(graphics2D);
        }
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        if (this.drawTca && this.getOrientation() == 2 && this.tcaData != null && this.blLabelRect != null && this.blLabelRect.intersects(rectangle)) {
            int n = this.getRow().getDMaximum();
            int n2 = this.getColumn().getDMinimum();
            Font font = this.getTickLabelFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n3 = font.getSize() * 2 / 3;
            int n4 = fontMetrics.stringWidth(" ");
            int n5 = font.getSize() + this.getLineSpacing();
            int n6 = this.getMaxLabelWidth(fontMetrics);
            int n7 = n + n3 + n4 + font.getSize();
            int n8 = n2 - fontMetrics.stringWidth("0000") - n4;
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            for (int i = 0; i < this.tcaData.length; ++i) {
                grannyTextRenderer.setString(this, (String)this.tcaData[i].getProperty("label"));
                int n9 = (int)Math.floor(grannyTextRenderer.getWidth() + 0.5);
                int n10 = n8 - n9;
                grannyTextRenderer.draw(graphics2D, n10, n7 += n5);
            }
        }
        graphics2D.dispose();
        this.getDasMouseInputAdapter().paint(graphics);
    }

    protected void paintHorizontalAxis(Graphics2D graphics2D) {
        int n;
        int n2;
        double d;
        int n3;
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        boolean bl = (this.orientation == 2 || this.oppositeAxisVisible) && this.blLineRect != null && this.blLineRect.intersects(rectangle);
        boolean bl2 = (this.orientation == 2 || this.oppositeAxisVisible) && this.blTickRect != null && this.blTickRect.intersects(rectangle);
        boolean bl3 = this.orientation == 2 && this.tickLabelsVisible && this.blLabelRect != null && this.blLabelRect.intersects(rectangle);
        boolean bl4 = this.orientation == 2 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(rectangle);
        boolean bl5 = (this.orientation == 1 || this.oppositeAxisVisible) && this.trLineRect != null && this.trLineRect.intersects(rectangle);
        boolean bl6 = (this.orientation == 1 || this.oppositeAxisVisible) && this.trTickRect != null && this.trTickRect.intersects(rectangle);
        boolean bl7 = this.orientation == 1 && this.tickLabelsVisible && this.trLabelRect != null && this.trLabelRect.intersects(rectangle);
        boolean bl8 = this.orientation == 1 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(rectangle);
        int n4 = this.getRow().getDMinimum() - 1;
        int n5 = this.getRow().getDMaximum();
        int n6 = this.getColumn().getDMaximum();
        int n7 = this.getColumn().getDMinimum();
        Font font = this.getTickLabelFont();
        double d2 = this.dataRange.getMaximum();
        double d3 = this.dataRange.getMinimum();
        TickVDescriptor tickVDescriptor = this.getTickV();
        if (bl) {
            graphics2D.drawLine(n7, n5, n6, n5);
        }
        if (bl5) {
            graphics2D.drawLine(n7, n4, n6, n4);
        }
        int n8 = font.getSize() * 2 / 3;
        int n9 = n8 / 2;
        for (n3 = 0; n3 < tickVDescriptor.tickV.getLength(); ++n3) {
            d = tickVDescriptor.tickV.doubleValue(n3, this.getUnits());
            n2 = (int)Math.floor(this.transform(d, tickVDescriptor.units));
            if (n7 > n2 || n2 > n6) continue;
            n = n8;
            if (bl2) {
                graphics2D.drawLine(n2, n5, n2, n5 + n);
            }
            if (bl3) {
                this.drawLabel(graphics2D, d, n3, n2, n5 + n);
            }
            if (bl6) {
                graphics2D.drawLine(n2, n4, n2, n4 - n);
            }
            if (!bl7) continue;
            this.drawLabel(graphics2D, d, n3, n2, n4 - n + 1);
        }
        for (n3 = 0; n3 < tickVDescriptor.minorTickV.getLength(); ++n3) {
            d = tickVDescriptor.minorTickV.doubleValue(n3, this.getUnits());
            n2 = (int)Math.floor(this.transform(d, tickVDescriptor.units));
            if (n7 > n2 || n2 > n6) continue;
            n = n9;
            if (bl2) {
                graphics2D.drawLine(n2, n5, n2, n5 + n);
            }
            if (!bl6) continue;
            graphics2D.drawLine(n2, n4, n2, n4 - n);
        }
        if (!this.axisLabel.equals("")) {
            int n10;
            int n11;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            int n12 = this.getTitlePositionOffset();
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, this.axisLabel);
            n2 = (int)grannyTextRenderer.getWidth();
            graphics2D2.setFont(this.getLabelFont());
            if (bl4) {
                n11 = n7 + (n6 - n7 - n2) / 2;
                n10 = n5 + n12;
                grannyTextRenderer.draw(graphics2D2, n11, n10);
            }
            if (bl8) {
                n11 = n7 + (n6 - n7 - n2) / 2;
                n10 = n4 - n12;
                grannyTextRenderer.draw(graphics2D2, n11, n10);
            }
            graphics2D2.dispose();
        }
    }

    protected void paintVerticalAxis(Graphics2D graphics2D) {
        int n;
        int n2;
        double d;
        int n3;
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        boolean bl = (this.orientation == 3 || this.oppositeAxisVisible) && this.blLineRect != null && this.blLineRect.intersects(rectangle);
        boolean bl2 = (this.orientation == 3 || this.oppositeAxisVisible) && this.blTickRect != null && this.blTickRect.intersects(rectangle);
        boolean bl3 = this.orientation == 3 && this.tickLabelsVisible && this.blLabelRect != null && this.blLabelRect.intersects(rectangle);
        boolean bl4 = this.orientation == 3 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(rectangle);
        boolean bl5 = (this.orientation == 4 || this.oppositeAxisVisible) && this.trLineRect != null && this.trLineRect.intersects(rectangle);
        boolean bl6 = (this.orientation == 4 || this.oppositeAxisVisible) && this.trTickRect != null && this.trTickRect.intersects(rectangle);
        boolean bl7 = this.orientation == 4 && this.tickLabelsVisible && this.trLabelRect != null && this.trLabelRect.intersects(rectangle);
        boolean bl8 = this.orientation == 4 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(rectangle);
        int n4 = this.getColumn().getDMinimum() - 1;
        int n5 = this.getColumn().getDMaximum();
        int n6 = this.getRow().getDMaximum();
        int n7 = this.getRow().getDMinimum();
        Font font = this.getTickLabelFont();
        double d2 = this.dataRange.getMaximum();
        double d3 = this.dataRange.getMinimum();
        TickVDescriptor tickVDescriptor = this.getTickV();
        if (bl) {
            graphics2D.drawLine(n4, n7, n4, n6);
        }
        if (bl5) {
            graphics2D.drawLine(n5, n7, n5, n6);
        }
        int n8 = font.getSize() * 2 / 3;
        int n9 = n8 / 2;
        for (n3 = 0; n3 < tickVDescriptor.tickV.getLength(); ++n3) {
            d = tickVDescriptor.tickV.doubleValue(n3, this.getUnits());
            n2 = (int)Math.floor(this.transform(d, tickVDescriptor.units));
            if (n7 > n2 || n2 > n6) continue;
            n = n8;
            if (bl2) {
                graphics2D.drawLine(n4, n2, n4 - n, n2);
            }
            if (bl3) {
                this.drawLabel(graphics2D, d, n3, n4 - n, n2);
            }
            if (bl6) {
                graphics2D.drawLine(n5, n2, n5 + n, n2);
            }
            if (!bl7) continue;
            this.drawLabel(graphics2D, d, n3, n5 + n, n2);
        }
        for (n3 = 0; n3 < tickVDescriptor.minorTickV.getLength(); ++n3) {
            n = n9;
            d = tickVDescriptor.minorTickV.doubleValue(n3, this.getUnits());
            n2 = (int)Math.floor(this.transform(d, tickVDescriptor.units));
            if (n7 > n2 || n2 > n6) continue;
            n = n9;
            if (bl2) {
                graphics2D.drawLine(n4, n2, n4 - n, n2);
            }
            if (!bl6) continue;
            graphics2D.drawLine(n5, n2, n5 + n, n2);
        }
        if (!this.axisLabel.equals("")) {
            int n10;
            int n11;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            int n12 = this.getTitlePositionOffset();
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, this.axisLabel);
            n2 = (int)grannyTextRenderer.getWidth();
            graphics2D2.setFont(this.getLabelFont());
            if (bl4) {
                graphics2D2.rotate(-1.5707963267948966);
                n11 = -n6 + (n6 - n7 - n2) / 2;
                n10 = n4 - n12;
                grannyTextRenderer.draw(graphics2D2, n11, n10);
            }
            if (bl8) {
                graphics2D2.rotate(1.5707963267948966);
                n11 = n7 + (n6 - n7 - n2) / 2;
                n10 = -n5 - n12;
                grannyTextRenderer.draw(graphics2D2, n11, n10);
            }
            graphics2D2.dispose();
        }
    }

    protected int getTitlePositionOffset() {
        Font font = this.getTickLabelFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Font font2 = this.getLabelFont();
        int n = font.getSize() * 2 / 3;
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, this.axisLabel);
        int n2 = this.orientation == 2 ? font.getSize() + n + fontMetrics.stringWidth(" ") + font2.getSize() + font2.getSize() / 2 : (this.orientation == 1 ? n + fontMetrics.stringWidth(" ") + font2.getSize() + font2.getSize() / 2 + (int)grannyTextRenderer.getDescent() : (this.orientation == 3 ? n + this.getMaxLabelWidth(fontMetrics) + fontMetrics.stringWidth(" ") + font2.getSize() / 2 + (int)grannyTextRenderer.getDescent() : n + this.getMaxLabelWidth(fontMetrics) + fontMetrics.stringWidth(" ") + font2.getSize() / 2 + (int)grannyTextRenderer.getDescent()));
        if (this.getOrientation() == 2 && this.drawTca && this.tcaData != null) {
            n2 += this.tcaData.length * (font.getSize() + this.getLineSpacing());
            n2 += font.getSize() + this.getLineSpacing();
        }
        return n2;
    }

    public int getLineSpacing() {
        return this.getTickLabelFont().getSize() / 4;
    }

    protected void drawLabel(Graphics graphics, double d, int n, int n2, int n3) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        if (!this.tickLabelsVisible) {
            return;
        }
        String string = this.tickFormatter(d);
        graphics2D.setFont(this.getTickLabelFont());
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, string);
        int n4 = (int)grannyTextRenderer.getWidth();
        int n5 = (int)grannyTextRenderer.getHeight();
        int n6 = (int)grannyTextRenderer.getAscent();
        int n7 = this.getFontMetrics(this.getTickLabelFont()).stringWidth(" ");
        if (this.orientation == 2) {
            n2 -= n4 / 2;
            n3 += this.getTickLabelFont().getSize() + n7;
        } else if (this.orientation == 1) {
            n2 -= n4 / 2;
            n3 = (int)((double)n3 - ((double)n7 + grannyTextRenderer.getDescent()));
        } else if (this.orientation == 3) {
            n2 -= n4 + n7;
            n3 += n6 - n5 / 2;
        } else {
            n2 += n7;
            n3 += n6 - n5 / 2;
        }
        Color color = graphics2D.getColor();
        grannyTextRenderer.draw(graphics2D, n2, n3);
        if (this.orientation == 2 && this.drawTca && this.tcaData != null) {
            this.drawTCAItems(graphics2D, d, n2, n3, n4);
        }
    }

    private void drawTCAItems(Graphics graphics, double d, int n, int n2, int n3) {
        if (this.tcaData == null || this.tcaData.length == 0) {
            return;
        }
        int n4 = this.getTickLabelFont().getSize();
        int n5 = this.getFontMetrics(this.getTickLabelFont()).stringWidth(" ");
        int n6 = n2;
        int n7 = n;
        int n8 = n7 + n3;
        int n9 = DataSetUtil.closestColumn((DataSet)this.tcaData[0], d, this.getUnits());
        if (n9 < 0 || n9 > this.tcaData[0].getXLength()) {
            return;
        }
        double d2 = this.getDatumRange().width().divide(this.getDLength()).doubleValue(this.getUnits().getOffsetUnits());
        double d3 = this.tcaData[0].getXTagDouble(n9, this.getUnits());
        if (Math.abs(d3 - d) > d2) {
            return;
        }
        Font font = this.getTickLabelFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n10 = font.getSize() + this.getLineSpacing();
        for (int i = 0; i < this.tcaData.length; ++i) {
            String string = DasAxis.format(this.tcaData[i].getDouble(n9, this.tcaData[i].getYUnits()), "(f8.2)");
            n3 = fontMetrics.stringWidth(string);
            n7 = n8 - n3;
            graphics.drawString(string, n7, n6 += n10);
        }
    }

    public Font getTickLabelFont() {
        return this.getFont();
    }

    public void setTickLabelFont(Font font) {
    }

    public Font getLabelFont() {
        return this.getFont();
    }

    public void setLabelFont(Font font) {
    }

    public Memento getMemento() {
        Memento memento = new Memento();
        memento.range = this.getDatumRange();
        if (this.isHorizontal()) {
            if (this.getColumn() != DasColumn.NULL) {
                memento.dmin = this.getColumn().getDMinimum();
                memento.dmax = this.getColumn().getDMaximum();
            } else {
                memento.dmin = 0;
                memento.dmax = 0;
            }
        } else if (this.getRow() != DasRow.NULL) {
            memento.dmin = this.getRow().getDMinimum();
            memento.dmax = this.getRow().getDMaximum();
        } else {
            memento.dmin = 0;
            memento.dmax = 0;
        }
        memento.log = this.isLog();
        memento.flipped = this.flipped;
        memento.axis = this;
        return memento;
    }

    public AffineTransform getAffineTransform(Memento memento, AffineTransform affineTransform) {
        double d;
        if (affineTransform == null) {
            return null;
        }
        if (memento.log != this.isLog()) {
            return null;
        }
        if (memento.flipped != this.flipped) {
            return null;
        }
        double d2 = this.transform(memento.range.min());
        double d3 = this.transform(memento.range.max());
        if (!(this.isHorizontal() ^ this.flipped)) {
            d = d2;
            d2 = d3;
            d3 = d;
        }
        if (!this.isHorizontal()) {
            d = this.getRow().getDMinimum();
            double d4 = this.getRow().getDMaximum();
            double d5 = (d2 - d3) / (d - d4);
            double d6 = -1.0 * d * d5 + d2;
            affineTransform.translate(0.0, d6);
            affineTransform.scale(1.0, d5);
            d5 = (d - d4) / (double)(memento.dmin - memento.dmax);
            d6 = (double)(-1 * memento.dmin) * d5 + d;
            affineTransform.translate(0.0, d6);
            affineTransform.scale(1.0, d5);
        } else {
            d = this.getColumn().getDMinimum();
            double d7 = this.getColumn().getDMaximum();
            double d8 = (d2 - d3) / (d - d7);
            double d9 = -1.0 * d * d8 + d2;
            affineTransform.translate(d9, 0.0);
            affineTransform.scale(d8, 1.0);
            d8 = (d - d7) / (double)(memento.dmin - memento.dmax);
            d9 = (double)(-1 * memento.dmin) * d8 + d;
            affineTransform.translate(d9, 0.0);
            affineTransform.scale(d8, 1.0);
        }
        if (affineTransform.getDeterminant() == 0.0) {
            return null;
        }
        return affineTransform;
    }

    public Object clone() {
        try {
            DasAxis dasAxis = (DasAxis)super.clone();
            dasAxis.dataRange = (DataRange)dasAxis.dataRange.clone();
            return dasAxis;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Assertion failure");
        }
    }

    private void setTickDirection(int n) {
        if (n == 995 || n == 4) {
            this.tickDirection = -1;
        } else if (n == 996 || n == 3) {
            this.tickDirection = 1;
        } else {
            throw new IllegalArgumentException("Invalid tick direction");
        }
    }

    protected int getMaxLabelWidth(FontMetrics fontMetrics) {
        TickVDescriptor tickVDescriptor = this.getTickV();
        DatumVector datumVector = tickVDescriptor.tickV;
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < datumVector.getLength(); ++i) {
            String string = this.tickFormatter(datumVector.doubleValue(i, this.getUnits()));
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, string);
            int n2 = (int)Math.round(grannyTextRenderer.getWidth());
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public void resize() {
        this.setBounds(this.getAxisBounds());
        this.invalidate();
        this.validate();
    }

    protected Rectangle getAxisBounds() {
        Rectangle rectangle = this.isHorizontal() ? this.getHorizontalAxisBounds() : this.getVerticalAxisBounds();
        if (this.getOrientation() == 2 && this.areTickLabelsVisible()) {
            if (this.drawTca && this.tcaData != null && this.tcaData.length != 0) {
                int n;
                int n2;
                int n3 = this.getColumn().getDMinimum();
                int n4 = this.getColumn().getDMaximum();
                Font font = this.getTickLabelFont();
                int n5 = this.getFontMetrics(font).stringWidth(" ");
                int n6 = (font.getSize() + this.getLineSpacing()) * this.tcaData.length;
                int n7 = this.getMaxLabelWidth(this.getFontMetrics(font));
                rectangle.height += n6;
                this.blLabelRect.height += n6;
                if (this.blTitleRect != null) {
                    this.blTitleRect.y += n6;
                }
                GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
                grannyTextRenderer.setString(this, "SCET");
                int n8 = (int)Math.floor(grannyTextRenderer.getWidth() + 0.5);
                for (n2 = 0; n2 < this.tcaData.length; ++n2) {
                    grannyTextRenderer.setString(this, (String)this.tcaData[n2].getProperty("label"));
                    n = (int)Math.floor(grannyTextRenderer.getWidth() + 0.5);
                    n8 = Math.max(n8, n);
                }
                if ((n8 += 50) > 0) {
                    n2 = n3 - n8 - n5;
                    n = Math.min(n2 - n7 / 2, rectangle.x);
                    int n9 = rectangle.x + rectangle.width;
                    rectangle.x = n;
                    rectangle.width = n9 - n;
                    this.blLabelRect.x = n;
                    this.blLabelRect.width = n9 - n;
                }
            }
            rectangle.height += this.getTickLabelFont().getSize() + this.getLineSpacing();
            if (this.getTickDirection() == -1) {
                rectangle.y -= this.getTickLabelFont().getSize() + this.getLineSpacing();
            }
        }
        return rectangle;
    }

    private Rectangle getHorizontalAxisBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = this.getRow().getDMinimum() - 1;
        int n11 = this.getRow().getDMaximum();
        DasColumn dasColumn = this.getColumn();
        int n12 = dasColumn.getDMaximum();
        int n13 = dasColumn.getDMinimum();
        boolean bl = this.orientation == 2 || this.oppositeAxisVisible;
        boolean bl2 = this.orientation == 2 && this.tickLabelsVisible;
        boolean bl3 = bl2 && !this.axisLabel.equals("");
        boolean bl4 = this.orientation == 1 || this.oppositeAxisVisible;
        boolean bl5 = this.orientation == 1 && this.tickLabelsVisible;
        boolean bl6 = bl5 && !this.axisLabel.equals("");
        Font font = this.getTickLabelFont();
        int n14 = font.getSize() * 2 / 3;
        if (bl) {
            if (this.blLineRect == null) {
                this.blLineRect = new Rectangle();
            }
            this.blLineRect.setBounds(n13, n11, n12 - n13 + 1, 1);
        }
        if (bl4) {
            if (this.trLineRect == null) {
                this.trLineRect = new Rectangle();
            }
            this.trLineRect.setBounds(n13, n10, n12 - n13 + 1, 1);
        }
        if (bl) {
            n9 = n13;
            n8 = n11 + 1;
            n7 = n12 - n13;
            n6 = n14;
            this.blTickRect = DasAxis.setRectangleBounds(this.blTickRect, n9, n8, n7 + 1, n6);
        }
        if (bl4) {
            n9 = n13;
            n8 = n10 - n14;
            n7 = n12 - n13;
            n6 = n14;
            this.trTickRect = DasAxis.setRectangleBounds(this.trTickRect, n9, n8, n7 + 1, n6);
        }
        n9 = this.getMaxLabelWidth(this.getFontMetrics(font));
        n8 = this.getFontMetrics(font).stringWidth(" ");
        if (bl2) {
            n7 = n13 - n9 / 2;
            n6 = this.blTickRect.y + this.blTickRect.height;
            n5 = n12 - n13 + n9;
            n4 = font.getSize() * 3 / 2 + n8;
            this.blLabelRect = DasAxis.setRectangleBounds(this.blLabelRect, n7, n6, n5, n4);
        }
        if (bl5) {
            n7 = n13 - n9 / 2;
            n6 = n10 - (font.getSize() * 3 / 2 + n8 + 1);
            n5 = n12 - n13 + n9;
            n4 = font.getSize() * 3 / 2 + n8;
            this.trLabelRect = DasAxis.setRectangleBounds(this.trLabelRect, n7, n6, n5, n4);
        }
        Font font2 = this.getLabelFont();
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, this.getLabel());
        n5 = (int)grannyTextRenderer.getHeight() + font2.getSize() / 2;
        if (bl3) {
            n4 = n13;
            n3 = this.blLabelRect.y + this.blLabelRect.height;
            n2 = n12 - n13;
            n = n5;
            this.blTitleRect = DasAxis.setRectangleBounds(this.blTitleRect, n4, n3, n2, n);
        }
        if (bl6) {
            n4 = n13;
            n3 = this.trLabelRect.y - n5;
            n2 = n12 - n13;
            n = n5;
            this.trTitleRect = DasAxis.setRectangleBounds(this.trTitleRect, n4, n3, n2, n);
        }
        Rectangle rectangle = new Rectangle(this.orientation == 2 ? this.blLineRect : this.trLineRect);
        if (bl) {
            rectangle.add(this.blLineRect);
            rectangle.add(this.blTickRect);
        }
        if (bl2) {
            rectangle.add(this.blLabelRect);
        }
        if (bl3) {
            rectangle.add(this.blTitleRect);
        }
        if (bl4) {
            rectangle.add(this.trLineRect);
            rectangle.add(this.trTickRect);
        }
        if (bl5) {
            rectangle.add(this.trLabelRect);
        }
        if (bl6) {
            rectangle.add(this.trTitleRect);
        }
        if (this.scanPrevious != null && this.scanNext != null) {
            Dimension dimension = this.scanPrevious.getPreferredSize();
            Dimension dimension2 = this.scanPrevious.getPreferredSize();
            n2 = Math.min(n13 - dimension.width, rectangle.x);
            n = Math.max(n12 + dimension2.width, rectangle.x + rectangle.width);
            rectangle.x = n2;
            rectangle.width = n - n2;
        }
        return rectangle;
    }

    private Rectangle getVerticalAxisBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl = this.orientation == 3 || this.oppositeAxisVisible;
        boolean bl2 = this.orientation == 3 && this.tickLabelsVisible;
        boolean bl3 = this.orientation == 3 && !this.axisLabel.equals("");
        boolean bl4 = this.orientation == 4 || this.oppositeAxisVisible;
        boolean bl5 = this.orientation == 4 && this.tickLabelsVisible;
        boolean bl6 = this.orientation == 4 && !this.axisLabel.equals("");
        int n10 = this.getColumn().getDMinimum() - 1;
        int n11 = this.getColumn().getDMaximum();
        int n12 = this.getRow().getDMaximum();
        int n13 = this.getRow().getDMinimum();
        Font font = this.getTickLabelFont();
        int n14 = font.getSize() * 2 / 3;
        if (bl) {
            if (this.blLineRect == null) {
                this.blLineRect = new Rectangle();
            }
            this.blLineRect.setBounds(n10, n13, 1, n12 - n13 + 1);
        }
        if (bl4) {
            if (this.trLineRect == null) {
                this.trLineRect = new Rectangle();
            }
            this.trLineRect.setBounds(n11, n13, 1, n12 - n13 + 1);
        }
        if (bl) {
            n9 = n10 - n14;
            n8 = n13;
            n7 = n14;
            n6 = n12 - n13;
            this.blTickRect = DasAxis.setRectangleBounds(this.blTickRect, n9, n8, n7, n6 + 1);
        }
        if (bl4) {
            n9 = n11 + 1;
            n8 = n13;
            n7 = n14;
            n6 = n12 - n13;
            this.trTickRect = DasAxis.setRectangleBounds(this.trTickRect, n9, n8, n7, n6 + 1);
        }
        n9 = this.getMaxLabelWidth(this.getFontMetrics(font));
        n8 = this.getFontMetrics(font).stringWidth(" ");
        if (bl2) {
            n7 = this.blTickRect.x - (n9 + n8);
            n6 = n13 - font.getSize();
            n5 = n9 + n8;
            n4 = n12 - n13 + font.getSize() * 2;
            this.blLabelRect = DasAxis.setRectangleBounds(this.blLabelRect, n7, n6, n5, n4);
        }
        if (bl5) {
            n7 = this.trTickRect.x + this.trTickRect.width;
            n6 = n13 - font.getSize();
            n5 = n9 + n8;
            n4 = n12 - n13 + font.getSize() * 2;
            this.trLabelRect = DasAxis.setRectangleBounds(this.trLabelRect, n7, n6, n5, n4);
        }
        Font font2 = this.getLabelFont();
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, this.getLabel());
        n5 = (int)grannyTextRenderer.getHeight() + font2.getSize() / 2;
        if (bl3) {
            n4 = this.blLabelRect.x - n5;
            n3 = n13;
            n2 = n5;
            n = n12 - n13;
            this.blTitleRect = DasAxis.setRectangleBounds(this.blTitleRect, n4, n3, n2, n);
        }
        if (bl6) {
            n4 = this.trLabelRect.x + this.trLabelRect.width;
            n3 = n13;
            n2 = n5;
            n = n12 - n13;
            this.trTitleRect = DasAxis.setRectangleBounds(this.trTitleRect, n4, n3, n2, n);
        }
        Rectangle rectangle = new Rectangle(this.orientation == 3 ? this.blLineRect : this.trLineRect);
        if (bl) {
            rectangle.add(this.blLineRect);
            rectangle.add(this.blTickRect);
        }
        if (bl2) {
            rectangle.add(this.blLabelRect);
        }
        if (bl3) {
            rectangle.add(this.blTitleRect);
        }
        if (bl4) {
            rectangle.add(this.trLineRect);
            rectangle.add(this.trTickRect);
        }
        if (bl5) {
            rectangle.add(this.trLabelRect);
        }
        if (bl6) {
            rectangle.add(this.trTitleRect);
        }
        return rectangle;
    }

    private static Rectangle setRectangleBounds(Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (rectangle == null) {
            return new Rectangle(n, n2, n3, n4);
        }
        rectangle.setBounds(n, n2, n3, n4);
        return rectangle;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isHorizontal() {
        return this.orientation == 2 || this.orientation == 1;
    }

    public int getTickDirection() {
        return this.tickDirection;
    }

    public DatumFormatter getDatumFormatter() {
        return this.datumFormatter;
    }

    public double transform(Datum datum) {
        return this.transform(datum.doubleValue(this.getUnits()), this.getUnits());
    }

    double transform(double d, Units units) {
        if (this.isHorizontal()) {
            DasColumn dasColumn = this.getColumn();
            return this.transform(d, units, dasColumn.getDMinimum(), dasColumn.getDMaximum());
        }
        DasRow dasRow = this.getRow();
        return this.transform(d, units, dasRow.getDMaximum(), dasRow.getDMinimum());
    }

    double transform(double d, Units units, int n, int n2) {
        if (units != this.dataRange.getUnits()) {
            d = units.convertDoubleTo(this.dataRange.getUnits(), d);
        }
        double d2 = n2 - n;
        if (this.dataRange.isLog()) {
            d = d <= 0.0 ? -1.0E308 : DasMath.log10(d);
        }
        double d3 = this.dataRange.getMinimum();
        double d4 = this.dataRange.getMaximum();
        double d5 = d4 - d3;
        double d6 = this.flipped ? (double)n2 - d2 * (d - d3) / d5 : d2 * (d - d3) / d5 + (double)n;
        if (d6 > 10000.0) {
            d6 = 10000.0;
        }
        if (d6 < -10000.0) {
            d6 = -10000.0;
        }
        return d6;
    }

    public Datum invTransform(double d) {
        DasDevicePosition dasDevicePosition = this.isHorizontal() ? this.getColumn() : this.getRow();
        double d2 = (d - (double)dasDevicePosition.getDMinimum()) / (double)this.getDLength();
        if (!this.isHorizontal()) {
            d2 = 1.0 - d2;
        }
        if (this.flipped) {
            d2 = 1.0 - d2;
        }
        double d3 = this.dataRange.getMinimum();
        double d4 = this.dataRange.getMaximum();
        double d5 = d4 - d3;
        double d6 = d5 * d2 + d3;
        double d7 = d5 / (double)this.getDLength();
        if (this.dataRange.isLog()) {
            d6 = DasMath.exp10(d6);
            d7 = d6 * (DasMath.exp10(d7) - 1.0);
        }
        Datum datum = Datum.create(d6, this.dataRange.getUnits(), d7);
        return datum;
    }

    protected String tickFormatter(double d) {
        return this.datumFormatter.grannyFormat(Datum.create(d, this.getUnits()), this.getUnits());
    }

    public void DataRangeSelected(DataRangeSelectionEvent dataRangeSelectionEvent) {
        this.setDataRange(dataRangeSelectionEvent.getMinimum(), dataRangeSelectionEvent.getMaximum());
    }

    public Datum findTick(Datum datum, double d, boolean bl) {
        return this.getTickV().findTick(datum, d, bl);
    }

    private void animateChange(double d, double d2, double d3, double d4) {
        if (this.animated && EventQueue.isDispatchThread()) {
            DataRange dataRange;
            DasApplication.getDefaultApplication().getLogger(DasApplication.GRAPHICS_LOG).fine("animate axis");
            boolean bl = this.getDrawTca();
            this.setDrawTca(false);
            long l = System.currentTimeMillis();
            long l2 = 0L;
            DataRange dataRange2 = this.dataRange;
            this.dataRange = dataRange = DataRange.getAnimationDataRange(this.dataRange.getDatumRange(), this.dataRange.isLog());
            double d5 = 300.0;
            double d6 = (double)(System.currentTimeMillis() - l) / d5;
            while (d6 < 1.0) {
                d6 = (double)(System.currentTimeMillis() - l) / d5;
                double[] dArray = new double[]{0.0, 0.3, 0.85, 1.0};
                double[] dArray2 = new double[]{0.0, 0.05, 0.9, 1.0};
                double d7 = DasMath.findex(dArray, d6, 0);
                double d8 = DasMath.interpolate(dArray2, d7);
                double d9 = 1.0 - d8;
                dataRange.setRange(d * d9 + d3 * d8, d2 * d9 + d4 * d8);
                this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
                if (this.dasPlot != null) {
                    this.dasPlot.paintImmediately(0, 0, this.dasPlot.getWidth(), this.dasPlot.getHeight());
                }
                ++l2;
            }
            logger.fine("animation frames/sec= " + 1000.0 * (double)l2 / d5);
            this.setDrawTca(bl);
            this.dataRange = dataRange2;
        }
    }

    protected void updateImmediately() {
        super.updateImmediately();
        logger.finer("" + this.getDatumRange());
        this.updateTickV();
    }

    public boolean areTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean bl) {
        if (this.tickLabelsVisible == bl) {
            return;
        }
        boolean bl2 = this.ticksVisible;
        this.tickLabelsVisible = bl;
        this.update();
        this.firePropertyChange("tickLabelsVisible", bl2, bl);
    }

    protected void installComponent() {
        super.installComponent();
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
    }

    static DasAxis processAxisElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        Object object;
        Object object2;
        Datum datum;
        Datum datum2;
        Object object3;
        String string;
        String string2 = element.getAttribute("name");
        boolean bl = element.getAttribute("log").equals("true");
        if ("TIME".equals(element.getAttribute("units"))) {
            string = element.getAttribute("dataMinimum");
            object3 = element.getAttribute("dataMaximum");
            datum2 = string == null || string.equals("") ? TimeUtil.create("1979-02-26") : TimeUtil.create(string);
            datum = object3 == null || ((String)object3).equals("") ? TimeUtil.create("1979-02-27") : TimeUtil.create((String)object3);
        } else {
            string = element.getAttribute("dataMinimum");
            object3 = element.getAttribute("dataMaximum");
            datum2 = string == null || string.equals("") ? Datum.create(1.0) : Datum.create(Double.parseDouble(string));
            datum = object3 == null || ((String)object3).equals("") ? Datum.create(10.0) : Datum.create(Double.parseDouble((String)object3));
        }
        int n = DasAxis.parseOrientationString(element.getAttribute("orientation"));
        object3 = new DasAxis(datum2, datum, n, bl);
        String string3 = element.getAttribute("row");
        if (!string3.equals("")) {
            object2 = (DasRow)formBase.checkValue(string3, DasRow.class, "<row>");
            ((DasCanvasComponent)object3).setRow((DasRow)object2);
        }
        if (!((String)(object2 = element.getAttribute("column"))).equals("")) {
            object = (DasColumn)formBase.checkValue((String)object2, DasColumn.class, "<column>");
            ((DasCanvasComponent)object3).setColumn((DasColumn)object);
        }
        ((DasAxis)object3).setLabel(element.getAttribute("label"));
        ((DasAxis)object3).setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        ((DasAxis)object3).setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        ((DasCanvasComponent)object3).setDasName(string2);
        object = formBase.getDasApplication();
        NameContext nameContext = ((DasApplication)object).getNameContext();
        nameContext.put(string2, object3);
        return object3;
    }

    protected static String orientationToString(int n) {
        switch (n) {
            case 1: {
                return "top";
            }
            case 2: {
                return "bottom";
            }
            case 3: {
                return "left";
            }
            case 4: {
                return "right";
            }
        }
        throw new IllegalStateException("invalid orienation: " + n);
    }

    protected static int parseOrientationString(String string) {
        if (string.equals("horizontal")) {
            return 2;
        }
        if (string.equals("vertical")) {
            return 3;
        }
        if (string.equals("left")) {
            return 3;
        }
        if (string.equals("right")) {
            return 4;
        }
        if (string.equals("top")) {
            return 1;
        }
        if (string.equals("bottom")) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid orientation: " + string);
    }

    public Element getDOMElement(Document document) {
        Element element = this.isAttached() ? document.createElement("attachedaxis") : document.createElement("axis");
        if (this.isAttached()) {
            element.setAttribute("ref", this.getMasterAxis().getDasName());
        } else {
            String string = this.getDataMinimum().toString();
            element.setAttribute("dataMinimum", string);
            String string2 = this.getDataMaximum().toString();
            element.setAttribute("dataMaximum", string2);
        }
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("label", this.getLabel());
        element.setAttribute("log", Boolean.toString(this.isLog()));
        element.setAttribute("tickLabelsVisible", Boolean.toString(this.areTickLabelsVisible()));
        element.setAttribute("oppositeAxisVisible", Boolean.toString(this.isOppositeAxisVisible()));
        element.setAttribute("animated", Boolean.toString(this.isAnimated()));
        element.setAttribute("orientation", DasAxis.orientationToString(this.getOrientation()));
        return element;
    }

    public DasAxis createAttachedAxis() {
        return new DasAxis(this.dataRange, this.getOrientation());
    }

    public DasAxis createAttachedAxis(int n) {
        return new DasAxis(this.dataRange, n);
    }

    static DasAxis processAttachedaxisElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException {
        Object object;
        Object object2;
        String string = element.getAttribute("name");
        DasAxis dasAxis = (DasAxis)formBase.checkValue(element.getAttribute("ref"), DasAxis.class, "<attachedaxis>");
        int n = element.getAttribute("orientation").equals("horizontal") ? 2 : 3;
        DasAxis dasAxis2 = dasAxis.createAttachedAxis(n);
        String string2 = element.getAttribute("row");
        if (!string2.equals("")) {
            object2 = (DasRow)formBase.checkValue(string2, DasRow.class, "<row>");
            dasAxis2.setRow((DasRow)object2);
        }
        if (!((String)(object2 = element.getAttribute("column"))).equals("")) {
            object = (DasColumn)formBase.checkValue((String)object2, DasColumn.class, "<column>");
            dasAxis2.setColumn((DasColumn)object);
        }
        dasAxis2.setDataPath(element.getAttribute("dataPath"));
        dasAxis2.setDrawTca(element.getAttribute("showTca").equals("true"));
        dasAxis2.setLabel(element.getAttribute("label"));
        dasAxis2.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        dasAxis2.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        dasAxis2.setDasName(string);
        object = formBase.getDasApplication();
        NameContext nameContext = ((DasApplication)object).getNameContext();
        nameContext.put(string, dasAxis2);
        return dasAxis2;
    }

    public void setPlot(DasPlot dasPlot) {
        this.dasPlot = dasPlot;
    }

    public static DasAxis createNamedAxis(String string) {
        DasAxis dasAxis = new DasAxis(Datum.create(1.0, Units.dimensionless), Datum.create(10.0, Units.dimensionless), 2);
        if (string == null) {
            string = "axis_" + Integer.toHexString(System.identityHashCode(dasAxis));
        }
        try {
            dasAxis.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        return dasAxis;
    }

    public void scanPrevious() {
        Datum datum = this.getDataMaximum().subtract(this.getDataMinimum()).multiply(1.0);
        Datum datum2 = this.getDataMinimum().subtract(datum);
        Datum datum3 = this.getDataMaximum().subtract(datum);
        this.setDataRange(datum2, datum3);
    }

    public void scanNext() {
        Datum datum = this.getDataMaximum().subtract(this.getDataMinimum()).multiply(1.0);
        Datum datum2 = this.getDataMinimum().add(datum);
        Datum datum3 = this.getDataMaximum().add(datum);
        this.setDataRange(datum2, datum3);
    }

    public Shape getActiveRegion() {
        Rectangle rectangle = this.primaryInputPanel.getBounds();
        rectangle.translate(this.getX(), this.getY());
        if (this.oppositeAxisVisible) {
            Rectangle rectangle2 = this.secondaryInputPanel.getBounds();
            rectangle2.translate(this.getX(), this.getY());
            GeneralPath generalPath = new GeneralPath(rectangle);
            generalPath.setWindingRule(0);
            generalPath.append(rectangle2, false);
            return generalPath;
        }
        return rectangle;
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseListener(mouseListener);
        this.secondaryInputPanel.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseListener(mouseListener);
        this.secondaryInputPanel.removeMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseMotionListener(mouseMotionListener);
        this.secondaryInputPanel.addMouseMotionListener(mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseMotionListener(mouseMotionListener);
        this.secondaryInputPanel.removeMouseMotionListener(mouseMotionListener);
    }

    public void timeRangeSelected(TimeRangeSelectionEvent timeRangeSelectionEvent) {
        if (timeRangeSelectionEvent.getSource() != this && !timeRangeSelectionEvent.equals(this.lastProcessedEvent)) {
            this.setDatumRange(timeRangeSelectionEvent.getRange());
            this.lastProcessedEvent = timeRangeSelectionEvent;
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener timeRangeSelectionListener) {
        if (this.timeRangeListenerList == null) {
            this.timeRangeListenerList = new EventListenerList();
        }
        this.timeRangeListenerList.add(TimeRangeSelectionListener.class, timeRangeSelectionListener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener timeRangeSelectionListener) {
        this.timeRangeListenerList.remove(TimeRangeSelectionListener.class, timeRangeSelectionListener);
    }

    private void fireTimeRangeSelectionListenerTimeRangeSelected(TimeRangeSelectionEvent timeRangeSelectionEvent) {
        if (this.timeRangeListenerList == null) {
            return;
        }
        Object[] objectArray = this.timeRangeListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TimeRangeSelectionListener.class) continue;
            String string = "fire event: " + this.getClass().getName() + "-->" + objectArray[i + 1].getClass().getName() + " " + timeRangeSelectionEvent;
            DasApplication.getDefaultApplication().getLogger(DasApplication.GUI_LOG).fine(string);
            ((TimeRangeSelectionListener)objectArray[i + 1]).timeRangeSelected(timeRangeSelectionEvent);
        }
    }

    static DasAxis processTimeaxisElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        Object object;
        Object object2;
        String string = element.getAttribute("name");
        Datum datum = TimeUtil.create(element.getAttribute("timeMinimum"));
        Datum datum2 = TimeUtil.create(element.getAttribute("timeMaximum"));
        int n = DasAxis.parseOrientationString(element.getAttribute("orientation"));
        DasAxis dasAxis = new DasAxis(datum, datum2, n);
        String string2 = element.getAttribute("row");
        if (!string2.equals("")) {
            object2 = (DasRow)formBase.checkValue(string2, DasRow.class, "<row>");
            dasAxis.setRow((DasRow)object2);
        }
        if (!((String)(object2 = element.getAttribute("column"))).equals("")) {
            object = (DasColumn)formBase.checkValue((String)object2, DasColumn.class, "<column>");
            dasAxis.setColumn((DasColumn)object);
        }
        dasAxis.setDataPath(element.getAttribute("dataPath"));
        dasAxis.setDrawTca(element.getAttribute("showTca").equals("true"));
        dasAxis.setLabel(element.getAttribute("label"));
        dasAxis.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        dasAxis.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        dasAxis.setDasName(string);
        object = formBase.getDasApplication();
        NameContext nameContext = ((DasApplication)object).getNameContext();
        nameContext.put(string, dasAxis);
        return dasAxis;
    }

    private static String format(double d, String string) {
        String string2;
        DecimalFormat decimalFormat;
        int n;
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("\"" + string + "\" is not a valid format specifier");
        }
        int n2 = Integer.parseInt(string.substring(2, string.indexOf(46)));
        int n3 = Integer.parseInt(string.substring(string.indexOf(46) + 1, string.indexOf(41)));
        char[] cArray = new char[n2];
        if (string.charAt(1) == 'f' || string.charAt(1) == 'F') {
            for (n = 0; n < n2 - n3 - 2; ++n) {
                cArray[n] = 35;
            }
            cArray[n] = 48;
            cArray[++n] = 46;
            ++n;
            while (n < n2) {
                cArray[n] = 48;
                ++n;
            }
            decimalFormat = new DecimalFormat(new String(cArray));
            string2 = decimalFormat.format(d);
        } else {
            for (n = 0; n < n2 - n3 - 6; ++n) {
                cArray[n] = 35;
            }
            cArray[n] = 48;
            cArray[++n] = 46;
            ++n;
            while (n < n2 - 5) {
                cArray[n] = 48;
                ++n;
            }
            cArray[n] = 69;
            cArray[n + 1] = d > -1.0 && d < 1.0 ? 45 : 43;
            cArray[n + 2] = 48;
            cArray[n + 3] = 48;
            decimalFormat = new DecimalFormat(new String(cArray));
            string2 = decimalFormat.format(d);
        }
        if (string2.length() > n2) {
            Arrays.fill(cArray, '*');
            return new String(cArray);
        }
        while (string2.length() < n2) {
            string2 = " " + string2;
        }
        return string2;
    }

    public String toString() {
        String string = super.toString() + "(" + this.getUnits() + ")";
        return string;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean bl) {
        this.update();
        this.flipped = bl;
    }

    static /* synthetic */ VectorDataSet[] access$602(DasAxis dasAxis, VectorDataSet[] vectorDataSetArray) {
        dasAxis.tcaData = vectorDataSetArray;
        return vectorDataSetArray;
    }

    private static class ScanButton
    extends JButton {
        private boolean hover;
        private boolean pressed;

        public ScanButton(String string) {
            this.setOpaque(true);
            this.setContentAreaFilled(false);
            this.setText(string);
            this.setFocusable(false);
            this.setBorder(new CompoundBorder(new LineBorder(Color.BLACK), new EmptyBorder(2, 2, 2, 2)));
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        ScanButton.this.setForeground(Color.LIGHT_GRAY);
                        ScanButton.this.pressed = true;
                        ScanButton.this.repaint();
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        ScanButton.this.setForeground(Color.BLACK);
                        ScanButton.this.pressed = false;
                        ScanButton.this.repaint();
                    }
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    ScanButton.this.hover = true;
                    ScanButton.this.repaint();
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    ScanButton.this.hover = false;
                    ScanButton.this.repaint();
                }
            });
        }

        protected void paintComponent(Graphics graphics) {
            if (this.hover || this.pressed) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                Object object2 = RenderingHints.VALUE_ANTIALIAS_ON;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
                super.paintComponent(graphics2D);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
        }

        protected void paintBorder(Graphics graphics) {
            if (this.hover || this.pressed) {
                super.paintBorder(graphics);
            }
        }
    }

    protected class AxisLayoutManager
    implements LayoutManager {
        protected AxisLayoutManager() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            if (DasAxis.this != container) {
                throw new IllegalArgumentException();
            }
            if (DasAxis.this.isHorizontal()) {
                this.horizontalLayout();
            } else {
                this.verticalLayout();
            }
            if (DasAxis.this.drawTca && DasAxis.this.getOrientation() == 2 && DasAxis.this.tcaData != null) {
                Rectangle rectangle = DasAxis.this.primaryInputPanel.getBounds();
                int n = (DasAxis.this.getTickLabelFont().getSize() + DasAxis.this.getLineSpacing()) * DasAxis.this.tcaData.length;
                rectangle.height += n;
                DasAxis.this.primaryInputPanel.setBounds(rectangle);
            }
        }

        protected void horizontalLayout() {
            int n = DasAxis.this.getRow().getDMinimum() - 1;
            int n2 = DasAxis.this.getRow().getDMaximum();
            int n3 = DasAxis.this.getColumn().getDMaximum();
            int n4 = DasAxis.this.getColumn().getDMinimum();
            boolean bl = DasAxis.this.orientation == 2 || DasAxis.this.oppositeAxisVisible;
            boolean bl2 = DasAxis.this.orientation == 2 && DasAxis.this.tickLabelsVisible;
            boolean bl3 = DasAxis.this.orientation == 1 || DasAxis.this.oppositeAxisVisible;
            boolean bl4 = DasAxis.this.orientation == 1 && DasAxis.this.tickLabelsVisible;
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            Font font = DasAxis.this.getTickLabelFont();
            int n5 = font.getSize() * 2 / 3;
            if (bl) {
                rectangle = new Rectangle(n4, n2, n3 - n4 + 1, 1);
            }
            if (bl3) {
                rectangle2 = new Rectangle(n4, n, n3 - n4 + 1, 1);
            }
            if (bl) {
                rectangle.height += n5;
            }
            if (bl3) {
                rectangle2.height += n5;
                rectangle2.y -= n5;
            }
            int n6 = DasAxis.this.getFontMetrics(font).stringWidth(" ");
            if (bl2) {
                rectangle.height += font.getSize() * 3 / 2 + n6;
            }
            if (bl4) {
                rectangle2.y -= font.getSize() * 3 / 2 + n6;
                rectangle2.height += font.getSize() * 3 / 2 + n6;
            }
            Rectangle rectangle3 = DasAxis.this.orientation == 2 ? rectangle : rectangle2;
            Rectangle rectangle4 = DasAxis.this.orientation == 2 ? rectangle2 : rectangle;
            rectangle3.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            if (DasAxis.this.oppositeAxisVisible) {
                rectangle4.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            }
            DasAxis.this.primaryInputPanel.setBounds(rectangle3);
            if (DasAxis.this.oppositeAxisVisible) {
                DasAxis.this.secondaryInputPanel.setBounds(rectangle4);
            } else {
                DasAxis.this.secondaryInputPanel.setBounds(-100, -100, 0, 0);
            }
            if (DasAxis.this.scanPrevious != null && DasAxis.this.scanNext != null) {
                Dimension dimension = DasAxis.this.scanPrevious.getPreferredSize();
                int n7 = n4 - dimension.width - DasAxis.this.getX();
                int n8 = (DasAxis.this.orientation == 2 ? n2 : n - dimension.height) - DasAxis.this.getY();
                DasAxis.this.scanPrevious.setBounds(n7, n8, dimension.width, dimension.height);
                dimension = DasAxis.this.scanNext.getPreferredSize();
                n7 = n3 - DasAxis.this.getX();
                DasAxis.this.scanNext.setBounds(n7, n8, dimension.width, dimension.height);
            }
        }

        protected void verticalLayout() {
            boolean bl = DasAxis.this.orientation == 3 || DasAxis.this.oppositeAxisVisible;
            boolean bl2 = DasAxis.this.orientation == 3 && DasAxis.this.tickLabelsVisible;
            boolean bl3 = DasAxis.this.orientation == 4 || DasAxis.this.oppositeAxisVisible;
            boolean bl4 = DasAxis.this.orientation == 4 && DasAxis.this.tickLabelsVisible;
            int n = DasAxis.this.getColumn().getDMinimum() - 1;
            int n2 = DasAxis.this.getColumn().getDMaximum();
            int n3 = DasAxis.this.getRow().getDMaximum();
            int n4 = DasAxis.this.getRow().getDMinimum();
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            Font font = DasAxis.this.getTickLabelFont();
            int n5 = font.getSize() * 2 / 3;
            if (bl) {
                rectangle = new Rectangle(n, n4, 1, n3 - n4 + 1);
            }
            if (bl3) {
                rectangle2 = new Rectangle(n2, n4, 1, n3 - n4 + 1);
            }
            if (bl) {
                rectangle.width += n5;
                rectangle.x -= n5;
            }
            if (bl3) {
                rectangle2.width += n5;
            }
            int n6 = DasAxis.this.getMaxLabelWidth(DasAxis.this.getFontMetrics(font));
            int n7 = DasAxis.this.getFontMetrics(font).stringWidth(" ");
            if (bl2) {
                rectangle.x -= n6 + n7;
                rectangle.width += n6 + n7;
            }
            if (bl4) {
                rectangle2.width += n6 + n7;
            }
            Rectangle rectangle3 = DasAxis.this.orientation == 3 ? rectangle : rectangle2;
            Rectangle rectangle4 = DasAxis.this.orientation == 3 ? rectangle2 : rectangle;
            rectangle3.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            if (DasAxis.this.oppositeAxisVisible) {
                rectangle4.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            }
            DasAxis.this.primaryInputPanel.setBounds(rectangle3);
            if (DasAxis.this.oppositeAxisVisible) {
                DasAxis.this.secondaryInputPanel.setBounds(rectangle4);
            } else {
                DasAxis.this.secondaryInputPanel.setBounds(-100, -100, 0, 0);
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension();
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension();
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    public class Memento {
        private DatumRange range;
        private int dmin;
        private int dmax;
        private boolean log;
        private boolean flipped;
        private DasAxis axis;

        public boolean equals(Object object) {
            Memento memento = (Memento)object;
            return this == memento || this.range.equals(memento.range) && this.dmin == memento.dmin && this.dmax == memento.dmax && this.log == memento.log && this.flipped == memento.flipped && this.axis == memento.axis;
        }

        public String toString() {
            return (this.log ? "log " : "") + this.range.toString() + " " + (this.dmax - this.dmin) + " pixels";
        }
    }
}

