/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;

public class AttachedLabel
extends DasCanvasComponent
implements Cloneable {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    private int orientation;
    protected String axisLabel = "";
    private Rectangle blTitleRect;
    private Rectangle trTitleRect;
    private double emOffset;
    private boolean rot90 = false;
    private static int[] rot90map = new int[]{0, 4, 3, 1, 2};
    private static int[] rot90unMap = new int[]{0, 3, 4, 2, 1};
    private static final boolean DEBUG_GRAPHICS = false;
    private static final Color[] DEBUG_COLORS = null;
    private int debugColorIndex = 0;

    public AttachedLabel(String string, int n, double d) {
        this.orientation = n;
        this.emOffset = d;
        this.axisLabel = string;
        this.setOpaque(false);
    }

    public void setOrientation(int n) {
        boolean bl = this.isHorizontal();
        this.setOrientationInternal(n);
    }

    private void setOrientationInternal(int n) {
        this.orientation = n;
    }

    public void setLabel(String string) {
        if (string == null) {
            throw new NullPointerException("axis label cannot be null");
        }
        String string2 = this.axisLabel;
        this.axisLabel = string;
        this.update();
        this.firePropertyChange("label", string2, string);
    }

    public String getLabel() {
        return this.axisLabel;
    }

    public final int getDevicePosition() {
        if (this.orientation == 2) {
            return this.getRow().getDMaximum();
        }
        if (this.orientation == 1) {
            return this.getRow().getDMinimum();
        }
        if (this.orientation == 3) {
            return this.getColumn().getDMinimum();
        }
        return this.getColumn().getDMaximum();
    }

    public int getDLength() {
        if (this.isHorizontal()) {
            return this.getColumn().getWidth();
        }
        return this.getRow().getHeight();
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.translate(-this.getX(), -this.getY());
        graphics2D.setColor(this.getForeground());
        if (this.isHorizontal()) {
            this.paintHorizontalLabel(graphics2D);
        } else {
            this.paintVerticalLabel(graphics2D);
        }
        graphics2D.dispose();
        this.getDasMouseInputAdapter().paint(graphics);
    }

    protected void paintHorizontalLabel(Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        boolean bl = this.orientation == 2 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(rectangle);
        boolean bl2 = this.orientation == 1 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(rectangle);
        int n = this.getRow().getDMinimum() - 1;
        int n2 = this.getRow().getDMaximum();
        int n3 = this.getColumn().getDMaximum();
        int n4 = this.getColumn().getDMinimum();
        Font font = this.getLabelFont();
        int n5 = font.getSize() * 2 / 3;
        int n6 = n5 / 2;
        if (!this.axisLabel.equals("")) {
            int n7;
            int n8;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            int n9 = this.getTitlePositionOffset();
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, this.axisLabel);
            int n10 = (int)grannyTextRenderer.getWidth();
            graphics2D2.setFont(this.getLabelFont());
            if (bl) {
                n8 = n4 + (n3 - n4 - n10) / 2;
                n7 = n2 + n9;
                if (this.rot90) {
                    graphics2D2.rotate(Math.PI, n8, n7);
                    graphics2D2.translate(-grannyTextRenderer.getWidth(), grannyTextRenderer.getAscent());
                }
                grannyTextRenderer.draw(graphics2D2, n8, n7);
            }
            if (bl2) {
                n8 = n4 + (n3 - n4 - n10) / 2;
                n7 = n - n9;
                grannyTextRenderer.draw(graphics2D2, n8, n7);
            }
            graphics2D2.dispose();
        }
    }

    protected void paintVerticalLabel(Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        boolean bl = this.orientation == 3 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(rectangle);
        boolean bl2 = this.orientation == 4 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(rectangle);
        int n = this.getColumn().getDMinimum() - 1;
        int n2 = this.getColumn().getDMaximum();
        int n3 = this.getRow().getDMaximum();
        int n4 = this.getRow().getDMinimum();
        Font font = this.getLabelFont();
        int n5 = font.getSize() * 2 / 3;
        int n6 = n5 / 2;
        if (!this.axisLabel.equals("")) {
            int n7;
            int n8;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            int n9 = this.getTitlePositionOffset();
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, this.axisLabel);
            int n10 = (int)grannyTextRenderer.getWidth();
            graphics2D2.setFont(this.getLabelFont());
            if (bl) {
                graphics2D2.rotate(-1.5707963267948966);
                n8 = -n3 + (n3 - n4 - n10) / 2;
                n7 = n - n9;
                grannyTextRenderer.draw(graphics2D2, n8, n7);
            }
            if (bl2) {
                graphics2D2.rotate(1.5707963267948966);
                n8 = n4 + (n3 - n4 - n10) / 2;
                n7 = -n2 - n9;
                if (this.rot90) {
                    graphics2D2.rotate(Math.PI, n8, n7);
                    graphics2D2.translate(-grannyTextRenderer.getWidth(), grannyTextRenderer.getAscent());
                }
                grannyTextRenderer.draw(graphics2D2, n8, n7);
            }
            graphics2D2.dispose();
        }
    }

    protected int getTitlePositionOffset() {
        Font font = this.getLabelFont();
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, this.axisLabel);
        int n = (int)Math.ceil(this.emOffset * (double)font.getSize());
        this.orientation = rot90map[this.orientation];
        if (this.orientation == 2) {
            n = (int)((double)n + grannyTextRenderer.getAscent());
        }
        this.orientation = rot90unMap[this.orientation];
        return n;
    }

    public Font getLabelFont() {
        return this.getFont();
    }

    public void setLabelFont(Font font) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Assertion failure");
        }
    }

    public void resize() {
        this.setBounds(this.getLabelBounds());
        this.invalidate();
        this.validate();
    }

    protected Rectangle getLabelBounds() {
        Rectangle rectangle = this.isHorizontal() ? this.getHorizontalLabelBounds() : this.getVerticalLabelBounds();
        return rectangle;
    }

    private Rectangle getHorizontalLabelBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getRow().getDMinimum() - 1;
        int n6 = this.getRow().getDMaximum();
        DasColumn dasColumn = this.getColumn();
        int n7 = dasColumn.getDMaximum();
        int n8 = dasColumn.getDMinimum();
        boolean bl = this.orientation == 2 && !this.axisLabel.equals("");
        boolean bl2 = this.orientation == 1 && !this.axisLabel.equals("");
        Font font = this.getLabelFont();
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, this.getLabel());
        int n9 = this.getTitlePositionOffset();
        if (bl) {
            n4 = 0;
            n3 = this.getRow().getDMaximum() + n9 - (int)Math.ceil(grannyTextRenderer.getAscent());
            n2 = this.getCanvas().getWidth();
            n = (int)Math.ceil(grannyTextRenderer.getHeight());
            this.blTitleRect = AttachedLabel.setRectangleBounds(this.blTitleRect, n4, n3, n2, n);
        }
        if (bl2) {
            n4 = 0;
            n3 = this.getRow().getDMinimum() - n9 - (int)Math.ceil(grannyTextRenderer.getAscent());
            n2 = this.getCanvas().getWidth();
            n = (int)Math.ceil(grannyTextRenderer.getHeight());
            this.trTitleRect = AttachedLabel.setRectangleBounds(this.trTitleRect, n4, n3, n2, n);
        }
        Rectangle rectangle = new Rectangle(this.orientation == 2 ? this.blTitleRect : this.trTitleRect);
        return rectangle;
    }

    private Rectangle getVerticalLabelBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = this.orientation == 3 && !this.axisLabel.equals("");
        boolean bl2 = this.orientation == 4 && !this.axisLabel.equals("");
        int n5 = this.getColumn().getDMinimum() - 1;
        int n6 = this.getColumn().getDMaximum();
        int n7 = this.getRow().getDMaximum();
        int n8 = this.getRow().getDMinimum();
        int n9 = this.getTitlePositionOffset();
        Font font = this.getLabelFont();
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, this.getLabel());
        if (bl) {
            n4 = this.getColumn().getDMinimum() - n9 - (int)Math.ceil(grannyTextRenderer.getAscent());
            n3 = 0;
            n2 = (int)Math.ceil(grannyTextRenderer.getHeight());
            n = this.getCanvas().getHeight();
            this.blTitleRect = AttachedLabel.setRectangleBounds(this.blTitleRect, n4, n3, n2, n);
        }
        if (bl2) {
            n4 = this.getColumn().getDMaximum() + n9 - (int)Math.ceil(grannyTextRenderer.getDescent());
            n3 = 0;
            n2 = (int)Math.ceil(grannyTextRenderer.getHeight());
            n = this.getCanvas().getHeight();
            this.trTitleRect = AttachedLabel.setRectangleBounds(this.trTitleRect, n4, n3, n2, n);
        }
        Rectangle rectangle = new Rectangle(this.orientation == 3 ? this.blTitleRect : this.trTitleRect);
        return rectangle;
    }

    private static Rectangle setRectangleBounds(Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (rectangle == null) {
            return new Rectangle(n, n2, n3, n4);
        }
        rectangle.setBounds(n, n2, n3, n4);
        return rectangle;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isHorizontal() {
        return this.orientation == 2 || this.orientation == 1;
    }

    protected static String orientationToString(int n) {
        switch (n) {
            case 1: {
                return "top";
            }
            case 2: {
                return "bottom";
            }
            case 3: {
                return "left";
            }
            case 4: {
                return "right";
            }
        }
        throw new IllegalStateException("invalid orienation: " + n);
    }

    protected static int parseOrientationString(String string) {
        if (string.equals("horizontal")) {
            return 2;
        }
        if (string.equals("vertical")) {
            return 3;
        }
        if (string.equals("left")) {
            return 3;
        }
        if (string.equals("right")) {
            return 4;
        }
        if (string.equals("top")) {
            return 1;
        }
        if (string.equals("bottom")) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid orientation: " + string);
    }

    public Shape getActiveRegion() {
        return this.getLabelBounds();
    }

    public double getEmOffset() {
        return this.emOffset;
    }

    public void setEmOffset(double d) {
        this.emOffset = d;
    }
}

