/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class Arrow
extends DasCanvasComponent {
    Point head;
    Point tail;
    Stroke stroke;
    double em = 24.0;

    public Arrow(DasCanvas dasCanvas, Point point, Point point2) {
        this.head = point;
        this.tail = point2;
        this.setRow(new DasRow(dasCanvas, point.getX(), point2.getX()));
        this.setColumn(new DasColumn(dasCanvas, point.getY(), point2.getY()));
    }

    public void resize() {
        Rectangle rectangle = new Rectangle();
        rectangle.add((double)this.head.x - this.em, (double)this.head.y - this.em);
        rectangle.add((double)this.tail.x + this.em, (double)this.tail.y + this.em);
        this.setBounds(rectangle);
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(-this.getX(), -this.getY());
        double d = 4.0;
        Line2D.Double double_ = new Line2D.Double(this.head, this.tail);
        double d2 = -(this.head.getX() - this.tail.getX());
        double d3 = -(this.head.getY() - this.tail.getY());
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        d2 = d2 * d / d4;
        d3 = d3 * d / d4;
        double d5 = this.head.getX();
        double d6 = this.head.getY();
        graphics2D.setStroke(new BasicStroke((float)(d / 2.0), 1, 1));
        graphics2D.draw(double_);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)d5, (float)d6);
        generalPath.lineTo((float)(d5 + 2.0 * d2 + 0.5 * d3), (float)(d6 + 2.0 * d3 - 0.5 * d2));
        generalPath.lineTo((float)(d5 + 3.0 * d2 + d3), (float)(d6 + 3.0 * d3 - d2));
        generalPath.lineTo((float)(d5 + 3.0 * d2 - d3), (float)(d6 + 3.0 * d3 + d2));
        generalPath.lineTo((float)(d5 + 2.0 * d2 - 0.5 * d3), (float)(d6 + 2.0 * d3 + 0.5 * d2));
        generalPath.lineTo((float)d5, (float)d6);
        graphics2D.fill(generalPath);
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        this.getMouseAdapter().paint(graphics);
    }
}

