/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.event.DataPointSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionListener;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MousePointSelectionEvent;
import edu.uiowa.physics.pw.das.event.VerticalSliceSelectionRenderer;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.Renderer;
import javax.swing.event.EventListenerList;

public class VerticalSlicerMouseModule
extends MouseModule {
    private DataSet ds;
    double offset;
    private DasAxis xaxis;
    private DasAxis yaxis;
    private DataSetConsumer dataSetConsumer;
    private DataPointSelectionEvent de;
    private EventListenerList listenerList = null;

    public VerticalSlicerMouseModule(DasCanvasComponent dasCanvasComponent, DataSetConsumer dataSetConsumer, DasAxis dasAxis, DasAxis dasAxis2) {
        super(dasCanvasComponent, new VerticalSliceSelectionRenderer(dasCanvasComponent), "Vertical Slice");
        this.dataSetConsumer = dataSetConsumer;
        this.xaxis = dasAxis;
        this.yaxis = dasAxis2;
        this.de = new DataPointSelectionEvent(this, null, null);
    }

    public static VerticalSlicerMouseModule create(DasPlot dasPlot) {
        DasAxis dasAxis = dasPlot.getXAxis();
        DasAxis dasAxis2 = dasPlot.getYAxis();
        return new VerticalSlicerMouseModule(dasPlot, dasPlot, dasAxis, dasAxis2);
    }

    public static VerticalSlicerMouseModule create(Renderer renderer) {
        DasPlot dasPlot = renderer.getParent();
        return new VerticalSlicerMouseModule(dasPlot, renderer, dasPlot.getXAxis(), dasPlot.getYAxis());
    }

    public void mousePointSelected(MousePointSelectionEvent mousePointSelectionEvent) {
        this.de.birthMilli = System.currentTimeMillis();
        this.ds = this.dataSetConsumer.getDataSet();
        this.de.set(this.xaxis.invTransform(mousePointSelectionEvent.getX()), this.yaxis.invTransform(mousePointSelectionEvent.getY()));
        this.de.setDataSet(this.ds);
        this.fireDataPointSelectionListenerDataPointSelected(this.de);
    }

    public synchronized void addDataPointSelectionListener(DataPointSelectionListener dataPointSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataPointSelectionListener.class, dataPointSelectionListener);
    }

    public synchronized void removeDataPointSelectionListener(DataPointSelectionListener dataPointSelectionListener) {
        this.listenerList.remove(DataPointSelectionListener.class, dataPointSelectionListener);
    }

    private void fireDataPointSelectionListenerDataPointSelected(DataPointSelectionEvent dataPointSelectionEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DataPointSelectionListener.class) continue;
            ((DataPointSelectionListener)objectArray[i + 1]).DataPointSelected(dataPointSelectionEvent);
        }
    }
}

