/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.event.Gesture;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MouseRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.VerticalRangeGesturesRenderer;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import javax.swing.event.EventListenerList;

public class VerticalRangeSelectorMouseModule
extends MouseModule {
    DasAxis axis;
    private EventListenerList listenerList = null;

    public String getLabel() {
        return "Zoom Y";
    }

    public VerticalRangeSelectorMouseModule(DasCanvasComponent dasCanvasComponent, DasAxis dasAxis) {
        if (dasAxis.isHorizontal()) {
            throw new IllegalArgumentException("Axis orientation is not vertical");
        }
        this.parent = dasCanvasComponent;
        this.dragRenderer = new VerticalRangeGesturesRenderer(dasCanvasComponent);
        this.axis = dasAxis;
    }

    public static VerticalRangeSelectorMouseModule create(DasPlot dasPlot) {
        DasAxis dasAxis = dasPlot.getYAxis();
        VerticalRangeSelectorMouseModule verticalRangeSelectorMouseModule = new VerticalRangeSelectorMouseModule(dasPlot, dasPlot.getYAxis());
        return verticalRangeSelectorMouseModule;
    }

    public void mouseRangeSelected(MouseDragEvent mouseDragEvent) {
        if (!mouseDragEvent.isGesture()) {
            MouseRangeSelectionEvent mouseRangeSelectionEvent = (MouseRangeSelectionEvent)mouseDragEvent;
            Datum datum = this.axis.invTransform(mouseRangeSelectionEvent.getMaximum());
            Datum datum2 = this.axis.invTransform(mouseRangeSelectionEvent.getMinimum());
            DatumRange datumRange = new DatumRange(datum, datum2);
            DatumRange datumRange2 = this.axis.getTickV().enclosingRange(datumRange, true);
            DataRangeSelectionEvent dataRangeSelectionEvent = new DataRangeSelectionEvent(this.parent, datumRange2.min(), datumRange2.max());
            this.fireDataRangeSelectionListenerDataRangeSelected(dataRangeSelectionEvent);
        } else if (mouseDragEvent.getGesture() == Gesture.BACK) {
            this.axis.setDataRangePrev();
        } else if (mouseDragEvent.getGesture() == Gesture.ZOOMOUT) {
            this.axis.setDataRangeZoomOut();
        } else if (mouseDragEvent.getGesture() == Gesture.FORWARD) {
            this.axis.setDataRangeForward();
        }
    }

    public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataRangeSelectionListener.class, dataRangeSelectionListener);
    }

    public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
        this.listenerList.remove(DataRangeSelectionListener.class, dataRangeSelectionListener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent dataRangeSelectionEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DataRangeSelectionListener.class) continue;
            ((DataRangeSelectionListener)objectArray[i + 1]).DataRangeSelected(dataRangeSelectionEvent);
        }
    }
}

