/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsUtil;
import edu.uiowa.physics.pw.das.event.LabelDragRenderer;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.text.NumberFormat;

public class LengthDragRenderer
extends LabelDragRenderer {
    private DasAxis xaxis;
    private DasAxis yaxis;
    private DasPlot plot;
    NumberFormat nf;
    private boolean showSlope = false;

    public LengthDragRenderer(DasCanvasComponent dasCanvasComponent, DasAxis dasAxis, DasAxis dasAxis2) {
        super(dasCanvasComponent);
        this.plot = (DasPlot)dasCanvasComponent;
        this.xaxis = dasAxis;
        this.yaxis = dasAxis2;
    }

    private String datumString(Datum datum) {
        String string = datum.toString();
        return string;
    }

    public Rectangle[] renderDrag(Graphics graphics, Point point, Point point2) {
        DasAxis dasAxis;
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = Math.atan2(point2.y - point.y, point2.x - point.x);
        Line2D.Double double_ = new Line2D.Double(point.x + (int)(3.0 * Math.cos(d)), (int)((double)point.y + 3.0 * Math.sin(d)), point2.x, point2.y);
        graphics2D.draw(double_);
        graphics2D.draw(new Ellipse2D.Double(point.x - 3, point.y - 3, 6.0, 6.0));
        Rectangle rectangle = new Rectangle();
        rectangle.setRect(point.x - 3, point.y - 3, 7.0, 7.0);
        rectangle.add(point2.x - 2, point2.y - 2);
        rectangle.add(point2.x + 2, point2.y + 2);
        DasAxis dasAxis2 = this.xaxis == null ? this.plot.getXAxis() : this.xaxis;
        DasAxis dasAxis3 = dasAxis = this.yaxis == null ? this.plot.getYAxis() : this.yaxis;
        if (!point.equals(point2)) {
            String string;
            Object object;
            Datum datum = dasAxis2.invTransform(point2.x + this.parent.getX());
            Datum datum2 = datum.subtract(dasAxis2.invTransform(point.x + this.parent.getX()));
            datum2 = DatumUtil.asOrderOneUnits(datum2);
            String string2 = datum.getUnits() == datum2.getUnits() ? datum.getFormatter().format(datum2) : this.datumString(datum2);
            Datum datum3 = dasAxis.invTransform(point2.y + this.parent.getY());
            Datum datum4 = datum3.subtract(dasAxis.invTransform(point.y + this.parent.getY()));
            String string3 = this.datumString(datum4);
            if (datum4.getUnits().isConvertableTo(datum2.getUnits())) {
                object = datum2.getUnits();
                double d2 = datum4.doubleValue((Units)object);
                double d3 = datum2.doubleValue((Units)object);
                double d4 = Math.sqrt(d2 * d2 + d3 * d3);
                double d5 = datum4.getResolution((Units)object);
                double d6 = datum2.getResolution((Units)object);
                double d7 = d4 * Math.sqrt(Math.pow(d5 / Math.max(Math.abs(d2), d5), 2.0) + Math.pow(d6 / Math.max(Math.abs(d3), d6), 2.0));
                Datum datum5 = Datum.create(d4, (Units)object, d7);
                string = " R:" + datum5;
            } else {
                string = "";
            }
            object = "\u0394x: " + string2 + " \u0394y: " + string3 + string;
            if (this.showSlope) {
                object = (String)object + "!c m: " + UnitsUtil.divideToString(datum4, datum2);
            }
            this.setLabel((String)object);
        } else {
            this.setLabel("");
        }
        super.renderDrag(graphics2D, point, point2);
        return new Rectangle[]{this.dirtyBounds, rectangle};
    }

    public boolean isShowSlope() {
        return this.showSlope;
    }

    public void setShowSlope(boolean bl) {
        this.showSlope = bl;
    }
}

