/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class LabelDragRenderer
implements DragRenderer {
    String label = "Label not set";
    GrannyTextRenderer gtr;
    DasCanvasComponent parent;
    InfoLabel infoLabel;
    int labelPositionX = 1;
    int labelPositionY = -1;
    Rectangle dirtyBounds;
    Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);
    int maxLabelWidth;
    ArrayList newDirtyBounds;
    boolean tooltip = false;

    public void clear(Graphics graphics) {
        if (this.dirtyBounds != null) {
            this.parent.paintImmediately(this.dirtyBounds);
        }
        this.dirtyBounds = null;
    }

    public LabelDragRenderer(DasCanvasComponent dasCanvasComponent) {
        this.parent = dasCanvasComponent;
        this.dirtyBounds = new Rectangle();
        this.gtr = new GrannyTextRenderer();
    }

    public MouseDragEvent getMouseDragEvent(Object object, Point point, Point point2, boolean bl) {
        if (this.tooltip && this.infoLabel != null) {
            this.infoLabel.hide();
        }
        return null;
    }

    public boolean isPointSelection() {
        return true;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    private Rectangle paintLabel(Graphics graphics, Point point) {
        if (this.label == null) {
            return null;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Dimension dimension = this.parent.getSize();
        this.gtr.setString(this.parent, this.label);
        int n = (int)this.gtr.getWidth() + 6;
        int n2 = (int)this.gtr.getHeight();
        if (this.maxLabelWidth < n) {
            this.maxLabelWidth = n;
        }
        this.labelPositionX = point.x + this.maxLabelWidth > dimension.width && point.x - 3 - n > 0 ? -1 : 1;
        int n3 = this.labelPositionX == 1 ? point.x + 3 : point.x - 3 - n;
        this.labelPositionY = point.y - 3 - n2 < 13 ? -1 : 1;
        int n4 = this.labelPositionY == 1 ? point.y - 3 - n2 : point.y + 3;
        this.dirtyBounds = new Rectangle();
        Color color = graphics2D.getColor();
        graphics2D.setColor(new Color(255, 255, 255, 200));
        this.dirtyBounds.setRect(n3, n4, n, n2);
        graphics2D.fill(this.dirtyBounds);
        graphics2D.setColor(new Color(20, 20, 20));
        this.gtr.draw(graphics2D, n3 + 3, (float)((double)n4 + this.gtr.getAscent()));
        graphics2D.setColor(color);
        return this.dirtyBounds;
    }

    public Rectangle[] renderDrag(Graphics graphics, Point point, Point point2) {
        Rectangle[] rectangleArray;
        this.logger.finest("renderDrag " + point2);
        if (this.tooltip) {
            if (this.infoLabel == null) {
                this.infoLabel = new InfoLabel();
            }
            Point point3 = (Point)point2.clone();
            SwingUtilities.convertPointToScreen(point3, this.parent);
            this.infoLabel.setText(this.label, point3);
            rectangleArray = new Rectangle[]{};
        } else if (this.label == null) {
            rectangleArray = new Rectangle[]{};
        } else {
            Rectangle rectangle = this.paintLabel(graphics, point2);
            rectangleArray = new Rectangle[]{rectangle};
        }
        return rectangleArray;
    }

    protected void resetDirtyBounds() {
        this.newDirtyBounds = new ArrayList();
    }

    protected void addDirtyBounds(Rectangle[] rectangleArray) {
        if (rectangleArray != null && rectangleArray.length > 0) {
            this.newDirtyBounds.addAll(Arrays.asList(rectangleArray));
        }
    }

    protected void addDirtyBounds(Rectangle rectangle) {
        if (rectangle != null) {
            this.newDirtyBounds.add(rectangle);
        }
    }

    protected Rectangle[] getDirtyBounds() {
        return this.newDirtyBounds.toArray(new Rectangle[this.newDirtyBounds.size()]);
    }

    public boolean isTooltip() {
        return this.tooltip;
    }

    public void setTooltip(boolean bl) {
        this.tooltip = bl;
        if (bl) {
            this.labelPositionX = 1;
            this.labelPositionY = -1;
        }
    }

    private class InfoLabel {
        JWindow window;
        JPanel label;
        GrannyTextRenderer gtr;
        JPanel containedPanel;
        JComponent glassPane;
        boolean contained = true;

        private InfoLabel() {
        }

        void init() {
            Window window = (Window)SwingUtilities.getRoot(LabelDragRenderer.this.parent);
            this.window = new JWindow(window);
            this.label = new JPanel(){

                public void paintComponent(Graphics graphics) {
                    graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                    InfoLabel.this.gtr.draw(graphics, 0.0f, (int)InfoLabel.this.gtr.getAscent());
                }
            };
            this.label.setOpaque(true);
            this.label.setPreferredSize(new Dimension(300, 20));
            this.window.getContentPane().add(this.label);
            this.window.pack();
            this.gtr = new GrannyTextRenderer();
            this.glassPane = (JComponent)LabelDragRenderer.this.parent.getCanvas().getGlassPane();
            this.containedPanel = new JPanel(){

                public void paintComponent(Graphics graphics) {
                    graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                    InfoLabel.this.gtr.draw(graphics, 0.0f, (int)InfoLabel.this.gtr.getAscent());
                }
            };
            this.containedPanel.setVisible(false);
            this.glassPane.add(this.containedPanel);
            this.contained = true;
        }

        void setText(String string, Point point) {
            if (this.window == null) {
                this.init();
            }
            if (string != null) {
                this.gtr.setString(this.containedPanel, string);
                Rectangle rectangle = this.gtr.getBounds();
                int n = point.x + LabelDragRenderer.this.labelPositionX * 3 + Math.min(LabelDragRenderer.this.labelPositionX, 0) * rectangle.width;
                int n2 = point.y + LabelDragRenderer.this.labelPositionY * 3 + Math.min(LabelDragRenderer.this.labelPositionY, 0) * rectangle.height;
                Rectangle rectangle2 = this.gtr.getBounds();
                Point point2 = new Point(n, n2);
                SwingUtilities.convertPointFromScreen(point2, this.glassPane);
                rectangle2.translate(point2.x, point2.y);
                this.contained = this.glassPane.getBounds().contains(rectangle2);
                if (this.contained) {
                    this.containedPanel.setSize(new Dimension(rectangle.width, rectangle.height));
                    this.containedPanel.setLocation(point2.x, point2.y);
                    this.window.setVisible(false);
                    this.containedPanel.setVisible(true);
                    this.containedPanel.repaint();
                } else {
                    this.gtr.setString(this.label, string);
                    rectangle = this.gtr.getBounds();
                    this.window.setSize(new Dimension(rectangle.width, rectangle.height));
                    n = point.x + LabelDragRenderer.this.labelPositionX * 3 + Math.min(LabelDragRenderer.this.labelPositionX, 0) * rectangle.width;
                    n2 = point.y + LabelDragRenderer.this.labelPositionY * 3 + Math.min(LabelDragRenderer.this.labelPositionY, 0) * rectangle.height;
                    this.containedPanel.setVisible(false);
                    this.window.setLocation(n, n2);
                    this.window.setVisible(true);
                    this.window.repaint();
                }
            } else {
                this.hide();
            }
        }

        void hide() {
            if (this.window == null) {
                this.init();
            }
            if (this.contained) {
                this.containedPanel.setVisible(false);
            } else {
                this.window.setVisible(false);
            }
        }
    }
}

