/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.event.Gesture;
import edu.uiowa.physics.pw.das.event.HorizontalRangeGesturesRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MouseRangeSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import javax.swing.event.EventListenerList;

public class HorizontalRangeSelectorMouseModule
extends MouseModule {
    DasAxis axis;
    private EventListenerList listenerList = null;

    public HorizontalRangeSelectorMouseModule(DasCanvasComponent dasCanvasComponent, DasAxis dasAxis) {
        super(dasCanvasComponent, new HorizontalRangeGesturesRenderer(dasCanvasComponent), "Zoom X");
        if (!dasAxis.isHorizontal()) {
            throw new IllegalArgumentException("Axis orientation is not horizontal");
        }
        this.axis = dasAxis;
    }

    public static HorizontalRangeSelectorMouseModule create(DasPlot dasPlot) {
        DasAxis dasAxis = dasPlot.getXAxis();
        HorizontalRangeSelectorMouseModule horizontalRangeSelectorMouseModule = new HorizontalRangeSelectorMouseModule(dasPlot, dasPlot.getXAxis());
        return horizontalRangeSelectorMouseModule;
    }

    public void mouseRangeSelected(MouseDragEvent mouseDragEvent) {
        if (!mouseDragEvent.isGesture()) {
            MouseRangeSelectionEvent mouseRangeSelectionEvent = (MouseRangeSelectionEvent)mouseDragEvent;
            Datum datum = this.axis.invTransform(mouseRangeSelectionEvent.getMinimum());
            Datum datum2 = this.axis.invTransform(mouseRangeSelectionEvent.getMaximum());
            DatumRange datumRange = new DatumRange(datum, datum2);
            DatumRange datumRange2 = this.axis.getTickV().enclosingRange(datumRange, true);
            DataRangeSelectionEvent dataRangeSelectionEvent = new DataRangeSelectionEvent(mouseDragEvent.getSource(), datumRange2.min(), datumRange2.max());
            this.fireDataRangeSelectionListenerDataRangeSelected(dataRangeSelectionEvent);
        } else if (mouseDragEvent.getGesture() == Gesture.BACK) {
            this.axis.setDataRangePrev();
        } else if (mouseDragEvent.getGesture() == Gesture.ZOOMOUT) {
            this.axis.setDataRangeZoomOut();
        } else if (mouseDragEvent.getGesture() == Gesture.FORWARD) {
            this.axis.setDataRangeForward();
        } else if (mouseDragEvent.getGesture() == Gesture.SCANPREV) {
            this.axis.scanPrevious();
        } else if (mouseDragEvent.getGesture() == Gesture.SCANNEXT) {
            this.axis.scanNext();
        }
    }

    public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataRangeSelectionListener.class, dataRangeSelectionListener);
    }

    public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
        this.listenerList.remove(DataRangeSelectionListener.class, dataRangeSelectionListener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent dataRangeSelectionEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DataRangeSelectionListener.class) continue;
            ((DataRangeSelectionListener)objectArray[i + 1]).DataRangeSelected(dataRangeSelectionEvent);
        }
    }
}

