/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.TableDataSetConsumer;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.event.HorizontalDragRangeRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MouseRangeSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import javax.swing.event.EventListenerList;

public class HorizontalDragRangeSelectorMouseModule
extends MouseModule {
    DasAxis axis;
    int start;
    private EventListenerList listenerList = null;
    private DataSetConsumer dataSetConsumer;

    public HorizontalDragRangeSelectorMouseModule(DasPlot dasPlot, DataSetConsumer dataSetConsumer, DasAxis dasAxis) {
        super(dasPlot, new HorizontalDragRangeRenderer(dasPlot), "Horizontal Drag Range");
        if (!dasAxis.isHorizontal()) {
            throw new IllegalArgumentException("Axis orientation is not horizontal");
        }
        this.dataSetConsumer = dataSetConsumer;
        this.axis = dasAxis;
    }

    public static HorizontalDragRangeSelectorMouseModule create(DasPlot dasPlot) {
        DasAxis dasAxis = dasPlot.getXAxis();
        HorizontalDragRangeSelectorMouseModule horizontalDragRangeSelectorMouseModule = new HorizontalDragRangeSelectorMouseModule(dasPlot, dasPlot, dasPlot.getXAxis());
        return horizontalDragRangeSelectorMouseModule;
    }

    public void mouseRangeSelected(MouseDragEvent mouseDragEvent) {
        MouseRangeSelectionEvent mouseRangeSelectionEvent = (MouseRangeSelectionEvent)mouseDragEvent;
        Datum datum = this.axis.invTransform(mouseRangeSelectionEvent.getMinimum());
        Datum datum2 = this.axis.invTransform(mouseRangeSelectionEvent.getMaximum());
        DataRangeSelectionEvent dataRangeSelectionEvent = new DataRangeSelectionEvent(this.parent, datum, datum2);
        this.fireDataRangeSelectionListenerDataRangeSelected(dataRangeSelectionEvent);
    }

    public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataRangeSelectionListener.class, dataRangeSelectionListener);
    }

    public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
        this.listenerList.remove(DataRangeSelectionListener.class, dataRangeSelectionListener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent dataRangeSelectionEvent) {
        if (this.dataSetConsumer instanceof TableDataSetConsumer) {
            dataRangeSelectionEvent.setDataSet(this.dataSetConsumer.getDataSet());
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DataRangeSelectionListener.class) continue;
            ((DataRangeSelectionListener)objectArray[i + 1]).DataRangeSelected(dataRangeSelectionEvent);
        }
    }
}

