/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseRangeSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class HorizontalDragRangeRenderer
implements DragRenderer {
    private Rectangle dirtyBounds;
    DasCanvasComponent parent;
    boolean updating;

    public HorizontalDragRangeRenderer(DasCanvasComponent dasCanvasComponent) {
        this.parent = dasCanvasComponent;
        this.dirtyBounds = new Rectangle();
        this.updating = true;
    }

    public HorizontalDragRangeRenderer(DasCanvasComponent dasCanvasComponent, boolean bl) {
        this(dasCanvasComponent);
        this.updating = bl;
    }

    public Rectangle[] renderDrag(Graphics graphics, Point point, Point point2) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n2 = point2.x;
        int n3 = point.x;
        if (n2 < n3) {
            n = n2;
            n2 = n3;
            n3 = n;
        }
        n = n2 - n3;
        int n4 = point2.y;
        Color color = graphics2D.getColor();
        graphics2D.setColor(new Color(255, 255, 255, 100));
        graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
        if (n > 6) {
            graphics2D.drawLine(n3 + 3, n4, n2 - 3, n4);
        }
        graphics2D.drawLine(n3, n4 + 2, n3, n4 - 2);
        graphics2D.drawLine(n2, n4 + 2, n2, n4 - 2);
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setColor(color);
        if (n > 6) {
            graphics2D.drawLine(n3 + 3, n4, n2 - 3, n4);
        }
        graphics2D.drawLine(n3, n4 + 2, n3, n4 - 2);
        graphics2D.drawLine(n2, n4 + 2, n2, n4 - 2);
        this.dirtyBounds.setLocation(n3 - 2, n4 + 3);
        this.dirtyBounds.add(n2 + 2, n4 - 3);
        return new Rectangle[]{this.dirtyBounds};
    }

    public MouseDragEvent getMouseDragEvent(Object object, Point point, Point point2, boolean bl) {
        MouseRangeSelectionEvent mouseRangeSelectionEvent = new MouseRangeSelectionEvent(object, point.x, point2.x, bl);
        return mouseRangeSelectionEvent;
    }

    public void clear(Graphics graphics) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    public boolean isPointSelection() {
        return true;
    }

    public boolean isUpdatingDragSelection() {
        return this.updating;
    }
}

