/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.dataset.ClippedTableDataSet;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.event.BoxRenderer;
import edu.uiowa.physics.pw.das.event.MouseBoxEvent;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.system.UserMessageCenter;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class DumpToFileMouseModule
extends MouseModule {
    DasAxis xAxis;
    DasAxis yAxis;
    DataSetConsumer dsConsumer;

    public DumpToFileMouseModule(DasCanvasComponent dasCanvasComponent, DataSetConsumer dataSetConsumer, DasAxis dasAxis, DasAxis dasAxis2) {
        super(dasCanvasComponent, new BoxRenderer(dasCanvasComponent), "Dump to File");
        if (!dasAxis.isHorizontal()) {
            throw new IllegalArgumentException("X Axis orientation is not horizontal");
        }
        if (dasAxis2.isHorizontal()) {
            throw new IllegalArgumentException("Y Axis orientation is not vertical");
        }
        this.xAxis = dasAxis;
        this.yAxis = dasAxis2;
        this.dsConsumer = dataSetConsumer;
    }

    public static DumpToFileMouseModule create(DasPlot dasPlot, DataSetConsumer dataSetConsumer) {
        DumpToFileMouseModule dumpToFileMouseModule = new DumpToFileMouseModule(dasPlot, dataSetConsumer, dasPlot.getXAxis(), dasPlot.getYAxis());
        return dumpToFileMouseModule;
    }

    public void mouseRangeSelected(MouseDragEvent mouseDragEvent) {
        DataSet dataSet;
        Object object;
        MouseBoxEvent mouseBoxEvent = (MouseBoxEvent)mouseDragEvent;
        DatumRange datumRange = new DatumRange(this.xAxis.invTransform(mouseBoxEvent.getXMinimum()), this.xAxis.invTransform(mouseBoxEvent.getXMaximum()));
        DatumRange datumRange2 = new DatumRange(this.yAxis.invTransform(mouseBoxEvent.getYMaximum()), this.yAxis.invTransform(mouseBoxEvent.getYMinimum()));
        DataSet dataSet2 = this.dsConsumer.getDataSet();
        if (dataSet2 == null) {
            UserMessageCenter.getDefault().notifyUser((Object)this, "This renderer doesn't have a dataset loaded");
            return;
        }
        if (dataSet2 instanceof TableDataSet) {
            object = (TableDataSet)dataSet2;
            dataSet = new ClippedTableDataSet((TableDataSet)object, datumRange, datumRange2);
        } else {
            object = (VectorDataSet)dataSet2;
            VectorDataSetBuilder vectorDataSetBuilder = new VectorDataSetBuilder(object.getXUnits(), object.getYUnits());
            for (int i = 0; i < object.getXLength(); ++i) {
                if (!(datumRange2.contains(object.getDatum(i)) & datumRange.contains(object.getXTagDatum(i)))) continue;
                vectorDataSetBuilder.insertY(object.getXTagDouble(i, object.getXUnits()), object.getDouble(i, object.getYUnits()));
            }
            dataSet = vectorDataSetBuilder.toVectorDataSet();
        }
        object = new JFileChooser();
        ((JFileChooser)object).setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.toString().matches(".*\\.das2Stream");
            }

            public String getDescription() {
                return "*.das2Stream";
            }
        });
        int n = ((JFileChooser)object).showSaveDialog(this.parent);
        if (n == 0) {
            File file = ((JFileChooser)object).getSelectedFile();
            try {
                FileChannel fileChannel = new FileOutputStream(file).getChannel();
                if (dataSet instanceof TableDataSet) {
                    TableUtil.dumpToAsciiStream((TableDataSet)dataSet, fileChannel);
                } else if (dataSet instanceof VectorDataSet) {
                    VectorUtil.dumpToAsciiStream((VectorDataSet)dataSet, fileChannel);
                }
            }
            catch (IOException iOException) {
                DasExceptionHandler.handle(iOException);
            }
        }
    }

    public DumpToFileMouseModule() {
    }
}

