/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.event.BoxRenderer;
import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MousePointSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.system.DasLogger;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class DasMouseInputAdapter
extends MouseInputAdapter
implements Editable {
    private MouseModule primary = null;
    private MouseModule secondary = null;
    private MouseModule tertiary = null;
    private Vector active = null;
    private boolean pinned = false;
    private Vector modules;
    private HashMap primaryActionButtonMap;
    private HashMap secondaryActionButtonMap;
    protected JPopupMenu primaryPopup;
    protected JPopupMenu secondaryPopup;
    private Point primaryPopupLocation;
    private Point secondaryPopupLocation;
    private JPanel pngFileNamePanel;
    private JTextField pngFileTextField;
    private JFileChooser pngFileChooser;
    JCheckBoxMenuItem primarySelectedItem;
    JCheckBoxMenuItem secondarySelectedItem;
    Rectangle[] dirtyBoundsList;
    Logger log = DasLogger.getLogger(DasLogger.GUI_LOG);
    int numInserted;
    protected ActionListener popupListener;
    protected DasCanvasComponent parent = null;
    private Point selectionStart;
    private Point selectionEnd;
    private Point dSelectionStart;
    private Point dSelectionEnd;
    private Graphics2D graphics;
    private MousePointSelectionEvent mousePointSelection;
    private int xOffset;
    private int yOffset;
    private int button = 0;
    private MouseMode mouseMode = MouseMode.idle;
    private DragRenderer resizeRenderer = null;
    private Point resizeStart = null;
    Vector hotSpots = null;
    Rectangle dirtyBounds = null;
    private boolean hasFocus = false;
    private Point pressPosition;
    private boolean hoverHighlite = false;

    public DasMouseInputAdapter(DasCanvasComponent dasCanvasComponent) {
        this.parent = dasCanvasComponent;
        this.modules = new Vector();
        this.primaryActionButtonMap = new HashMap();
        this.secondaryActionButtonMap = new HashMap();
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.primaryPopup = this.createPopup();
            this.secondaryPopup = this.createPopup();
        }
        this.active = null;
        this.mousePointSelection = new MousePointSelectionEvent(this, 0, 0);
        this.resizeRenderer = new BoxRenderer(dasCanvasComponent);
        this.numInserted = 0;
        this.dirtyBoundsList = new Rectangle[0];
    }

    public void replaceMouseModule(MouseModule mouseModule, MouseModule mouseModule2) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(mouseModule);
        this.primaryActionButtonMap.put(mouseModule2, jCheckBoxMenuItem);
        this.primaryActionButtonMap.remove(mouseModule);
        this.secondaryActionButtonMap.put(mouseModule2, this.secondaryActionButtonMap.get(mouseModule));
        this.secondaryActionButtonMap.remove(mouseModule);
        this.modules.removeElement(mouseModule);
        this.modules.addElement(mouseModule2);
    }

    public void addMouseModule(MouseModule mouseModule) {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            DasLogger.getLogger(DasLogger.GUI_LOG).info("not adding module since headless is true");
        } else {
            MouseModule mouseModule2 = this.getModuleByLabel(mouseModule.getLabel());
            if (mouseModule2 != null) {
                DasLogger.getLogger(DasLogger.GUI_LOG).info("Replacing mouse module " + mouseModule.getLabel() + ".");
                this.replaceMouseModule(mouseModule2, mouseModule);
            } else {
                this.modules.add(mouseModule);
                String string = mouseModule.getLabel();
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
                JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(string);
                jCheckBoxMenuItem.addActionListener(this.popupListener);
                jCheckBoxMenuItem.setActionCommand("primary");
                jCheckBoxMenuItem2.addActionListener(this.popupListener);
                jCheckBoxMenuItem2.setActionCommand("secondary");
                this.primaryActionButtonMap.put(mouseModule, jCheckBoxMenuItem);
                this.secondaryActionButtonMap.put(mouseModule, jCheckBoxMenuItem2);
                this.primaryPopup.add((Component)jCheckBoxMenuItem, this.primaryActionButtonMap.size() - 1);
                this.secondaryPopup.add((Component)jCheckBoxMenuItem2, this.secondaryActionButtonMap.size() - 1);
            }
        }
    }

    public KeyAdapter getKeyAdapter() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DasMouseInputAdapter.this.log.finest("keyPressed ");
                if (keyEvent.getKeyCode() == 27 & DasMouseInputAdapter.this.active != null) {
                    DasMouseInputAdapter.this.active = null;
                    DasMouseInputAdapter.this.refresh();
                    keyEvent.consume();
                } else if (keyEvent.getKeyChar() == 'p') {
                    DasMouseInputAdapter.this.pinned = true;
                    keyEvent.consume();
                } else {
                    if (DasMouseInputAdapter.this.active == null) {
                        return;
                    }
                    for (int i = 0; i < DasMouseInputAdapter.this.active.size(); ++i) {
                        ((MouseModule)DasMouseInputAdapter.this.active.get(i)).keyPressed(keyEvent);
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (DasMouseInputAdapter.this.active == null) {
                    return;
                }
                for (int i = 0; i < DasMouseInputAdapter.this.active.size(); ++i) {
                    ((MouseModule)DasMouseInputAdapter.this.active.get(i)).keyReleased(keyEvent);
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (DasMouseInputAdapter.this.active == null) {
                    return;
                }
                for (int i = 0; i < DasMouseInputAdapter.this.active.size(); ++i) {
                    ((MouseModule)DasMouseInputAdapter.this.active.get(i)).keyTyped(keyEvent);
                }
            }
        };
    }

    public void setPrimaryModule(MouseModule mouseModule) {
        Object object = this.primaryActionButtonMap.entrySet().iterator();
        while (object.hasNext()) {
            try {
                Object v = object.next().getValue();
                ((JCheckBoxMenuItem)v).setSelected(false);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                throw runtimeException;
            }
        }
        object = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(mouseModule);
        if (object != null) {
            ((AbstractButton)object).setSelected(true);
        }
        this.primarySelectedItem = object;
        this.primary = mouseModule;
        this.parent.setCursor(this.primary.getCursor());
    }

    public void setSecondaryModule(MouseModule mouseModule) {
        Object object = this.secondaryActionButtonMap.entrySet().iterator();
        while (object.hasNext()) {
            try {
                Object v = object.next().getValue();
                ((JCheckBoxMenuItem)v).setSelected(false);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                throw runtimeException;
            }
        }
        object = (JCheckBoxMenuItem)this.secondaryActionButtonMap.get(mouseModule);
        if (object != null) {
            ((AbstractButton)object).setSelected(true);
        }
        this.secondarySelectedItem = object;
        this.secondary = mouseModule;
    }

    public void setTertiaryModule(MouseModule mouseModule) {
        this.tertiary = mouseModule;
    }

    private JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.popupListener = this.createPopupMenuListener();
        Action[] actionArray = this.parent.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setAction(actionArray[i]);
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.addSeparator();
        Action[] actionArray2 = DasCanvas.getActions();
        for (int i = 0; i < actionArray2.length; ++i) {
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setAction(actionArray2[i]);
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.addSeparator();
        return jPopupMenu;
    }

    private ActionListener createPopupMenuListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DasMouseInputAdapter dasMouseInputAdapter = DasMouseInputAdapter.this;
                String string = actionEvent.getActionCommand();
                if (string.equals("properties")) {
                    DasMouseInputAdapter.this.parent.showProperties();
                } else if (string.equals("print")) {
                    Printable printable = ((DasCanvas)DasMouseInputAdapter.this.parent.getParent()).getPrintable();
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    printerJob.setPrintable(printable);
                    if (printerJob.printDialog()) {
                        try {
                            printerJob.print();
                        }
                        catch (PrinterException printerException) {
                            Object[] objectArray = new Object[]{"Error printing", printerException.getMessage()};
                            JOptionPane.showMessageDialog(null, objectArray, "ERROR", 0);
                        }
                    }
                } else if (string.equals("toPng")) {
                    Object object;
                    if (DasMouseInputAdapter.this.pngFileNamePanel == null) {
                        DasMouseInputAdapter.this.pngFileNamePanel = new JPanel();
                        DasMouseInputAdapter.this.pngFileNamePanel.setLayout(new BoxLayout(DasMouseInputAdapter.this.pngFileNamePanel, 0));
                        DasMouseInputAdapter.this.pngFileTextField = new JTextField(32);
                        DasMouseInputAdapter.this.pngFileTextField.setMaximumSize(DasMouseInputAdapter.this.pngFileTextField.getPreferredSize());
                        DasMouseInputAdapter.this.pngFileChooser = new JFileChooser();
                        DasMouseInputAdapter.this.pngFileChooser.setApproveButtonText("Select File");
                        DasMouseInputAdapter.this.pngFileChooser.setDialogTitle("Write to PNG");
                        object = new JButton("Browse");
                        ((AbstractButton)object).setActionCommand("pngBrowse");
                        ((AbstractButton)object).addActionListener(this);
                        DasMouseInputAdapter.this.pngFileNamePanel.add(DasMouseInputAdapter.this.pngFileTextField);
                        DasMouseInputAdapter.this.pngFileNamePanel.add((Component)object);
                    }
                    DasMouseInputAdapter.this.pngFileTextField.setText(DasMouseInputAdapter.this.pngFileChooser.getCurrentDirectory().getPath());
                    object = new String[]{"Write to PNG", "Cancel"};
                    int n = JOptionPane.showOptionDialog(DasMouseInputAdapter.this.parent, DasMouseInputAdapter.this.pngFileNamePanel, "Write to PNG", 0, 3, null, (Object[])object, "Ok");
                    if (n == 0) {
                        DasCanvas dasCanvas = (DasCanvas)DasMouseInputAdapter.this.parent.getParent();
                        try {
                            dasCanvas.writeToPng(DasMouseInputAdapter.this.pngFileTextField.getText());
                        }
                        catch (IOException iOException) {
                            DasExceptionHandler.handle(iOException);
                        }
                    }
                } else if (string.equals("pngBrowse")) {
                    int n = DasMouseInputAdapter.this.pngFileChooser.showDialog(DasMouseInputAdapter.this.parent, "Select File");
                    if (n == 0) {
                        DasMouseInputAdapter.this.pngFileTextField.setText(DasMouseInputAdapter.this.pngFileChooser.getSelectedFile().getPath());
                    }
                } else if (!string.equals("close")) {
                    if (string.equals("primary")) {
                        if (DasMouseInputAdapter.this.primarySelectedItem != null) {
                            DasMouseInputAdapter.this.primarySelectedItem.setSelected(false);
                        }
                        for (int i = 0; i < DasMouseInputAdapter.this.modules.size(); ++i) {
                            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)DasMouseInputAdapter.this.primaryActionButtonMap.get(DasMouseInputAdapter.this.modules.get(i));
                            if (!jCheckBoxMenuItem.isSelected()) continue;
                            DasMouseInputAdapter.this.primarySelectedItem = jCheckBoxMenuItem;
                            break;
                        }
                        DasMouseInputAdapter.this.primarySelectedItem.setSelected(true);
                    } else if (string.equals("secondary")) {
                        if (DasMouseInputAdapter.this.secondarySelectedItem != null) {
                            DasMouseInputAdapter.this.secondarySelectedItem.setSelected(false);
                        }
                        Point point = DasMouseInputAdapter.this.secondaryPopupLocation;
                        for (int i = 0; i < DasMouseInputAdapter.this.modules.size(); ++i) {
                            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)DasMouseInputAdapter.this.secondaryActionButtonMap.get(DasMouseInputAdapter.this.modules.get(i));
                            if (!jCheckBoxMenuItem.isSelected()) continue;
                            DasMouseInputAdapter.this.secondarySelectedItem = jCheckBoxMenuItem;
                            break;
                        }
                    } else {
                        DasDie.println("" + string);
                    }
                }
            }
        };
    }

    private void renderSelection(Graphics2D graphics2D) {
        try {
            for (int i = 0; i < this.active.size(); ++i) {
                DasCanvas dasCanvas = this.parent.getCanvas();
                this.selectionStart = SwingUtilities.convertPoint(dasCanvas, this.dSelectionStart, this.parent);
                this.selectionEnd = SwingUtilities.convertPoint(dasCanvas, this.dSelectionEnd, this.parent);
                DragRenderer dragRenderer = ((MouseModule)this.active.get(i)).getDragRenderer();
                Rectangle[] rectangleArray = dragRenderer.renderDrag(graphics2D, this.selectionStart, this.selectionEnd);
                this.dirtyBoundsList = new Rectangle[rectangleArray.length];
                for (i = 0; i < rectangleArray.length; ++i) {
                    this.dirtyBoundsList[i] = new Rectangle(rectangleArray[i]);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            DasExceptionHandler.handle(runtimeException);
        }
    }

    private synchronized void refresh() {
        if (this.dirtyBoundsList.length > 0) {
            int n;
            Rectangle[] rectangleArray = new Rectangle[this.dirtyBoundsList.length];
            for (n = 0; n < rectangleArray.length; ++n) {
                if (this.dirtyBoundsList[n] == null) continue;
                rectangleArray[n] = new Rectangle(this.dirtyBoundsList[n]);
            }
            for (n = 0; n < rectangleArray.length; ++n) {
                if (rectangleArray[n] == null) continue;
                this.parent.paintImmediately(rectangleArray[n]);
            }
            for (n = 0; n < this.dirtyBoundsList.length; ++n) {
                if (this.dirtyBoundsList[n] == null) continue;
                this.parent.paintImmediately(this.dirtyBoundsList[n]);
            }
        } else if (this.active != null) {
            this.parent.paintImmediately(0, 0, this.parent.getWidth(), this.parent.getHeight());
        }
        if (this.active == null) {
            this.dirtyBoundsList = new Rectangle[0];
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.active != null) {
            this.renderSelection(graphics2D);
        }
        if (this.hasFocus && this.hoverHighlite) {
            graphics2D.translate(-this.parent.getX(), -this.parent.getY());
            graphics2D.setColor(new Color(255, 0, 0, 10));
            graphics2D.setStroke(new BasicStroke(10.0f));
            graphics2D.draw(this.parent.getBounds());
        }
    }

    private MouseMode activateMouseMode(MouseEvent mouseEvent) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.parent.getRow() != DasRow.NULL && this.parent.getColumn() != DasColumn.NULL) {
            int n = this.parent.getColumn().getDMinimum() - this.xOffset;
            int n2 = this.parent.getColumn().getDMaximum() - this.xOffset;
            int n3 = this.parent.getRow().getDMinimum() - this.yOffset;
            int n4 = this.parent.getRow().getDMaximum() - this.yOffset;
            bl = mouseEvent.getX() < n + 10;
            bl2 = mouseEvent.getX() > n2 - 10;
            bl3 = mouseEvent.getY() < n3 + 10 && mouseEvent.getY() >= n3;
            bl4 = mouseEvent.getY() > n4 - 10;
        }
        MouseMode mouseMode = MouseMode.idle;
        Cursor cursor = new Cursor(0);
        if (!(this.parent instanceof DasAxis)) {
            if ((mouseEvent.getModifiersEx() & 0x40) == 64) {
                if (bl) {
                    if (bl3) {
                        mouseMode = MouseMode.resize;
                        cursor = new Cursor(6);
                    } else if (bl4) {
                        mouseMode = MouseMode.resize;
                        cursor = new Cursor(4);
                    }
                } else if (bl2) {
                    if (bl3) {
                        mouseMode = MouseMode.resize;
                        cursor = new Cursor(7);
                    } else if (bl4) {
                        mouseMode = MouseMode.resize;
                        cursor = new Cursor(5);
                    }
                }
            } else if ((mouseEvent.getModifiersEx() & 0x80) == 128) {
                if (bl) {
                    if (bl3) {
                        mouseMode = MouseMode.move;
                        cursor = new Cursor(13);
                    } else if (bl4) {
                        mouseMode = MouseMode.move;
                        cursor = new Cursor(13);
                    }
                } else if (bl2) {
                    if (bl3) {
                        mouseMode = MouseMode.move;
                        cursor = new Cursor(13);
                    } else if (bl4) {
                        mouseMode = MouseMode.move;
                        cursor = new Cursor(13);
                    }
                }
            }
        }
        Shape shape = null;
        if (this.hotSpots != null) {
            Vector vector = this.hotSpots;
            for (int i = 0; i < vector.size(); ++i) {
                Shape shape2 = (Shape)vector.get(i);
                if (!shape2.contains(mouseEvent.getX(), mouseEvent.getY())) continue;
                cursor = new Cursor(12);
                mouseMode = MouseMode.hotSpot;
                shape = shape2;
            }
        }
        if (mouseMode == MouseMode.resize) {
            mouseMode.resizeBottom = bl4;
            mouseMode.resizeTop = bl3;
            mouseMode.resizeRight = bl2;
            mouseMode.resizeLeft = bl;
        } else if (mouseMode == MouseMode.move) {
            mouseMode.moveStart = mouseEvent.getPoint();
        }
        if (mouseMode != this.mouseMode) {
            this.getGlassPane().setCursor(cursor);
            if (this.mouseMode == MouseMode.hotSpot && mouseMode != MouseMode.hotSpot) {
                this.parent.repaint(this.dirtyBounds);
                this.dirtyBounds = null;
            } else if (mouseMode == MouseMode.hotSpot && this.mouseMode != MouseMode.hotSpot) {
                Graphics2D graphics2D = (Graphics2D)this.parent.getGraphics();
                graphics2D.setColor(new Color(0, 200, 255, 50));
                graphics2D.fill(shape);
                this.dirtyBounds = shape.getBounds();
            }
        }
        return mouseMode;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.log.finest("mouseMoved");
        Point point = this.parent.getLocation();
        this.xOffset = point.x;
        this.yOffset = point.y;
        MouseMode mouseMode = this.activateMouseMode(mouseEvent);
        this.mouseMode = mouseMode != null ? mouseMode : MouseMode.idle;
    }

    private void showPopup(JPopupMenu jPopupMenu, Point point) {
        this.log.finest("showPopup");
        HashMap hashMap = null;
        if (jPopupMenu == this.primaryPopup) {
            hashMap = this.primaryActionButtonMap;
        } else if (jPopupMenu == this.secondaryPopup) {
            hashMap = this.secondaryActionButtonMap;
        } else {
            throw new IllegalArgumentException("menu must be primary or secondary popup menu");
        }
        for (MouseModule mouseModule : this.modules) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(mouseModule);
            jCheckBoxMenuItem.setText(mouseModule.getLabel());
        }
        jPopupMenu.show(this.parent, point.x, point.y);
    }

    public void setPinned(boolean bl) {
        this.pinned = bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        block21: {
            block19: {
                block20: {
                    this.log.finest("mousePressed " + this.mouseMode);
                    if (this.pinned) {
                        this.active = null;
                        this.refresh();
                    }
                    this.pinned = false;
                    Point point = this.parent.getLocation();
                    this.parent.requestFocus();
                    this.xOffset = point.x;
                    this.yOffset = point.y;
                    this.pressPosition = mouseEvent.getPoint();
                    if (this.mouseMode != MouseMode.resize) break block19;
                    this.resizeStart = new Point(0, 0);
                    this.graphics = (Graphics2D)this.getGlassPane().getGraphics();
                    this.graphics.translate(this.parent.getX(), this.parent.getY());
                    if (this.mouseMode.resizeRight) {
                        this.resizeStart.x = 0;
                    } else if (this.mouseMode.resizeLeft) {
                        this.resizeStart.x = this.parent.getWidth();
                    }
                    if (!this.mouseMode.resizeTop) break block20;
                    this.resizeStart.y = this.parent.getHeight();
                    break block21;
                }
                if (!this.mouseMode.resizeBottom) break block21;
                this.resizeStart.y = 0;
                break block21;
            }
            if (this.mouseMode == MouseMode.move) {
                this.mouseMode.moveStart = mouseEvent.getPoint();
                this.graphics = (Graphics2D)this.getGlassPane().getGraphics();
                this.graphics.translate(this.parent.getX(), this.parent.getY());
            } else if (this.mouseMode == MouseMode.hotSpot) {
                Vector vector = this.hotSpots;
                for (int i = 0; i < vector.size(); ++i) {
                    if (!((Shape)vector.get(i)).contains(mouseEvent.getX(), mouseEvent.getY())) continue;
                    this.primary.hotSpotPressed((Shape)vector.get(i));
                }
            } else if (this.active == null) {
                this.button = mouseEvent.getButton();
                this.selectionStart = mouseEvent.getPoint();
                this.dSelectionStart = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.parent.getCanvas());
                this.selectionEnd = mouseEvent.getPoint();
                this.dSelectionEnd = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.parent.getCanvas());
                this.graphics = (Graphics2D)this.parent.getGraphics();
                if (mouseEvent.isControlDown() || this.button == 3) {
                    if (this.button == 1 || this.button == 3) {
                        this.showPopup(this.primaryPopup, mouseEvent.getPoint());
                    } else {
                        this.showPopup(this.secondaryPopup, mouseEvent.getPoint());
                    }
                } else {
                    Object object;
                    int n;
                    this.active = new Vector();
                    if (this.button == 1 || this.button == 3) {
                        for (n = 0; n < this.modules.size(); ++n) {
                            object = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(this.modules.get(n));
                            if (!((AbstractButton)object).isSelected()) continue;
                            this.active.add(this.modules.get(n));
                        }
                    } else {
                        for (n = 0; n < this.modules.size(); ++n) {
                            object = (JCheckBoxMenuItem)this.secondaryActionButtonMap.get(this.modules.get(n));
                            if (!((AbstractButton)object).isSelected()) continue;
                            this.active.add(this.modules.get(n));
                        }
                    }
                    this.mouseMode = MouseMode.moduleDrag;
                    this.mousePointSelection.set(mouseEvent.getX() + this.xOffset, mouseEvent.getY() + this.yOffset);
                    for (n = 0; n < this.active.size(); ++n) {
                        object = (MouseModule)this.active.get(n);
                        ((MouseModule)object).mousePressed(mouseEvent);
                        if (!((MouseModule)object).dragRenderer.isPointSelection()) continue;
                        this.mouseDragged(mouseEvent);
                    }
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.log.finest("mouseDragged in " + this.mouseMode);
        if (this.mouseMode == MouseMode.resize) {
            this.resizeRenderer.clear(this.graphics);
            this.resizeRenderer.renderDrag(this.graphics, this.resizeStart, mouseEvent.getPoint());
        } else if (this.mouseMode == MouseMode.move) {
            Point point = mouseEvent.getPoint();
            int n = point.x - this.mouseMode.moveStart.x;
            int n2 = point.y - this.mouseMode.moveStart.y;
            int n3 = this.parent.getColumn().getDMinimum();
            int n4 = this.parent.getColumn().getDMaximum();
            int n5 = this.parent.getRow().getDMinimum();
            int n6 = this.parent.getRow().getDMaximum();
            Point point2 = new Point(n3 + n - this.parent.getX(), n5 + n2 - this.parent.getY());
            Point point3 = new Point(n4 + n - this.parent.getX(), n6 + n2 - this.parent.getY());
            this.resizeRenderer.clear(this.graphics);
            this.resizeRenderer.renderDrag(this.graphics, point2, point3);
        } else if (this.active != null) {
            this.selectionEnd = mouseEvent.getPoint();
            this.dSelectionEnd = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.parent.getCanvas());
            this.mousePointSelection.set((int)this.dSelectionEnd.getX(), (int)this.dSelectionEnd.getY());
            for (int i = 0; i < this.active.size(); ++i) {
                try {
                    MouseModule mouseModule = (MouseModule)this.active.get(i);
                    if (mouseModule.dragRenderer.isPointSelection()) {
                        this.log.finest("mousePointSelected");
                        mouseModule.mousePointSelected(this.mousePointSelection);
                    }
                    if (mouseModule.dragRenderer.isUpdatingDragSelection()) {
                        MouseDragEvent mouseDragEvent = mouseModule.dragRenderer.getMouseDragEvent(this.parent, this.dSelectionStart, this.dSelectionEnd, mouseEvent.isShiftDown());
                        this.log.finest("mouseRangeSelected");
                        mouseModule.mouseRangeSelected(mouseDragEvent);
                    }
                    mouseModule.mouseDragged(mouseEvent);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    DasExceptionHandler.handle(runtimeException);
                }
            }
            this.refresh();
        }
    }

    private void performResize(MouseEvent mouseEvent) {
        DasCanvas dasCanvas = (DasCanvas)this.parent.getParent();
        int n = this.parent.getColumn().getDMinimum();
        int n2 = this.parent.getColumn().getDMaximum();
        int n3 = this.parent.getRow().getDMinimum();
        int n4 = this.parent.getRow().getDMaximum();
        int n5 = mouseEvent.getX() + this.xOffset;
        int n6 = mouseEvent.getY() + this.yOffset;
        if (this.mouseMode.resizeRight) {
            n2 = n5;
        } else if (this.mouseMode.resizeLeft) {
            n = n5;
        }
        if (this.mouseMode.resizeTop) {
            n3 = n6;
        } else if (this.mouseMode.resizeBottom) {
            n4 = n6;
        }
        this.parent.getColumn().setDPosition(n, n2);
        this.parent.getRow().setDPosition(n3, n4);
        this.parent.resize();
        this.getGlassPane().setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        this.log.finest("mouseReleased");
        if (this.mouseMode == MouseMode.resize) {
            this.performResize(mouseEvent);
        } else if (this.mouseMode == MouseMode.move) {
            this.performMove(mouseEvent);
        } else if (mouseEvent.getButton() == this.button && this.active != null) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            for (int i = 0; i < this.active.size(); ++i) {
                MouseModule mouseModule = (MouseModule)this.active.get(i);
                try {
                    MouseDragEvent mouseDragEvent = mouseModule.dragRenderer.getMouseDragEvent(this.parent, this.dSelectionStart, this.dSelectionEnd, mouseEvent.isShiftDown());
                    mouseModule.mouseRangeSelected(mouseDragEvent);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    DasExceptionHandler.handle(runtimeException);
                    continue;
                }
                finally {
                    this.button = 0;
                    try {
                        mouseModule.mouseReleased(mouseEvent);
                    }
                    catch (RuntimeException runtimeException) {
                        DasExceptionHandler.handle(runtimeException);
                    }
                }
            }
            if (!this.pinned) {
                this.active = null;
                this.refresh();
            }
        }
    }

    public void removeMouseModule(MouseModule mouseModule) {
    }

    public MouseModule getMouseModule(int n) {
        return (MouseModule)this.modules.get(n);
    }

    public MouseModule[] getMouseModules() {
        Object[] objectArray = new MouseModule[this.modules.size()];
        this.modules.copyInto(objectArray);
        return objectArray;
    }

    public String getPrimaryModuleLabel() {
        return this.primary == null ? "" : this.primary.getLabel();
    }

    public void setPrimaryModuleByLabel(String string) {
        MouseModule mouseModule = this.getModuleByLabel(string);
        if (mouseModule != null) {
            this.setPrimaryModule(mouseModule);
        }
    }

    public String getSecondaryModuleLabel() {
        return this.secondary == null ? "" : this.secondary.getLabel();
    }

    public void setSecondaryModuleByLabel(String string) {
        MouseModule mouseModule = this.getModuleByLabel(string);
        if (mouseModule != null) {
            this.setSecondaryModule(mouseModule);
        }
    }

    public void setMouseModule(int n, MouseModule mouseModule) {
        this.modules.set(n, mouseModule);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.hasFocus = true;
        this.parent.repaint();
        if (this.primary != null) {
            this.hotSpots = this.primary.getHotSpots();
            this.getGlassPane().setCursor(this.primary.getCursor());
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.hasFocus = false;
        this.parent.repaint();
        if (this.mouseMode == MouseMode.hotSpot) {
            this.parent.repaint(this.dirtyBounds);
            this.mouseMode = MouseMode.idle;
        }
        this.getGlassPane().setCursor(Cursor.getDefaultCursor());
    }

    public void addMenuItem(Component component) {
        if (this.numInserted == 0) {
            this.primaryPopup.insert(new JPopupMenu.Separator(), 0);
        }
        this.primaryPopup.insert(component, this.numInserted);
        ++this.numInserted;
    }

    private Component getGlassPane() {
        return ((DasCanvas)this.parent.getParent()).getGlassPane();
    }

    public MouseModule getModuleByLabel(String string) {
        MouseModule mouseModule = null;
        for (int i = 0; i < this.modules.size(); ++i) {
            if (!string.equals(((MouseModule)this.modules.get(i)).getLabel())) continue;
            mouseModule = (MouseModule)this.modules.get(i);
        }
        return mouseModule;
    }

    public boolean isHoverHighlite() {
        return this.hoverHighlite;
    }

    public void setHoverHighlite(boolean bl) {
        this.hoverHighlite = bl;
    }

    public Point getMousePressPosition() {
        return this.pressPosition;
    }

    private void performMove(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = point.x - this.mouseMode.moveStart.x;
        int n2 = point.y - this.mouseMode.moveStart.y;
        int n3 = this.parent.getColumn().getDMinimum();
        int n4 = this.parent.getColumn().getDMaximum();
        this.parent.getColumn().setDPosition(n3 + n, n4 + n);
        n3 = this.parent.getRow().getDMinimum();
        n4 = this.parent.getRow().getDMaximum();
        this.parent.getRow().setDPosition(n3 + n2, n4 + n2);
    }

    private static class MouseMode {
        String s;
        boolean resizeTop = false;
        boolean resizeBottom = false;
        boolean resizeRight = false;
        boolean resizeLeft = false;
        Point moveStart = null;
        static MouseMode idle = new MouseMode("idle");
        static MouseMode resize = new MouseMode("resize");
        static MouseMode move = new MouseMode("move");
        static MouseMode moduleDrag = new MouseMode("moduleDrag");
        static MouseMode hotSpot = new MouseMode("hotSpot");

        MouseMode(String string) {
            this.s = string;
        }

        public String toString() {
            return this.s;
        }
    }
}

