/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.DefaultDatumFormatterFactory;
import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.LabelDragRenderer;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.text.ParseException;

public class CrossHairRenderer
extends LabelDragRenderer
implements DragRenderer,
Editable {
    protected int xInitial;
    protected int yInitial;
    protected DataSet ds;
    protected DasAxis XAxis;
    protected DasAxis YAxis;
    protected DasPlot parent;
    private int ix = 0;
    private int iy = 0;
    private int context;
    private DatumFormatter nfx;
    private DatumFormatter nfy;
    private DatumFormatter nfz;
    private FontMetrics fm;
    private int dxMax = -999999;
    private Rectangle hDirtyBounds;
    private Rectangle vDirtyBounds;
    private Point crossHairLocation = null;
    private DataSetConsumer dataSetConsumer;
    private boolean allPlanesReport;
    private boolean debugging;
    private boolean snapping;
    private boolean multiLine = false;

    public CrossHairRenderer(DasPlot dasPlot, DataSetConsumer dataSetConsumer, DasAxis dasAxis, DasAxis dasAxis2) {
        super(dasPlot);
        this.XAxis = dasAxis;
        this.YAxis = dasAxis2;
        this.parent = dasPlot;
        this.dataSetConsumer = dataSetConsumer;
        this.hDirtyBounds = new Rectangle();
        this.vDirtyBounds = new Rectangle();
    }

    private DatumFormatter addResolutionToFormat(DatumFormatter datumFormatter) throws ParseException {
        String[] stringArray;
        String string = datumFormatter.toString();
        String string2 = string.indexOf(69) == -1 ? string + "00" : ((stringArray = string.split("E"))[0].indexOf(46) == -1 ? stringArray[0] + ".00" + "E0" : stringArray[0] + "00" + "E0");
        return DefaultDatumFormatterFactory.getInstance().newFormatter(string2);
    }

    private String getZString(TableDataSet tableDataSet, Datum datum, Datum datum2, int[] nArray) {
        String[] stringArray;
        int n = DataSetUtil.closestColumn(tableDataSet, datum);
        int n2 = TableUtil.closestRow(tableDataSet, tableDataSet.tableOfIndex(n), datum2);
        Datum datum3 = tableDataSet.getDatum(n, n2);
        if (nArray != null) {
            nArray[0] = n;
            nArray[1] = n2;
        }
        try {
            if (this.dataSetConsumer instanceof TableDataSetConsumer) {
                this.nfz = ((TableDataSetConsumer)this.dataSetConsumer).getZAxis().getDatumFormatter();
                this.nfz = this.addResolutionToFormat(this.nfz);
            } else {
                this.nfz = DefaultDatumFormatterFactory.getInstance().newFormatter("0.000");
            }
        }
        catch (ParseException parseException) {
            DasProperties.getLogger().severe("failure to create formatter");
            stringArray = ((TableDataSetConsumer)this.dataSetConsumer).getZAxis();
            stringArray.getUnits().getDatumFormatterFactory().defaultFormatter();
        }
        String string = datum3.isFill() ? "fill" : this.nfz.grannyFormat(datum3);
        if (this.allPlanesReport) {
            if (this.debugging) {
                string = string + "!c" + tableDataSet.toString();
            }
            stringArray = tableDataSet.getPlaneIds();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("")) continue;
                string = string + "!c";
                string = string + stringArray[i] + ":" + this.nfz.grannyFormat(((TableDataSet)tableDataSet.getPlanarView(stringArray[i])).getDatum(n, n2));
                if (!this.debugging) continue;
                string = string + " " + ((TableDataSet)tableDataSet.getPlanarView(stringArray[i])).toString();
            }
            if (this.debugging) {
                string = string + "!ci:" + n + " j:" + n2;
            }
        }
        return string;
    }

    public Rectangle[] renderDrag(Graphics graphics, Point point, Point point2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(DasProperties.getRenderingHints());
        this.ds = this.dataSetConsumer.getDataSet();
        Object var5_5 = null;
        if (this.crossHairLocation == null) {
            String string;
            String string2;
            DasAxis dasAxis = this.XAxis == null ? this.parent.getXAxis() : this.XAxis;
            DasAxis dasAxis2 = this.YAxis == null ? this.parent.getYAxis() : this.YAxis;
            Datum datum = dasAxis.invTransform(point2.x + this.parent.getX());
            Datum datum2 = dasAxis2.invTransform(point2.y + this.parent.getY());
            this.nfy = datum2.getFormatter();
            this.nfx = datum.getFormatter();
            String string3 = this.nfx.format(datum);
            String string4 = this.nfy.format(datum2);
            String string5 = string2 = this.multiLine ? "!c" : " ";
            if (this.ds instanceof TableDataSet) {
                String string6;
                TableDataSet tableDataSet = (TableDataSet)this.ds;
                if (this.snapping) {
                    int[] nArray = new int[2];
                    string6 = this.getZString(tableDataSet, datum, datum2, nArray);
                    datum = tableDataSet.getXTagDatum(nArray[0]);
                    string3 = this.nfx.format(datum);
                    datum2 = tableDataSet.getYTagDatum(tableDataSet.tableOfIndex(nArray[0]), nArray[1]);
                    string4 = this.nfy.format(datum2);
                } else {
                    string6 = this.getZString(tableDataSet, datum, datum2, null);
                }
                string = "x:" + string3 + string2 + "y:" + string4 + string2 + "z:" + string6;
            } else {
                string = "x:" + string3 + string2 + "y:" + string4;
            }
            this.setLabel(string);
            super.renderDrag(graphics2D, point, point2);
        }
        this.drawCrossHair(graphics2D, point2);
        return new Rectangle[]{this.hDirtyBounds, this.vDirtyBounds, this.dirtyBounds};
    }

    private void drawCrossHair(Graphics graphics, Point point) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Color color = Color.black;
        graphics2D.setColor(color);
        Dimension dimension = this.parent.getSize();
        this.hDirtyBounds.setBounds(0, point.y - 1, dimension.width, 3);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(ghostColor);
        graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
        graphics2D.drawLine(0, point.y, dimension.width, point.y);
        graphics2D.drawLine(point.x, 0, point.x, dimension.height);
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
        graphics2D.drawLine(0, point.y, dimension.width, point.y);
        this.vDirtyBounds.setBounds(point.x - 1, 0, 3, dimension.height);
        graphics2D.drawLine(point.x, 0, point.x, dimension.height);
        graphics2D.dispose();
    }

    public void clear(Graphics graphics) {
        super.clear(graphics);
        this.parent.paintImmediately(this.hDirtyBounds);
        this.parent.paintImmediately(this.vDirtyBounds);
    }

    public boolean isPointSelection() {
        return true;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }

    public boolean isAllPlanesReport() {
        return this.allPlanesReport;
    }

    public void setAllPlanesReport(boolean bl) {
        this.allPlanesReport = bl;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean bl) {
        this.debugging = bl;
    }

    public Rectangle[] getDirtyBounds() {
        return new Rectangle[]{this.dirtyBounds, this.hDirtyBounds, this.vDirtyBounds};
    }

    public boolean isSnapping() {
        return this.snapping;
    }

    public void setSnapping(boolean bl) {
        this.snapping = bl;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean bl) {
        this.multiLine = bl;
    }
}

