/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.event.CrossHairRenderer;
import edu.uiowa.physics.pw.das.event.DataPointSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionListener;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MousePointSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import javax.swing.event.EventListenerList;

public class CrossHairMouseModule
extends MouseModule {
    private DasAxis xaxis;
    private DasAxis yaxis;
    private DasPlot plot;
    protected DataPointSelectionEvent de;
    DataSetConsumer dataSetConsumer;
    private EventListenerList listenerList = null;

    public CrossHairMouseModule(DasPlot dasPlot, DasAxis dasAxis, DasAxis dasAxis2) {
        this(dasPlot, dasPlot, dasAxis, dasAxis2);
    }

    public CrossHairMouseModule(DasPlot dasPlot, DataSetConsumer dataSetConsumer, DasAxis dasAxis, DasAxis dasAxis2) {
        super(dasPlot, new CrossHairRenderer(dasPlot, dataSetConsumer, dasAxis, dasAxis2), "Crosshair Digitizer");
        this.plot = dasPlot;
        this.dataSetConsumer = dataSetConsumer;
        this.xaxis = dasAxis;
        this.yaxis = dasAxis2;
        this.de = new DataPointSelectionEvent(this, null, null);
    }

    public static CrossHairMouseModule create(DasPlot dasPlot) {
        DasAxis dasAxis = null;
        DasAxis dasAxis2 = null;
        return new CrossHairMouseModule(dasPlot, dasPlot, dasAxis, dasAxis2);
    }

    protected DataPointSelectionEvent getDataPointSelectionEvent(MousePointSelectionEvent mousePointSelectionEvent) {
        this.de.setDataSet(this.dataSetConsumer.getDataSet());
        DasAxis dasAxis = this.xaxis == null ? this.plot.getXAxis() : this.xaxis;
        DasAxis dasAxis2 = this.yaxis == null ? this.plot.getYAxis() : this.yaxis;
        this.de.set(dasAxis.invTransform(mousePointSelectionEvent.getX()), dasAxis2.invTransform(mousePointSelectionEvent.getY()));
        return this.de;
    }

    public void mousePointSelected(MousePointSelectionEvent mousePointSelectionEvent) {
        this.fireDataPointSelectionListenerDataPointSelected(this.getDataPointSelectionEvent(mousePointSelectionEvent));
    }

    public synchronized void addDataPointSelectionListener(DataPointSelectionListener dataPointSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataPointSelectionListener.class, dataPointSelectionListener);
    }

    public synchronized void removeDataPointSelectionListener(DataPointSelectionListener dataPointSelectionListener) {
        this.listenerList.remove(DataPointSelectionListener.class, dataPointSelectionListener);
    }

    protected void fireDataPointSelectionListenerDataPointSelected(DataPointSelectionEvent dataPointSelectionEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DataPointSelectionListener.class) continue;
            ((DataPointSelectionListener)objectArray[i + 1]).DataPointSelected(dataPointSelectionEvent);
        }
    }
}

