/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.BoxRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.event.Gesture;
import edu.uiowa.physics.pw.das.event.MouseBoxEvent;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BoxZoomMouseModule
extends BoxRangeSelectorMouseModule {
    DatumRange xrange;
    DatumRange yrange;
    JDialog dialog;
    JLabel xrangeLabel;
    JLabel yrangeLabel;
    JCheckBox autoUpdateCB;
    JCheckBox constrainProportionsCB;
    boolean autoUpdate = false;
    boolean constrainProportions = false;

    public BoxZoomMouseModule(DasCanvasComponent dasCanvasComponent, DataSetConsumer dataSetConsumer, DasAxis dasAxis, DasAxis dasAxis2) {
        super(dasCanvasComponent, dataSetConsumer, dasAxis, dasAxis2);
        this.setLabel("Box Zoom");
    }

    JDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(DasApplication.getDefaultApplication().getMainFrame());
            Container container = this.dialog.getContentPane();
            Box box = Box.createVerticalBox();
            container.add(box);
            this.xrangeLabel = new JLabel("X: ");
            box.add(this.xrangeLabel);
            this.xrangeLabel.setPreferredSize(new Dimension(110, 20));
            this.yrangeLabel = new JLabel("Y: ");
            box.add(this.yrangeLabel);
            this.yrangeLabel.setPreferredSize(new Dimension(110, 20));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            JButton jButton = new JButton(this.getZoomXAction());
            JButton jButton2 = new JButton(this.getZoomYAction());
            Insets insets = jButton2.getMargin();
            insets.left = 5;
            insets.right = 5;
            jButton2.setMargin(insets);
            JButton jButton3 = new JButton(this.getZoomBoxAction());
            jPanel.add((Component)jButton2, "West");
            jPanel.add((Component)jButton3, "Center");
            jPanel.add((Component)jButton, "South");
            box.add(jPanel);
            final JCheckBox jCheckBox = new JCheckBox("auto box zoom");
            jCheckBox.setSelected(this.autoUpdate);
            box.add(jCheckBox);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BoxZoomMouseModule.this.autoUpdate = jCheckBox.isSelected();
                }
            });
            this.autoUpdateCB = jCheckBox;
            if (this.xAxis.getUnits() == this.yAxis.getUnits()) {
                final JCheckBox jCheckBox2 = new JCheckBox("constrain proportions");
                jCheckBox2.setSelected(this.constrainProportions);
                box.add(jCheckBox2);
                jCheckBox2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BoxZoomMouseModule.this.constrainProportions = jCheckBox2.isSelected();
                    }
                });
                this.constrainProportionsCB = jCheckBox2;
            }
            this.dialog.pack();
        }
        this.dialog.setVisible(true);
        return this.dialog;
    }

    Action getZoomYAction() {
        return new AbstractAction("<html><center>z<br>o<br>o<br>m<br>Y</center></html>"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BoxZoomMouseModule.this.yrange != null) {
                    BoxZoomMouseModule.this.yAxis.setDatumRange(BoxZoomMouseModule.this.yrange);
                }
            }
        };
    }

    Action getZoomXAction() {
        return new AbstractAction("zoom X"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BoxZoomMouseModule.this.xrange != null) {
                    BoxZoomMouseModule.this.xAxis.setDatumRange(BoxZoomMouseModule.this.xrange);
                }
            }
        };
    }

    Action getZoomBoxAction() {
        return new AbstractAction("<html><center>Zoom<br>Box</center></html>"){

            public void actionPerformed(ActionEvent actionEvent) {
                BoxZoomMouseModule.this.zoomBox();
            }
        };
    }

    private void zoomBox() {
        if (this.yrange != null) {
            this.yAxis.setDatumRange(this.yrange);
        }
        if (this.xrange != null) {
            this.xAxis.setDatumRange(this.xrange);
        }
    }

    public void mouseRangeSelected(MouseDragEvent mouseDragEvent) {
        if (mouseDragEvent instanceof MouseBoxEvent) {
            MouseBoxEvent mouseBoxEvent = (MouseBoxEvent)mouseDragEvent;
            this.xrange = new DatumRange(this.xAxis.invTransform(mouseBoxEvent.getXMinimum()), this.xAxis.invTransform(mouseBoxEvent.getXMaximum()));
            this.yrange = new DatumRange(this.yAxis.invTransform(mouseBoxEvent.getYMaximum()), this.yAxis.invTransform(mouseBoxEvent.getYMinimum()));
            if (this.constrainProportions) {
                double d = (double)this.yAxis.getHeight() / (double)this.xAxis.getWidth();
                DatumRange datumRange = new DatumRange(mouseBoxEvent.getXMinimum(), mouseBoxEvent.getXMaximum(), Units.dimensionless);
                DatumRange datumRange2 = new DatumRange(mouseBoxEvent.getYMinimum(), mouseBoxEvent.getYMaximum(), Units.dimensionless);
                double d2 = datumRange2.width().divide(datumRange.width()).doubleValue(Units.dimensionless);
                if (d2 > d) {
                    double d3 = d2 / d;
                    datumRange = datumRange.rescale(0.5 - d3 / 2.0, 0.5 + d3 / 2.0);
                } else {
                    double d4 = d / d2;
                    datumRange2 = datumRange2.rescale(0.5 - d4 / 2.0, 0.5 + d4 / 2.0);
                }
                this.xrange = new DatumRange(this.xAxis.invTransform(datumRange.min().doubleValue(Units.dimensionless)), this.xAxis.invTransform(datumRange.max().doubleValue(Units.dimensionless)));
                this.yrange = new DatumRange(this.yAxis.invTransform(datumRange2.max().doubleValue(Units.dimensionless)), this.yAxis.invTransform(datumRange2.min().doubleValue(Units.dimensionless)));
            } else {
                this.xrange = new DatumRange(this.xAxis.invTransform(mouseBoxEvent.getXMinimum()), this.xAxis.invTransform(mouseBoxEvent.getXMaximum()));
                this.yrange = new DatumRange(this.yAxis.invTransform(mouseBoxEvent.getYMaximum()), this.yAxis.invTransform(mouseBoxEvent.getYMinimum()));
            }
            this.getDialog();
            this.xrangeLabel.setText("X: " + this.xrange.toString());
            this.yrangeLabel.setText("Y: " + this.yrange.toString());
            if (this.autoUpdate) {
                this.zoomBox();
            }
        } else if (mouseDragEvent.isGesture()) {
            if (mouseDragEvent.getGesture() == Gesture.ZOOMOUT) {
                this.xAxis.setDataRangeZoomOut();
                this.yAxis.setDataRangeZoomOut();
            } else if (mouseDragEvent.getGesture() == Gesture.BACK) {
                this.xAxis.setDataRangePrev();
                this.yAxis.setDataRangePrev();
            } else if (mouseDragEvent.getGesture() == Gesture.FORWARD) {
                this.xAxis.setDataRangeForward();
                this.yAxis.setDataRangeForward();
            }
        }
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean bl) {
        if (this.autoUpdateCB != null) {
            this.autoUpdateCB.setSelected(bl);
        }
        this.autoUpdate = bl;
    }

    public boolean isConstrainProportions() {
        return this.constrainProportions;
    }

    public void setConstrainProportions(boolean bl) {
        if (this.constrainProportionsCB != null) {
            this.constrainProportionsCB.setSelected(bl);
        }
        this.constrainProportions = bl;
    }
}

