/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.event.BoxSelectionEvent;
import edu.uiowa.physics.pw.das.event.BoxSelectionListener;
import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseBoxEvent;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.event.EventListenerList;

public class BoxSelectorMouseModule
extends MouseModule {
    DasAxis xaxis;
    DasAxis yaxis;
    DataSetConsumer dataSetConsumer;
    EventListenerList listenerList = null;
    MouseDragEvent lastMouseEvent;
    private boolean dragEvents = false;
    private boolean keyEvents = false;
    private boolean releaseEvents = true;

    public BoxSelectorMouseModule(DasCanvasComponent dasCanvasComponent, DasAxis dasAxis, DasAxis dasAxis2, DataSetConsumer dataSetConsumer, DragRenderer dragRenderer, String string) {
        super(dasCanvasComponent, dragRenderer, string);
        this.xaxis = dasAxis;
        this.yaxis = dasAxis2;
        this.dataSetConsumer = dataSetConsumer;
    }

    private BoxSelectionEvent getBoxSelectionEvent(MouseDragEvent mouseDragEvent) {
        Object object;
        Object object2;
        Object object3;
        MouseBoxEvent mouseBoxEvent = (MouseBoxEvent)mouseDragEvent;
        DatumRange datumRange = null;
        DatumRange datumRange2 = null;
        if (this.xaxis != null) {
            object3 = this.xaxis.invTransform(mouseBoxEvent.getXMinimum());
            if (((Datum)object3).gt((Datum)(object2 = this.xaxis.invTransform(mouseBoxEvent.getXMaximum())))) {
                object = object3;
                object3 = object2;
                object2 = object;
            }
            datumRange = new DatumRange((Datum)object3, (Datum)object2);
        }
        if (this.yaxis != null) {
            object3 = this.yaxis.invTransform(mouseBoxEvent.getYMinimum());
            if (((Datum)object3).gt((Datum)(object2 = this.yaxis.invTransform(mouseBoxEvent.getYMaximum())))) {
                object = object3;
                object3 = object2;
                object2 = object;
            }
            datumRange2 = new DatumRange((Datum)object3, (Datum)object2);
        }
        object3 = new BoxSelectionEvent(this, datumRange, datumRange2);
        return object3;
    }

    public void mouseRangeSelected(MouseDragEvent mouseDragEvent) {
        this.lastMouseEvent = mouseDragEvent;
        if (this.keyEvents) {
            this.parent.requestFocus();
        }
        if (this.dragEvents) {
            this.fireBoxSelectionListenerBoxSelected(this.getBoxSelectionEvent(mouseDragEvent));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (this.lastMouseEvent != null) {
            BoxSelectionEvent boxSelectionEvent = this.getBoxSelectionEvent(this.lastMouseEvent);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("keyChar", String.valueOf(keyEvent.getKeyChar()));
            boxSelectionEvent = new BoxSelectionEvent(this, boxSelectionEvent.getXRange(), boxSelectionEvent.getYRange(), hashMap);
            this.fireBoxSelectionListenerBoxSelected(boxSelectionEvent);
        }
    }

    public synchronized void addBoxSelectionListener(BoxSelectionListener boxSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(BoxSelectionListener.class, boxSelectionListener);
    }

    public synchronized void removeBoxSelectionListener(BoxSelectionListener boxSelectionListener) {
        this.listenerList.remove(BoxSelectionListener.class, boxSelectionListener);
    }

    protected void fireBoxSelectionListenerBoxSelected(BoxSelectionEvent boxSelectionEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != BoxSelectionListener.class) continue;
            ((BoxSelectionListener)objectArray[i + 1]).BoxSelected(boxSelectionEvent);
        }
    }

    public boolean isDragEvents() {
        return this.dragEvents;
    }

    public void setDragEvents(boolean bl) {
        this.dragEvents = bl;
    }

    public boolean isKeyEvents() {
        return this.keyEvents;
    }

    public void setKeyEvents(boolean bl) {
        this.keyEvents = bl;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (this.releaseEvents) {
            this.fireBoxSelectionListenerBoxSelected(this.getBoxSelectionEvent(this.lastMouseEvent));
        }
    }

    public boolean isReleaseEvents() {
        return this.releaseEvents;
    }

    public void setReleaseEvents(boolean bl) {
        this.releaseEvents = bl;
    }
}

