/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseBoxEvent;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class BoxRenderer
implements DragRenderer {
    Rectangle dirtyBounds;
    DasCanvasComponent parent;
    boolean updating;

    public BoxRenderer(DasCanvasComponent dasCanvasComponent, boolean bl) {
        this.parent = dasCanvasComponent;
        this.dirtyBounds = new Rectangle();
        this.updating = bl;
    }

    public BoxRenderer(DasCanvasComponent dasCanvasComponent) {
        this(dasCanvasComponent, false);
    }

    public void clear(Graphics graphics) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    public Rectangle[] renderDrag(Graphics graphics, Point point, Point point2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = new Rectangle(point);
        rectangle.add(point2);
        Color color = graphics2D.getColor();
        graphics2D.setColor(new Color(255, 255, 255, 100));
        graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setColor(color);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.dirtyBounds.setLocation(rectangle.x - 2, rectangle.y - 3);
        this.dirtyBounds.add(rectangle.x + rectangle.width + 2, rectangle.y + rectangle.height + 3);
        return new Rectangle[]{this.dirtyBounds};
    }

    public MouseDragEvent getMouseDragEvent(Object object, Point point, Point point2, boolean bl) {
        return new MouseBoxEvent(object, point, point2, bl);
    }

    public boolean isPointSelection() {
        return false;
    }

    public boolean isUpdatingDragSelection() {
        return this.updating;
    }
}

