/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.event.BoxGesturesRenderer;
import edu.uiowa.physics.pw.das.event.BoxSelectionEvent;
import edu.uiowa.physics.pw.das.event.BoxSelectionListener;
import edu.uiowa.physics.pw.das.event.MouseBoxEvent;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import javax.swing.event.EventListenerList;

public class BoxRangeSelectorMouseModule
extends MouseModule {
    protected DasAxis xAxis;
    protected DasAxis yAxis;
    private DataSetConsumer consumer;
    private EventListenerList listenerList = new EventListenerList();

    public BoxRangeSelectorMouseModule(DasCanvasComponent dasCanvasComponent, DataSetConsumer dataSetConsumer, DasAxis dasAxis, DasAxis dasAxis2) {
        super(dasCanvasComponent, new BoxGesturesRenderer(dasCanvasComponent), "Box Selection");
        if (!dasAxis.isHorizontal()) {
            throw new IllegalArgumentException("X Axis orientation is not horizontal");
        }
        if (dasAxis2.isHorizontal()) {
            throw new IllegalArgumentException("Y Axis orientation is not vertical");
        }
        this.xAxis = dasAxis;
        this.yAxis = dasAxis2;
        this.consumer = dataSetConsumer;
    }

    public static BoxRangeSelectorMouseModule create(DasPlot dasPlot) {
        BoxRangeSelectorMouseModule boxRangeSelectorMouseModule = new BoxRangeSelectorMouseModule(dasPlot, null, dasPlot.getXAxis(), dasPlot.getYAxis());
        return boxRangeSelectorMouseModule;
    }

    public void mouseRangeSelected(MouseDragEvent mouseDragEvent) {
        if (mouseDragEvent instanceof MouseBoxEvent) {
            MouseBoxEvent mouseBoxEvent = (MouseBoxEvent)mouseDragEvent;
            Datum datum = this.xAxis.invTransform(mouseBoxEvent.getXMinimum());
            Datum datum2 = this.xAxis.invTransform(mouseBoxEvent.getXMaximum());
            Datum datum3 = this.yAxis.invTransform(mouseBoxEvent.getYMinimum());
            Datum datum4 = this.yAxis.invTransform(mouseBoxEvent.getYMaximum());
            BoxSelectionEvent boxSelectionEvent = new BoxSelectionEvent(this, datum, datum2, datum3, datum4);
            if (this.consumer != null) {
                boxSelectionEvent.setDataSet(this.consumer.getDataSet());
            }
            this.fireBoxSelected(boxSelectionEvent);
        }
    }

    public void addBoxSelectionListener(BoxSelectionListener boxSelectionListener) {
        this.listenerList.add(BoxSelectionListener.class, boxSelectionListener);
    }

    public void removeBoxSelectionListener(BoxSelectionListener boxSelectionListener) {
        this.listenerList.remove(BoxSelectionListener.class, boxSelectionListener);
    }

    protected void fireBoxSelected(BoxSelectionEvent boxSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != BoxSelectionListener.class) continue;
            ((BoxSelectionListener)objectArray[i + 1]).BoxSelected(boxSelectionEvent);
        }
    }
}

