/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum.format;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeDatumFormatter
extends DatumFormatter {
    private static final int YEAR_FIELD_INDEX = 0;
    private static final int MONTH_FIELD_INDEX = 1;
    private static final int DAY_FIELD_INDEX = 2;
    private static final int DOY_FIELD_INDEX = 3;
    private static final int HOUR_FIELD_INDEX = 4;
    private static final int MINUTE_FIELD_INDEX = 5;
    private static final int SECONDS_FIELD_INDEX = 6;
    private static final int TIMESTAMP_FIELD_COUNT = 7;
    public static final TimeDatumFormatter DEFAULT;
    public static final TimeDatumFormatter DAYS;
    public static final TimeDatumFormatter YEARS;
    public static final TimeDatumFormatter MONTHS;
    public static final TimeDatumFormatter HOURS;
    public static final TimeDatumFormatter MINUTES;
    public static final TimeDatumFormatter SECONDS;
    public static final TimeDatumFormatter MILLISECONDS;
    private String formatString;
    private MessageFormat format;
    private int[] scaleSeconds;

    public TimeDatumFormatter(String string) throws ParseException {
        this.formatString = string;
        this.format = new MessageFormat(this.parseTimeFormatString(string));
    }

    public String toString() {
        return this.formatString;
    }

    public String format(Datum datum) {
        TimeUtil.TimeStruct timeStruct = TimeUtil.toTimeStruct(datum);
        Number[] numberArray = this.timeStructToArray(timeStruct);
        return this.format.format(numberArray);
    }

    private String parseTimeFormatString(String string) throws ParseException {
        Pattern pattern = Pattern.compile("(([yMDdHmsS])\\2*)|([-/:.,_ \t]+)|('(?:[^']|'')*')");
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find(n)) {
            CharSequence charSequence;
            Object object;
            int n2 = matcher.start();
            if (n2 > n) {
                object = new char[n2 + 1];
                Arrays.fill((char[])object, n, n2, '.');
                object[n] = 94;
                object[n2] = 94;
                charSequence = new StringBuffer("Unrecognized sub-pattern\n");
                ((StringBuffer)charSequence).append(string).append("\n");
                ((StringBuffer)charSequence).append((char[])object);
                throw new ParseException(((StringBuffer)charSequence).toString(), n);
            }
            object = matcher.group(1);
            charSequence = matcher.group(3);
            String string2 = matcher.group(4);
            if (object != null) {
                switch (((String)object).charAt(0)) {
                    case 'y': {
                        TimeDatumFormatter.appendSubFormat(stringBuffer, 0, ((String)object).length());
                        break;
                    }
                    case 'M': {
                        TimeDatumFormatter.appendSubFormat(stringBuffer, 1, ((String)object).length());
                        break;
                    }
                    case 'D': {
                        TimeDatumFormatter.appendSubFormat(stringBuffer, 3, ((String)object).length());
                        break;
                    }
                    case 'd': {
                        TimeDatumFormatter.appendSubFormat(stringBuffer, 2, ((String)object).length());
                        break;
                    }
                    case 'H': {
                        TimeDatumFormatter.appendSubFormat(stringBuffer, 4, ((String)object).length());
                        break;
                    }
                    case 'm': {
                        TimeDatumFormatter.appendSubFormat(stringBuffer, 5, ((String)object).length());
                        break;
                    }
                    case 's': {
                        TimeDatumFormatter.appendSubFormat(stringBuffer, 6, ((String)object).length());
                        break;
                    }
                    case 'S': {
                        int n3 = ((String)object).length();
                        int n4 = this.addScaleFactor(n3);
                        TimeDatumFormatter.appendSubFormat(stringBuffer, n4, n3);
                        break;
                    }
                }
            } else if (charSequence != null) {
                stringBuffer.append((String)charSequence);
            } else if (string2 != null) {
                string2 = string2.substring(1, string2.length() - 1);
                string2 = string2.replaceAll("''", "'");
                stringBuffer.append(string2);
            }
            n = matcher.end();
        }
        return stringBuffer.toString();
    }

    private static void appendSubFormat(StringBuffer stringBuffer, int n, int n2) {
        stringBuffer.append("{").append(n).append(",number,");
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append("}");
    }

    private int addScaleFactor(int n) {
        if (this.scaleSeconds == null) {
            this.scaleSeconds = new int[1];
        } else {
            int[] nArray = new int[this.scaleSeconds.length + 1];
            System.arraycopy(this.scaleSeconds, 0, nArray, 0, this.scaleSeconds.length);
            this.scaleSeconds = nArray;
        }
        this.scaleSeconds[this.scaleSeconds.length - 1] = n;
        return 7 + this.scaleSeconds.length - 1;
    }

    private Number[] timeStructToArray(TimeUtil.TimeStruct timeStruct) {
        int n = this.scaleSeconds == null ? 0 : this.scaleSeconds.length;
        int n2 = this.scaleSeconds == null ? 10 : (int)Math.pow(10.0, TimeDatumFormatter.max(this.scaleSeconds));
        int n3 = 7 + n;
        Number[] numberArray = new Number[n3];
        int n4 = (int)Math.round(timeStruct.seconds * (double)n2) / n2;
        double d = timeStruct.seconds - (double)n4;
        timeStruct.seconds = n4;
        timeStruct.micros = (int)(d * 1000000.0);
        TimeUtil.carry(timeStruct);
        numberArray[0] = new Integer(timeStruct.year);
        numberArray[1] = new Integer(timeStruct.month);
        numberArray[2] = new Integer(timeStruct.day);
        numberArray[3] = new Integer(timeStruct.doy);
        numberArray[4] = new Integer(timeStruct.hour);
        numberArray[5] = new Integer(timeStruct.minute);
        numberArray[6] = new Integer((int)timeStruct.seconds);
        for (int i = 7; i < numberArray.length; ++i) {
            int n5 = (int)Math.round(d * Math.pow(10.0, this.scaleSeconds[i - 7]));
            numberArray[i] = new Integer(n5);
        }
        return numberArray;
    }

    private static int max(int[] nArray) {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            n = Math.max(n, nArray[i]);
        }
        return n;
    }

    static {
        try {
            DEFAULT = new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            YEARS = new TimeDatumFormatter("yyyy");
            MONTHS = new TimeDatumFormatter("yyyy-MM");
            DAYS = new TimeDatumFormatter("yyyy-MM-dd");
            HOURS = new TimeDatumFormatter("yyyy-MM-dd HH:'00'");
            MINUTES = new TimeDatumFormatter("HH:mm");
            SECONDS = new TimeDatumFormatter("HH:mm:ss");
            MILLISECONDS = new TimeDatumFormatter("HH:mm:ss.SSS");
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }
}

