/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum.format;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.text.DecimalFormat;

public class LatinPrefixDatumFormatter
extends DatumFormatter {
    private DecimalFormat format;
    int digits;
    int exponent;

    public LatinPrefixDatumFormatter(int n) {
        this.digits = n;
    }

    public String format(Datum datum) {
        return this.format(datum, datum.getUnits()) + " " + datum.getUnits();
    }

    public String format(Datum datum, Units units) {
        String string;
        double d = datum.doubleValue(units);
        if (d == 0.0) {
            return "0.";
        }
        int n = (int)DasMath.log10(1.000001 * Math.abs(d)) / 3 * 3;
        switch (n) {
            case -18: {
                string = "a";
                break;
            }
            case -15: {
                string = "f";
                break;
            }
            case -12: {
                string = "p";
                break;
            }
            case -9: {
                string = "n";
                break;
            }
            case -6: {
                string = "\u03bc";
                break;
            }
            case -3: {
                string = "m";
                break;
            }
            case 0: {
                string = "";
                break;
            }
            case 3: {
                string = "k";
                break;
            }
            case 6: {
                string = "M";
                break;
            }
            case 9: {
                string = "G";
                break;
            }
            case 12: {
                string = "T";
                break;
            }
            default: {
                string = "";
                n = 0;
            }
        }
        int n2 = d < 0.0 ? -1 : 1;
        double d2 = DasMath.exp10(n);
        double d3 = d / d2;
        int n3 = this.digits - (int)DasMath.log10(d3);
        StringBuffer stringBuffer = new StringBuffer(this.digits + 2).append("0");
        if (this.digits > 1) {
            stringBuffer.append('.');
        }
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append('0');
        }
        String string2 = stringBuffer.toString();
        DecimalFormat decimalFormat = new DecimalFormat(stringBuffer.toString());
        return decimalFormat.format(d3) + string;
    }

    public String toString() {
        return "EngineeringFormatter(" + this.digits + " sig fig)";
    }
}

