/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum.format;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.text.DecimalFormat;

public class ExponentialDatumFormatter
extends DatumFormatter {
    private DecimalFormat format;
    int digits;
    int exponent;
    DecimalFormat mantFormat;
    String mantFormatString;

    public ExponentialDatumFormatter(int n, int n2) {
        this.digits = n;
        this.exponent = n2;
        StringBuffer stringBuffer = new StringBuffer(n + 2).append("0");
        if (n > 1) {
            stringBuffer.append('.');
        }
        for (int i = 1; i < n; ++i) {
            stringBuffer.append('0');
        }
        this.mantFormatString = stringBuffer.toString();
        this.mantFormat = new DecimalFormat(stringBuffer.toString());
    }

    public String format(Datum datum) {
        return this.format(datum, datum.getUnits()) + " " + datum.getUnits();
    }

    public String format(Datum datum, Units units) {
        double d = datum.doubleValue(datum.getUnits());
        if (d == 0.0) {
            return "0.";
        }
        double d2 = DasMath.exp10(this.exponent);
        double d3 = d / d2;
        double d4 = DasMath.exp10(this.digits);
        d3 = (double)Math.round(d3 * d4) / d4;
        return this.mantFormat.format(d3) + "E" + this.exponent;
    }

    public String grannyFormat(Datum datum, Units units) {
        String string = this.format(datum, units);
        if (string.indexOf("E") != -1) {
            int n = string.indexOf("E");
            StringBuffer stringBuffer = new StringBuffer(string.length() + 4);
            String string2 = string.substring(0, n);
            stringBuffer.append(string2).append("\u00d7");
            stringBuffer.append("10").append("!A").append(string.substring(n + 1)).append("!N");
            string = stringBuffer.toString();
        }
        return string;
    }

    public String grannyFormat(Datum datum) {
        String string = this.format(datum, datum.getUnits());
        if (string.indexOf("E") != -1) {
            int n = string.indexOf("E");
            StringBuffer stringBuffer = new StringBuffer(string.length() + 4);
            String string2 = string.substring(0, n);
            stringBuffer.append(string2).append("\u00d7");
            stringBuffer.append("10").append("!A").append(string.substring(n + 1)).append("!N");
            string = stringBuffer.toString();
        }
        return string + " " + datum.getUnits();
    }

    public String toString() {
        return this.mantFormatString + "E" + this.exponent;
    }
}

