/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum.format;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.text.DecimalFormat;
import java.text.ParseException;

public class DefaultDatumFormatter
extends DatumFormatter {
    private String formatString;
    private DecimalFormat format;

    protected DefaultDatumFormatter() {
    }

    public DefaultDatumFormatter(String string) throws ParseException {
        if (string.equals("")) {
            this.formatString = "";
            this.format = null;
        } else {
            this.formatString = string;
            this.format = new DecimalFormat(string);
        }
    }

    public String format(Datum datum) {
        return this.format(datum, datum.getUnits()) + " " + datum.getUnits();
    }

    public String format(Datum datum, Units units) {
        String string;
        double d = datum.doubleValue(units);
        if (Double.isInfinite(d)) {
            return "" + d;
        }
        if (this.format == null) {
            double d2 = datum.getResolution(units.getOffsetUnits());
            if (d2 == 0.0 && Double.toString(d).length() > 7) {
                d2 = d / 10000.0;
            }
            if (d2 > 0.0) {
                int n = (int)Math.ceil(-1.0 * DasMath.log10(d2) - 1.0E-5);
                int n2 = d != 0.0 ? (int)DasMath.log10(Math.abs(d)) : 0;
                if (n >= 0) {
                    DecimalFormat decimalFormat;
                    if (n2 <= -5 || n2 >= 5) {
                        decimalFormat = new DecimalFormat("0E0");
                        decimalFormat.setMinimumFractionDigits(n + n2 - 1);
                        decimalFormat.setMaximumFractionDigits(n + n2 - 1);
                    } else {
                        decimalFormat = new DecimalFormat("0");
                        decimalFormat.setMinimumFractionDigits(n);
                        decimalFormat.setMaximumFractionDigits(n);
                    }
                    string = decimalFormat.format(d);
                } else {
                    DecimalFormat decimalFormat;
                    double d3 = DasMath.exp10(-1 * n);
                    d = (double)Math.round(d / d3) * d3;
                    if (n2 <= -5 || n2 >= 5) {
                        decimalFormat = new DecimalFormat("0E0");
                        decimalFormat.setMinimumFractionDigits(n + n2 + 1);
                        decimalFormat.setMaximumFractionDigits(n + n2 + 1);
                    } else {
                        decimalFormat = new DecimalFormat("0");
                    }
                    string = decimalFormat.format(d);
                }
            } else {
                string = Double.toString(d);
            }
        } else {
            string = this.format.format(datum.doubleValue(units));
        }
        return string;
    }

    public String grannyFormat(Datum datum, Units units) {
        String string = this.format(datum, units);
        if (string.indexOf("E") != -1) {
            int n = string.indexOf("E");
            StringBuffer stringBuffer = new StringBuffer(string.length() + 4);
            String string2 = string.substring(0, n);
            if (Double.parseDouble(string2) != 1.0) {
                stringBuffer.append(string2).append("\u00d7");
            }
            stringBuffer.append("10").append("!A").append(string.substring(n + 1)).append("!N");
            string = stringBuffer.toString();
        }
        return string;
    }

    public String grannyFormat(Datum datum) {
        return this.grannyFormat(datum, datum.getUnits()) + " " + datum.getUnits();
    }

    public String toString() {
        return this.formatString;
    }
}

