/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;

public class UnitsUtil {
    public static final boolean isRatiometric(Units units) {
        return units != Units.dimensionless && units.isConvertableTo(Units.logERatio);
    }

    public static final boolean isTimeLocation(Units units) {
        return units.isConvertableTo(Units.us2000);
    }

    public static Units getInverseUnit(Units units) {
        if (units == Units.seconds) {
            return Units.hertz;
        }
        if (units == Units.hertz) {
            return Units.seconds;
        }
        if (units == Units.dimensionless) {
            return Units.dimensionless;
        }
        if (units == Units.microseconds) {
            return Units.megaHertz;
        }
        throw new IllegalArgumentException("units not supported: " + units);
    }

    public static String divideToString(Datum datum, Datum datum2) {
        try {
            Datum datum3 = UnitsUtil.divide(datum, datum2);
            return String.valueOf(datum3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Units units = datum.getUnits();
            Units units2 = datum2.getUnits();
            double d = datum.doubleValue(units);
            double d2 = datum2.doubleValue(units2);
            return "" + d / d2 + " " + units + " / " + units2;
        }
    }

    public static Datum divide(Datum datum, Datum datum2) {
        Units units;
        Units units2 = datum2.getUnits();
        Units units3 = datum.getUnits();
        try {
            units = UnitsUtil.getInverseUnit(units2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            units = null;
        }
        double d = datum.doubleValue(units3);
        double d2 = datum2.doubleValue(units2);
        if (units2 == Units.dimensionless) {
            return units3.createDatum(d / d2);
        }
        if (units3 == Units.dimensionless) {
            return units.createDatum(d / d2);
        }
        if (!units2.isConvertableTo(units3)) {
            throw new IllegalArgumentException("unable to calculate, b units not convertable to a");
        }
        UnitsConverter unitsConverter = units2.getConverter(units3);
        return Units.dimensionless.createDatum(d / unitsConverter.convert(d2));
    }
}

