/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Units;

public abstract class UnitsConverter {
    public static final UnitsConverter IDENTITY = new ScaleOffset(1.0, 0.0);
    public static final UnitsConverter TERA = new ScaleOffset(1.0E-12, 0.0);
    public static final UnitsConverter GIGA = new ScaleOffset(1.0E-9, 0.0);
    public static final UnitsConverter MEGA = new ScaleOffset(1.0E-6, 0.0);
    public static final UnitsConverter KILO = new ScaleOffset(0.001, 0.0);
    public static final UnitsConverter MILLI = new ScaleOffset(1000.0, 0.0);
    public static final UnitsConverter MICRO = new ScaleOffset(1000000.0, 0.0);
    public static final UnitsConverter NANO = new ScaleOffset(1.0E9, 0.0);
    public static final UnitsConverter PICO = new ScaleOffset(1.0E12, 0.0);
    protected UnitsConverter inverse;

    protected UnitsConverter() {
    }

    protected UnitsConverter(UnitsConverter unitsConverter) {
        this.inverse = unitsConverter;
    }

    public abstract UnitsConverter getInverse();

    public abstract double convert(double var1);

    public Number convert(Number number) {
        double d = number.doubleValue();
        d = this.convert(d);
        if (number instanceof Integer) {
            return new Integer((int)d);
        }
        if (number instanceof Long) {
            return new Long((long)d);
        }
        return new Double(d);
    }

    public UnitsConverter append(UnitsConverter unitsConverter) {
        return new Appended(this, unitsConverter);
    }

    public static UnitsConverter getConverter(Units units, Units units2) {
        return Units.getConverter(units, units2);
    }

    public static class Appended
    extends UnitsConverter {
        UnitsConverter[] converters;

        public Appended(UnitsConverter unitsConverter, UnitsConverter unitsConverter2) {
            int n;
            UnitsConverter[] unitsConverterArray = Appended.ucToArray(unitsConverter);
            UnitsConverter[] unitsConverterArray2 = Appended.ucToArray(unitsConverter2);
            this.converters = new UnitsConverter[unitsConverterArray.length + unitsConverterArray2.length];
            for (n = 0; n < unitsConverterArray.length; ++n) {
                this.converters[n] = unitsConverterArray[n];
            }
            for (n = 0; n < unitsConverterArray2.length; ++n) {
                this.converters[n + unitsConverterArray.length] = unitsConverterArray2[n];
            }
        }

        private Appended(UnitsConverter[] unitsConverterArray, UnitsConverter unitsConverter) {
            super(unitsConverter);
            this.converters = unitsConverterArray;
        }

        public double convert(double d) {
            for (int i = 0; i < this.converters.length; ++i) {
                d = this.converters[i].convert(d);
            }
            return d;
        }

        public Number convert(Number number) {
            for (int i = 0; i < this.converters.length; ++i) {
                number = this.converters[i].convert(number);
            }
            return number;
        }

        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                int n = this.converters.length;
                UnitsConverter[] unitsConverterArray = new UnitsConverter[n];
                for (int i = 0; i < n; ++i) {
                    unitsConverterArray[i] = this.converters[n - i - 1].getInverse();
                }
                this.inverse = new Appended(unitsConverterArray, (UnitsConverter)this);
            }
            return this.inverse;
        }

        private static UnitsConverter[] ucToArray(UnitsConverter unitsConverter) {
            if (unitsConverter instanceof Appended) {
                return ((Appended)unitsConverter).converters;
            }
            return new UnitsConverter[]{unitsConverter};
        }
    }

    public static class ScaleOffset
    extends UnitsConverter {
        private final double offset;
        private final double scale;
        private final int hashCode;

        public ScaleOffset(double d, double d2) {
            this(d, d2, null);
        }

        private ScaleOffset(double d, double d2, UnitsConverter unitsConverter) {
            super(unitsConverter);
            this.scale = d;
            this.offset = d2;
            this.hashCode = this.computeHashCode();
        }

        private int computeHashCode() {
            long l = Double.doubleToLongBits(this.scale);
            long l2 = Double.doubleToLongBits(this.offset);
            long l3 = 1859L + 13L * l + l2;
            int n = (int)(l3 >> 32);
            int n2 = (int)(0xFFFFFFFFL & l3);
            return n + n2;
        }

        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                this.inverse = new ScaleOffset(1.0 / this.scale, -(this.offset / this.scale), this);
            }
            return this.inverse;
        }

        public double convert(double d) {
            return this.scale * d + this.offset;
        }

        public UnitsConverter append(UnitsConverter unitsConverter) {
            if (this.equals(IDENTITY)) {
                return unitsConverter;
            }
            if (unitsConverter.equals(IDENTITY)) {
                return this;
            }
            if (unitsConverter instanceof ScaleOffset) {
                ScaleOffset scaleOffset = (ScaleOffset)unitsConverter;
                double d = this.scale * scaleOffset.scale;
                double d2 = this.offset * scaleOffset.scale + scaleOffset.offset;
                return new ScaleOffset(d, d2);
            }
            return super.append(unitsConverter);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ScaleOffset)) {
                return false;
            }
            ScaleOffset scaleOffset = (ScaleOffset)object;
            return this.scale == scaleOffset.scale && this.offset == scaleOffset.offset;
        }

        public String toString() {
            return this.getClass().getName() + "[scale=" + this.scale + ",offset=" + this.offset + "]";
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

