/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.components.propertyeditor.Displayable;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.NumberUnits;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatterFactory;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Icon;

public abstract class Units
implements Displayable {
    private static Map unitsMap = new HashMap();
    public static final Units dimensionless = new NumberUnits("");
    public static final Units dB = new NumberUnits("dB");
    public static final Units radians = new NumberUnits("radian");
    public static final Units degrees = new NumberUnits("degrees");
    public static final Units celcius;
    public static final Units fahrenheit;
    public static final Units hours;
    public static final Units minutes;
    public static final Units seconds;
    public static final Units milliseconds;
    public static final Units microseconds;
    public static final Units nanoseconds;
    public static final Units days;
    public static final Units bytesPerSecond;
    public static final Units kiloBytesPerSecond;
    public static final Units bytes;
    public static final Units kiloBytes;
    public static final Units hertz;
    public static final Units kiloHertz;
    public static final Units megaHertz;
    public static final Units eV;
    public static final Units pcm3;
    public static final Units kelvin;
    public static final Units cmps;
    public static final Units v2pm2Hz;
    public static final Units meters;
    public static final Units kiloMeters;
    public static final TimeLocationUnits us2000;
    public static final TimeLocationUnits t2000;
    public static final TimeLocationUnits t1970;
    public static final TimeLocationUnits mj1958;
    public static final TimeLocationUnits cdfEpoch;
    public static final Units percent;
    public static final Units percentIncrease;
    public static final Units log10Ratio;
    public static final Units logERatio;
    private String id;
    private String description;
    private Map conversionMap = new IdentityHashMap();
    private static final double FILL_DOUBLE = -1.0E31;
    private static final float FILL_FLOAT = -1.0E31f;
    private static final int FILL_INT = Integer.MAX_VALUE;
    private static final long FILL_LONG = Long.MAX_VALUE;

    protected Units(String string) {
        this(string, "");
    }

    protected Units(String string, String string2) {
        this.id = string;
        this.description = string2;
        unitsMap.put(string, this);
    }

    public void registerConverter(Units units, UnitsConverter unitsConverter) {
        this.conversionMap.put(units, unitsConverter);
        UnitsConverter unitsConverter2 = (UnitsConverter)units.conversionMap.get(this);
        if (unitsConverter2 == null || unitsConverter2.getInverse() != unitsConverter) {
            units.registerConverter(this, unitsConverter.getInverse());
        }
    }

    public Units[] getConvertableUnits() {
        HashSet<Units> hashSet = new HashSet<Units>();
        LinkedList<Units> linkedList = new LinkedList<Units>();
        linkedList.add(this);
        while (!linkedList.isEmpty()) {
            Units units = (Units)linkedList.removeFirst();
            for (Map.Entry entry : units.conversionMap.entrySet()) {
                Units units2 = (Units)entry.getKey();
                if (hashSet.contains(units2)) continue;
                linkedList.add(units2);
                hashSet.add(units2);
            }
        }
        return hashSet.toArray(new Units[hashSet.size()]);
    }

    public boolean isConvertableTo(Units units) {
        try {
            this.getConverter(units);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static UnitsConverter getConverter(Units units, Units units2) {
        Object object;
        if (units == units2) {
            return UnitsConverter.IDENTITY;
        }
        if (units.conversionMap.get(units2) != null) {
            return (UnitsConverter)units.conversionMap.get(units2);
        }
        HashMap<Units, Object> hashMap = new HashMap<Units, Object>();
        hashMap.put(units, null);
        LinkedList<Units> linkedList = new LinkedList<Units>();
        linkedList.add(units);
        while (!linkedList.isEmpty()) {
            object = (Units)linkedList.removeFirst();
            for (Map.Entry entry : ((Units)object).conversionMap.entrySet()) {
                Units units3 = (Units)entry.getKey();
                if (hashMap.containsKey(units3)) continue;
                hashMap.put(units3, object);
                linkedList.add(units3);
                if (units3 != units2) continue;
                return Units.buildConversion(units, units2, hashMap);
            }
        }
        object = units == dimensionless ? "(dimensionless)" : units.toString();
        String string = units2 == dimensionless ? "(dimensionless)" : units2.toString();
        throw new IllegalArgumentException("Inconvertible units: " + (String)object + " -> " + (String)string);
    }

    private static UnitsConverter buildConversion(Units units, Units units2, Map map) {
        ArrayList<Units> arrayList = new ArrayList<Units>();
        Units units3 = units2;
        while (units3 != null) {
            arrayList.add(units3);
            units3 = (Units)map.get(units3);
        }
        UnitsConverter unitsConverter = UnitsConverter.IDENTITY;
        for (int i = arrayList.size() - 1; i > 0; --i) {
            Units units4 = (Units)arrayList.get(i);
            Units units5 = (Units)arrayList.get(i - 1);
            UnitsConverter unitsConverter2 = (UnitsConverter)units4.conversionMap.get(units5);
            unitsConverter = unitsConverter.append(unitsConverter2);
        }
        units.registerConverter(units2, unitsConverter);
        return unitsConverter;
    }

    public UnitsConverter getConverter(Units units) {
        return Units.getConverter(this, units);
    }

    public final double convertDoubleTo(Units units, double d) {
        if (this == units) {
            return d;
        }
        return Units.getConverter(this, units).convert(d);
    }

    public String toString() {
        return this.id;
    }

    public Units getOffsetUnits() {
        return this;
    }

    public abstract Datum createDatum(double var1);

    public abstract Datum createDatum(int var1);

    public abstract Datum createDatum(long var1);

    public abstract Datum createDatum(Number var1);

    public abstract Datum createDatum(double var1, double var3);

    public double getFillDouble() {
        return -1.0E31;
    }

    public float getFillFloat() {
        return -1.0E31f;
    }

    public int getFillInt() {
        return Integer.MAX_VALUE;
    }

    public long getFillLong() {
        return Long.MAX_VALUE;
    }

    public Datum getFillDatum() {
        return this.createDatum(-1.0E31);
    }

    public boolean isFill(double d) {
        return d < -1.0E30;
    }

    public boolean isFill(float f) {
        return f < -1.0E30f;
    }

    public boolean isFill(long l) {
        return l == Long.MAX_VALUE;
    }

    public boolean isFill(int n) {
        return n == Integer.MAX_VALUE;
    }

    public boolean isFill(Number number) {
        if (number instanceof Double) {
            return this.isFill(number.doubleValue());
        }
        if (number instanceof Float) {
            return this.isFill(number.floatValue());
        }
        if (number instanceof Integer) {
            return this.isFill(number.intValue());
        }
        if (number instanceof Long) {
            return this.isFill(number.longValue());
        }
        throw new IllegalArgumentException("Unknown Number class: " + number.getClass().toString());
    }

    public abstract DatumFormatterFactory getDatumFormatterFactory();

    public abstract Datum parse(String var1) throws ParseException;

    public String format(Datum datum) {
        return this.getDatumFormatterFactory().defaultFormatter().format(datum);
    }

    public String grannyFormat(Datum datum) {
        return this.getDatumFormatterFactory().defaultFormatter().grannyFormat(datum);
    }

    public abstract Datum add(Number var1, Number var2, Units var3);

    public abstract Datum subtract(Number var1, Number var2, Units var3);

    public abstract Datum multiply(Number var1, Number var2, Units var3);

    public abstract Datum divide(Number var1, Number var2, Units var3);

    public static Units getByName(String string) {
        Units units = (Units)unitsMap.get(string);
        if (units == null) {
            throw new IllegalArgumentException("Unrecognized units: " + string);
        }
        return units;
    }

    public static void main(String[] stringArray) throws ParseException {
        Datum datum = Datum.create(100);
        Datum datum2 = datum.convertTo(dB);
        System.out.println("ratio: " + datum);
        System.out.println("dB: " + datum2);
        Datum datum3 = Datum.create(1000000.0, hertz);
        Datum datum4 = datum3.convertTo(kiloHertz);
        Datum datum5 = datum4.convertTo(megaHertz);
        System.out.println("Hz: " + datum3);
        System.out.println("kHz: " + datum4);
        System.out.println("MHz: " + datum5);
    }

    public Icon getListIcon() {
        return null;
    }

    public String getListLabel() {
        return this.id;
    }

    static {
        dimensionless.registerConverter(dB, new dBConverter());
        celcius = new NumberUnits("deg C");
        fahrenheit = new NumberUnits("deg F");
        celcius.registerConverter(fahrenheit, new UnitsConverter.ScaleOffset(1.8, 32.0));
        hours = new NumberUnits("hr");
        minutes = new NumberUnits("min");
        seconds = new NumberUnits("s");
        milliseconds = new NumberUnits("ms");
        microseconds = new NumberUnits("microseconds");
        nanoseconds = new NumberUnits("nanoseconds");
        days = new NumberUnits("days");
        seconds.registerConverter(milliseconds, UnitsConverter.MILLI);
        seconds.registerConverter(microseconds, UnitsConverter.MICRO);
        seconds.registerConverter(nanoseconds, UnitsConverter.NANO);
        hours.registerConverter(seconds, new UnitsConverter.ScaleOffset(3600.0, 0.0));
        minutes.registerConverter(seconds, new UnitsConverter.ScaleOffset(60.0, 0.0));
        days.registerConverter(seconds, new UnitsConverter.ScaleOffset(86400.0, 0.0));
        bytesPerSecond = new NumberUnits("bytes/s");
        kiloBytesPerSecond = new NumberUnits("KBytes/s");
        bytes = new NumberUnits("bytes");
        kiloBytes = new NumberUnits("KBytes");
        bytesPerSecond.registerConverter(kiloBytesPerSecond, UnitsConverter.KILO);
        bytes.registerConverter(kiloBytes, UnitsConverter.KILO);
        hertz = new NumberUnits("Hz");
        kiloHertz = new NumberUnits("kHz");
        megaHertz = new NumberUnits("MHz");
        hertz.registerConverter(kiloHertz, UnitsConverter.KILO);
        hertz.registerConverter(megaHertz, UnitsConverter.MEGA);
        eV = new NumberUnits("eV");
        pcm3 = new NumberUnits("cm!a-3!n");
        kelvin = new NumberUnits("K");
        cmps = new NumberUnits("cm/s");
        v2pm2Hz = new NumberUnits("V!a2!nm!a-2!nHz!a-1");
        meters = new NumberUnits("m");
        kiloMeters = new NumberUnits("km");
        meters.registerConverter(kiloMeters, UnitsConverter.KILO);
        us2000 = new TimeLocationUnits("us2000", "Microseconds since midnight Jan 1, 2000.", microseconds);
        t2000 = new TimeLocationUnits("t2000", "Seconds since midnight Jan 1, 2000.", seconds);
        t1970 = new TimeLocationUnits("t1970", "Seconds since midnight Jan 1, 1970", seconds);
        mj1958 = new TimeLocationUnits("mj1958", "Julian - 2436204.5", days);
        cdfEpoch = new TimeLocationUnits("cdfEpoch", "milliseconds since 01-Jan-0000", milliseconds);
        t2000.registerConverter(us2000, UnitsConverter.MICRO);
        us2000.registerConverter(cdfEpoch, new UnitsConverter.ScaleOffset(0.001, 6.3113904E13));
        t2000.registerConverter(t1970, new UnitsConverter.ScaleOffset(1.0, 9.466848E8));
        t2000.registerConverter(mj1958, new UnitsConverter.ScaleOffset(1.1574074074074073E-5, 15340.0));
        percent = new NumberUnits("%", "");
        percentIncrease = new NumberUnits("% diff", "Special dimensionless number, useful for expressing on logarithmic scale.  100% indicates a doubling");
        log10Ratio = new NumberUnits("log10Ratio", "Special dimensionless number, useful for expressing distances on a log10 scale");
        logERatio = new NumberUnits("logERatio", "Special dimensionless number, useful for expressing distances on a logE scale");
        log10Ratio.registerConverter(logERatio, new UnitsConverter.ScaleOffset(Math.log(10.0), 0.0));
        logERatio.registerConverter(percentIncrease, new PercentRatioConverter());
        dB.registerConverter(log10Ratio, new UnitsConverter.ScaleOffset(10.0, 0.0));
    }

    private static class PercentRatioConverter
    extends UnitsConverter {
        private PercentRatioConverter() {
        }

        public double convert(double d) {
            return (Math.exp(d) - 1.0) * 100.0;
        }

        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                this.inverse = new UnitsConverter(){

                    public double convert(double d) {
                        return Math.log(d / 100.0 + 1.0);
                    }

                    public UnitsConverter getInverse() {
                        return PercentRatioConverter.this;
                    }
                };
            }
            return this.inverse;
        }
    }

    private static final class dBConverter
    extends UnitsConverter {
        private dBConverter() {
        }

        public double convert(double d) {
            return 10.0 * DasMath.log10(d);
        }

        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                this.inverse = new UnitsConverter(){

                    public double convert(double d) {
                        return Math.pow(10.0, d / 10.0);
                    }

                    public UnitsConverter getInverse() {
                        return dBConverter.this;
                    }
                };
            }
            return this.inverse;
        }
    }
}

