/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatterFactory;
import edu.uiowa.physics.pw.das.datum.format.DefaultDatumFormatterFactory;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberUnits
extends Units {
    private static Pattern expressionPattern = Pattern.compile("(.+)(\\*)(.+)");

    public NumberUnits(String string) {
        this(string, "");
    }

    public NumberUnits(String string, String string2) {
        super(string, string2);
    }

    public Datum createDatum(double d) {
        return new Datum.Double(d, (Units)this, 0.0);
    }

    public Datum createDatum(double d, double d2) {
        return new Datum.Double(d, (Units)this, d2);
    }

    public Datum createDatum(int n) {
        return new Datum.Double(n, (Units)this);
    }

    public Datum createDatum(long l) {
        return new Datum.Double(l, (Units)this);
    }

    public Datum createDatum(Number number) {
        return new Datum.Double(number, (Units)this);
    }

    public DatumFormatterFactory getDatumFormatterFactory() {
        return DefaultDatumFormatterFactory.getInstance();
    }

    private double[] parseDecimal(String string) {
        BigDecimal bigDecimal = new BigDecimal(string = string.trim());
        if (bigDecimal.scale() > 0) {
            double d = DasMath.exp10(-1 * bigDecimal.scale());
            return new double[]{Double.parseDouble(string), d};
        }
        int n = string.indexOf(69);
        if (n == -1) {
            n = string.indexOf(101);
        }
        if (n == -1) {
            int n2 = string.indexOf(46);
            double[] dArray = new double[2];
            dArray[0] = Double.parseDouble(string);
            if (n2 == -1) {
                dArray[1] = 1.0;
            } else {
                int n3 = string.length() - n2 - 1;
                dArray[1] = DasMath.exp10(-1 * n3);
            }
            return dArray;
        }
        String string2 = string.substring(0, n);
        double[] dArray = this.parseDecimal(string2);
        double d = DasMath.exp10(Double.parseDouble(string.substring(n + 1)));
        dArray[0] = dArray[0] * d;
        dArray[1] = dArray[1] * d;
        return dArray;
    }

    private Datum parseExpression(String string) throws ParseException {
        Datum datum;
        Datum datum2;
        Datum datum3;
        Matcher matcher = expressionPattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("not an expression");
        }
        String string2 = matcher.group(2);
        try {
            datum3 = Units.dimensionless.parse(matcher.group(1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            datum3 = this.parse(matcher.group(1));
        }
        try {
            datum2 = Units.dimensionless.parse(matcher.group(3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            datum2 = this.parse(matcher.group(3));
        }
        if (string2.equals("*")) {
            datum = datum3.multiply(datum2);
        } else if (string2.equals("/")) {
            datum = datum3.divide(datum2);
        } else {
            throw new IllegalArgumentException("Bad operator: " + string2 + " of expression " + string);
        }
        return datum;
    }

    public Datum parse(String string) throws ParseException {
        if (expressionPattern.matcher(string).matches()) {
            Datum datum = this.parseExpression(string);
            datum = datum.getUnits() == Units.dimensionless ? this.createDatum(datum.doubleValue()) : datum.convertTo(this);
            return datum;
        }
        try {
            Units units;
            String[] stringArray = string.trim().split("\\s");
            double[] dArray = this.parseDecimal(stringArray[0]);
            if (stringArray.length == 1) {
                return Datum.create(dArray[0], (Units)this, dArray[1]);
            }
            String string2 = stringArray[1];
            for (int i = 2; i < stringArray.length; ++i) {
                string2 = string2 + " " + stringArray[i];
            }
            try {
                units = Units.getByName(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ParseException parseException = new ParseException(string, stringArray[0].length() + 1);
                parseException.initCause(illegalArgumentException);
                throw parseException;
            }
            UnitsConverter unitsConverter = units.getConverter(this);
            return Datum.create(unitsConverter.convert(dArray[0]), (Units)this, unitsConverter.convert(dArray[1]));
        }
        catch (NumberFormatException numberFormatException) {
            ParseException parseException = new ParseException(numberFormatException.getMessage(), 0);
            parseException.initCause(numberFormatException);
            throw parseException;
        }
    }

    protected static Number add(Number number, Number number2) {
        if (number instanceof Integer && number2 instanceof Integer) {
            return new Integer(number.intValue() + number2.intValue());
        }
        return new Double(number.doubleValue() + number2.doubleValue());
    }

    protected static Number subtract(Number number, Number number2) {
        if (number instanceof Integer && number2 instanceof Integer) {
            return new Integer(number.intValue() - number2.intValue());
        }
        return new Double(number.doubleValue() - number2.doubleValue());
    }

    protected static Number divide(Number number, Number number2) {
        if (number instanceof Integer && number2 instanceof Integer) {
            return new Integer(number.intValue() / number2.intValue());
        }
        return new Double(number.doubleValue() / number2.doubleValue());
    }

    protected static Number multiply(Number number, Number number2) {
        if (number instanceof Integer && number2 instanceof Integer) {
            return new Integer(number.intValue() * number2.intValue());
        }
        return new Double(number.doubleValue() * number2.doubleValue());
    }

    public Datum add(Number number, Number number2, Units units) {
        if (units != this) {
            UnitsConverter unitsConverter = Units.getConverter(units, this);
            number2 = unitsConverter.convert(number2);
        }
        return this.createDatum(NumberUnits.add(number, number2));
    }

    public Datum subtract(Number number, Number number2, Units units) {
        if (units != this) {
            UnitsConverter unitsConverter = Units.getConverter(units, this);
            number2 = unitsConverter.convert(number2);
        }
        return this.createDatum(NumberUnits.subtract(number, number2));
    }

    public Datum multiply(Number number, Number number2, Units units) {
        if (units == Units.dimensionless) {
            return this.createDatum(NumberUnits.multiply(number, number2));
        }
        if (this == Units.dimensionless) {
            return units.createDatum(NumberUnits.multiply(number, number2));
        }
        throw new IllegalArgumentException("Multiplication of two non-dimensionless numbers is not supported");
    }

    public Datum divide(Number number, Number number2, Units units) {
        if (units == Units.dimensionless) {
            return this.createDatum(NumberUnits.divide(number, number2));
        }
        UnitsConverter unitsConverter = units.getConverter(this);
        if (unitsConverter == null) {
            throw new IllegalArgumentException("Only division by dimensionless or convertable Datums is supported");
        }
        return Units.dimensionless.createDatum(NumberUnits.divide(number, unitsConverter.convert(number2)));
    }
}

