/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.TimeUtil;

public class MonthDatumRange
extends DatumRange {
    int width;
    int widthDigit = -1;
    int[] start;
    int[] end;

    public MonthDatumRange(int[] nArray, int[] nArray2) {
        super(TimeUtil.toDatum(nArray), TimeUtil.toDatum(nArray2));
        int n;
        int[] nArray3 = new int[7];
        boolean bl = false;
        for (n = 0; n < 7; ++n) {
            nArray3[n] = nArray2[n] - nArray[n];
        }
        while (nArray3[1] < 0) {
            nArray3[1] = nArray3[1] + 12;
            nArray3[0] = nArray3[0] - 1;
        }
        for (n = 0; n < 7; ++n) {
            if (nArray3[n] == 0) continue;
            if (this.widthDigit != -1) {
                throw new IllegalArgumentException("MonthDatumRange must only vary in month or year, not both");
            }
            this.widthDigit = n;
            this.width = nArray3[this.widthDigit];
        }
        this.start = nArray;
        this.end = nArray2;
    }

    public DatumRange next() {
        int[] nArray = new int[7];
        for (int i = 0; i < 7; ++i) {
            nArray[i] = this.end[i];
        }
        nArray[this.widthDigit] = nArray[this.widthDigit] + this.width;
        switch (this.widthDigit) {
            case 1: {
                while (nArray[1] > 12) {
                    nArray[1] = nArray[1] - 12;
                    nArray[0] = nArray[0] + 1;
                }
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("not implemented");
            }
        }
        return new MonthDatumRange(this.end, nArray);
    }

    public DatumRange previous() {
        int[] nArray = new int[7];
        for (int i = 0; i < 7; ++i) {
            nArray[i] = this.start[i];
        }
        nArray[this.widthDigit] = nArray[this.widthDigit] - this.width;
        switch (this.widthDigit) {
            case 1: {
                while (nArray[1] < 1) {
                    nArray[1] = nArray[1] + 12;
                    nArray[0] = nArray[0] - 1;
                }
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("not implemented");
            }
        }
        return new MonthDatumRange(nArray, this.start);
    }
}

