/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.LocationUnits;
import edu.uiowa.physics.pw.das.datum.Units;

public final class DatumVector {
    private final Units units;
    private final Object store;
    private final double resolution;
    private final int offset;
    private final int length;

    private DatumVector(double[] dArray, int n, int n2, Units units) {
        this(dArray, n, n2, units, 0.0, true);
    }

    private DatumVector(double[] dArray, int n, int n2, Units units, double d, boolean bl) {
        if (dArray == null) {
            throw new NullPointerException("array is null");
        }
        if (units == null) {
            throw new NullPointerException("units is null");
        }
        if (bl) {
            this.store = new double[n2];
            for (int i = 0; i < n2; ++i) {
                ((double[])this.store)[i] = dArray[n + i];
            }
            n = 0;
        } else {
            this.store = dArray;
        }
        this.offset = n;
        this.units = units;
        this.resolution = d;
        this.length = n2;
    }

    public DatumVector getSubVector(int n, int n2) {
        if (n == 0 && n2 == this.length) {
            return this;
        }
        return new DatumVector((double[])this.store, this.offset + n, n2 - n, this.units, this.resolution, false);
    }

    public Datum get(int n) {
        return Datum.create(((double[])this.store)[n + this.offset], this.units, this.resolution);
    }

    public Units getUnits() {
        return this.units;
    }

    public double doubleValue(int n, Units units) {
        return this.units.convertDoubleTo(units, ((double[])this.store)[n + this.offset]);
    }

    public double[] toDoubleArray(Units units) {
        return this.toDoubleArray(null, units);
    }

    public double[] toDoubleArray(double[] dArray, Units units) {
        if (dArray == null || dArray.length < this.length) {
            dArray = new double[this.length];
        }
        if (units == this.units) {
            System.arraycopy(this.store, this.offset, dArray, 0, this.length);
        } else {
            double[] dArray2 = (double[])this.store;
            for (int i = 0; i < this.length; ++i) {
                dArray[i] = this.units.convertDoubleTo(units, dArray2[i]);
            }
        }
        return dArray;
    }

    public static DatumVector newDatumVector(Datum[] datumArray, Units units) {
        double[] dArray = new double[datumArray.length];
        for (int i = 0; i < datumArray.length; ++i) {
            dArray[i] = datumArray[i].doubleValue(units);
        }
        return DatumVector.newDatumVector(dArray, units);
    }

    public static DatumVector newDatumVector(double[] dArray, Units units) {
        return DatumVector.newDatumVector(dArray, 0, dArray.length, units);
    }

    public static DatumVector newDatumVector(double[] dArray, double d, Units units) {
        return new DatumVector(dArray, 0, dArray.length, units, d, true);
    }

    public static DatumVector newDatumVector(double[] dArray, int n, int n2, Units units) {
        return new DatumVector(dArray, n, n2, units);
    }

    public int getLength() {
        return this.length;
    }

    public DatumVector add(Datum datum) {
        Units units;
        double[] dArray = new double[this.getLength()];
        if (datum.getUnits() instanceof LocationUnits) {
            units = datum.getUnits();
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = datum.add(this.get(i)).doubleValue(units);
            }
        } else {
            units = this.units;
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.get(i).add(datum).doubleValue(units);
            }
        }
        return new DatumVector(dArray, 0, dArray.length, units);
    }

    public DatumVector subtract(Datum datum) {
        double[] dArray = new double[this.getLength()];
        Units units = this.units instanceof LocationUnits && datum.getUnits() instanceof LocationUnits ? this.units.getOffsetUnits() : this.units;
        for (int i = 0; i < dArray.length; ++i) {
            Datum datum2 = this.get(i).subtract(datum);
            dArray[i] = datum2.doubleValue(units);
        }
        return new DatumVector(dArray, 0, dArray.length, units);
    }

    public DatumVector multiply(double d) {
        double[] dArray = new double[this.getLength()];
        if (this.units instanceof LocationUnits) {
            throw new IllegalArgumentException("can't multiply a LocationUnits");
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.get(i).multiply(d).doubleValue(this.units);
        }
        return new DatumVector(dArray, 0, dArray.length, this.units);
    }

    public String toString() {
        Units units = this.getUnits();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.getLength(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            Datum datum = this.get(i);
            stringBuffer.append(datum.getFormatter().format(datum, units));
        }
        stringBuffer.append(" " + units.toString() + " ]");
        return stringBuffer.toString();
    }
}

