/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.EnumerationUnits;
import edu.uiowa.physics.pw.das.datum.LocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatterFactory;
import edu.uiowa.physics.pw.das.datum.format.DefaultDatumFormatterFactory;
import edu.uiowa.physics.pw.das.datum.format.EnumerationDatumFormatterFactory;
import edu.uiowa.physics.pw.das.datum.format.ExponentialDatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DatumUtil {
    private static final String zeros100 = "0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";

    private DatumUtil() {
    }

    public static DatumFormatter bestFormatter(DatumVector datumVector) {
        Units units;
        double[] dArray;
        if (datumVector.getUnits() instanceof EnumerationUnits) {
            return EnumerationDatumFormatterFactory.getInstance().defaultFormatter();
        }
        if (datumVector.getUnits() instanceof TimeLocationUnits) {
            Datum datum = datumVector.get(0);
            int n = datumVector.getLength();
            Datum datum2 = datumVector.get(n - 1);
            return DatumUtil.bestTimeFormatter(datum, datum2, n - 1);
        }
        if (datumVector.getUnits() instanceof LocationUnits) {
            dArray = new double[datumVector.getLength()];
            units = ((LocationUnits)datumVector.get(0).getUnits()).getOffsetUnits();
            dArray[0] = 0.0;
            for (int i = 1; i < datumVector.getLength(); ++i) {
                dArray[i] = datumVector.get(i).subtract(datumVector.get(0)).doubleValue(units);
            }
        } else {
            units = datumVector.getUnits();
            dArray = datumVector.toDoubleArray(units);
        }
        double d = DasMath.exp10((int)DasMath.log10(DasMath.max(dArray)) - 7);
        double d2 = DasMath.gcd(dArray, d);
        int n = 99;
        int n2 = -1;
        for (int i = 0; i < datumVector.getLength(); ++i) {
            int n3;
            double d3 = datumVector.get(i).doubleValue(units);
            if (!(Math.abs(d3) > d2 * 0.1) || (n3 = (int)Math.floor(0.05 + DasMath.log10(Math.abs(d3)))) >= n) continue;
            n = n3;
            n2 = i;
        }
        Datum datum = units.createDatum(d2);
        Datum datum3 = datumVector.get(n2);
        if (datum3.lt(units.createDatum(0.0))) {
            datum3 = datum3.multiply(-1.0);
        }
        return DatumUtil.bestFormatter(datum3, datum3.add(datum), 1);
    }

    public static int fractionalDigits(Datum datum) {
        int n;
        int n2 = 10;
        double d = Math.abs(datum.doubleValue());
        int n3 = (int)Math.floor(DasMath.log10(d) + 1.0E-4);
        long l = (long)(d / DasMath.exp10(n3 - (n2 - 1)) + 0.5);
        for (n = 1; n < 16 && (double)l % DasMath.exp10(n) == 0.0; ++n) {
        }
        return n2 - 1 - --n - n3;
    }

    public static DatumFormatter limitLogResolutionFormatter(Datum datum, Datum datum2, int n) {
        Units units = datum.getUnits();
        if (units instanceof TimeLocationUnits) {
            return DatumUtil.bestTimeFormatter(datum, datum2, n);
        }
        double d = DasMath.log10(datum.doubleValue(units));
        double d2 = DasMath.log10(datum2.doubleValue(units));
        double d3 = (DasMath.exp10((d2 - d) / (double)n) - 1.0) * 100.0;
        int n2 = 2 - (int)Math.floor(0.05 + DasMath.log10(d3));
        n2 = n2 < 0 ? 0 : n2;
        String string = DatumUtil.exp(n2);
        DatumFormatterFactory datumFormatterFactory = units.getDatumFormatterFactory();
        try {
            return datumFormatterFactory.newFormatter(string);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    public static DatumFormatter limitResolutionFormatter(Datum datum, Datum datum2, int n) {
        Units units = datum.getUnits();
        if (units instanceof TimeLocationUnits) {
            return DatumUtil.bestTimeFormatter(datum, datum2, n);
        }
        Datum datum3 = datum2.subtract(datum).divide(n);
        double d = datum3.doubleValue(units);
        int n2 = -1 * (int)Math.floor(0.05 + DasMath.log10(d));
        n2 = n2 < 0 ? 0 : n2;
        String string = DatumUtil.zeros(n2);
        DatumFormatterFactory datumFormatterFactory = units.getDatumFormatterFactory();
        try {
            return datumFormatterFactory.newFormatter(string);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    public static DatumFormatter bestFormatter(Datum datum, Datum datum2, int n) {
        Object object;
        Units units = datum.getUnits();
        if (datum2.lt(datum)) {
            object = datum2;
            datum2 = datum;
            datum = object;
        }
        if (units instanceof TimeLocationUnits) {
            return DatumUtil.bestTimeFormatter(datum, datum2, n);
        }
        object = datum.getUnits().getDatumFormatterFactory();
        try {
            int n2;
            if (!(object instanceof DefaultDatumFormatterFactory)) {
                return ((DatumFormatterFactory)object).defaultFormatter();
            }
            int n3 = DatumUtil.fractionalDigits(datum2.subtract(datum).divide(n));
            int n4 = 99;
            double d = DasMath.exp10(-1 * n3);
            Datum datum3 = datum2.subtract(datum).divide(n);
            double d2 = datum3.doubleValue(units);
            for (n2 = 0; n2 < n; ++n2) {
                int n5;
                double d3 = datum.add(datum3.multiply(n2)).doubleValue(units);
                if (!(Math.abs(d3) > d * 0.1) || (n5 = (int)Math.floor(0.05 + DasMath.log10(Math.abs(d3)))) >= n4) continue;
                n4 = n5;
            }
            if (n4 < -3 || n4 > 3) {
                return new ExponentialDatumFormatter(n4 - -1 * n3 + 1, n4);
            }
            n2 = -1 * (int)Math.floor(0.05 + DasMath.log10(d));
            n2 = n2 < 0 ? 0 : n2;
            String string = DatumUtil.zeros(n2);
            return ((DatumFormatterFactory)object).newFormatter(string);
        }
        catch (ParseException parseException) {
            Logger logger = DasApplication.getDefaultApplication().getLogger();
            RuntimeException runtimeException = new RuntimeException(parseException);
            logger.log(Level.SEVERE, parseException.getMessage(), runtimeException);
            throw runtimeException;
        }
    }

    private static String exp(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 4);
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append('#');
        }
        stringBuffer.append("0.#E0");
        return stringBuffer.toString();
    }

    public static String zeros(int n) {
        if (n < 0) {
            return "0";
        }
        if (n <= 100) {
            return zeros100.substring(0, n + 2);
        }
        StringBuffer stringBuffer = new StringBuffer(n + 2).append("0.");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('0');
        }
        return stringBuffer.toString();
    }

    public static DatumFormatter bestTimeFormatter(Datum datum, Datum datum2, int n) {
        double d = datum2.subtract(datum).doubleValue(Units.seconds) / (double)n;
        if (d < 1.0) {
            return TimeDatumFormatter.MILLISECONDS;
        }
        if (d < 60.0) {
            return TimeDatumFormatter.SECONDS;
        }
        if (d < 3600.0) {
            return TimeDatumFormatter.MINUTES;
        }
        if (d < 86400.0) {
            return TimeDatumFormatter.HOURS;
        }
        if (d < 2419200.0) {
            return TimeDatumFormatter.DAYS;
        }
        if (d < 3.15576E7) {
            return TimeDatumFormatter.MONTHS;
        }
        return TimeDatumFormatter.YEARS;
    }

    public static Datum parse(String string) throws ParseException {
        Units units;
        String[] stringArray = string.trim().split("\\s");
        if (stringArray.length == 1) {
            units = Units.dimensionless;
        } else {
            try {
                units = Units.getByName(stringArray[1]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException(illegalArgumentException.getMessage(), 0);
            }
        }
        return Datum.create(Double.parseDouble(stringArray[0]), units);
    }

    public static Datum parseValid(String string) {
        try {
            return DatumUtil.parse(string);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    public static Datum createValid(String string) {
        return Datum.create(Double.parseDouble(string), Units.dimensionless);
    }

    public static double[] doubleValues(Datum[] datumArray, Units units) {
        double[] dArray = new double[datumArray.length];
        for (int i = 0; i < datumArray.length; ++i) {
            dArray[i] = datumArray[i].doubleValue(units);
        }
        return dArray;
    }

    public static double[] doubleValues(Datum[] datumArray, Units[] unitsArray) {
        double[] dArray = new double[datumArray.length];
        for (int i = 0; i < datumArray.length; ++i) {
            dArray[i] = datumArray[i].doubleValue(unitsArray[i]);
        }
        return dArray;
    }

    public static Datum asOrderOneUnits(Datum datum) {
        Units units = datum.getUnits();
        if (units == Units.dimensionless) {
            return datum;
        }
        if (units == Units.dB) {
            return datum;
        }
        if (units instanceof LocationUnits) {
            return datum;
        }
        Units[] unitsArray = units.getConvertableUnits();
        double d = 0.0;
        Datum datum2 = datum;
        for (int i = 0; i < unitsArray.length; ++i) {
            Datum datum3 = datum.convertTo(unitsArray[i]);
            Number number = datum3.getValue();
            double d2 = Math.abs(number.doubleValue());
            double d3 = d2 > 20.0 ? 20.0 / d2 : d2;
            if (!(d3 > d)) continue;
            d = d3;
            datum2 = datum3;
        }
        return datum2;
    }
}

