/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumUtil;
import edu.uiowa.physics.pw.das.datum.MonthDatumRange;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatumRangeUtil {
    private static final int DATEFORMAT_USA = 1;
    private static final int DATEFORMAT_EUROPE = 0;
    private static final int DATEFORMAT_YYYY_DDD = 2;
    private static final boolean DEBUG = false;

    private static boolean isYear(String string) {
        return string.length() == 4 && Pattern.matches("\\d{4}", string);
    }

    private static boolean isDayOfYear(String string) {
        return string.length() == 3 && Pattern.matches("\\d{3}", string);
    }

    private static int monthNumber(String string) throws ParseException {
        if (Pattern.matches("\\d+", string)) {
            return DatumRangeUtil.parseInt(string);
        }
        int n = DatumRangeUtil.monthNameNumber(string);
        if (n == -1) {
            throw new ParseException("hoping for month at, got " + string, 0);
        }
        return n;
    }

    private static int monthNameNumber(String string) {
        if (string.length() < 3) {
            return -1;
        }
        String[] stringArray = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
        string = string.substring(0, 3).toLowerCase();
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            n = i;
        }
        if (n == -1) {
            return -1;
        }
        return n + 1;
    }

    private static int y2k(String string) throws ParseException {
        int n = DatumRangeUtil.parseInt(string);
        if (n > 100) {
            return n;
        }
        if (n < 70) {
            return 2000 + n;
        }
        return 1900 + n;
    }

    private int stregex(String string, String string2) {
        Matcher matcher = Pattern.compile(string2).matcher(string);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    private static void caldat(int n, DateDescriptor dateDescriptor) {
        int n2 = (int)(((double)(n - 1867216) - 0.25) / 36524.25);
        int n3 = n + 1 + n2 - n2 / 4;
        int n4 = n3 + 1524;
        int n5 = 6680 + (int)(((double)(n4 - 2439870) - 122.1) / 365.25);
        int n6 = 365 * n5 + n5 / 4;
        int n7 = (int)((double)(n4 - n6) / 30.6001);
        int n8 = n4 - n6 - (int)(30.6001 * (double)n7);
        int n9 = n7 - 1;
        n9 = (n9 - 1) % 12 + 1;
        int n10 = n5 - 4715;
        dateDescriptor.day = "" + n8;
        dateDescriptor.month = "" + n9;
        dateDescriptor.year = "" + (n10 -= (n10 -= n9 > 2 ? 1 : 0) <= 0 ? 1 : 0);
    }

    private static int julday(int n, int n2, int n3) {
        int n4 = 367 * n3 - 7 * (n3 + (n + 9) / 12) / 4 - 3 * ((n3 + (n - 9) / 7) / 100 + 1) / 4 + 275 * n / 9 + n2 + 1721029;
        return n4;
    }

    private static void printGroups(Matcher matcher) {
        for (int i = 0; i <= matcher.groupCount(); ++i) {
            System.out.println(" " + i + ": " + matcher.group(i));
        }
        System.out.println(" ");
    }

    private static int parseInt(String string) throws ParseException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("failed attempt to parse int in " + string, 0);
        }
    }

    public static DatumRange parseTimeRange(String string) throws ParseException {
        return new TimeRangeParser().parse(string);
    }

    public static DatumRange parseTimeRangeValid(String string) {
        try {
            return DatumRangeUtil.parseTimeRange(string);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    private static String efficientTime(Datum datum, Datum datum2, DatumRange datumRange) {
        int n;
        TimeUtil.TimeStruct timeStruct = TimeUtil.toTimeStruct(datum);
        int n2 = 4;
        if (TimeUtil.getSecondsSinceMidnight(datum) == 0.0 && datum.equals(datumRange.max())) {
            timeStruct.hour = 24;
            --timeStruct.day;
        }
        String string = "" + timeStruct.hour + ":";
        Datum[] datumArray = new Datum[]{datum, datum2};
        for (int i = 0; i < datumArray.length; ++i) {
            int[] nArray = TimeUtil.toTimeArray(datumArray[i]);
            for (n = 7; n > 3 && nArray[n] <= 0; --n) {
            }
            n2 = Math.max(n2, n);
        }
        int[] nArray = TimeUtil.toTimeArray(datum);
        if (n2 > 3) {
            string = string + (nArray[4] < 10 ? "0" : "") + nArray[4];
            if (n2 > 4) {
                int n3 = nArray[5];
                string = string + ":" + (n3 < 10 ? "0" : "") + n3;
                if (n2 > 5) {
                    n = nArray[6];
                    DecimalFormat decimalFormat = new DecimalFormat("000");
                    string = string + "." + decimalFormat.format(n);
                    if (n2 > 6) {
                        int n4 = nArray[7];
                        string = string + decimalFormat.format(n4);
                    }
                }
            }
        }
        return string;
    }

    public static String formatTimeRange(DatumRange datumRange) {
        String[] stringArray = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "June", "July", "Aug", "Sep", "Oct", "Nov", "Dec"};
        double d = datumRange.width().doubleValue(Units.seconds);
        TimeUtil.TimeStruct timeStruct = TimeUtil.toTimeStruct(datumRange.min());
        TimeUtil.TimeStruct timeStruct2 = TimeUtil.toTimeStruct(datumRange.max());
        boolean bl = TimeUtil.getSecondsSinceMidnight(datumRange.min()) == 0.0;
        boolean bl2 = TimeUtil.getSecondsSinceMidnight(datumRange.max()) == 0.0;
        boolean bl3 = bl && timeStruct.day == 1;
        boolean bl4 = bl2 && timeStruct2.day == 1;
        boolean bl5 = bl3 && timeStruct.month == 1;
        boolean bl6 = bl4 && timeStruct2.month == 1;
        String string = " through ";
        if (bl5 && bl6) {
            if (timeStruct2.year - timeStruct.year == 1) {
                return "" + timeStruct.year;
            }
            return "" + timeStruct.year + string + (timeStruct2.year - 1);
        }
        if (bl3 && bl4) {
            if (timeStruct2.month == 1) {
                timeStruct2.month = 13;
                --timeStruct2.year;
            }
            if (timeStruct2.year == timeStruct.year) {
                if (timeStruct2.month - timeStruct.month == 1) {
                    return stringArray[timeStruct.month - 1] + " " + timeStruct.year;
                }
                return stringArray[timeStruct.month - 1] + string + stringArray[timeStruct2.month - 1 - 1] + " " + timeStruct.year;
            }
            return stringArray[timeStruct.month - 1] + " " + timeStruct.year + string + stringArray[timeStruct2.month - 1 - 1] + " " + timeStruct2.year;
        }
        if (bl && bl2) {
            if (TimeUtil.getJulianDay(datumRange.max()) - TimeUtil.getJulianDay(datumRange.min()) == 1) {
                return TimeDatumFormatter.DAYS.format(datumRange.min());
            }
            Datum datum = datumRange.max().subtract(Datum.create(1, Units.days));
            return TimeDatumFormatter.DAYS.format(datumRange.min()) + string + TimeDatumFormatter.DAYS.format(datum);
        }
        if (d < 1.0) {
            TimeDatumFormatter timeDatumFormatter = TimeDatumFormatter.MILLISECONDS;
        } else if (d < 60.0) {
            TimeDatumFormatter timeDatumFormatter = TimeDatumFormatter.MILLISECONDS;
        } else if (d < 3600.0) {
            TimeDatumFormatter timeDatumFormatter = TimeDatumFormatter.SECONDS;
        } else {
            TimeDatumFormatter timeDatumFormatter = TimeDatumFormatter.MINUTES;
        }
        int n = TimeUtil.getJulianDay(datumRange.max());
        if (TimeUtil.getSecondsSinceMidnight(datumRange.max()) == 0.0) {
            --n;
        }
        if (n == TimeUtil.getJulianDay(datumRange.min())) {
            return TimeDatumFormatter.DAYS.format(datumRange.min()) + " " + DatumRangeUtil.efficientTime(datumRange.min(), datumRange.max(), datumRange) + " to " + DatumRangeUtil.efficientTime(datumRange.max(), datumRange.min(), datumRange);
        }
        String string2 = DatumRangeUtil.efficientTime(datumRange.min(), datumRange.max(), datumRange);
        String string3 = DatumRangeUtil.efficientTime(datumRange.max(), datumRange.min(), datumRange);
        return TimeDatumFormatter.DAYS.format(datumRange.min()) + " " + string2 + " to " + TimeDatumFormatter.DAYS.format(datumRange.max()) + " " + string3;
    }

    public static List generateList(DatumRange datumRange, DatumRange datumRange2) {
        ArrayList<DatumRange> arrayList = new ArrayList<DatumRange>();
        DatumRange datumRange3 = datumRange2;
        while (datumRange3.max().gt(datumRange.min())) {
            arrayList.add(0, datumRange3);
            datumRange3 = datumRange3.previous();
        }
        datumRange3 = datumRange2.next();
        while (datumRange3.min().lt(datumRange.max())) {
            arrayList.add(datumRange3);
            datumRange3 = datumRange3.next();
        }
        return arrayList;
    }

    public static DatumRange newDimensionless(double d, double d2) {
        return new DatumRange(Datum.create(d), Datum.create(d2));
    }

    public static DatumRange parseDatumRange(String string, Units units) throws ParseException {
        Datum datum;
        if (units instanceof TimeLocationUnits) {
            return DatumRangeUtil.parseTimeRange(string);
        }
        String[] stringArray = string.split("to");
        if (stringArray.length == 1) {
            stringArray = string.split("\u2013");
        }
        if (stringArray.length != 2) {
            if (stringArray.length == 3) {
                stringArray[0] = "-" + stringArray[1];
                stringArray[1] = stringArray[2];
            } else {
                throw new IllegalArgumentException("failed to parse: " + string);
            }
        }
        try {
            datum = DatumUtil.parse(stringArray[1]);
            if (datum.getUnits() == Units.dimensionless) {
                datum = units.parse(stringArray[1]);
            }
        }
        catch (ParseException parseException) {
            datum = units.parse(stringArray[1]);
        }
        Datum datum2 = datum.getUnits().parse(stringArray[0]);
        if (datum2.getUnits().isConvertableTo(units)) {
            return new DatumRange(datum2.convertTo(units), datum.convertTo(units));
        }
        throw new ParseException("Can't convert parsed unit (" + datum2.getUnits() + ") to " + units, 0);
    }

    public static DatumRange parseDatumRange(String string, DatumRange datumRange) throws ParseException {
        return DatumRangeUtil.parseDatumRange(string, datumRange.getUnits());
    }

    static class TimeRangeParser {
        String token;
        String delim = "";
        String string;
        int ipos;
        final int YEAR = 0;
        final int MONTH = 1;
        final int DAY = 2;
        final int HOUR = 3;
        final int MINUTE = 4;
        final int SECOND = 5;
        final int NANO = 6;
        final int STATE_OPEN = 89;
        final int STATE_TS1TIME = 90;
        final int STATE_TS2TIME = 91;
        int state = 89;
        String delimRegEx = " |-|/|\\.|:|to|through|T|Z|\u2013";
        Pattern delimPattern = Pattern.compile(this.delimRegEx);
        int[] ts1 = new int[]{-1, -1, -1, -1, -1, -1, -1};
        int[] ts2 = new int[]{-1, -1, -1, -1, -1, -1, -1};
        int[] ts = null;
        boolean beforeTo;
        private Pattern yyyymmddPattern = Pattern.compile("((\\d{4})(\\d{2})(\\d{2}))( |to|t|-)");

        TimeRangeParser() {
        }

        private boolean tryPattern(Pattern pattern, String string, int[] nArray, DateDescriptor dateDescriptor) throws ParseException {
            Matcher matcher = pattern.matcher(string.toLowerCase());
            if (matcher.find() && matcher.start() == 0) {
                int n = matcher.start();
                int n2 = matcher.end() - matcher.start();
                dateDescriptor.delim = matcher.group(nArray[3]);
                dateDescriptor.date = string.substring(matcher.start(), matcher.end() - dateDescriptor.delim.length());
                dateDescriptor.day = matcher.group(nArray[2]);
                dateDescriptor.month = matcher.group(nArray[1]);
                dateDescriptor.year = matcher.group(nArray[0]);
                return true;
            }
            return false;
        }

        public boolean isTime(String string, int[] nArray) throws ParseException {
            Pattern pattern = Pattern.compile("(\\d+):(\\d\\d+):(\\d\\d+).(\\d+) )");
            Pattern pattern2 = Pattern.compile("(\\d+):(\\d\\d+):(\\d\\d+)");
            Pattern pattern3 = Pattern.compile("(\\d+):(\\d\\d+)");
            Pattern pattern4 = Pattern.compile("(\\d+):");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                nArray[3] = Integer.parseInt(matcher.group(1));
                nArray[4] = Integer.parseInt(matcher.group(2));
                nArray[5] = Integer.parseInt(matcher.group(3));
                nArray[6] = (int)((double)Integer.parseInt(matcher.group(4)) * (100000.0 / DasMath.exp10(matcher.group(4).length())));
                throw new RuntimeException("working on this");
            }
            matcher = pattern2.matcher(string);
            if (matcher.matches() || (matcher = pattern3.matcher(string)).matches() || (matcher = pattern4.matcher(string)).matches()) {
                // empty if block
            }
            return false;
        }

        public boolean isDate(String string, DateDescriptor dateDescriptor) throws ParseException {
            int[] nArray;
            String string2;
            if (string.length() < 6) {
                return false;
            }
            String string3 = "( |to|t|-)";
            String string4 = "(\\d{2}(\\d{2})?)";
            if (this.tryPattern(this.yyyymmddPattern, string, new int[]{2, 3, 4, 5}, dateDescriptor)) {
                dateDescriptor.dateformat = 1;
                return true;
            }
            String string5 = "(/|\\.|-| )";
            Matcher matcher = Pattern.compile(string5).matcher(string);
            if (!matcher.find()) {
                return false;
            }
            int n = matcher.start();
            String string6 = string.substring(matcher.start(), matcher.end());
            String string7 = "(jan[a-z]*|feb[a-z]*|mar[a-z]*|apr[a-z]*|may|june?|july?|aug[a-z]*|sep[a-z]*|oct[a-z]*|nov[a-z]*|dec[a-z]*)";
            String string8 = "((\\d?\\d)|" + string7 + ")";
            String string9 = "(\\d?\\d)";
            if (string6.equals(".")) {
                string2 = "(" + string9 + "\\." + string8 + "\\." + string4 + string3 + ")";
                nArray = new int[]{6, 3, 2, 8};
            } else {
                string2 = "(" + string9 + string6 + string7 + string6 + string4 + string3 + ")";
                nArray = new int[]{4, 3, 2, 6};
            }
            if (this.tryPattern(Pattern.compile(string2), string, nArray, dateDescriptor)) {
                dateDescriptor.dateformat = 0;
                return true;
            }
            String string10 = string8 + string6 + string9 + string6 + string4 + string3;
            if (this.tryPattern(Pattern.compile(string10), string, new int[]{5, 1, 4, 7}, dateDescriptor)) {
                dateDescriptor.dateformat = 1;
                return true;
            }
            String string11 = "(\\d{4})" + string6 + string8 + string6 + string9 + string3;
            if (this.tryPattern(Pattern.compile(string11), string, new int[]{1, 2, 5, 6}, dateDescriptor)) {
                dateDescriptor.dateformat = 1;
                return true;
            }
            String string12 = "(\\d{3})";
            String string13 = string12 + "(-|/)" + string4 + string3;
            if (this.tryPattern(Pattern.compile(string13), string, new int[]{3, 1, 1, 5}, dateDescriptor)) {
                int n2 = DatumRangeUtil.parseInt(dateDescriptor.day);
                if (n2 > 366) {
                    return false;
                }
                int n3 = DatumRangeUtil.parseInt(dateDescriptor.year);
                DatumRangeUtil.caldat(DatumRangeUtil.julday(12, 31, n3 - 1) + n2, dateDescriptor);
                dateDescriptor.dateformat = 2;
                return true;
            }
            string13 = string4 + "(-|/)" + string12 + string3;
            if (this.tryPattern(Pattern.compile(string13), string, new int[]{1, 4, 4, 5}, dateDescriptor)) {
                int n4 = DatumRangeUtil.parseInt(dateDescriptor.day);
                if (n4 > 366) {
                    return false;
                }
                int n5 = DatumRangeUtil.parseInt(dateDescriptor.year);
                DatumRangeUtil.caldat(DatumRangeUtil.julday(12, 31, n5 - 1) + n4, dateDescriptor);
                dateDescriptor.dateformat = 2;
                return true;
            }
            return false;
        }

        private void nextToken() {
            Matcher matcher = this.delimPattern.matcher(this.string.substring(this.ipos));
            if (matcher.find()) {
                int n = matcher.start();
                int n2 = matcher.end() - matcher.start();
                this.token = this.string.substring(this.ipos, this.ipos + n);
                this.delim = this.string.substring(this.ipos + n, this.ipos + n + n2);
                this.ipos = this.ipos + n + n2;
            } else {
                this.token = this.string.substring(this.ipos);
                this.delim = "";
                this.ipos = this.string.length();
            }
        }

        private void setBeforeTo(boolean bl) {
            this.beforeTo = bl;
            this.ts = this.beforeTo ? this.ts1 : this.ts2;
        }

        public String normalizeTo(String string) throws ParseException {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '-') continue;
                ++n;
            }
            if (n == 0) {
                return string;
            }
            DateDescriptor dateDescriptor = new DateDescriptor();
            this.ipos = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while (this.ipos < string.length()) {
                if (this.isDate(string.substring(this.ipos), dateDescriptor)) {
                    this.ipos = this.ipos + dateDescriptor.date.length() + dateDescriptor.delim.length();
                    this.token = dateDescriptor.date;
                    this.delim = dateDescriptor.delim;
                } else {
                    this.nextToken();
                }
                stringBuffer.append(this.token);
                if (this.delim.equals("-")) {
                    stringBuffer.append("to");
                    continue;
                }
                stringBuffer.append(this.delim);
            }
            String string2 = stringBuffer.toString();
            String[] stringArray = string2.split("to");
            if (stringArray.length > 2) {
                string2 = stringArray[0];
                for (int i = 1; i < stringArray.length; ++i) {
                    string2 = string2 + "-" + stringArray[i];
                }
            } else if (stringArray.length == 2) {
                String string3 = stringArray[0].trim();
                String string4 = stringArray[1].trim();
                if (!DatumRangeUtil.isYear(string3) || !DatumRangeUtil.isYear(string4)) {
                    string2 = string3 + " " + string4;
                }
            }
            return string2;
        }

        public DatumRange parse(String string) throws ParseException {
            int n;
            int n2;
            Object object;
            int n3;
            int n4;
            CharSequence charSequence;
            String string2;
            Logger logger = DasApplication.getDefaultApplication().getLogger(DasApplication.SYSTEM_LOG);
            this.string = string + " ";
            this.ipos = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String[] stringArray = new String[]{"%y", "%m", "%d", "%H", "%M", "%S", ""};
            stringArray[6] = "%N";
            String[] stringArray2 = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "NANO"};
            boolean bl = false;
            int n5 = 89;
            String string3 = "";
            this.setBeforeTo(true);
            DateDescriptor dateDescriptor = new DateDescriptor();
            int n6 = 1;
            this.string = string2 = this.normalizeTo(this.string);
            this.ipos = 0;
            while (this.ipos < this.string.length()) {
                int n7;
                charSequence = this.delim;
                string3 = string3 + (String)charSequence;
                if (((String)charSequence).equals("to")) {
                    this.setBeforeTo(false);
                }
                if (((String)charSequence).equals("through")) {
                    this.setBeforeTo(false);
                    bl = true;
                }
                if (((String)charSequence).equals("\u2013")) {
                    this.setBeforeTo(false);
                }
                if (this.isDate(this.string.substring(this.ipos), dateDescriptor)) {
                    string3 = string3 + "%x";
                    if (this.ts1[2] != -1 || this.ts1[1] != -1 || this.ts1[0] != -1) {
                        this.setBeforeTo(false);
                    }
                    n4 = DatumRangeUtil.monthNumber(dateDescriptor.month);
                    n7 = DatumRangeUtil.y2k(dateDescriptor.year);
                    this.ts[2] = n3 = DatumRangeUtil.parseInt(dateDescriptor.day);
                    this.ts[1] = n4;
                    this.ts[0] = n7;
                    this.delim = dateDescriptor.delim;
                    this.ipos = this.ipos + dateDescriptor.date.length() + dateDescriptor.delim.length();
                    continue;
                }
                this.nextToken();
                if (this.token.equals("")) continue;
                if (DatumRangeUtil.isYear(this.token)) {
                    string3 = string3 + "%Y";
                    if (this.ts1[0] == -1 && this.beforeTo) {
                        this.ts1[0] = DatumRangeUtil.parseInt(this.token);
                        this.ts2[0] = this.ts1[0];
                        continue;
                    }
                    this.setBeforeTo(false);
                    this.ts2[0] = DatumRangeUtil.parseInt(this.token);
                    if (this.ts1[0] != -1) continue;
                    this.ts1[0] = this.ts2[0];
                    continue;
                }
                if (DatumRangeUtil.isDayOfYear(this.token)) {
                    n6 = 2;
                    string3 = string3 + "%j";
                    if (this.ts1[0] == -1) {
                        throw new ParseException("day of year before year: " + string + " (" + string3 + ")", this.ipos);
                    }
                    n4 = DatumRangeUtil.parseInt(this.token);
                    DatumRangeUtil.caldat(DatumRangeUtil.julday(12, 31, this.ts1[0] - 1) + n4, dateDescriptor);
                    n6 = 2;
                    n7 = DatumRangeUtil.parseInt(dateDescriptor.day);
                    n3 = DatumRangeUtil.parseInt(dateDescriptor.month);
                    if (this.ts1[2] == -1 && this.beforeTo) {
                        this.ts1[2] = n7;
                        this.ts1[1] = n3;
                        this.ts2[2] = n7;
                        this.ts2[1] = n3;
                        continue;
                    }
                    this.setBeforeTo(false);
                    this.ts2[2] = n7;
                    this.ts2[1] = n3;
                    if (this.ts1[2] != -1) continue;
                    this.ts1[2] = n7;
                    this.ts1[1] = n3;
                    continue;
                }
                if (DatumRangeUtil.monthNameNumber(this.token) != -1) {
                    string3 = string3 + "%b";
                    n4 = DatumRangeUtil.monthNameNumber(this.token);
                    if (this.ts1[1] == -1) {
                        this.ts1[1] = n4;
                        this.ts2[1] = n4;
                        continue;
                    }
                    this.setBeforeTo(false);
                    this.ts2[1] = n4;
                    if (this.ts1[1] != -1) continue;
                    this.ts1[1] = n4;
                    continue;
                }
                int n8 = n4 = this.delim.equals(":") || ((String)charSequence).equals(":") ? 1 : 0;
                if (n4 != 0) {
                    if (this.delim.equals(":") && !((String)charSequence).equals(":") && n5 == 89) {
                        string3 = string3 + "%H";
                        if (this.beforeTo && this.ts1[3] == -1) {
                            n5 = 90;
                        } else {
                            this.setBeforeTo(false);
                            n5 = 91;
                        }
                        this.ts[3] = DatumRangeUtil.parseInt(this.token);
                    } else {
                        for (n7 = 3; n7 <= 6 && this.ts[n7] != -1; ++n7) {
                        }
                        if (n7 == 5 && this.delim.equals(".")) {
                            this.ts[n7] = DatumRangeUtil.parseInt(this.token);
                            string3 = string3 + stringArray[n7];
                            this.nextToken();
                            n7 = 6;
                        }
                        if (n7 == 6) {
                            n3 = this.token.length();
                            this.ts[n7] = DatumRangeUtil.parseInt(this.token) * (int)Math.pow(10.0, 9 - n3);
                            switch (n3) {
                                case 3: {
                                    string3 = string3 + "%_ms";
                                    break;
                                }
                                case 6: {
                                    string3 = string3 + "%_us";
                                    break;
                                }
                                default: {
                                    string3 = string3 + "%N";
                                    break;
                                }
                            }
                        } else {
                            this.ts[n7] = DatumRangeUtil.parseInt(this.token);
                            string3 = string3 + stringArray[n7];
                        }
                    }
                    if (this.delim.equals(":") || this.delim.equals(".")) continue;
                    n5 = 89;
                    continue;
                }
                if (this.beforeTo) {
                    arrayList.add(this.token);
                    string3 = string3 + "UNRSV1" + arrayList.size();
                    continue;
                }
                arrayList2.add(this.token);
                string3 = string3 + "UNRSV2" + arrayList2.size();
            }
            string3 = string3 + " ";
            charSequence = new StringBuffer("ts1: ");
            for (n4 = 0; n4 < 7; ++n4) {
                ((StringBuffer)charSequence).append("" + this.ts1[n4] + " ");
            }
            logger.fine(((StringBuffer)charSequence).toString());
            charSequence = new StringBuffer("ts2: ");
            for (n4 = 0; n4 < 7; ++n4) {
                ((StringBuffer)charSequence).append("" + this.ts2[n4] + " ");
            }
            logger.fine(((StringBuffer)charSequence).toString());
            logger.fine(string3);
            if (this.beforeTo) {
                int n9 = 0;
                for (n4 = 0; n4 < arrayList.size(); ++n4) {
                    while (this.ts1[n9] != -1) {
                        ++n9;
                    }
                    this.ts1[n9] = DatumRangeUtil.parseInt((String)arrayList.get(n4));
                    String[] stringArray3 = string3.split("UNRSV1" + (n4 + 1));
                    string3 = stringArray3[0] + stringArray[n9] + stringArray3[1];
                }
                arrayList.removeAll(arrayList);
            }
            if (arrayList.size() + arrayList2.size() > 0) {
                String string4;
                ArrayList<String> arrayList3;
                String[] stringArray4;
                int n10;
                if (arrayList.size() < arrayList2.size()) {
                    if (arrayList.size() > 0) {
                        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                            while (n10 < 7 && this.ts2[n10] != -1) {
                                ++n10;
                            }
                            if (n10 == 7) {
                                throw new ParseException("can't resolve token in \"" + string + "\": " + arrayList2.get(n3) + " (" + string3 + ")", 0);
                            }
                            this.ts2[n10] = DatumRangeUtil.parseInt((String)arrayList2.get(n3));
                            stringArray4 = string3.split("UNRSV2" + (n3 + 1));
                            string3 = stringArray4[0] + stringArray[n10] + stringArray4[1];
                        }
                        arrayList3 = arrayList;
                        string4 = "UNRSV1";
                        this.ts = this.ts1;
                    } else {
                        for (n10 = 0; n10 < 7 && this.ts1[n10] != -1; ++n10) {
                        }
                        --n10;
                        arrayList3 = arrayList2;
                        string4 = "UNRSV2";
                        this.ts = this.ts2;
                    }
                } else if (arrayList2.size() > 0) {
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        while (n10 < 7 && this.ts1[n10] != -1) {
                            ++n10;
                        }
                        if (n10 == 7) {
                            throw new ParseException("can't resolve token in \"" + string + "\": " + arrayList.get(n3) + " (" + string3 + ")", 0);
                        }
                        this.ts1[n10] = DatumRangeUtil.parseInt((String)arrayList.get(n3));
                        stringArray4 = string3.split("UNRSV1" + (n3 + 1));
                        string3 = stringArray4[0] + stringArray[n10] + stringArray4[1];
                    }
                    arrayList3 = arrayList2;
                    string4 = "UNRSV2";
                    this.ts = this.ts2;
                } else {
                    while (n10 < 7 && this.ts2[n10] != -1) {
                        ++n10;
                    }
                    --n10;
                    arrayList3 = arrayList;
                    string4 = "UNRSV1";
                    this.ts = this.ts1;
                }
                n3 = n10;
                for (int i = arrayList3.size() - 1; i >= 0; --i) {
                    while (this.ts[n3] != -1 && n3 > 0) {
                        --n3;
                    }
                    if (this.ts[n3] != -1) {
                        throw new ParseException("can't resolve these tokens in \"" + string + "\": " + arrayList3 + " (" + string3 + ")", 0);
                    }
                    this.ts[n3] = DatumRangeUtil.parseInt((String)arrayList3.get(i));
                    object = string3.split(string4 + (i + 1));
                    string3 = object[0] + stringArray[n3] + object[1];
                }
            }
            StringBuffer stringBuffer = new StringBuffer("ts1: ");
            for (n2 = 0; n2 < 7; ++n2) {
                stringBuffer.append("" + this.ts1[n2] + " ");
            }
            logger.fine(stringBuffer.toString());
            stringBuffer = new StringBuffer("ts2: ");
            for (n2 = 0; n2 < 7; ++n2) {
                stringBuffer.append("" + this.ts2[n2] + " ");
            }
            logger.fine(stringBuffer.toString());
            logger.fine(string3);
            for (n = 0; n <= 2; ++n) {
                if (this.ts2[n] == -1 && this.ts1[n] != -1) {
                    this.ts2[n] = this.ts1[n];
                }
                if (this.ts1[n] != -1 || this.ts2[n] == -1) continue;
                this.ts1[n] = this.ts2[n];
            }
            int[] nArray = new int[]{-1, 1, 1, 0, 0, 0, 0};
            int n11 = -1;
            n3 = -1;
            for (n = 6; n >= 0; --n) {
                if (this.ts2[n] != -1 && n3 == -1) {
                    n3 = n;
                }
                if (n3 == -1) {
                    this.ts2[n] = nArray[n];
                }
                if (this.ts2[n] == -1 && n3 != -1) {
                    throw new ParseException("not specified in stop time: " + stringArray2[n] + " in " + string + " (" + string3 + ")", this.ipos);
                }
                if (this.ts1[n] != -1 && n11 == -1) {
                    n11 = n;
                }
                if (n11 == -1) {
                    this.ts1[n] = nArray[n];
                }
                if (this.ts1[n] != -1 || n11 == -1) continue;
                throw new ParseException("not specified in start time:" + stringArray2[n] + " in " + string + " (" + string3 + ")", this.ipos);
            }
            if (n11 != n3 && (n11 < 3 || n3 < 3)) {
                throw new ParseException("resolution mismatch: " + stringArray2[n11] + " specified for start, but " + stringArray2[n3] + " specified for end, must be same" + " in \"" + string + "\"" + " (" + string3 + ")", this.ipos);
            }
            if (this.beforeTo) {
                bl = true;
            }
            if (bl) {
                int n12 = n3;
                this.ts2[n12] = this.ts2[n12] + 1;
            }
            if (this.ts1[0] < 1900) {
                this.ts1[0] = DatumRangeUtil.y2k("" + this.ts1[0]);
            }
            if (this.ts2[0] < 1900) {
                this.ts2[0] = DatumRangeUtil.y2k("" + this.ts2[0]);
            }
            if (n11 < 2) {
                try {
                    return new MonthDatumRange(this.ts1, this.ts2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    object = new ParseException("fails to parse due to MonthDatumRange: " + string + " (" + string3 + ")", 0);
                    ((Throwable)object).initCause(illegalArgumentException);
                    throw object;
                }
            }
            Datum datum = TimeUtil.createTimeDatum(this.ts1[0], this.ts1[1], this.ts1[2], this.ts1[3], this.ts1[4], this.ts1[5], this.ts1[6]);
            object = TimeUtil.createTimeDatum(this.ts2[0], this.ts2[1], this.ts2[2], this.ts2[3], this.ts2[4], this.ts2[5], this.ts2[6]);
            return new DatumRange(datum, (Datum)object);
        }
    }

    public static class DateDescriptor {
        String date;
        String year;
        String month;
        String day;
        String delim;
        int dateformat;
    }
}

