/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRangeUtil;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.Units;

public class DatumRange
implements Comparable {
    Datum s1;
    Datum s2;

    public DatumRange(Datum datum, Datum datum2) {
        if (datum2.lt(datum)) {
            throw new IllegalArgumentException("s2<s1: " + datum2 + "<" + datum);
        }
        this.s1 = datum;
        this.s2 = datum2;
    }

    public DatumRange(double d, double d2, Units units) {
        this(Datum.create(d, units), Datum.create(d2, units));
    }

    public boolean intersects(DatumRange datumRange) {
        return this.s2.gt(datumRange.s1) && this.s1.lt(datumRange.s2);
    }

    public DatumRange intersection(DatumRange datumRange) {
        if (this.intersects(datumRange)) {
            Units units = this.getUnits();
            double d = this.s1.doubleValue(units);
            double d2 = datumRange.s1.doubleValue(units);
            double d3 = this.s2.doubleValue(units);
            double d4 = datumRange.s2.doubleValue(units);
            return new DatumRange(Math.max(d, d2), Math.min(d3, d4), units);
        }
        throw new IllegalArgumentException("does not intersect: " + datumRange);
    }

    public boolean contains(DatumRange datumRange) {
        return this.s1.le(datumRange.s1) && datumRange.s2.le(this.s2);
    }

    public DatumRange union(DatumRange datumRange) {
        if (this.intersects(datumRange) || this.max().equals(datumRange.min()) || this.min().equals(datumRange.max())) {
            Units units = this.getUnits();
            double d = this.s1.doubleValue(units);
            double d2 = datumRange.s1.doubleValue(units);
            double d3 = this.s2.doubleValue(units);
            double d4 = datumRange.s2.doubleValue(units);
            return new DatumRange(Math.min(d, d2), Math.max(d3, d4), units);
        }
        throw new IllegalArgumentException("does not intersect or touch: " + datumRange);
    }

    public boolean contains(Datum datum) {
        return this.s1.le(datum) && datum.lt(this.s2);
    }

    public Datum width() {
        return this.s2.subtract(this.s1);
    }

    public String toString() {
        if (this.s1.getUnits() instanceof TimeLocationUnits) {
            return DatumRangeUtil.formatTimeRange(this);
        }
        return "" + this.s1 + " to " + this.s2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DatumRange)) {
            return false;
        }
        return this == object || 0 == this.compareTo(object);
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new NullPointerException("Cannot compare to null");
        }
        if (!(object instanceof DatumRange)) {
            throw new IllegalArgumentException("argument is not a DatumRange");
        }
        DatumRange datumRange = (DatumRange)object;
        int n = this.s1.compareTo(datumRange.s1);
        if (n != 0) {
            return n;
        }
        return this.s2.compareTo(datumRange.s2);
    }

    public DatumRange zoomOut(double d) {
        double d2 = (d - 1.0) / 2.0;
        return this.rescale(-d2, 1.0 + d2);
    }

    public DatumRange rescale(double d, double d2) {
        Datum datum = this.width();
        if (!datum.isFinite()) {
            throw new RuntimeException("width is not finite");
        }
        if (datum.doubleValue(datum.getUnits()) == 0.0) {
            throw new RuntimeException("width is zero!");
        }
        return new DatumRange(this.s1.add(datum.multiply(d)), this.s1.add(datum.multiply(d2)));
    }

    public double normalize(Datum datum) {
        return datum.subtract(this.s1).divide(this.width()).doubleValue(Units.dimensionless);
    }

    public Datum min() {
        return this.s1;
    }

    public Datum max() {
        return this.s2;
    }

    public DatumRange next() {
        return this.rescale(1.0, 2.0);
    }

    public DatumRange previous() {
        return this.rescale(-1.0, 0.0);
    }

    public DatumRange include(Datum datum) {
        if (datum.isFill()) {
            return this;
        }
        if (this.contains(datum)) {
            return this;
        }
        Datum datum2 = this.min().le(datum) ? this.min() : datum;
        Datum datum3 = this.max().ge(datum) ? this.max() : datum;
        return new DatumRange(datum2, datum3);
    }

    public Units getUnits() {
        return this.s1.getUnits();
    }

    public static DatumRange newDatumRange(double d, double d2, Units units) {
        return new DatumRange(Datum.create(d, units), Datum.create(d2, units));
    }
}

