/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;

public class Datum
implements Comparable {
    private Units units;
    private Number value;
    private double resolution;
    private DatumFormatter formatter;

    private Datum(Number number, Units units, double d) {
        this(number, units, units.getDatumFormatterFactory().defaultFormatter(), d);
    }

    private Datum(Number number, Units units, DatumFormatter datumFormatter, double d) {
        this.value = number;
        this.units = units;
        this.resolution = d;
        this.formatter = datumFormatter;
    }

    protected double doubleValue() {
        return this.getValue().doubleValue();
    }

    public double doubleValue(Units units) {
        if (units != this.getUnits()) {
            return this.getUnits().getConverter(units).convert(this.getValue()).doubleValue();
        }
        return this.getValue().doubleValue();
    }

    public double getResolution(Units units) {
        Units units2 = this.getUnits().getOffsetUnits();
        if (units != units2) {
            return units2.getConverter(units).convert(this.resolution);
        }
        return this.resolution;
    }

    protected int intValue() {
        return this.getValue().intValue();
    }

    public int intValue(Units units) {
        if (units != this.getUnits()) {
            return this.getUnits().getConverter(units).convert(this.getValue()).intValue();
        }
        return this.getValue().intValue();
    }

    public Units getUnits() {
        return this.units;
    }

    public Number getValue() {
        return this.value;
    }

    public boolean isFill() {
        return this.getUnits().isFill(this.getValue());
    }

    public Datum add(Datum datum) {
        Datum datum2 = this.add(datum.getValue(), datum.getUnits());
        datum2.resolution = Math.sqrt(datum.resolution * datum.resolution + this.resolution * this.resolution);
        return datum2;
    }

    public Datum add(Number number, Units units) {
        return this.getUnits().add(this.getValue(), number, units);
    }

    public Datum add(double d, Units units) {
        return this.add(new java.lang.Double(d), units);
    }

    public Datum subtract(Datum datum) {
        Datum datum2 = this.subtract(datum.getValue(), datum.getUnits());
        datum2.resolution = Math.sqrt(datum.resolution * datum.resolution + this.resolution * this.resolution);
        return datum2;
    }

    public Datum subtract(Number number, Units units) {
        Datum datum = this.getUnits().subtract(this.getValue(), number, units);
        return datum;
    }

    public Datum subtract(double d, Units units) {
        return this.subtract(new java.lang.Double(d), units);
    }

    public Datum divide(Datum datum) {
        return this.getUnits().divide(this.getValue(), datum.getValue(), datum.getUnits());
    }

    public Datum divide(Number number, Units units) {
        return this.getUnits().divide(this.getValue(), number, units);
    }

    public Datum divide(double d) {
        return this.divide(new java.lang.Double(d), Units.dimensionless);
    }

    public Datum multiply(Datum datum) {
        return this.getUnits().multiply(this.getValue(), datum.getValue(), datum.getUnits());
    }

    public Datum multiply(Number number, Units units) {
        return this.getUnits().multiply(this.getValue(), number, units);
    }

    public Datum multiply(double d) {
        return this.multiply(new java.lang.Double(d), Units.dimensionless);
    }

    public Datum convertTo(Units units) throws IllegalArgumentException {
        UnitsConverter unitsConverter = this.units.getConverter(units);
        Datum datum = units.createDatum(unitsConverter.convert(this.getValue()));
        if (this.resolution != 0.0) {
            unitsConverter = this.units.getOffsetUnits().getConverter(units.getOffsetUnits());
            datum.resolution = unitsConverter.convert(this.resolution);
        }
        return datum;
    }

    public int hashCode() {
        long l = this.getValue().hashCode();
        int n = (int)(l ^ l >>> 32);
        int n2 = this.units.hashCode();
        return n ^ n2;
    }

    public boolean equals(Object object) throws IllegalArgumentException {
        return object instanceof Datum && this.equals((Datum)object);
    }

    public boolean equals(Datum datum) throws IllegalArgumentException {
        return datum.units == this.units && datum.value.equals(this.value);
    }

    public boolean lt(Datum datum) throws IllegalArgumentException {
        return this.compareTo(datum) < 0;
    }

    public boolean gt(Datum datum) throws IllegalArgumentException {
        return this.compareTo(datum) > 0;
    }

    public boolean le(Datum datum) throws IllegalArgumentException {
        return this.compareTo(datum) <= 0;
    }

    public boolean ge(Datum datum) throws IllegalArgumentException {
        return this.compareTo(datum) >= 0;
    }

    public int compareTo(Object object) throws IllegalArgumentException {
        if (!(object instanceof Datum)) {
            throw new IllegalArgumentException("comparable type mismatch");
        }
        return this.compareTo((Datum)object);
    }

    public int compareTo(Datum datum) throws IllegalArgumentException {
        double d;
        if (this.units != datum.units) {
            datum = datum.convertTo(this.units);
        }
        if ((d = this.getValue().doubleValue() - datum.getValue().doubleValue()) == 0.0) {
            return 0;
        }
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    public boolean isValid() {
        return this.value.doubleValue() != java.lang.Double.NaN;
    }

    public boolean isFinite() {
        return this.value.doubleValue() != java.lang.Double.POSITIVE_INFINITY && this.value.doubleValue() != java.lang.Double.NEGATIVE_INFINITY;
    }

    public String toString() {
        if (this.formatter == null) {
            return this.units.getDatumFormatterFactory().defaultFormatter().format(this);
        }
        return this.formatter.format(this);
    }

    public static Datum create(double d) {
        return Units.dimensionless.createDatum(d);
    }

    public static Datum create(double d, Units units) {
        return units.createDatum(d);
    }

    public static Datum create(double d, Units units, DatumFormatter datumFormatter) {
        Datum datum = Datum.create(d, units);
        datum.formatter = datumFormatter;
        return datum;
    }

    public static Datum create(double d, Units units, double d2) {
        Datum datum = units.createDatum(d, d2);
        datum.formatter = units.getDatumFormatterFactory().defaultFormatter();
        return datum;
    }

    public static Datum create(int n) {
        return Units.dimensionless.createDatum(n);
    }

    public static Datum create(int n, Units units) {
        return units.createDatum(n);
    }

    public DatumFormatter getFormatter() {
        return this.formatter;
    }

    public static class Double
    extends Datum {
        Double(Number number, Units units) {
            super(number, units, 0.0);
        }

        Double(double d, Units units) {
            super((Number)new java.lang.Double(d), units, 0.0);
        }

        Double(double d) {
            super((Number)new java.lang.Double(d), Units.dimensionless, 0.0);
        }

        Double(double d, Units units, double d2) {
            super(new java.lang.Double(d), units, units.getDatumFormatterFactory().defaultFormatter(), d2);
        }
    }
}

