/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.XSliceDataSet;
import edu.uiowa.physics.pw.das.dataset.YSliceDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.HashMap;
import java.util.Map;

public class WritableTableDataSet
implements TableDataSet {
    double[] z;
    double[] x;
    double[] y;
    final int nx;
    final int ny;
    Units xunits;
    Units yunits;
    Units zunits;
    Map properties;

    public static WritableTableDataSet newSimple(int n, Units units, int n2, Units units2, Units units3) {
        double[] dArray = new double[n * n2];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n2];
        return new WritableTableDataSet(dArray2, units, dArray3, units2, dArray, units3, new HashMap());
    }

    public static WritableTableDataSet newEmpty(TableDataSet tableDataSet) {
        int n;
        if (tableDataSet.tableCount() > 1) {
            throw new IllegalArgumentException("only supported for simple tables");
        }
        int n2 = tableDataSet.tableEnd(0);
        int n3 = tableDataSet.getYLength(0);
        WritableTableDataSet writableTableDataSet = WritableTableDataSet.newSimple(n2, tableDataSet.getXUnits(), n3, tableDataSet.getYUnits(), tableDataSet.getZUnits());
        for (n = 0; n < n2; ++n) {
            writableTableDataSet.setXTagDouble(n, tableDataSet.getXTagDouble(n, tableDataSet.getXUnits()), tableDataSet.getXUnits());
        }
        for (n = 0; n < n3; ++n) {
            writableTableDataSet.setYTagDouble(0, n, tableDataSet.getYTagDouble(0, n, tableDataSet.getYUnits()), tableDataSet.getYUnits());
        }
        if (tableDataSet.getProperty("xTagWidth") != null) {
            writableTableDataSet.setProperty("xTagWidth", tableDataSet.getProperty("xTagWidth"));
        }
        if (tableDataSet.getProperty("yTagWidth") != null) {
            writableTableDataSet.setProperty("yTagWidth", tableDataSet.getProperty("yTagWidth"));
        }
        return writableTableDataSet;
    }

    public static WritableTableDataSet newCopy(TableDataSet tableDataSet) {
        if (tableDataSet.tableCount() > 1) {
            throw new IllegalArgumentException("only supported for simple tables");
        }
        int n = tableDataSet.tableEnd(0);
        int n2 = tableDataSet.getYLength(0);
        WritableTableDataSet writableTableDataSet = WritableTableDataSet.newEmpty(tableDataSet);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                writableTableDataSet.setDouble(i, j, tableDataSet.getDouble(i, j, tableDataSet.getZUnits()), tableDataSet.getZUnits());
            }
        }
        writableTableDataSet.properties = new HashMap(tableDataSet.getProperties());
        return writableTableDataSet;
    }

    private WritableTableDataSet(double[] dArray, Units units, double[] dArray2, Units units2, double[] dArray3, Units units3, Map map) {
        this.z = dArray3;
        this.x = dArray;
        this.y = dArray2;
        this.nx = dArray.length;
        this.ny = dArray2.length;
        this.zunits = units3;
        this.yunits = units2;
        this.xunits = units;
        this.properties = map;
    }

    private final int indexOf(int n, int n2) {
        return n * this.ny + n2;
    }

    public Datum getDatum(int n, int n2) {
        return Datum.create(this.z[this.indexOf(n, n2)], this.zunits);
    }

    public void setDatum(int n, int n2, Datum datum) {
        this.z[this.indexOf((int)n, (int)n2)] = datum.doubleValue(this.zunits);
    }

    public double getDouble(int n, int n2, Units units) {
        if (units == this.zunits) {
            return this.z[this.indexOf(n, n2)];
        }
        return this.zunits.convertDoubleTo(units, this.z[this.indexOf(n, n2)]);
    }

    public void setDouble(int n, int n2, double d, Units units) {
        this.z[this.indexOf((int)n, (int)n2)] = units == this.zunits ? d : units.convertDoubleTo(this.zunits, d);
    }

    public double[] getDoubleScan(int n, Units units) {
        throw new UnsupportedOperationException();
    }

    public int getInt(int n, int n2, Units units) {
        throw new UnsupportedOperationException();
    }

    public DataSet getPlanarView(String string) {
        return null;
    }

    public String[] getPlaneIds() {
        return new String[0];
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public DatumVector getScan(int n) {
        throw new UnsupportedOperationException();
    }

    public int getXLength() {
        return this.x.length;
    }

    public VectorDataSet getXSlice(int n) {
        return new XSliceDataSet(this, n);
    }

    public Datum getXTagDatum(int n) {
        return Datum.create(this.x[n], this.xunits);
    }

    public double getXTagDouble(int n, Units units) {
        return this.xunits.convertDoubleTo(units, this.x[n]);
    }

    public void setXTagDouble(int n, double d, Units units) {
        this.x[n] = units.convertDoubleTo(this.xunits, d);
    }

    public int getXTagInt(int n, Units units) {
        throw new UnsupportedOperationException();
    }

    public Units getXUnits() {
        return this.xunits;
    }

    public int getYLength(int n) {
        return this.y.length;
    }

    public VectorDataSet getYSlice(int n, int n2) {
        return new YSliceDataSet(this, n, n2);
    }

    public Datum getYTagDatum(int n, int n2) {
        return Datum.create(this.y[n2], this.yunits);
    }

    public double getYTagDouble(int n, int n2, Units units) {
        return this.yunits.convertDoubleTo(units, this.y[n2]);
    }

    public void setYTagDouble(int n, int n2, double d, Units units) {
        this.y[n2] = units.convertDoubleTo(this.yunits, d);
    }

    public int getYTagInt(int n, int n2, Units units) {
        throw new UnsupportedOperationException();
    }

    public DatumVector getYTags(int n) {
        return DatumVector.newDatumVector(this.y, this.yunits);
    }

    public Units getYUnits() {
        return this.yunits;
    }

    public Units getZUnits() {
        return this.zunits;
    }

    public int tableCount() {
        return 1;
    }

    public int tableEnd(int n) {
        return this.x.length;
    }

    public int tableOfIndex(int n) {
        return 0;
    }

    public int tableStart(int n) {
        return 0;
    }

    public Map getProperties() {
        return new HashMap(this.properties);
    }
}

