/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.HashMap;
import java.util.Map;

public class WeightsTableDataSet
implements TableDataSet {
    TableDataSet source;
    Units sourceUnits;
    double fill;

    public static TableDataSet create(TableDataSet tableDataSet) {
        if (tableDataSet.getPlanarView("weights") != null) {
            return (TableDataSet)tableDataSet.getPlanarView("weights");
        }
        return new WeightsTableDataSet(tableDataSet);
    }

    private WeightsTableDataSet(TableDataSet tableDataSet) {
        this.source = tableDataSet;
        this.sourceUnits = tableDataSet.getZUnits();
        this.fill = tableDataSet.getZUnits().getFillDouble();
    }

    public Datum getDatum(int n, int n2) {
        return Units.dimensionless.createDatum(this.getDouble(n, n2, Units.dimensionless));
    }

    public double getDouble(int n, int n2, Units units) {
        return this.sourceUnits.isFill(this.source.getDouble(n, n2, this.sourceUnits)) ? 0.0 : 1.0;
    }

    public double[] getDoubleScan(int n, Units units) {
        throw new IllegalStateException("not implemented");
    }

    public int getInt(int n, int n2, Units units) {
        return this.source.getDouble(n, n2, this.sourceUnits) != this.fill ? 1 : 0;
    }

    public DataSet getPlanarView(String string) {
        return this;
    }

    public String[] getPlaneIds() {
        return new String[]{""};
    }

    public Map getProperties() {
        return new HashMap();
    }

    public Object getProperty(String string) {
        return null;
    }

    public DatumVector getScan(int n) {
        throw new IllegalStateException("not implemented");
    }

    public int getXLength() {
        return this.source.getXLength();
    }

    public VectorDataSet getXSlice(int n) {
        throw new IllegalStateException("not implemented");
    }

    public Datum getXTagDatum(int n) {
        return this.source.getXTagDatum(n);
    }

    public double getXTagDouble(int n, Units units) {
        return this.source.getXTagDouble(n, units);
    }

    public int getXTagInt(int n, Units units) {
        return this.source.getXTagInt(n, units);
    }

    public Units getXUnits() {
        return this.source.getXUnits();
    }

    public int getYLength(int n) {
        return this.source.getYLength(n);
    }

    public VectorDataSet getYSlice(int n, int n2) {
        throw new IllegalStateException("not implemented");
    }

    public Datum getYTagDatum(int n, int n2) {
        return this.source.getYTagDatum(n, n2);
    }

    public double getYTagDouble(int n, int n2, Units units) {
        return this.source.getYTagDouble(n, n2, units);
    }

    public int getYTagInt(int n, int n2, Units units) {
        return this.source.getYTagInt(n, n2, units);
    }

    public DatumVector getYTags(int n) {
        return this.source.getYTags(n);
    }

    public Units getYUnits() {
        return this.source.getYUnits();
    }

    public Units getZUnits() {
        return Units.dimensionless;
    }

    public int tableCount() {
        return this.source.tableCount();
    }

    public int tableEnd(int n) {
        return this.source.tableEnd(n);
    }

    public int tableOfIndex(int n) {
        return this.source.tableOfIndex(n);
    }

    public int tableStart(int n) {
        return this.source.tableStart(n);
    }
}

