/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.LocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsUtil;
import edu.uiowa.physics.pw.das.stream.DataTransferType;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamProducer;
import edu.uiowa.physics.pw.das.stream.StreamXDescriptor;
import edu.uiowa.physics.pw.das.util.FixedWidthFormatter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class VectorUtil {
    public static double[] getXTagArrayDouble(DataSet dataSet, Units units) {
        int n = dataSet.getXLength();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = dataSet.getXTagDouble(i, units);
        }
        return dArray;
    }

    private static int closest(double[] dArray, double d) {
        int n;
        for (n = 0; n < dArray.length - 1 && dArray[n] < d; ++n) {
        }
        while (n > 0 && dArray[n] > d) {
            --n;
        }
        if (n < dArray.length - 2) {
            n = (d - dArray[n]) / (dArray[n + 1] - dArray[n]) < 0.5 ? n : n + 1;
        }
        return n;
    }

    public static int closestXTag(DataSet dataSet, Datum datum) {
        return VectorUtil.closestXTag(dataSet, datum.doubleValue(datum.getUnits()), datum.getUnits());
    }

    public static int closestXTag(DataSet dataSet, double d, Units units) {
        double[] dArray = VectorUtil.getXTagArrayDouble(dataSet, units);
        return VectorUtil.closest(dArray, d);
    }

    public static Datum median(VectorDataSet vectorDataSet) {
        int n;
        double[] dArray = new double[vectorDataSet.getXLength()];
        int n2 = 0;
        Units units = vectorDataSet.getYUnits();
        for (n = 0; n < vectorDataSet.getXLength(); ++n) {
            double d = vectorDataSet.getDouble(n, units);
            if (units.isFill(d)) continue;
            dArray[n2++] = d;
        }
        if (n2 == 0) {
            return Datum.create(units.getFillDouble(), units);
        }
        Arrays.sort(dArray, 0, n2);
        n = n2 / 2;
        return Datum.create(dArray[n], units);
    }

    public static void dumpToAsciiStream(VectorDataSet vectorDataSet, Datum datum, Datum datum2, OutputStream outputStream) {
        Object object;
        List<String> list;
        PrintStream printStream = new PrintStream(outputStream);
        Datum datum3 = null;
        Units units = null;
        printStream.print("[00]");
        printStream.println("<stream start=\"" + vectorDataSet.getXTagDatum(0) + "\" end=\"" + vectorDataSet.getXTagDatum(vectorDataSet.getXLength() - 1) + "\" >");
        printStream.println("<comment>Stream creation date: " + TimeUtil.now().toString() + "</comment>");
        printStream.print("</stream>");
        if (vectorDataSet.getXUnits() instanceof LocationUnits && (units = ((LocationUnits)(datum3 = datum).getUnits()).getOffsetUnits()) == Units.microseconds) {
            units = Units.seconds;
        }
        printStream.print("[01]<packet>\n");
        printStream.print("<x type=\"asciiTab10\" ");
        if (datum3 != null) {
            printStream.print("base=\"" + datum3 + "\" ");
            printStream.print(" xUnits=\"" + units + "\" ");
        } else {
            printStream.print(" xUnits=\"" + vectorDataSet.getXUnits() + "\"");
        }
        printStream.println(" />");
        if (vectorDataSet.getProperty("plane-list") != null) {
            list = (List)vectorDataSet.getProperty("plane-list");
        } else {
            list = new ArrayList();
            list.add("");
        }
        for (int i = 0; i < list.size(); ++i) {
            object = (String)list.get(i);
            printStream.println("<y type=\"asciiTab10\" name=\"" + (String)object + "\" yUnits=\"" + vectorDataSet.getPlanarView((String)object).getYUnits() + "\" />");
        }
        printStream.print("</packet>");
        DecimalFormat decimalFormat = new DecimalFormat("00000.000");
        object = new DecimalFormat("0.00E00");
        double d = datum2.subtract(datum).doubleValue(units);
        for (int i = 0; i < vectorDataSet.getXLength(); ++i) {
            double d2 = datum3 != null ? vectorDataSet.getXTagDatum(i).subtract(datum3).doubleValue(units) : vectorDataSet.getXTagDouble(i, vectorDataSet.getXUnits());
            if (!(d2 >= 0.0) || !(d2 < d)) continue;
            printStream.print(":01:");
            printStream.print(decimalFormat.format(d2) + " ");
            for (int j = 0; j < list.size(); ++j) {
                VectorDataSet vectorDataSet2 = (VectorDataSet)vectorDataSet.getPlanarView((String)list.get(j));
                printStream.print(FixedWidthFormatter.format(((NumberFormat)object).format(vectorDataSet2.getDouble(i, vectorDataSet2.getYUnits())), 9));
                if (j == list.size() - 1) {
                    printStream.print("\n");
                    continue;
                }
                printStream.print(" ");
            }
        }
        printStream.close();
    }

    public static void dumpToAsciiStream(VectorDataSet vectorDataSet, OutputStream outputStream) {
        VectorUtil.dumpToAsciiStream(vectorDataSet, Channels.newChannel(outputStream));
    }

    public static void dumpToAsciiStream(VectorDataSet vectorDataSet, WritableByteChannel writableByteChannel) {
        VectorUtil.dumpToDas2Stream(vectorDataSet, writableByteChannel, true);
    }

    public static void dumpToStream(VectorDataSet vectorDataSet, OutputStream outputStream) {
        VectorUtil.dumpToAsciiStream(vectorDataSet, outputStream);
    }

    private static void dumpToDas2Stream(VectorDataSet vectorDataSet, WritableByteChannel writableByteChannel, boolean bl) {
        if (vectorDataSet.getXLength() == 0) {
            try {
                writableByteChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            Object object;
            int n;
            Object object2;
            Object object32;
            StreamProducer streamProducer = new StreamProducer(writableByteChannel);
            StreamDescriptor streamDescriptor = new StreamDescriptor();
            Map map = vectorDataSet.getProperties();
            for (Object object32 : map.keySet()) {
                streamDescriptor.setProperty((String)object32, map.get(object32));
            }
            if (bl) {
                object2 = UnitsUtil.isTimeLocation(vectorDataSet.getXUnits()) ? DataTransferType.getByName("time24") : DataTransferType.getByName("ascii10");
                object32 = DataTransferType.getByName("ascii10");
            } else {
                object2 = DataTransferType.getByName("sun_real8");
                object32 = DataTransferType.getByName("sun_real4");
            }
            streamProducer.streamDescriptor(streamDescriptor);
            StreamXDescriptor streamXDescriptor = new StreamXDescriptor();
            streamXDescriptor.setUnits(vectorDataSet.getXUnits());
            streamXDescriptor.setDataTransferType((DataTransferType)object2);
            PacketDescriptor packetDescriptor = new PacketDescriptor();
            packetDescriptor.setXDescriptor(streamXDescriptor);
            String[] stringArray = DataSetUtil.getAllPlaneIds(vectorDataSet);
            DatumVector[] datumVectorArray = new DatumVector[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                object = new StreamMultiYDescriptor();
                ((StreamMultiYDescriptor)object).setName(stringArray[n]);
                ((StreamMultiYDescriptor)object).setDataTransferType((DataTransferType)object32);
                ((StreamMultiYDescriptor)object).setUnits(((VectorDataSet)vectorDataSet.getPlanarView(stringArray[n])).getYUnits());
                packetDescriptor.addYDescriptor((SkeletonDescriptor)object);
            }
            streamProducer.packetDescriptor(packetDescriptor);
            for (n = 0; n < vectorDataSet.getXLength(); ++n) {
                object = vectorDataSet.getXTagDatum(n);
                for (int i = 0; i < stringArray.length; ++i) {
                    datumVectorArray[i] = VectorUtil.toDatumVector(((VectorDataSet)vectorDataSet.getPlanarView(stringArray[i])).getDatum(n));
                }
                streamProducer.packet(packetDescriptor, (Datum)object, datumVectorArray);
            }
            streamProducer.streamClosed(streamDescriptor);
        }
        catch (StreamException streamException) {
            throw new RuntimeException(streamException);
        }
    }

    private static DatumVector toDatumVector(Datum datum) {
        double[] dArray = new double[]{datum.doubleValue(datum.getUnits())};
        return DatumVector.newDatumVector(dArray, datum.getUnits());
    }

    public static String toString(VectorDataSet vectorDataSet) {
        return "[VectorDataSet " + vectorDataSet.getXLength() + " xTags ]";
    }

    public static VectorDataSet finiteDerivative(VectorDataSet vectorDataSet, int n) {
        VectorDataSetBuilder vectorDataSetBuilder = new VectorDataSetBuilder(vectorDataSet.getXUnits(), Units.dimensionless);
        Units units = vectorDataSet.getXUnits();
        Units units2 = vectorDataSet.getYUnits();
        for (int i = n; i < vectorDataSet.getXLength(); ++i) {
            double d = vectorDataSet.getXTagDouble(i, units) - vectorDataSet.getXTagDouble(i - n, units);
            double d2 = vectorDataSet.getDouble(i, units2) - vectorDataSet.getDouble(i - n, units2);
            vectorDataSetBuilder.insertY(vectorDataSet.getXTagDouble(i - n, units) + d / 2.0, d2 / d);
        }
        for (String string : vectorDataSet.getProperties().keySet()) {
            vectorDataSetBuilder.setProperty(string, vectorDataSet.getProperty(string));
        }
        return vectorDataSetBuilder.toVectorDataSet();
    }
}

