/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.dataset.WeightsTableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.LocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsUtil;
import edu.uiowa.physics.pw.das.stream.DataTransferType;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamProducer;
import edu.uiowa.physics.pw.das.stream.StreamXDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.DasMath;
import edu.uiowa.physics.pw.das.util.FixedWidthFormatter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.text.DecimalFormat;
import java.util.Map;

public class TableUtil {
    public static double[] getYTagArrayDouble(TableDataSet tableDataSet, int n, Units units) {
        double[] dArray = new double[tableDataSet.getYLength(n)];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = tableDataSet.getYTagDouble(n, i, units);
        }
        return dArray;
    }

    public static Datum getLargestYTag(TableDataSet tableDataSet) {
        Datum datum = tableDataSet.getYTagDatum(0, tableDataSet.getYLength(0) - 1);
        for (int i = 1; i < tableDataSet.tableCount(); ++i) {
            Datum datum2 = tableDataSet.getYTagDatum(i, tableDataSet.getYLength(i) - 1);
            if (!datum2.gt(datum)) continue;
            datum = datum2;
        }
        return datum;
    }

    public static Datum getSmallestYTag(TableDataSet tableDataSet) {
        Datum datum = tableDataSet.getYTagDatum(0, 0);
        for (int i = 1; i < tableDataSet.tableCount(); ++i) {
            Datum datum2 = tableDataSet.getYTagDatum(i, 0);
            if (!datum2.lt(datum)) continue;
            datum = datum2;
        }
        return datum;
    }

    public static int closestRow(TableDataSet tableDataSet, int n, Datum datum) {
        return TableUtil.closestRow(tableDataSet, n, datum.doubleValue(datum.getUnits()), datum.getUnits());
    }

    public static int closestRow(TableDataSet tableDataSet, int n, double d, Units units) {
        double[] dArray = TableUtil.getYTagArrayDouble(tableDataSet, n, units);
        return DataSetUtil.closest(dArray, d);
    }

    public static Datum closestDatum(TableDataSet tableDataSet, Datum datum, Datum datum2) {
        int n = DataSetUtil.closestColumn(tableDataSet, datum);
        int n2 = TableUtil.closestRow(tableDataSet, tableDataSet.tableOfIndex(n), datum2);
        return tableDataSet.getDatum(n, n2);
    }

    public static int tableIndexAt(TableDataSet tableDataSet, int n) {
        int n2 = 0;
        while (tableDataSet.tableEnd(n2) <= n) {
            ++n2;
        }
        return n2;
    }

    public static Datum guessYTagWidth(TableDataSet tableDataSet) {
        return TableUtil.guessYTagWidth(tableDataSet, 0);
    }

    public static Datum guessYTagWidth(TableDataSet tableDataSet, int n) {
        double d = tableDataSet.getYTagDouble(n, 0, tableDataSet.getYUnits());
        double d2 = tableDataSet.getYTagDouble(n, 1, tableDataSet.getYUnits());
        int n2 = tableDataSet.getYLength(n) - 1;
        double d3 = tableDataSet.getYTagDouble(n, n2, tableDataSet.getYUnits());
        if ((d3 - d) / ((d2 - d) * (double)n2) > 10.0) {
            return Units.log10Ratio.createDatum(DasMath.log10(d2 / d));
        }
        return tableDataSet.getYUnits().createDatum(d2 - d);
    }

    public static double tableMax(TableDataSet tableDataSet, Units units) {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < tableDataSet.tableCount(); ++i) {
            int n = tableDataSet.getYLength(i);
            for (int j = tableDataSet.tableStart(i); j < tableDataSet.tableEnd(i); ++j) {
                for (int k = 0; k < n; ++k) {
                    if (!(tableDataSet.getDouble(j, k, units) > d)) continue;
                    d = tableDataSet.getDouble(j, k, units);
                }
            }
        }
        return d;
    }

    public static void checkForNaN(TableDataSet tableDataSet) {
        for (int i = 0; i < tableDataSet.getXLength(); ++i) {
            for (int j = 0; j < 16; ++j) {
                double d = tableDataSet.getDouble(i, j, tableDataSet.getZUnits());
                if (!Double.isNaN(d)) continue;
                System.out.println("found NaN at " + i + "," + j);
                if (tableDataSet.getPlanarView("weights") == null) continue;
                System.out.println("  weight: " + ((TableDataSet)tableDataSet.getPlanarView("weights")).getDouble(i, j, Units.dimensionless));
            }
        }
    }

    protected static void checkForNaN(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                double d = dArray[i][j];
                if (!Double.isNaN(d)) continue;
                System.out.println("found NaN at " + i + "," + j);
            }
        }
    }

    public static String toString(TableDataSet tableDataSet) {
        StringBuffer stringBuffer = new StringBuffer();
        if (tableDataSet.tableCount() > 0) {
            stringBuffer.append(tableDataSet.getYLength(0));
        }
        int n = 3;
        for (int i = 1; i < tableDataSet.tableCount() && i < n; ++i) {
            stringBuffer.append(", " + tableDataSet.getYLength(i));
        }
        return "[" + tableDataSet.getXLength() + " xTags, " + stringBuffer.toString() + " yTags]";
    }

    public static DatumVector getDatumVector(TableDataSet tableDataSet, int n) {
        Units units = tableDataSet.getZUnits();
        double[] dArray = new double[tableDataSet.getYLength(tableDataSet.tableOfIndex(n))];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = tableDataSet.getDouble(n, i, units);
        }
        return DatumVector.newDatumVector(dArray, units);
    }

    public static DatumVector getYTagsDatumVector(TableDataSet tableDataSet, int n) {
        Units units = tableDataSet.getYUnits();
        DatumVector datumVector = DatumVector.newDatumVector(TableUtil.getYTagArrayDouble(tableDataSet, n, units), units);
        return datumVector;
    }

    public static void dumpToAsciiStream(TableDataSet tableDataSet, Datum datum, Datum datum2, OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        Datum datum3 = null;
        Units units = null;
        printStream.print("This is not a das2 stream, even though it looks like it.");
        printStream.print("[00]");
        printStream.println("<stream start=\"" + datum + "\" end=\"" + datum2 + "\" >");
        printStream.println("<comment>Stream creation date: " + TimeUtil.now().toString() + "</comment>");
        printStream.print("</stream>");
        if (tableDataSet.getXUnits() instanceof LocationUnits && (units = ((LocationUnits)(datum3 = datum).getUnits()).getOffsetUnits()) == Units.microseconds) {
            units = Units.seconds;
        }
        printStream.print("[01]<packet>\n");
        printStream.print("<x type=\"asciiTab10\" ");
        if (datum3 != null) {
            printStream.print("base=\"" + datum3 + "\" ");
            printStream.print(" xUnits=\"" + units + "\" ");
        } else {
            printStream.print(" xUnits=\"" + tableDataSet.getXUnits());
        }
        printStream.println(" />");
        String string = "" + tableDataSet.getYTagDatum(0, 0);
        for (int i = 1; i < tableDataSet.getYLength(0); ++i) {
            string = string + ", " + tableDataSet.getYTagDatum(0, i);
        }
        printStream.println("<yscan type=\"asciiTab10\" zUnits=\"" + tableDataSet.getZUnits() + "\" yTags=\"" + string + "\"/>");
        printStream.print("</packet>");
        DecimalFormat decimalFormat = new DecimalFormat("00000.000");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.00E00");
        double d = datum2.subtract(datum).doubleValue(units);
        for (int i = 0; i < tableDataSet.getXLength(); ++i) {
            double d2 = datum3 != null ? tableDataSet.getXTagDatum(i).subtract(datum3).doubleValue(units) : tableDataSet.getXTagDouble(i, tableDataSet.getXUnits());
            if (!(d2 >= 0.0) || !(d2 < d)) continue;
            printStream.print(":01:");
            printStream.print(decimalFormat.format(d2) + " ");
            int n = tableDataSet.tableOfIndex(i);
            for (int j = 0; j < tableDataSet.getYLength(n); ++j) {
                String string2 = j + 1 == tableDataSet.getYLength(n) ? "\n" : " ";
                printStream.print(FixedWidthFormatter.format(decimalFormat2.format(tableDataSet.getDouble(i, j, tableDataSet.getZUnits())), 9) + string2);
            }
        }
        printStream.close();
    }

    public static void dumpToAsciiStream(TableDataSet tableDataSet, OutputStream outputStream) {
        TableUtil.dumpToAsciiStream(tableDataSet, Channels.newChannel(outputStream));
    }

    public static void dumpToAsciiStream(TableDataSet tableDataSet, WritableByteChannel writableByteChannel) {
        TableUtil.dumpToDas2Stream(tableDataSet, writableByteChannel, true);
    }

    public static void dumpToDas2Stream(TableDataSet tableDataSet, OutputStream outputStream, boolean bl) {
        TableUtil.dumpToDas2Stream(tableDataSet, Channels.newChannel(outputStream), bl);
    }

    public static void dumpToBinaryStream(TableDataSet tableDataSet, OutputStream outputStream) {
        TableUtil.dumpToDas2Stream(tableDataSet, Channels.newChannel(outputStream), false);
    }

    private static void dumpToDas2Stream(TableDataSet tableDataSet, WritableByteChannel writableByteChannel, boolean bl) {
        try {
            Object object;
            Object object22;
            StreamProducer streamProducer = new StreamProducer(writableByteChannel);
            StreamDescriptor streamDescriptor = new StreamDescriptor();
            Map map = tableDataSet.getProperties();
            for (Object object22 : map.keySet()) {
                streamDescriptor.setProperty((String)object22, map.get(object22));
            }
            if (bl) {
                object22 = UnitsUtil.isTimeLocation(tableDataSet.getXUnits()) ? DataTransferType.getByName("time24") : DataTransferType.getByName("ascii24");
                object = DataTransferType.getByName("ascii10");
            } else {
                object = DataTransferType.getByName("sun_real4");
                object22 = DataTransferType.getByName("sun_real8");
            }
            streamProducer.streamDescriptor(streamDescriptor);
            DatumVector[] datumVectorArray = new DatumVector[1];
            for (int i = 0; i < tableDataSet.tableCount(); ++i) {
                StreamXDescriptor streamXDescriptor = new StreamXDescriptor();
                streamXDescriptor.setUnits(tableDataSet.getXUnits());
                streamXDescriptor.setDataTransferType((DataTransferType)object22);
                StreamYScanDescriptor streamYScanDescriptor = new StreamYScanDescriptor();
                streamYScanDescriptor.setDataTransferType((DataTransferType)object);
                streamYScanDescriptor.setZUnits(tableDataSet.getZUnits());
                streamYScanDescriptor.setYCoordinates(tableDataSet.getYTags(i));
                PacketDescriptor packetDescriptor = new PacketDescriptor();
                packetDescriptor.setXDescriptor(streamXDescriptor);
                packetDescriptor.addYDescriptor(streamYScanDescriptor);
                streamProducer.packetDescriptor(packetDescriptor);
                for (int j = tableDataSet.tableStart(i); j < tableDataSet.tableEnd(i); ++j) {
                    Datum datum = tableDataSet.getXTagDatum(j);
                    datumVectorArray[0] = tableDataSet.getScan(j);
                    streamProducer.packet(packetDescriptor, datum, datumVectorArray);
                }
            }
            streamProducer.streamClosed(streamDescriptor);
        }
        catch (StreamException streamException) {
            throw new RuntimeException(streamException);
        }
    }

    public static int getPreviousRow(TableDataSet tableDataSet, int n, Datum datum) {
        int n2 = TableUtil.closestRow(tableDataSet, n, datum);
        if (n2 > 0 && tableDataSet.getYTagDatum(n, n2).gt(datum)) {
            return n2 - 1;
        }
        return n2;
    }

    public static int getNextRow(TableDataSet tableDataSet, int n, Datum datum) {
        int n2 = TableUtil.closestRow(tableDataSet, n, datum);
        if (n2 < tableDataSet.getYLength(n) - 1 && tableDataSet.getYTagDatum(n, n2).lt(datum)) {
            return n2 + 1;
        }
        return n2;
    }

    public static VectorDataSet collapse(TableDataSet tableDataSet, int n, int n2) {
        int n3 = tableDataSet.tableOfIndex(n);
        if (tableDataSet.tableOfIndex(n + n2 - 1) != n3) {
            throw new IllegalArgumentException("collapse can't span multiple tables!");
        }
        int n4 = tableDataSet.getYLength(n3);
        Units units = tableDataSet.getZUnits();
        Units units2 = tableDataSet.getYUnits();
        VectorDataSetBuilder vectorDataSetBuilder = new VectorDataSetBuilder(tableDataSet.getYUnits(), tableDataSet.getZUnits());
        TableDataSet tableDataSet2 = WeightsTableDataSet.create(tableDataSet);
        for (int i = 0; i < n4; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            for (int j = n; j < n + n2; ++j) {
                double d3 = tableDataSet2.getDouble(j, i, Units.dimensionless);
                d += tableDataSet.getDouble(j, i, units) * d3;
                d2 += d3;
            }
            double d4 = d2 == 0.0 ? units.getFillDouble() : d / d2;
            vectorDataSetBuilder.insertY(tableDataSet.getYTagDouble(n3, i, units2), d4);
        }
        return vectorDataSetBuilder.toVectorDataSet();
    }
}

