/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.CacheTag;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.dataset.GapListDouble;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class TableDataSetBuilder {
    private static final double[] EMPTY = new double[0];
    private GapListDouble xTags = new GapListDouble();
    private List zValues = new ArrayList();
    private List planeIDs = new ArrayList();
    private Units xUnits;
    private Units yUnits;
    private Map zUnitsMap;
    private SortedSet yTagSet;
    private Map properties;
    private int count;

    public TableDataSetBuilder(Units units, Units units2, Units units3) {
        this.planeIDs.add("");
        this.xUnits = Units.dimensionless;
        this.yUnits = Units.dimensionless;
        this.zUnitsMap = new HashMap();
        this.zUnitsMap.put("", Units.dimensionless);
        this.yTagSet = new TreeSet(new DoubleArrayComparator());
        this.properties = new HashMap();
        this.count = 0;
        this.setXUnits(units);
        this.setYUnits(units2);
        this.setZUnits(units3);
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void addProperties(Map map) {
        this.properties.putAll(map);
    }

    public void addPlane(String string, Units units) {
        if (string != null && !this.planeIDs.contains(string)) {
            this.planeIDs.add(string);
            this.zUnitsMap.put(string, units);
        }
    }

    public void insertYScan(Datum datum, DatumVector datumVector, DatumVector datumVector2) {
        this.insertYScan(datum, datumVector, new DatumVector[]{datumVector2}, new String[]{""});
    }

    public void insertYScan(Datum datum, DatumVector datumVector, DatumVector datumVector2, String string) {
        this.insertYScan(datum, datumVector, new DatumVector[]{datumVector2}, new String[]{string});
    }

    public void insertYScan(Datum datum, DatumVector datumVector, DatumVector[] datumVectorArray, String[] stringArray) {
        double d = datum.doubleValue(this.xUnits);
        double[] dArray = datumVector.toDoubleArray(this.yUnits);
        int n = this.xTags.indexOf(d);
        for (int i = 0; i < datumVectorArray.length; ++i) {
            if (datumVector.getLength() == datumVectorArray[i].getLength()) continue;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Scan length must equal yTags length");
        }
        if (this.yTagSet.contains(dArray)) {
            dArray = (double[])this.yTagSet.tailSet(dArray).iterator().next();
        } else {
            this.yTagSet.add(dArray);
        }
        if (n < 0) {
            n ^= 0xFFFFFFFF;
        }
        this.xTags.add(d);
        MultiYScan multiYScan = new MultiYScan();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Units units = (Units)this.zUnitsMap.get(string);
            if (units == null) {
                units = Units.dimensionless;
                this.addPlane(string, units);
            }
            double[] dArray2 = datumVectorArray[i].toDoubleArray(units);
            multiYScan.put(string, dArray2);
            multiYScan.setYTags(dArray);
            this.zValues.add(n, multiYScan);
        }
    }

    private void appendProperties(Map map) {
        for (Object k : map.keySet()) {
            if (this.properties.containsKey(k)) {
                if (k.equals("sizeBytes")) continue;
                if (k.equals("cacheTag")) {
                    CacheTag cacheTag = (CacheTag)this.properties.get(k);
                    CacheTag cacheTag2 = (CacheTag)map.get(k);
                    try {
                        this.properties.put(k, CacheTag.append(cacheTag, cacheTag2));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.err.println("ignoring unequal property: append: " + k + "=" + map.get(k) + " to " + this.properties.get(k));
                    }
                    continue;
                }
                if (this.properties.get(k).equals(map.get(k))) continue;
                System.err.println("ignoring unequal property: append: " + k + "=" + map.get(k) + " to " + this.properties.get(k));
                continue;
            }
            this.properties.put(k, map.get(k));
        }
    }

    public void append(TableDataSet tableDataSet) {
        this.appendProperties(tableDataSet.getProperties());
        String[] stringArray = this.planeIDs.toArray(new String[this.planeIDs.size()]);
        TableDataSet[] tableDataSetArray = new TableDataSet[stringArray.length];
        tableDataSetArray[0] = tableDataSet;
        for (int i = 1; i < stringArray.length; ++i) {
            tableDataSetArray[i] = (TableDataSet)tableDataSet.getPlanarView(stringArray[i]);
        }
        DatumVector[] datumVectorArray = new DatumVector[tableDataSetArray.length];
        for (int i = 0; i < tableDataSet.tableCount(); ++i) {
            DatumVector datumVector = this.getYTagsDatumVector(tableDataSet, i);
            for (int j = tableDataSet.tableStart(i); j < tableDataSet.tableEnd(i); ++j) {
                for (int k = 0; k < tableDataSetArray.length; ++k) {
                    datumVectorArray[k] = this.getZScanDatumVector(tableDataSetArray[k], i, j);
                }
                this.insertYScan(tableDataSet.getXTagDatum(j), datumVector, datumVectorArray, stringArray);
            }
        }
    }

    private DatumVector getYTagsDatumVector(TableDataSet tableDataSet, int n) {
        double[] dArray = new double[tableDataSet.getYLength(n)];
        for (int i = 0; i < tableDataSet.getYLength(n); ++i) {
            dArray[i] = tableDataSet.getYTagDouble(n, i, this.yUnits);
        }
        return DatumVector.newDatumVector(dArray, this.yUnits);
    }

    private DatumVector getZScanDatumVector(TableDataSet tableDataSet, int n, int n2) {
        if (tableDataSet == null) {
            return null;
        }
        double[] dArray = new double[tableDataSet.getYLength(n)];
        for (int i = 0; i < tableDataSet.getYLength(n); ++i) {
            dArray[i] = tableDataSet.getDouble(n2, i, this.yUnits);
        }
        return DatumVector.newDatumVector(dArray, this.yUnits);
    }

    public void setXUnits(Units units) {
        if (units == null) {
            throw new NullPointerException();
        }
        this.xUnits = units;
    }

    public void setYUnits(Units units) {
        if (units == null) {
            throw new NullPointerException();
        }
        this.yUnits = units;
    }

    public void setZUnits(Units units) {
        this.setZUnits(units, "");
    }

    public void setZUnits(Units units, String string) {
        if (units == null) {
            throw new NullPointerException();
        }
        this.zUnitsMap.put(string, units);
    }

    public String toString() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (MultiYScan multiYScan : this.zValues) {
            stringBuffer.append(TableDataSetBuilder.toString(this.xTags.toArray(), n, n + 1)).append(TableDataSetBuilder.toString(multiYScan.get(""))).append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public TableDataSet toTableDataSet() {
        int n = TableDataSetBuilder.getTableCount(this.zValues);
        int[] nArray = TableDataSetBuilder.getTableOffsets(this.zValues, n);
        double[][] dArray = TableDataSetBuilder.collapseYTags(this.zValues, n);
        double[][][] dArray2 = TableDataSetBuilder.collapseZValues(this.zValues, this.planeIDs, this.zUnitsMap);
        Units[] unitsArray = TableDataSetBuilder.getUnitsArray(this.planeIDs, this.zUnitsMap);
        return new DefaultTableDataSet(this.xTags.toArray(), this.xUnits, dArray, this.yUnits, dArray2, unitsArray, this.planeIDs.toArray(new String[this.planeIDs.size()]), nArray, this.properties);
    }

    public int getXLength() {
        return this.xTags.size();
    }

    public double getXTag(int n) {
        return this.xTags.get(n);
    }

    private static double[] insert(double[] dArray, double d, int n) {
        double[] dArray2 = new double[dArray.length + 1];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        dArray2[n] = d;
        System.arraycopy(dArray, n, dArray2, n + 1, dArray.length - n);
        return dArray2;
    }

    private static double[][] insert(double[][] dArray, double[] dArray2, int n) {
        double[][] dArrayArray = new double[dArray.length + 1][];
        System.arraycopy(dArray, 0, dArrayArray, 0, n);
        dArrayArray[n] = dArray2;
        System.arraycopy(dArray, n, dArrayArray, n + 1, dArray.length - n);
        return dArrayArray;
    }

    private static String toString(double[] dArray) {
        return TableDataSetBuilder.toString(dArray, 0, dArray.length);
    }

    private static String toString(double[] dArray, int n, int n2) {
        if (dArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = n; i < n2 - 1; ++i) {
            stringBuffer.append(dArray[i]).append(", ");
        }
        stringBuffer.append(dArray[n2 - 1]).append(']');
        return stringBuffer.toString();
    }

    private static int getTableCount(List list) {
        int n = 0;
        double[] dArray = null;
        for (MultiYScan multiYScan : list) {
            if (Arrays.equals(dArray, multiYScan.getYTags())) continue;
            dArray = multiYScan.getYTags();
            ++n;
        }
        return n;
    }

    private static int[] getTableOffsets(List list, int n) {
        double[] dArray = null;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[n];
        for (MultiYScan multiYScan : list) {
            if (!Arrays.equals(dArray, multiYScan.getYTags())) {
                nArray[n2] = n3;
                dArray = multiYScan.getYTags();
                ++n2;
            }
            ++n3;
        }
        return nArray;
    }

    private static double[][] collapseYTags(List list, int n) {
        double[] dArray = null;
        int n2 = 0;
        double[][] dArrayArray = new double[n][];
        for (MultiYScan multiYScan : list) {
            if (Arrays.equals(dArray, multiYScan.getYTags())) continue;
            dArrayArray[n2] = multiYScan.getYTags();
            dArray = multiYScan.getYTags();
            ++n2;
        }
        return dArrayArray;
    }

    private static double[][][] collapseZValues(List list, List list2, Map map) {
        double[][][] dArray = new double[list2.size()][list.size()][];
        int n = 0;
        for (MultiYScan multiYScan : list) {
            for (int i = 0; i < list2.size(); ++i) {
                double[] dArray2 = multiYScan.get((String)list2.get(i));
                if (dArray2 == null) {
                    dArray2 = new double[multiYScan.getYTags().length];
                    Units units = (Units)map.get(list2.get(i));
                    Arrays.fill(dArray2, units.getFillDouble());
                }
                dArray[i][n] = dArray2;
            }
            ++n;
        }
        return dArray;
    }

    private static Units[] getUnitsArray(List list, Map map) {
        Units[] unitsArray = new Units[list.size()];
        for (int i = 0; i < unitsArray.length; ++i) {
            unitsArray[i] = (Units)map.get(list.get(i));
        }
        return unitsArray;
    }

    private class MultiYScan {
        private HashMap map = new HashMap();
        double[] yTags;

        private MultiYScan() {
        }

        public void put(String string, double[] dArray) {
            this.map.put(string, dArray);
        }

        public double[] get(String string) {
            return (double[])this.map.get(string);
        }

        public double[] getYTags() {
            return this.yTags;
        }

        public void setYTags(double[] dArray) {
            this.yTags = dArray;
        }
    }

    private class DoubleArrayComparator
    implements Comparator {
        private DoubleArrayComparator() {
        }

        public int compare(Object object, Object object2) {
            double[] dArray = (double[])object;
            double[] dArray2 = (double[])object2;
            if (dArray.length != dArray2.length) {
                return dArray.length - dArray2.length;
            }
            for (int i = 0; i < dArray.length; ++i) {
                double d = dArray[i] - dArray2[i];
                if (d < 0.0) {
                    return -1;
                }
                if (!(d > 0.0)) continue;
                return 1;
            }
            return 0;
        }
    }
}

